/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.launcher.SplashScreen;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.MainPanel;
import edu.ku.brc.af.core.SpecialMsgNotifier;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsEditor;
import edu.ku.brc.af.prefs.PreferencesDlg;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.tasks.StatsTrackerTask;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.ProcessListUtil;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.ResultSetController;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory;
import edu.ku.brc.af.ui.forms.validation.ValComboBoxFromQuery;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.dbsupport.DataProviderSessionIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.QueryExecutor;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.helpers.ProxyHelper;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.services.gpx.GPXPanel;
import edu.ku.brc.specify.config.CollectingEventsAndAttrsMaint;
import edu.ku.brc.specify.config.DebugLoggerDialog;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.config.FeedBackDlg;
import edu.ku.brc.specify.config.FixDBAfterLogin;
import edu.ku.brc.specify.config.LoggerDialog;
import edu.ku.brc.specify.config.SpecifyAppContextMgr;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.init.DataBuilder;
import edu.ku.brc.specify.config.init.RegisterSpecify;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizardFrame;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.specify.datamodel.AccessionAttachment;
import edu.ku.brc.specify.datamodel.AgentAttachment;
import edu.ku.brc.specify.datamodel.Attachment;
import edu.ku.brc.specify.datamodel.BorrowAttachment;
import edu.ku.brc.specify.datamodel.CollectingEventAttachment;
import edu.ku.brc.specify.datamodel.Collection;
import edu.ku.brc.specify.datamodel.CollectionObject;
import edu.ku.brc.specify.datamodel.CollectionObjectAttachment;
import edu.ku.brc.specify.datamodel.ConservDescriptionAttachment;
import edu.ku.brc.specify.datamodel.ConservEventAttachment;
import edu.ku.brc.specify.datamodel.DNASequenceAttachment;
import edu.ku.brc.specify.datamodel.DNASequencingRunAttachment;
import edu.ku.brc.specify.datamodel.Determination;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.datamodel.Division;
import edu.ku.brc.specify.datamodel.FieldNotebookAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageAttachment;
import edu.ku.brc.specify.datamodel.FieldNotebookPageSetAttachment;
import edu.ku.brc.specify.datamodel.GiftAttachment;
import edu.ku.brc.specify.datamodel.Institution;
import edu.ku.brc.specify.datamodel.LoanAttachment;
import edu.ku.brc.specify.datamodel.LocalityAttachment;
import edu.ku.brc.specify.datamodel.PermitAttachment;
import edu.ku.brc.specify.datamodel.Preparation;
import edu.ku.brc.specify.datamodel.PreparationAttachment;
import edu.ku.brc.specify.datamodel.ReferenceWorkAttachment;
import edu.ku.brc.specify.datamodel.RepositoryAgreementAttachment;
import edu.ku.brc.specify.datamodel.SpecifyUser;
import edu.ku.brc.specify.datamodel.Storage;
import edu.ku.brc.specify.datamodel.Taxon;
import edu.ku.brc.specify.datamodel.TaxonAttachment;
import edu.ku.brc.specify.dbsupport.PostDeleteEventListener;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.dbsupport.PostUpdateEventListener;
import edu.ku.brc.specify.prefs.SystemPrefs;
import edu.ku.brc.specify.tasks.subpane.JasperReportsCache;
import edu.ku.brc.specify.tasks.subpane.wb.wbuploader.Uploader;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.CustomFrame;
import edu.ku.brc.ui.DefaultClassActionHandler;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.JTiledToolbar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.VerticalSeparator;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.CacheManager;
import edu.ku.brc.util.FileCache;
import edu.ku.brc.util.MemoryWarningSystem;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.thumbnails.Thumbnailer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Specify
extends JPanel
implements DatabaseLoginListener,
CommandListener,
FrameworkAppIFace {
    private static final Logger log = Logger.getLogger(Specify.class);
    public static final boolean IS_DEVELOPMENT = true;
    private static final String sendStatsPrefName = "usage_tracking.send_stats";
    private static final String sendISAStatsPrefName = "usage_tracking.send_isa_stats";
    private static final String UPDATE_CHK_ERROR = "Specify.UPDATE_CHK_ERROR";
    private static final String ERRMSG = "ERRMSG";
    private static final String STATS_SEND_DONE = "STATS_SEND_DONE";
    private static final String MANAGED_RELEASES = "MANAGED_RELEASES";
    private static final int PREFERRED_WIDTH = 1024;
    private static final int PREFERRED_HEIGHT = 768;
    private static Specify specifyApp = null;
    private JStatusBar statusField = null;
    private JMenuBar menuBar = null;
    private JFrame topFrame = null;
    private MainPanel mainPanel = null;
    private JMenuItem changeCollectionMenuItem = null;
    private JLabel appIcon = null;
    protected boolean hasChanged = false;
    protected String currentDatabaseName = null;
    protected DatabaseLoginPanel dbLoginPanel = null;
    protected String databaseName = null;
    protected String userName = null;
    protected GhostGlassPane glassPane;
    private boolean isWorkbenchOnly = UIRegistry.isMobile();
    private String appName = "Specify";
    private String appVersion = "6.0";
    private String appBuildVersion = "(Unknown)";
    protected static CacheManager cacheManager = new CacheManager();

    protected void preStartUp() {
        new MacOSAppHandler(this);
        Specify.setUpSystemProperties();
    }

    protected void preInitializePrefs() {
        AppPreferences remotePrefs = AppPreferences.getRemote();
        int i = 0;
        String[] classNames = new String[]{"Taxon", "Geography", "LithoStrat", "GeologicTimePeriod", "Storage"};
        int[] ranks = new int[]{140, 200, 200, 200, 200};
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            remotePrefs.getColor("Treeeditor.TreeColColor1." + className, new Color(202, 238, 255), true);
            remotePrefs.getColor("Treeeditor.TreeColColor2." + className, new Color(151, 221, 255), true);
            remotePrefs.getColor("Treeeditor.SynonymyColor." + className, Color.BLUE, true);
            remotePrefs.getInt("TreeEditor.Rank.Threshold." + className, ranks[i], true);
            ++i;
            ++n2;
        }
        remotePrefs.getBoolean("TreeEditor.RestoreTreeExpansionState", true, true);
        remotePrefs.getBoolean("google.earth.useorigheaders", true, true);
        remotePrefs.getInt("SubPaneMgr.MaxPanes", 12, true);
        String ds = AppContextMgr.getInstance().getClassObject(Discipline.class).getType();
        remotePrefs.getBoolean("Interactions.Using.Interactions." + ds, true, true);
        remotePrefs.getBoolean("Interactions.Doing.Gifts." + ds, true, true);
        remotePrefs.getBoolean("Interactions.Doing.Exchanges." + ds, Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.botany), true);
        remotePrefs.getBoolean("Agent.Use.Variants." + ds, Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.botany), true);
        remotePrefs.load();
    }

    public static void checkForSpecifyAppsRunning() {
        List<Integer> ids = ProcessListUtil.getProcessIdWithText("exe4j.moduleName", "specify.jar", "SpiReport");
        if (ids.size() > 1) {
            UIRegistry.showLocalizedMsg("WARNING", "Specify.TOO_MANY_SP", new Object[0]);
            System.exit(0);
        }
    }

    public void startUp() {
        Class[] attachmentClasses;
        log.debug((Object)"StartUp...");
        if (UIHelper.isLinux()) {
            Specify.checkForSpecifyAppsRunning();
        }
        if (UIRegistry.isEmbedded().booleanValue()) {
            SpecifyDBSetupWizardFrame.checkForMySQLProcesses();
        }
        UIHelper.adjustUIDefaults();
        Specify.setupDefaultFonts();
        if (!UIRegistry.doesAppversionsMatch()) {
            System.exit(0);
        }
        Thumbnailer thumb = new Thumbnailer();
        File thumbnailDir = null;
        try {
            thumbnailDir = XMLHelper.getConfigDir("thumbnail_generators.xml");
            thumb.registerThumbnailers(thumbnailDir);
        }
        catch (Exception e1) {
            throw new RuntimeException("Couldn't find thumbnailer xml [" + (thumbnailDir != null ? thumbnailDir.getAbsolutePath() : "") + "]");
        }
        thumb.setQuality(0.5f);
        thumb.setMaxHeight(128);
        thumb.setMaxWidth(128);
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        String userSplashIconPath = AppPreferences.getLocalPrefs().get("specify.bg.image", null);
        if (userSplashIconPath != null) {
            SystemPrefs.changeSplashImage();
        }
        AttachmentUtils.setThumbnailer(thumb);
        DefaultClassActionHandler defClassActionHandler = DefaultClassActionHandler.getInstance();
        ActionListener attachmentDisplayer = AttachmentUtils.getAttachmentDisplayer();
        Class[] classArray = attachmentClasses = new Class[]{Attachment.class, AccessionAttachment.class, AgentAttachment.class, BorrowAttachment.class, CollectingEventAttachment.class, CollectionObjectAttachment.class, ConservDescriptionAttachment.class, ConservEventAttachment.class, DNASequenceAttachment.class, DNASequencingRunAttachment.class, FieldNotebookAttachment.class, FieldNotebookPageAttachment.class, FieldNotebookPageSetAttachment.class, GiftAttachment.class, LoanAttachment.class, LocalityAttachment.class, PermitAttachment.class, PreparationAttachment.class, ReferenceWorkAttachment.class, RepositoryAgreementAttachment.class, TaxonAttachment.class};
        int n = attachmentClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            defClassActionHandler.registerActionHandler(cls, attachmentDisplayer);
            ++n2;
        }
        UsageTracker.incrUsageCount("RunCount");
        FileCache.setDefaultPath(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "cache");
        cacheManager.registerCache(UIRegistry.getLongTermFileCache());
        cacheManager.registerCache(UIRegistry.getShortTermFileCache());
        cacheManager.registerCache(UIRegistry.getFormsCache());
        cacheManager.registerCache(JasperReportsCache.getInstance());
        UIRegistry.register("mainpane", this);
        specifyApp = this;
        if (!this.isWorkbenchOnly) {
            HibernateUtil.setListener("post-commit-update", new PostUpdateEventListener());
            HibernateUtil.setListener("post-commit-insert", new PostInsertEventListener());
            HibernateUtil.setListener("post-commit-delete", new PostDeleteEventListener());
        }
        Specify.adjustLocaleFromPrefs();
        CommandDispatcher.register("App", this);
        CommandDispatcher.register(ERRMSG, this);
        DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider = new DatabaseLoginPanel.MasterPasswordProviderIFace(){

            @Override
            public boolean hasMasterUserAndPwdInfo(String username, String password, String dbName) {
                if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
                    UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                    return UserAndMasterPasswordMgr.getInstance().hasMasterUsernameAndPassword();
                }
                return false;
            }

            @Override
            public Pair<String, String> getUserNamePassword(String username, String password, String dbName) {
                UserAndMasterPasswordMgr.getInstance().set(username, password, dbName);
                Pair<String, String> usrPwd = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
                return usrPwd;
            }

            @Override
            public boolean editMasterInfo(String username, String databaseNameArg, boolean askForCredentials) {
                return UserAndMasterPasswordMgr.getInstance().editMasterInfo(username, databaseNameArg, askForCredentials);
            }
        };
        if (UIRegistry.isMobile()) {
            DBConnection.setShutdownUI(new DBConnection.ShutdownUIIFace(){
                CustomDialog processDlg;

                @Override
                public void displayInitialDlg() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIRegistry.showLocalizedMsg(1, "MOBILE_INFO", "MOBILE_INTRO", new Object[0]);
                        }
                    });
                }

                @Override
                public void displayFinalShutdownDlg() {
                    this.processDlg.setVisible(false);
                    UIRegistry.showLocalizedMsg(1, "MOBILE_INFO", "MOBILE_FINI", new Object[0]);
                }

                @Override
                public void displayShutdownMsgDlg() {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
                    panel.add((Component)new JLabel(IconManager.getIcon(Specify.getLargeIconName()), 0), "West");
                    panel.add((Component)UIHelper.createI18NLabel("MOBILE_SHUTTING_DOWN", 0), "Center");
                    this.processDlg = new CustomDialog(null, "Shutdown", false, 0, (Component)panel);
                    this.processDlg.setAlwaysOnTop(true);
                    UIHelper.centerAndShow(this.processDlg);
                }
            });
        }
        UIRegistry.dumpPaths();
        this.dbLoginPanel = UIHelper.doLogin(usrPwdProvider, true, false, false, this, Specify.getLargeIconName(), this.getTitle(), null, Specify.getOpaqueIconName(), "login");
        localPrefs.load();
    }

    public static void setUpSystemProperties() {
        System.setProperty("edu.ku.brc.af.ui.forms.ViewFactory", "edu.ku.brc.specify.config.SpecifyViewFactory");
        System.setProperty("edu.ku.brc.af.core.AppContextMgrFactory", "edu.ku.brc.specify.config.SpecifyAppContextMgr");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFace", "edu.ku.brc.specify.config.AppPrefsDBIOIImpl");
        System.setProperty("edu.ku.brc.af.prefs.AppPrefsIOIFaceGlobal", "edu.ku.brc.specify.config.AppPrefsGlobalDBIOIImpl");
        System.setProperty("edu.ku.brc.ui.ViewBasedDialogFactoryIFace", "edu.ku.brc.specify.ui.DBObjDialogFactory");
        System.setProperty("edu.ku.brc.ui.forms.DraggableRecordIdentifierFactory", "edu.ku.brc.specify.ui.SpecifyDraggableRecordIdentiferFactory");
        System.setProperty("edu.ku.brc.dbsupport.AuditInterceptor", "edu.ku.brc.specify.dbsupport.AuditInterceptor");
        System.setProperty("edu.ku.brc.dbsupport.DataProvider", "edu.ku.brc.specify.dbsupport.HibernateDataProvider");
        System.setProperty("edu.ku.brc.ui.db.PickListDBAdapterFactory", "edu.ku.brc.specify.ui.db.PickListDBAdapterFactory");
        System.setProperty("edu.ku.brc.dbsupport.CustomQueryFactory", "edu.ku.brc.specify.dbsupport.SpecifyCustomQueryFactory");
        System.setProperty("edu.ku.brc.ui.forms.formatters.UIFieldFormatterMgr", "edu.ku.brc.specify.ui.SpecifyUIFieldFormatterMgr");
        System.setProperty("edu.ku.brc.af.core.ExpressSearchSQLAdjuster", "edu.ku.brc.specify.dbsupport.SpecifyQueryAdjusterForDomain");
        System.setProperty("edu.ku.brc.af.core.SchemaI18NService", "edu.ku.brc.specify.config.SpecifySchemaI18NService");
        System.setProperty("edu.ku.brc.ui.weblink.WebLinkMgr", "edu.ku.brc.specify.config.SpecifyWebLinkMgr");
        System.setProperty("edu.ku.brc.ui.forms.formatters.DataObjFieldFormatMgr", "edu.ku.brc.specify.config.SpecifyDataObjFieldFormatMgr");
        System.setProperty("RecordSetFactory", "edu.ku.brc.specify.config.SpecifyRecordSetFactory");
        System.setProperty("edu.ku.brc.dbsupport.DBTableIdMgr", "edu.ku.brc.specify.config.SpecifyDBTableIdMgr");
        System.setProperty("edu.ku.brc.af.auth.SecurityMgr", "edu.ku.brc.af.auth.specify.SpecifySecurityMgr");
        System.setProperty("edu.ku.brc.af.core.db.BackupServiceFactory", "edu.ku.brc.af.core.db.MySQLBackupService");
        System.setProperty("edu.ku.brc.exceptions.ExceptionTracker", "edu.ku.brc.specify.config.SpecifyExceptionTracker");
        System.setProperty("edu.ku.brc.af.ui.forms.validation.TypeSearchForQueryFactory", "edu.ku.brc.specify.ui.SpecifyTypeSearchForQueryFactory");
        System.setProperty(DBMSUserMgr.factoryName, "edu.ku.brc.dbsupport.MySQLDMBSUserMgr");
        System.setProperty("edu.ku.brc.af.core.db.SchmeaUpdateService", "edu.ku.brc.specify.dbsupport.SpecifySchemaUpdateService");
        System.setProperty("edu.ku.brc.af.core.CollectionObjLSIDGenFactory", "edu.ku.brc.specify.config.SpecifyLSIDGeneratorFactory");
    }

    protected void initStartUpPanels(final String databaseNameArg, final String userNameArg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Specify.this.initStartUpPanels(databaseNameArg, userNameArg);
                }
            });
            return;
        }
        TaskMgr.getInstance().readRegistry(UIRegistry.isMobile());
        TaskMgr.initializePlugins();
        Taskable bkTask = TaskMgr.getTask("BackupTask");
        if (bkTask != null) {
            bkTask.setIconName("MySQL");
        }
        this.validate();
        this.add((Component)this.mainPanel, "Center");
        this.doLayout();
        this.mainPanel.setBackground(Color.WHITE);
        JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
        if (toolBar != null && toolBar.getComponentCount() < 2) {
            toolBar.setVisible(false);
        }
    }

    public boolean isApplet() {
        return false;
    }

    private void initialize(GraphicsConfiguration gc) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1024, 768));
        this.setPreferredSize(new Dimension(1024, 768));
        this.topFrame = new JFrame(gc);
        this.topFrame.setIconImage(IconManager.getImage(Specify.getIconName()).getImage());
        this.glassPane = GhostGlassPane.getInstance();
        this.topFrame.setGlassPane(this.glassPane);
        this.topFrame.setLocationRelativeTo(null);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        UIRegistry.register("glasspane", this.glassPane);
        UIHelper.checkForOpenGL();
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        UIRegistry.setTopWindow(this.topFrame);
        this.menuBar = this.createMenus();
        if (this.menuBar != null) {
            this.topFrame.setJMenuBar(this.menuBar);
        }
        UIRegistry.register("menubar", this.menuBar);
        JToolBar toolBar = this.createToolBar();
        if (toolBar != null) {
            top.add((Component)toolBar, "Center");
        }
        UIRegistry.register("toolbar", toolBar);
        this.mainPanel = new MainPanel();
        int[] sections = new int[]{5, 5, 5, 1};
        this.statusField = new JStatusBar(sections);
        this.statusField.setErrorIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
        this.statusField.setWarningIcon(IconManager.getIcon("Warning", IconManager.IconSize.Std16));
        UIRegistry.setStatusBar(this.statusField);
        JLabel secLbl = this.statusField.getSectionLabel(3);
        if (secLbl != null) {
            boolean isSecurityOn = AppContextMgr.isSecurityOn();
            secLbl.setIcon(IconManager.getImage(isSecurityOn ? "SecurityOn" : "SecurityOff", IconManager.IconSize.Std16));
            secLbl.setHorizontalAlignment(0);
            secLbl.setHorizontalTextPosition(2);
            secLbl.setText("");
            secLbl.setToolTipText(UIRegistry.getResourceString("Specify.SEC_" + (isSecurityOn ? "ON" : "OFF")));
        }
        this.add((Component)this.statusField, "South");
    }

    public static String getIconName() {
        return IconManager.makeIconName("AppIcon");
    }

    public static String getOpaqueIconName() {
        return IconManager.makeIconName("SpecifyWhite32");
    }

    public static String getLargeIconName() {
        return IconManager.makeIconName("SpecifyLargeIcon");
    }

    protected void setAppIcon(String imgEncoded) {
        ImageIcon otherAppIcon;
        String appIconName = Specify.getIconName();
        String innerAppIconName = "InnerAppIcon";
        ImageIcon appImgIcon = null;
        if (StringUtils.isNotEmpty((String)imgEncoded) && (appImgIcon = GraphicsUtils.uudecodeImage("", imgEncoded)) != null && appImgIcon.getIconWidth() == 32 && appImgIcon.getIconHeight() == 32) {
            this.appIcon.setIcon(appImgIcon);
            CustomDialog.setAppIcon(appImgIcon);
            CustomFrame.setAppIcon(appImgIcon);
            IconManager.register(innerAppIconName, appImgIcon, null, IconManager.IconSize.Std32);
            return;
        }
        appImgIcon = IconManager.getImage(appIconName, IconManager.IconSize.Std32);
        this.appIcon.setIcon(appImgIcon);
        if (!UIHelper.isMacOS() && (otherAppIcon = IconManager.getImage(Specify.getOpaqueIconName(), IconManager.IconSize.Std32)) != null) {
            appImgIcon = otherAppIcon;
        }
        CustomDialog.setAppIcon(appImgIcon);
        CustomFrame.setAppIcon(appImgIcon);
        IconManager.register(innerAppIconName, appImgIcon, null, IconManager.IconSize.Std32);
        this.topFrame.setIconImage(appImgIcon.getImage());
    }

    public JToolBar createToolBar() {
        JToolBar toolBar;
        SkinItem skinItem = SkinsMgr.getSkinItem("ToolBar");
        if (SkinsMgr.hasSkins() && skinItem != null && (skinItem.getBGImage() != null || skinItem.getBgColor() != null)) {
            JTiledToolbar ttb = new JTiledToolbar(skinItem.getBGImage());
            if (skinItem.getBgColor() != null) {
                ttb.setBackground(skinItem.getBgColor());
                ttb.setOpaque(true);
            } else {
                ttb.setOpaque(false);
            }
            toolBar = ttb;
        } else {
            toolBar = new JToolBar();
        }
        toolBar.setLayout(new ToolbarLayoutManager(2, 2));
        this.appIcon = new JLabel("  ");
        this.setAppIcon(AppPreferences.getRemote().get("ui.formatting.user_icon_image", null));
        CommandDispatcher.register("Preferences", new CommandListener(){

            @Override
            public void doCommand(CommandAction cmdAction) {
                if (cmdAction.isAction("Updated")) {
                    Specify.this.setAppIcon(AppPreferences.getRemote().get("ui.formatting.user_icon_image", null));
                }
            }
        });
        return toolBar;
    }

    @Override
    public void doPreferences() {
        if (AppContextMgr.getInstance().hasContext()) {
            PreferencesDlg dlg = new PreferencesDlg(false);
            dlg.setVisible(true);
        } else {
            UIRegistry.showLocalizedMsg("Specify.NOTAVAIL");
        }
    }

    private void openPrefsEditor(AppPreferences prefs, String titleKey) {
        String titleStr = UIRegistry.getResourceString("Specify." + titleKey);
        CustomDialog dialog = new CustomDialog(this.topFrame, titleStr, true, 1, (Component)new AppPrefsEditor(prefs));
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        dialog.setOkLabel(okLabel);
        dialog.pack();
        UIHelper.centerAndShow(dialog);
        if (!dialog.isCancelled()) {
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            CommandDispatcher.dispatch(new CommandAction("Preferences", "Changed", prefs));
        }
    }

    private void openLocalPrefs() {
        this.openPrefsEditor(AppPreferences.getLocalPrefs(), "LOCAL_PREFS");
    }

    private void openRemotePrefs() {
        this.openPrefsEditor(AppPreferences.getRemote(), "REMOTE_PREFS");
    }

    private void openGlobalPrefs() {
        this.openPrefsEditor(AppPreferences.getGlobalPrefs(), "GLOBAL_PREFS");
    }

    public JMenuBar createMenus() {
        JMenuItem mi;
        String mnu;
        String title;
        JMenuBar mb = new JMenuBar();
        JMenu menu = null;
        if (!UIHelper.isMacOS() || !this.isWorkbenchOnly) {
            menu = UIHelper.createLocalizedMenu(mb, "Specify.FILE_MENU", "Specify.FILE_MNEU");
        }
        if (!this.isWorkbenchOnly) {
            title = "Specify.CHANGE_COLLECTION";
            mnu = "Specify.CHANGE_COLL_MNEU";
            this.changeCollectionMenuItem = UIHelper.createLocalizedMenuItem(menu, title, mnu, title, false, null);
            this.changeCollectionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SubPaneMgr.getInstance().aboutToShutdown()) {
                        Specify.this.restartApp(null, Specify.this.databaseName, Specify.this.userName, true, false);
                    }
                }
            });
            menu.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    boolean enable = Uploader.getCurrentUpload() == null && ((SpecifyAppContextMgr)AppContextMgr.getInstance()).getNumOfCollectionsForUser() > 1 && !TaskMgr.areTasksDisabled();
                    Specify.this.changeCollectionMenuItem.setEnabled(enable);
                }
            });
        }
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            if (!UIRegistry.isMobile()) {
                menu.addSeparator();
            }
            title = "Specify.EXIT";
            mnu = "Specify.Exit_MNEU";
            mi = UIHelper.createLocalizedMenuItem(menu, title, mnu, title, true, null);
            if (!UIHelper.isMacOS()) {
                mi.setAccelerator(KeyStroke.getKeyStroke(81, 128));
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.doExit(true);
                }
            });
        }
        menu = UIRegistry.getInstance().createEditMenu();
        mb.add(menu);
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            menu.addSeparator();
            title = "Specify.PREFERENCES";
            mnu = "Specify.PREFERENCES_MNEU";
            mi = UIHelper.createLocalizedMenuItem(menu, title, mnu, title, false, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.doPreferences();
                }
            });
            mi.setEnabled(true);
        }
        JMenu dataMenu = UIHelper.createLocalizedMenu(mb, "Specify.DATA_MENU", "Specify.DATA_MNEU");
        ResultSetController.addMenuItems(dataMenu);
        dataMenu.addSeparator();
        AbstractAction saveAndNewAction = new AbstractAction(UIRegistry.getResourceString("Specify.SAVE_AND_NEW")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormViewObj fvo = Specify.this.getCurrentFVO();
                if (fvo != null) {
                    fvo.setSaveAndNew(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
            }
        };
        saveAndNewAction.setEnabled(false);
        JCheckBoxMenuItem saveAndNewCBMI = new JCheckBoxMenuItem(saveAndNewAction);
        dataMenu.add(saveAndNewCBMI);
        UIRegistry.register("SaveAndNew", saveAndNewCBMI);
        UIRegistry.registerAction("SaveAndNew", saveAndNewAction);
        mb.add(dataMenu);
        AbstractAction configCarryForwardAction = new AbstractAction(UIRegistry.getResourceString("Specify.CONFIG_CARRY_FORWARD_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormViewObj fvo = Specify.this.getCurrentFVO();
                if (fvo != null) {
                    fvo.configureCarryForward();
                }
            }
        };
        configCarryForwardAction.setEnabled(false);
        JMenuItem configCFWMI = new JMenuItem(configCarryForwardAction);
        dataMenu.add(configCFWMI);
        UIRegistry.register("ConfigCarryForward", configCFWMI);
        UIRegistry.registerAction("ConfigCarryForward", configCarryForwardAction);
        mb.add(dataMenu);
        AbstractAction carryForwardAction = new AbstractAction(UIRegistry.getResourceString("Specify.CARRY_FORWARD_CHECKED_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormViewObj fvo = Specify.this.getCurrentFVO();
                if (fvo != null) {
                    fvo.toggleCarryForward();
                    ((JCheckBoxMenuItem)e.getSource()).setSelected(fvo.isDoCarryForward());
                }
            }
        };
        carryForwardAction.setEnabled(false);
        JCheckBoxMenuItem carryForwardCBMI = new JCheckBoxMenuItem(carryForwardAction);
        dataMenu.add(carryForwardCBMI);
        UIRegistry.register("CarryForward", carryForwardCBMI);
        UIRegistry.registerAction("CarryForward", carryForwardAction);
        mb.add(dataMenu);
        if (!this.isWorkbenchOnly) {
            String AUTO_NUM = "AutoNumbering";
            AbstractAction autoNumberOnOffAction = new AbstractAction(UIRegistry.getResourceString("FormViewObj.SET_AUTONUMBER_ONOFF")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FormViewObj fvo = Specify.this.getCurrentFVO();
                    if (fvo != null) {
                        fvo.toggleAutoNumberOnOffState();
                        ((JCheckBoxMenuItem)e.getSource()).setSelected(fvo.isAutoNumberOn());
                    }
                }
            };
            autoNumberOnOffAction.setEnabled(false);
            JCheckBoxMenuItem autoNumCBMI = new JCheckBoxMenuItem(autoNumberOnOffAction);
            dataMenu.add(autoNumCBMI);
            UIRegistry.register("AutoNumbering", autoNumCBMI);
            UIRegistry.registerAction("AutoNumbering", autoNumberOnOffAction);
        }
        if (System.getProperty("user.name").equals("rods")) {
            dataMenu.addSeparator();
            AbstractAction gpxAction = new AbstractAction("GPS Data"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GPXPanel.getDlgInstance().setVisible(true);
                }
            };
            JMenuItem gpxMI = new JMenuItem(gpxAction);
            dataMenu.add(gpxMI);
            UIRegistry.register("GPXDlg", gpxMI);
            UIRegistry.registerAction("GPXDlg", gpxAction);
        }
        mb.add(dataMenu);
        SubPaneMgr.getInstance();
        if (!this.isWorkbenchOnly) {
            menu = UIHelper.createLocalizedMenu(mb, "Specify.SYSTEM_MENU", "Specify.SYSTEM_MNEU");
        }
        menu = UIHelper.createLocalizedMenu(mb, "Specify.TABS_MENU", "Specify.TABS_MNEU");
        String ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_CUR_MENU");
        String mnu2 = UIRegistry.getResourceString("Specify.SBP_CLOSE_CUR_MNEU");
        mi = UIHelper.createMenuItemWithAction(menu, ttl, mnu2, ttl, true, UIRegistry.getAction("CloseCurrent"));
        if (!UIHelper.isMacOS()) {
            mi.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        }
        ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALL_MENU");
        mnu2 = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALL_MNEU");
        mi = UIHelper.createMenuItemWithAction(menu, ttl, mnu2, ttl, true, UIRegistry.getAction("CloseAll"));
        if (!UIHelper.isMacOS()) {
            mi.setAccelerator(KeyStroke.getKeyStroke(87, 192));
        }
        ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALLBUT_MENU");
        mnu2 = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALLBUT_MNEU");
        mi = UIHelper.createMenuItemWithAction(menu, ttl, mnu2, ttl, true, UIRegistry.getAction("CloseAllBut"));
        menu.addSeparator();
        JMenuItem configTaskMI = new JMenuItem(UIRegistry.getAction("ConfigureTask"));
        menu.add(configTaskMI);
        boolean doDebug = AppPreferences.getLocalPrefs().getBoolean("debug.menu", false);
        if (!UIRegistry.isRelease() || doDebug) {
            menu = UIHelper.createLocalizedMenu(mb, "Specify.DEBUG_MENU", "Specify.DEBUG_MNEU");
            String ttle = "Specify.SHOW_LOC_PREFS";
            String mneu = "Specify.SHOW_LOC_PREF_MNEU";
            String desc = "Specify.SHOW_LOC_PREFS";
            mi = UIHelper.createLocalizedMenuItem(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.openLocalPrefs();
                }
            });
            ttle = "Specify.SHOW_REM_PREFS";
            mneu = "Specify.SHOW_REM_PREFS_MNEU";
            desc = "Specify.SHOW_REM_PREFS";
            mi = UIHelper.createLocalizedMenuItem(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.openRemotePrefs();
                }
            });
            menu.addSeparator();
            ttle = "Specify.CONFIG_LOGGERS";
            mneu = "Specify.CONFIG_LOGGERS_MNEU";
            desc = "Specify.CONFIG_LOGGER";
            mi = UIHelper.createLocalizedMenuItem(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LoggerDialog dialog = new LoggerDialog(Specify.this.topFrame);
                    UIHelper.centerAndShow(dialog);
                }
            });
            ttle = "Specify.CONFIG_DEBUG_LOGGERS";
            mneu = "Specify.CONFIG_DEBUG_LOGGERS_MNEU";
            desc = "Specify.CONFIG_DEBUG_LOGGER";
            mi = UIHelper.createLocalizedMenuItem(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DebugLoggerDialog dialog = new DebugLoggerDialog(Specify.this.topFrame);
                    UIHelper.centerAndShow(dialog);
                }
            });
            menu.addSeparator();
            ttle = "Specify.SHOW_MEM_STATS";
            mneu = "Specify.SHOW_MEM_STATS_MNEU";
            desc = "Specify.SHOW_MEM_STATS";
            mi = UIHelper.createLocalizedMenuItem(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    System.gc();
                    System.runFinalization();
                    double meg = 1048576.0;
                    double heapSize = (double)Runtime.getRuntime().totalMemory() / meg;
                    double heapMaxSize = (double)Runtime.getRuntime().maxMemory() / meg;
                    double heapFreeSize = (double)Runtime.getRuntime().freeMemory() / meg;
                    UIRegistry.getStatusBar().setText(String.format("Heap Size: %7.2f    Max: %7.2f    Free: %7.2f   Used: %7.2f", heapSize, heapMaxSize, heapFreeSize, heapSize - heapFreeSize));
                }
            });
            JMenu prefsMenu = new JMenu(UIRegistry.getResourceString("Specify.PREFS_IMPORT_EXPORT"));
            menu.add(prefsMenu);
            ttle = "Specify.IMPORT_MENU";
            mneu = "Specify.IMPORT_MNEU";
            desc = "Specify.IMPORT_PREFS";
            mi = UIHelper.createLocalizedMenuItem(prefsMenu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.importPrefs();
                }
            });
            ttle = "Specify.EXPORT_MENU";
            mneu = "Specify.EXPORT_MNEU";
            desc = "Specify.EXPORT_PREFS";
            mi = UIHelper.createLocalizedMenuItem(prefsMenu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.exportPrefs();
                }
            });
            ttle = "Associate Storage Items";
            mneu = "A";
            desc = "";
            mi = UIHelper.createMenuItemWithAction(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.associateStorageItems();
                }
            });
            ttle = "Load GPX Points";
            mneu = "a";
            desc = "";
            mi = UIHelper.createMenuItemWithAction(menu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CustomDialog dlg = GPXPanel.getDlgInstance();
                    if (dlg != null) {
                        dlg.setVisible(true);
                    }
                }
            });
            JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem("Security Activated");
            menu.add(cbMenuItem);
            cbMenuItem.setSelected(AppContextMgr.isSecurityOn());
            cbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean isSecurityOn = !SpecifyAppContextMgr.isSecurityOn();
                    AppContextMgr.getInstance().setSecurity(isSecurityOn);
                    ((JMenuItem)ae.getSource()).setSelected(isSecurityOn);
                    JLabel secLbl = Specify.this.statusField.getSectionLabel(3);
                    if (secLbl != null) {
                        secLbl.setIcon(IconManager.getImage(isSecurityOn ? "SecurityOn" : "SecurityOff", IconManager.IconSize.Std16));
                        secLbl.setHorizontalAlignment(0);
                        secLbl.setToolTipText(UIRegistry.getResourceString("Specify.SEC_" + (isSecurityOn ? "ON" : "OFF")));
                    }
                }
            });
            JMenuItem sizeMenuItem = new JMenuItem("Set to 1024x768");
            menu.add(sizeMenuItem);
            sizeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.topFrame.setSize(1024, 768);
                }
            });
        }
        JMenu helpMenu = UIHelper.createLocalizedMenu(mb, "Specify.HELP_MENU", "Specify.HELP_MNEU");
        HelpMgr.createHelpMenuItem(helpMenu, UIRegistry.getResourceString("SPECIFY_HELP"));
        helpMenu.addSeparator();
        String ttle = "Specify.LOG_SHOW_FILES";
        String mneu = "Specify.LOG_SHOW_FILES_MNEU";
        String desc = "Specify.LOG_SHOW_FILES";
        mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
        helpMenu.addSeparator();
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AppBase.displaySpecifyLogFiles();
            }
        });
        ttle = "Specify.CHECK_UPDATE";
        mneu = "Specify.CHECK_UPDATE_MNEU";
        desc = "Specify.CHECK_UPDATE_DESC";
        mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Specify.this.checkForUpdates();
            }
        });
        ttle = "Specify.AUTO_REG";
        mneu = "Specify.AUTO_REG_MNEU";
        desc = "Specify.AUTO_REG_DESC";
        mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RegisterSpecify.register(true, 0);
            }
        });
        ttle = "Specify.SA_REG";
        mneu = "Specify.SA_REG_MNEU";
        desc = "Specify.SA_REG_DESC";
        mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RegisterSpecify.registerISA();
            }
        });
        ttle = "Specify.FEEDBACK";
        mneu = "Specify.FB_MNEU";
        desc = "Specify.FB_DESC";
        mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FeedBackDlg feedBackDlg = new FeedBackDlg();
                feedBackDlg.sendFeedback();
            }
        });
        helpMenu.addSeparator();
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            ttle = "Specify.ABOUT";
            mneu = "Specify.ABOUTMNEU";
            desc = "Specify.ABOUT";
            mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Specify.this.doAbout();
                }
            });
        }
        return mb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkForUpdates() {
        String errKey = null;
        String updatePath = UIRegistry.getResourceString("UPDATE_PATH");
        try {
            UpdateDescriptor updateDesc = UpdateChecker.getUpdateDescriptor((String)updatePath, (ApplicationDisplayMode)ApplicationDisplayMode.UNATTENDED);
            if (updateDesc != null) {
                UpdateDescriptorEntry entry = updateDesc.getPossibleUpdateEntry();
                if (entry != null) {
                    Object[] options = new Object[]{UIRegistry.getResourceString("Specify.INSTALLUPDATE"), UIRegistry.getResourceString("Specify.SKIP")};
                    int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage("Specify.UPDATE_AVAIL", entry.getNewVersion()), UIRegistry.getResourceString("Specify.UPDATE_AVAIL_TITLE"), 1, 3, null, options, options[0]);
                    if (userChoice != 0) return;
                    if (!this.doExit(false)) {
                        return;
                    }
                } else {
                    errKey = "Specify.NO_UPDATE_AVAIL";
                }
            } else {
                errKey = UPDATE_CHK_ERROR;
            }
        }
        catch (Exception ex) {
            errKey = UPDATE_CHK_ERROR;
            ex.printStackTrace();
            log.error((Object)ex);
        }
        if (errKey != null) {
            log.error((Object)String.format("Update Error: %s - %s", errKey, updatePath));
            UIRegistry.showLocalizedError(errKey);
            return;
        }
        try {
            ApplicationLauncher.Callback callback = new ApplicationLauncher.Callback(){

                public void exited(int exitValue) {
                    log.error((Object)("exitValue: " + exitValue));
                }

                public void prepareShutdown() {
                    log.error((Object)"prepareShutdown");
                }
            };
            ApplicationLauncher.launchApplication((String)"100", null, (boolean)true, (ApplicationLauncher.Callback)callback);
            return;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            log.error((Object)"EXPCEPTION");
        }
    }

    protected FormViewObj getCurrentFVO() {
        MultiView mv;
        SubPaneIFace sp = SubPaneMgr.getInstance().getCurrentSubPane();
        if (sp instanceof FormPane && (mv = ((FormPane)sp).getMultiView()) != null) {
            return mv.getCurrentViewAsFormViewObj();
        }
        return null;
    }

    public Storage getStorageItem(DataProviderSessionIFace session, String path, Storage parentArg) {
        Storage parent = parentArg;
        String nodeStr = StringUtils.substringBefore((String)path, (String)"/");
        String pathStr = StringUtils.substringAfter((String)path, (String)"/");
        if (parent == null) {
            parent = session.getData(Storage.class, "name", nodeStr, DataProviderSessionIFace.CompareType.Equals);
            if (StringUtils.isNotEmpty((String)pathStr)) {
                return this.getStorageItem(session, pathStr, parent);
            }
            return parent;
        }
        for (Storage node : parent.getChildren()) {
            if (!node.getName().equals(nodeStr)) continue;
            if (StringUtils.isNotEmpty((String)pathStr)) {
                return this.getStorageItem(session, pathStr, node);
            }
            return node;
        }
        return null;
    }

    protected void addCOToStorage(DataProviderSessionIFace session, Storage storage, CollectionObject co) throws Exception {
        if (co != null && storage != null) {
            Set<Preparation> preps = storage.getPreparations();
            for (Preparation prep : co.getPreparations()) {
                preps.add(prep);
                prep.setStorage(storage);
                session.saveOrUpdate(prep);
            }
            session.saveOrUpdate(co);
        }
    }

    protected void associateStorageItems() {
        this.showStorageHelperDlg();
    }

    protected void associate(Taxon taxon, Storage storage) {
        if (taxon != null && storage != null) {
            DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
            try {
                session.attach(taxon);
                session.attach(storage);
                session.beginTransaction();
                if (taxon != null) {
                    for (Determination deter : taxon.getDeterminations()) {
                        this.addCOToStorage(session, storage, deter.getCollectionObject());
                    }
                }
                session.commit();
            }
            catch (Exception ex) {
                session.rollback();
                ex.printStackTrace();
            }
            session.close();
        }
    }

    protected void showStorageHelperDlg() {
        int btnOpts = 0;
        ValComboBoxFromQuery taxonCBX = TypeSearchForQueryFactory.getInstance().createValComboBoxFromQuery("Taxon", btnOpts, null, null);
        taxonCBX.setRequired(true);
        ValComboBoxFromQuery storageCBX = TypeSearchForQueryFactory.getInstance().createValComboBoxFromQuery("Storage", btnOpts, null, null);
        storageCBX.setRequired(true);
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,p", "p,4px,p"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createI18NLabel("Taxon"), cc.xy(1, 1));
        pb.add((Component)taxonCBX, cc.xy(3, 1));
        pb.add((Component)UIHelper.createI18NLabel("Storage"), cc.xy(1, 3));
        pb.add((Component)storageCBX, cc.xy(3, 3));
        pb.setDefaultDialogBorder();
        CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getMostRecentWindow(), "", true, pb.getPanel());
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            this.associate((Taxon)taxonCBX.getValue(), (Storage)storageCBX.getValue());
        }
    }

    protected Action createAction(String name, String type, String action) {
        AbstractAction actionObj = new AbstractAction(UIRegistry.getResourceString(name)){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        UIRegistry.registerAction(name, actionObj);
        return actionObj;
    }

    protected void localities() {
        Connection connection = DBConnection.getInstance().getConnection();
        Statement stmt = null;
        Statement stmt2 = null;
        try {
            try {
                stmt = connection.createStatement();
                stmt2 = connection.createStatement();
                String sql = "SELECT l.LocalityID, l.LocalityName, g.FullName, l.Latitude1, l.Longitude1 FROM locality l INNER JOIN geography g ON l.GeographyID = g.GeographyID";
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String currLocalityName = rs.getString(2);
                    ResultSet rs1 = stmt2.executeQuery(String.valueOf(sql) + " WHERE g.FullName = \"" + rs.getString(3) + "\" AND l.LocalityID <> " + rs.getInt(1));
                    while (rs1.next()) {
                        String localityName = rs1.getString(2);
                        int distance = StringUtils.getLevenshteinDistance((String)currLocalityName, (String)localityName);
                        if (distance >= 6) continue;
                        log.error((Object)("----- " + distance + "\n" + currLocalityName + "\n" + localityName));
                        log.error((Object)(rs.getBigDecimal(4) + "," + rs.getBigDecimal(5) + "\n" + rs1.getBigDecimal(4) + "," + rs1.getBigDecimal(5)));
                    }
                    rs1.close();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void doAbout() {
        AppContextMgr acm = AppContextMgr.getInstance();
        boolean hasContext = acm.hasContext();
        int baseNumRows = 11;
        String serverName = AppPreferences.getLocalPrefs().get("login.servers_selected", null);
        if (serverName != null) {
            ++baseNumRows;
        }
        CellConstraints cc = new CellConstraints();
        PanelBuilder infoPB = new PanelBuilder(new FormLayout("p,6px,f:p:g", "p,4px,p,4px," + UIHelper.createDuplicateJGoodiesDef("p", "2px", baseNumRows)));
        JLabel iconLabel = new JLabel(IconManager.getIcon("SpecifyLargeIcon"), 0);
        PanelBuilder iconPB = new PanelBuilder(new FormLayout("p", "20px,t:p,f:p:g"));
        iconPB.add((Component)iconLabel, cc.xy(1, 2));
        if (hasContext) {
            Vector<Object[]> list;
            DBTableIdMgr tableMgr = DBTableIdMgr.getInstance();
            boolean hasReged = !RegisterSpecify.isAnonymous() && RegisterSpecify.hasInstitutionRegistered();
            int y = 1;
            infoPB.addSeparator(UIRegistry.getResourceString("Specify.SYS_INFO"), cc.xyw(1, y, 3));
            JLabel lbl = UIHelper.createLabel(this.databaseName);
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.DB"), cc.xy(1, y += 2));
            infoPB.add((Component)lbl, cc.xy(3, y));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Specify.this.openLocalPrefs();
                    }
                }
            });
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Institution.getClassTableId())), cc.xy(1, y += 2));
            lbl = UIHelper.createLabel(acm.getClassObject(Institution.class).getName());
            infoPB.add((Component)lbl, cc.xy(3, y));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Specify.this.openRemotePrefs();
                    }
                }
            });
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Division.getClassTableId())), cc.xy(1, y += 2));
            lbl = UIHelper.createLabel(acm.getClassObject(Division.class).getName());
            infoPB.add((Component)lbl, cc.xy(3, y));
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Specify.this.openGlobalPrefs();
                    }
                }
            });
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Discipline.getClassTableId())), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(acm.getClassObject(Discipline.class).getName()), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createFormLabel(tableMgr.getTitleForId(Collection.getClassTableId())), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(acm.getClassObject(Collection.class).getCollectionName()), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.BLD"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(this.appBuildVersion), cc.xy(3, y));
            UIRegistry.loadAndPushResourceBundle("bld");
            infoPB.add((Component)UIHelper.createFormLabel("SVN"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("build")), cc.xy(3, y));
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.BLD_TM"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("buildtime")), cc.xy(3, y));
            UIRegistry.popResourceBundle();
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.REG"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createI18NLabel(hasReged ? "Specify.HASREG" : "Specify.NOTREG"), cc.xy(3, y));
            String isaNumber = RegisterSpecify.getISANumber();
            infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.ISANUM"), cc.xy(1, y += 2));
            infoPB.add((Component)UIHelper.createLabel(StringUtils.isNotEmpty((String)isaNumber) ? isaNumber : ""), cc.xy(3, y));
            y += 2;
            if (serverName != null) {
                infoPB.add((Component)UIHelper.createI18NFormLabel("Specify.SERVER"), cc.xy(1, y));
                infoPB.add((Component)UIHelper.createLabel(StringUtils.isNotEmpty((String)serverName) ? serverName : ""), cc.xy(3, y));
                y += 2;
            }
            if (StringUtils.contains((String)DBConnection.getInstance().getConnectionStr(), (String)"mysql") && (list = BasicSQLUtils.query("select version() as ve")) != null && list.size() > 0) {
                infoPB.add((Component)UIHelper.createFormLabel("MySQL Version"), cc.xy(1, y));
                infoPB.add((Component)UIHelper.createLabel(list.get(0)[0].toString()), cc.xy(3, y));
                y += 2;
            }
            infoPB.add((Component)UIHelper.createFormLabel("Java Version"), cc.xy(1, y));
            infoPB.add((Component)UIHelper.createLabel(System.getProperty("java.version")), cc.xy(3, y));
            y += 2;
        }
        String txt = Specify.getAboutText(this.appName, this.appVersion);
        JLabel txtLbl = UIHelper.createLabel(txt);
        txtLbl.setFont(UIRegistry.getDefaultFont());
        JEditorPane txtPane = new JEditorPane("text/html", txt);
        txtPane.setEditable(false);
        txtPane.setBackground(new JPanel().getBackground());
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,20px,f:min(400px;p):g,10px,8px,10px,p:g", "f:p:g"));
        pb.add((Component)iconPB.getPanel(), cc.xy(1, 1));
        pb.add((Component)txtPane, cc.xy(3, 1));
        Color bg = this.getBackground();
        if (hasContext) {
            pb.add((Component)new VerticalSeparator(bg.darker(), bg.brighter()), cc.xy(5, 1));
            pb.add((Component)infoPB.getPanel(), cc.xy(7, 1));
        }
        pb.setDefaultDialogBorder();
        String title = UIRegistry.getResourceString("Specify.ABOUT");
        CustomDialog aboutDlg = new CustomDialog(this.topFrame, String.valueOf(title) + " " + this.appName, true, 1, (Component)pb.getPanel());
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        aboutDlg.setOkLabel(okLabel);
        aboutDlg.createUI();
        aboutDlg.pack();
        Dimension size = aboutDlg.getSize();
        size.height += 120;
        aboutDlg.setSize(size);
        txtPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        AttachmentUtils.openURI(event.getURL().toURI());
                    }
                    catch (Exception e) {
                        UsageTracker.incrHandledUsageCount();
                    }
                }
            }
        });
        UIHelper.centerAndShow(aboutDlg);
    }

    public static String getAboutText(String appNameArg, String appVersionArg) {
        return "<html><font face=\"sans-serif\" size=\"11pt\">" + appNameArg + " " + appVersionArg + "<br><br>Specify Software Project<br>" + "Biodiversity Institute<br>University of Kansas<br>1345 Jayhawk Blvd.<br>Lawrence, KS  USA 66045<br><br>" + "<a href=\"http://www.specifysoftware.org\">www.specifysoftware.org</a>" + "<br><a href=\"mailto:specify@ku.edu\">specify@ku.edu</a><br>" + "<p>The Specify Software Project is " + "funded by the Advances in Biological Informatics Program, " + "U.S. National Science Foundation  (Award DBI-0960913 and earlier awards).<br><br>" + "Specify 6.0 Copyright \u00a9 2012 University of Kansas Center for Research. " + "Specify comes with ABSOLUTELY NO WARRANTY.<br><br>" + "This is free software licensed under GNU General Public License 2 (GPL2).</P></font></html>";
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        boolean okToShutdown;
        block39: {
            block36: {
                okToShutdown = true;
                try {
                    try {
                        block37: {
                            if (AttachmentUtils.getAttachmentManager() != null) {
                                AttachmentUtils.getAttachmentManager().cleanup();
                            }
                            if (!(okToShutdown = SubPaneMgr.getInstance().aboutToShutdown())) break block36;
                            UsageTracker.save();
                            try {
                                DataProviderSessionIFace session = null;
                                SpecifyUser currentUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class);
                                if (currentUser == null) break block37;
                                session = DataProviderFactory.getInstance().createSession();
                                SpecifyUser user = session.getData(SpecifyUser.class, "id", currentUser.getId(), DataProviderSessionIFace.CompareType.Equals);
                                user.setIsLoggedIn(false);
                                user.setLoginDisciplineName(null);
                                user.setLoginCollectionName(null);
                                user.setLoginOutTime(new Timestamp(System.currentTimeMillis()));
                                try {
                                    try {
                                        session.beginTransaction();
                                        session.saveOrUpdate(user);
                                        session.commit();
                                    }
                                    catch (Exception ex) {
                                        log.error((Object)ex);
                                        if (session != null) {
                                            session.close();
                                        }
                                        break block37;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (session != null) {
                                        session.close();
                                    }
                                    throw throwable;
                                }
                                if (session != null) {
                                    session.close();
                                }
                            }
                            catch (Exception ex) {
                                log.error((Object)ex);
                            }
                        }
                        if (!BackupServiceFactory.getInstance().checkForBackUp(true)) {
                            log.info((Object)"Application shutdown");
                            if (this.topFrame != null) {
                                Rectangle r = this.topFrame.getBounds();
                                AppPreferences.getLocalPrefs().putInt("APP.X", r.x);
                                AppPreferences.getLocalPrefs().putInt("APP.Y", r.y);
                                AppPreferences.getLocalPrefs().putInt("APP.W", r.width);
                                AppPreferences.getLocalPrefs().putInt("APP.H", r.height);
                            }
                            AppPreferences.getLocalPrefs().flush();
                            try {
                                UIRegistry.getLongTermFileCache().saveCacheMapping();
                                log.info((Object)"Successfully saved long term cache mapping");
                            }
                            catch (IOException ioe) {
                                log.warn((Object)"Error while saving long term cache mapping.", (Throwable)ioe);
                            }
                            log.info((Object)"Clearing the short term cache");
                            UIRegistry.getShortTermFileCache().clear();
                            try {
                                UIRegistry.getFormsCache().saveCacheMapping();
                                log.info((Object)"Successfully saved forms cache mapping");
                            }
                            catch (IOException ioe) {
                                log.warn((Object)"Error while saving forms cache mapping.", (Throwable)ioe);
                            }
                            if (this.topFrame != null) {
                                this.topFrame.setVisible(false);
                            }
                            QueryExecutor.getInstance().shutdown();
                            break block36;
                        }
                        okToShutdown = false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (okToShutdown && doAppExit) {
                            Boolean canSendStats = false;
                            if (AppContextMgr.getInstance().hasContext()) {
                                canSendStats = AppPreferences.getRemote().getBoolean(sendStatsPrefName, true);
                            }
                            if (canSendStats.booleanValue()) {
                                Boolean canSendISAStats = AppPreferences.getRemote().getBoolean(sendISAStatsPrefName, true);
                                StatsTrackerTask statsTrackerTask = (StatsTrackerTask)TaskMgr.getTask("StatsTracker");
                                if (statsTrackerTask != null) {
                                    UIRegistry.getTopWindow().setVisible(false);
                                    statsTrackerTask.setSendSecondaryStatsAllowed(canSendISAStats);
                                    statsTrackerTask.sendStats(false, false, true);
                                    return false;
                                }
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        CommandDispatcher.dispatch(new CommandAction("App", Specify.STATS_SEND_DONE, null));
                                    }
                                });
                            }
                        }
                        break block39;
                    }
                }
                catch (Throwable throwable) {
                    if (okToShutdown && doAppExit) {
                        Boolean canSendStats = false;
                        if (AppContextMgr.getInstance().hasContext()) {
                            canSendStats = AppPreferences.getRemote().getBoolean(sendStatsPrefName, true);
                        }
                        if (canSendStats.booleanValue()) {
                            Boolean canSendISAStats = AppPreferences.getRemote().getBoolean(sendISAStatsPrefName, true);
                            StatsTrackerTask statsTrackerTask = (StatsTrackerTask)TaskMgr.getTask("StatsTracker");
                            if (statsTrackerTask != null) {
                                UIRegistry.getTopWindow().setVisible(false);
                                statsTrackerTask.setSendSecondaryStatsAllowed(canSendISAStats);
                                statsTrackerTask.sendStats(false, false, true);
                                return false;
                            }
                        } else {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    throw throwable;
                }
            }
            if (okToShutdown && doAppExit) {
                Boolean canSendStats = false;
                if (AppContextMgr.getInstance().hasContext()) {
                    canSendStats = AppPreferences.getRemote().getBoolean(sendStatsPrefName, true);
                }
                if (canSendStats.booleanValue()) {
                    Boolean canSendISAStats = AppPreferences.getRemote().getBoolean(sendISAStatsPrefName, true);
                    StatsTrackerTask statsTrackerTask = (StatsTrackerTask)TaskMgr.getTask("StatsTracker");
                    if (statsTrackerTask != null) {
                        UIRegistry.getTopWindow().setVisible(false);
                        statsTrackerTask.setSendSecondaryStatsAllowed(canSendISAStats);
                        statsTrackerTask.sendStats(false, false, true);
                        return false;
                    }
                } else {
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }
        return okToShutdown;
    }

    protected String getTitle() {
        String resAppVersion = UIRegistry.getAppVersion();
        if (StringUtils.isNotEmpty((String)resAppVersion)) {
            this.appVersion = resAppVersion;
        }
        return AppBase.getTitle(this.appVersion, this.appBuildVersion, this.appName);
    }

    public void showApp() {
        JFrame f = this.getFrame();
        f.setTitle(this.getTitle());
        f.getContentPane().add((Component)this, "Center");
        f.pack();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Specify.this.doExit(true);
            }
        });
        UIHelper.centerWindow(f);
        Rectangle r = f.getBounds();
        int x = AppPreferences.getLocalPrefs().getInt("APP.X", r.x);
        int y = AppPreferences.getLocalPrefs().getInt("APP.Y", r.y);
        int w = AppPreferences.getLocalPrefs().getInt("APP.W", r.width);
        int h = AppPreferences.getLocalPrefs().getInt("APP.H", r.height);
        UIHelper.positionAndFitToScreen(f, x, y, w, h);
        f.setVisible(true);
    }

    public JFrame getFrame() {
        if (this.topFrame == null) {
            this.topFrame = new JFrame();
        }
        return this.topFrame;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setStatus(String s) {
        SwingUtilities.invokeLater(new SpecifyRunnable(this, s){

            @Override
            public void run() {
                this.mApp.statusField.setText((String)this.obj);
            }
        });
    }

    protected static void setupDefaultFonts() {
        Font labelFont = UIHelper.createLabel("").getFont();
        Font defaultFont = !UIHelper.isMacOS() ? labelFont : labelFont;
        BaseTask.setToolbarBtnFont(defaultFont);
        RolloverCommand.setDefaultFont(defaultFont);
    }

    protected void checkAndSendStats() {
        StatsTrackerTask statsTrackerTask;
        AppPreferences appPrefs = AppPreferences.getRemote();
        Boolean canSendStats = appPrefs.getBoolean(sendStatsPrefName, null);
        Boolean canSendISAStats = appPrefs.getBoolean(sendISAStatsPrefName, null);
        if (canSendStats == null) {
            canSendStats = true;
            appPrefs.putBoolean(sendStatsPrefName, canSendStats);
        }
        if (canSendStats.booleanValue() && (statsTrackerTask = (StatsTrackerTask)TaskMgr.getTask("StatsTracker")) != null) {
            statsTrackerTask.setSendSecondaryStatsAllowed(canSendISAStats);
            statsTrackerTask.sendStats(false, true, false);
        }
    }

    public void restartApp(Window window, String databaseNameArg, String userNameArg, boolean startOver, boolean firstTime) {
        AppContextMgr.CONTEXT_STATUS status;
        block25: {
            String dbPassword;
            SpecifyUser spUser;
            log.debug((Object)"restartApp");
            if (this.dbLoginPanel != null) {
                this.dbLoginPanel.getStatusBar().setText(UIRegistry.getResourceString("Specify.INITIALIZING_APP"));
            }
            if (!firstTime) {
                this.checkAndSendStats();
            }
            UIRegistry.dumpPaths();
            try {
                AppPreferences.getLocalPrefs().flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            AppPreferences.shutdownRemotePrefs();
            AppPreferences.shutdownPrefs();
            AppPreferences.setConnectedToDB(false);
            status = AppContextMgr.getInstance().setContext(databaseNameArg, userNameArg, startOver, firstTime, !firstTime);
            if (!(status != AppContextMgr.CONTEXT_STATUS.OK || (spUser = AppContextMgr.getInstance().getClassObject(SpecifyUser.class)) == null || !StringUtils.isNotEmpty((String)(dbPassword = spUser.getPassword())) || StringUtils.isAlphanumeric((String)dbPassword) && UIHelper.isAllCaps(dbPassword) && dbPassword.length() >= 25)) {
                String encryptedPassword = Encryption.encrypt(spUser.getPassword(), spUser.getPassword());
                spUser.setPassword(encryptedPassword);
                DataProviderSessionIFace session = DataProviderFactory.getInstance().createSession();
                try {
                    try {
                        session.beginTransaction();
                        session.saveOrUpdate(session.merge(spUser));
                        session.commit();
                    }
                    catch (Exception ex) {
                        session.rollback();
                        ex.printStackTrace();
                        session.close();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    session.close();
                    throw throwable;
                }
                session.close();
            }
        }
        UsageTracker.setUserInfo(databaseNameArg, userNameArg);
        SpecifyAppPrefs.initialPrefs();
        AppPreferences appPrefs = AppPreferences.getRemote();
        Boolean canSendStats = appPrefs.getBoolean(sendStatsPrefName, null);
        Boolean canSendISAStats = appPrefs.getBoolean(sendISAStatsPrefName, null);
        if (canSendStats == null) {
            canSendStats = true;
            appPrefs.putBoolean(sendStatsPrefName, canSendStats);
        }
        if (canSendISAStats == null) {
            canSendISAStats = true;
            appPrefs.putBoolean(sendISAStatsPrefName, canSendISAStats);
        }
        if (status == AppContextMgr.CONTEXT_STATUS.OK) {
            if (AppContextMgr.getInstance().getClassObject(Discipline.class) == null) {
                return;
            }
            if (firstTime) {
                GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                this.initialize(gc);
                this.topFrame.setDefaultCloseOperation(0);
                UIRegistry.register("frame", this.topFrame);
            } else {
                SubPaneMgr.getInstance().closeAll();
            }
            this.preInitializePrefs();
            this.initStartUpPanels(databaseNameArg, userNameArg);
            AppPrefsCache.addChangeListener("ui.formatting.scrdateformat", UIFieldFormatterMgr.getInstance());
            if (this.changeCollectionMenuItem != null) {
                this.changeCollectionMenuItem.setEnabled(((SpecifyAppContextMgr)AppContextMgr.getInstance()).getNumOfCollectionsForUser() > 1);
            }
            if (window != null) {
                window.setVisible(false);
            }
            if (!AppPreferences.getGlobalPrefs().getBoolean("CollectingEventsAndAttrsMaint1", false).booleanValue()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CollectingEventsAndAttrsMaint dbMaint = new CollectingEventsAndAttrsMaint();
                        dbMaint.performMaint();
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FixDBAfterLogin fixer;
                    if (!AppPreferences.getGlobalPrefs().getBoolean("FixUploaderRecordsets", false).booleanValue()) {
                        fixer = new FixDBAfterLogin();
                        fixer.fixUploaderRecordsets();
                    }
                    if (!AppPreferences.getGlobalPrefs().getBoolean("FixNullEmbeddedCollectingEvents", false).booleanValue()) {
                        FixDBAfterLogin.fixNullEmbeddedCollectingEvents();
                    }
                    if (!AppPreferences.getGlobalPrefs().getBoolean("FixedUnMatchedWBSpecifyUserIDs", false).booleanValue()) {
                        FixDBAfterLogin.fixUnMatchedWBSpecifyUserIDs();
                    }
                    fixer = new FixDBAfterLogin();
                    fixer.checkMultipleLocalities();
                }
            });
            DataBuilder.mergeStandardGroups(AppContextMgr.getInstance().getClassObject(Collection.class));
        } else if (status == AppContextMgr.CONTEXT_STATUS.Error) {
            if (this.dbLoginPanel != null) {
                this.dbLoginPanel.getWindow().setVisible(false);
            }
            if (AppContextMgr.getInstance().getClassObject(Collection.class) == null) {
                JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH"), UIRegistry.getResourceString("Specify.LOGIN_USER_MISMATCH_TITLE"), 0);
                System.exit(0);
            }
        }
        CommandDispatcher.dispatch(new CommandAction("App", firstTime ? "StartUp" : "AppRestart", null));
        TaskMgr.requestInitalContext();
        if (!UIRegistry.isRelease()) {
            DebugLoggerDialog dialog = new DebugLoggerDialog(null);
            dialog.configureLoggers();
        }
        this.showApp();
        if (this.dbLoginPanel != null) {
            this.dbLoginPanel.getWindow().setVisible(false);
            this.dbLoginPanel = null;
        }
        this.setDatabaseNameAndCollection();
    }

    protected void importPrefs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        String title = UIRegistry.getResourceString("Specify.SELECT_FILE_OR_DIR");
        if (chooser.showDialog(null, title) != 1) {
            File destFile = chooser.getSelectedFile();
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(destFile));
                AppPreferences remotePrefs = AppPreferences.getRemote();
                for (Object key : properties.keySet()) {
                    String keyStr = (String)key;
                    remotePrefs.getProperties().put(keyStr, properties.get(key));
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        } else {
            throw new NoSuchElementException("The External File Repository needs a valid directory.");
        }
    }

    protected void exportPrefs() {
        AppPreferences remotePrefs = AppPreferences.getRemote();
        Properties props = remotePrefs.getProperties();
        try {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            String title = UIRegistry.getResourceString("Specify.SELECT_FILE_OR_DIR");
            if (chooser.showDialog(null, title) == 1) {
                throw new NoSuchElementException("The External File Repository needs a valid directory.");
            }
            File destFile = chooser.getSelectedFile();
            props.store(new FileOutputStream(destFile), "User Prefs");
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    @Override
    public void loggedIn(Window window, String databaseNameArg, String userNameArg) {
        log.debug((Object)("loggedIn - database[" + databaseNameArg + "] username[" + userNameArg + "]"));
        boolean firstTime = this.databaseName == null;
        this.databaseName = databaseNameArg;
        this.userName = userNameArg;
        FormHelper.setCurrentUserEditStr(userNameArg);
        AppPreferences.setConnectedToDB(true);
        this.restartApp(window, this.databaseName, this.userName, false, firstTime);
        if (this.statusField != null) {
            this.statusField.setSectionText(2, this.userName);
            this.statusField.setSectionToolTipText(2, DBTableIdMgr.getInstance().getTitleForId(SpecifyUser.getClassTableId()));
        }
    }

    protected void setDatabaseNameAndCollection() {
        if (this.statusField != null) {
            String collectionName;
            AppContextMgr mgr = AppContextMgr.getInstance();
            String disciplineName = mgr.getClassObject(Discipline.class).getName();
            String string = collectionName = mgr.getClassObject(Collection.class) != null ? mgr.getClassObject(Collection.class).getCollectionName() : "";
            if (!UIRegistry.isMobile()) {
                this.statusField.setSectionText(0, disciplineName);
                this.statusField.setSectionText(1, collectionName);
                this.statusField.setSectionToolTipText(0, DBTableIdMgr.getInstance().getTitleForId(Discipline.getClassTableId()));
                this.statusField.setSectionToolTipText(1, DBTableIdMgr.getInstance().getTitleForId(Collection.getClassTableId()));
            } else {
                this.statusField.setSectionText(0, "Specify Mobile");
                this.statusField.setSectionText(1, "WorkBench");
                this.statusField.setSectionToolTipText(0, null);
                this.statusField.setSectionToolTipText(1, null);
            }
            AppPreferences.getLocalPrefs().put("CURRENT_DB", this.databaseName);
        }
    }

    @Override
    public void cancelled() {
        DataProviderFactory.getInstance().shutdown();
        DBConnection.shutdown();
        DBConnection.shutdownFinalConnection(true, false);
    }

    public static void adjustLocaleFromPrefs() {
        String language = AppPreferences.getLocalPrefs().get("locale.lang", null);
        if (language != null) {
            String country = AppPreferences.getLocalPrefs().get("locale.country", "");
            String variant = AppPreferences.getLocalPrefs().get("locale.var", "");
            Locale prefLocale = new Locale(language, country, variant);
            Locale.setDefault(prefLocale);
            UIRegistry.setResourceLocale(prefLocale);
        }
        try {
            ResourceBundle.getBundle("resources", Locale.getDefault());
        }
        catch (MissingResourceException ex) {
            Locale.setDefault(Locale.ENGLISH);
            UIRegistry.setResourceLocale(Locale.ENGLISH);
        }
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppBuildVersion() {
        return this.appBuildVersion;
    }

    @Override
    public void doCommand(final CommandAction cmdAction) {
        if (cmdAction.isType("App")) {
            if (cmdAction.isAction("AppReqRestart")) {
                UIRegistry.writeGlassPaneMsg(UIRegistry.getResourceString("Specify.RESET_ENV"), 24);
                SwingWorker workerThread = new SwingWorker(){

                    @Override
                    public Object construct() {
                        Specify.this.restartApp(null, Specify.this.databaseName, Specify.this.userName, true, false);
                        return null;
                    }

                    @Override
                    public void finished() {
                        UIRegistry.clearGlassPaneMsg();
                    }
                };
                workerThread.start();
            } else if (cmdAction.isAction("AppReqExit")) {
                this.doExit(true);
            } else if (cmdAction.isAction("CheckForUpdates")) {
                this.checkForUpdates();
            } else if (cmdAction.isAction(STATS_SEND_DONE)) {
                AppPreferences.shutdownAllPrefs();
                if (UIRegistry.isMobile()) {
                    DataProviderFactory.getInstance().shutdown();
                    DBConnection.shutdown();
                    DBConnection.shutdownFinalConnection(true, false);
                } else {
                    DataProviderFactory.getInstance().shutdown();
                    DBConnection.shutdown();
                    System.exit(0);
                }
            }
        } else if (cmdAction.isType(ERRMSG) && cmdAction.isAction("DISPLAY")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIRegistry.displayErrorDlgLocalized((String)cmdAction.getData(), new Object[0]);
                }
            });
        }
    }

    public static Specify getSpecify() {
        return specifyApp;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public static void startApp() {
        boolean isRelease = true;
        UIRegistry.setRelease(isRelease);
        UIRegistry.setTesting(!isRelease);
        boolean doCheckSum = false;
        XMLHelper.setUseChecksum(isRelease && doCheckSum);
        IconManager.setApplicationClass(Specify.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_imgproc.xml"));
        if (!UIRegistry.isRelease()) {
            MemoryWarningSystem.setPercentageUsageThreshold(0.75);
            MemoryWarningSystem mws = new MemoryWarningSystem();
            mws.addListener(new MemoryWarningSystem.Listener(){

                protected void setMessage(String msg, boolean isError) {
                    JStatusBar statusBar = UIRegistry.getStatusBar();
                    if (statusBar != null) {
                        if (isError) {
                            statusBar.setErrorMessage(msg);
                        } else {
                            statusBar.setText(msg);
                        }
                    } else {
                        log.error((Object)msg);
                    }
                }

                @Override
                public void memoryUsage(long usedMemory, long maxMemory) {
                    double percentageUsed = (double)usedMemory / (double)maxMemory;
                    String msg = String.format("Percent Memory Used %6.2f of Max %d", percentageUsed * 100.0, maxMemory);
                    this.setMessage(msg, false);
                }

                @Override
                public void memoryUsageLow(long usedMemory, long maxMemory) {
                    double percentageUsed = (double)usedMemory / (double)maxMemory;
                    String msg = String.format("Memory is Low! Percentage Used = %6.2f of Max %d", percentageUsed * 100.0, maxMemory);
                    this.setMessage(msg, true);
                    if (MemoryWarningSystem.getThresholdPercentage() < 0.8) {
                        MemoryWarningSystem.setPercentageUsageThreshold(0.8);
                    }
                }
            });
        }
        Font defFont = UIHelper.createLabel("").getFont();
        UIRegistry.setDefaultFont(defFont);
        Specify.setupDefaultFonts();
        Font sysBaseFont = UIRegistry.getBaseFont();
        String key = "ui.formatting.controlSizes";
        String fontName = AppPreferences.getLocalPrefs().get(String.valueOf(key) + ".FN", UIRegistry.getBaseFont().getFamily());
        Integer fontSize = AppPreferences.getLocalPrefs().getInt(String.valueOf(key) + ".SZ", UIRegistry.getBaseFont().getSize());
        Font newBaseFont = fontName != null && fontSize != null ? new Font(fontName, 0, fontSize) : sysBaseFont;
        UIRegistry.setBaseFont(newBaseFont);
        BaseTask.setToolbarBtnFont(newBaseFont);
        RolloverCommand.setDefaultFont(newBaseFont);
        ImageIcon helpIcon = IconManager.getIcon(Specify.getIconName(), IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        Specify specify = new Specify();
        RolloverCommand.setHoverImg(IconManager.getIcon("DropIndicator"));
        specify.preStartUp();
        specify.startUp();
    }

    public static void checkDebugLoggerSettings() {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            String className;
            boolean isOn;
            Logger logger = (Logger)e.nextElement();
            int inx = logger.getName().lastIndexOf(46);
            if (inx <= -1 || !(isOn = localPrefs.getBoolean(String.valueOf(className = logger.getName().substring(inx + 1)) + ".debug", false).booleanValue())) continue;
            logger.setLevel(Level.DEBUG);
        }
    }

    public static void main(String[] args) {
        UIRegistry.setAppName("Specify");
        AppBase.processArgs(args);
        AppBase.setupTeeForStdErrStdOut(true, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                log.debug((Object)"Checking for update....");
                try {
                    boolean isMgrRel;
                    String EXTRA_CHECK;
                    Boolean isExtraCheck;
                    String EZDB_FIRSTTIME;
                    try {
                        UIHelper.OSTYPE osType = UIHelper.getOSType();
                        if (osType == UIHelper.OSTYPE.Windows) {
                            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
                        } else if (osType == UIHelper.OSTYPE.Linux) {
                            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Can't change L&F: ", (Throwable)e);
                    }
                    AppPreferences localPrefs = AppPreferences.getLocalPrefs();
                    localPrefs.setDirPath(UIRegistry.getAppDataDir());
                    ProxyHelper.setProxySettingsFromPrefs();
                    Specify.checkDebugLoggerSettings();
                    String VERSION_CHECK = "version_check.auto";
                    if (localPrefs.getBoolean(VERSION_CHECK, null) == null) {
                        localPrefs.putBoolean(VERSION_CHECK, true);
                    }
                    SpecialMsgNotifier smn = new SpecialMsgNotifier();
                    smn.checkForMessages();
                    if (UIRegistry.isEmbedded().booleanValue() && !UIRegistry.isMobile() && localPrefs.getBoolean(EZDB_FIRSTTIME = "ezdb.firsttime", null) == null) {
                        UIRegistry.showLocalizedMsg("EZDB_FIRSTTIME");
                        localPrefs.putBoolean(EZDB_FIRSTTIME, true);
                        localPrefs.flush();
                    }
                    if ((isExtraCheck = localPrefs.getBoolean(EXTRA_CHECK = "extra.check", true)) == null) {
                        isExtraCheck = true;
                        localPrefs.putBoolean(EXTRA_CHECK, isExtraCheck);
                    }
                    boolean isReleaseManager = localPrefs.getBoolean("RELEASE_MANAGER", false);
                    boolean isManagedRelease = localPrefs.getBoolean(Specify.MANAGED_RELEASES, false);
                    boolean bl = isMgrRel = !isReleaseManager && isManagedRelease;
                    if (localPrefs.getBoolean(VERSION_CHECK, true).booleanValue() && !isMgrRel) {
                        if (!isMgrRel) {
                            localPrefs.getBoolean(Specify.MANAGED_RELEASES, false);
                        }
                        try {
                            SplashScreen.hide();
                            ApplicationLauncher.Callback callback = new ApplicationLauncher.Callback(){

                                public void exited(int exitValue) {
                                    Specify.startApp();
                                }

                                public void prepareShutdown() {
                                }
                            };
                            ApplicationLauncher.launchApplication((String)"100", null, (boolean)true, (ApplicationLauncher.Callback)callback);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            log.error((Object)ex);
                            Specify.startApp();
                        }
                    } else {
                        if (!isManagedRelease && !isExtraCheck.booleanValue() && StringUtils.isNotEmpty((String)UIRegistry.getAppVersion())) {
                            UIRegistry.showLocalizedMsg(null, "SpReg.NOT_REGISTERED", new Object[0]);
                        }
                        Specify.startApp();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.error((Object)ex);
                }
            }
        });
    }

    class SpecifyRunnable
    implements Runnable {
        protected Specify mApp;
        protected Object obj;

        public SpecifyRunnable(Specify aApp, Object obj) {
            this.mApp = aApp;
            this.obj = obj;
        }

        @Override
        public void run() {
        }
    }
}

