/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.specify;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.FrameworkAppIFace;
import edu.ku.brc.af.core.MacOSAppHandler;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.ui.db.DatabaseLoginListener;
import edu.ku.brc.af.ui.db.DatabaseLoginPanel;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.specify.Specify;
import edu.ku.brc.specify.config.SpecifyAppPrefs;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizardFrame;
import edu.ku.brc.specify.dbsupport.PostDeleteEventListener;
import edu.ku.brc.specify.dbsupport.PostInsertEventListener;
import edu.ku.brc.specify.dbsupport.PostUpdateEventListener;
import edu.ku.brc.specify.prefs.MySQLPrefs;
import edu.ku.brc.specify.ui.AppBase;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.FileCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BackupAndRestoreApp
extends JPanel
implements DatabaseLoginListener,
CommandListener,
FrameworkAppIFace {
    private static final Logger log = Logger.getLogger(BackupAndRestoreApp.class);
    private JStatusBar statusField = null;
    private JMenuBar menuBar = null;
    private JFrame topFrame = null;
    private MySQLPrefs mainPanel = null;
    private JLabel appIcon = null;
    protected boolean hasChanged = false;
    protected String currentDatabaseName = null;
    protected DatabaseLoginPanel dbLoginPanel = null;
    protected String databaseName = null;
    protected String userName = null;
    protected GhostGlassPane glassPane;
    private boolean isWorkbenchOnly = false;
    private String appName = "Backup and Restore";
    private String appVersion = "6.0";
    private String appBuildVersion = "(Unknown)";

    protected void preStartUp() {
        new MacOSAppHandler(this);
        Specify.setUpSystemProperties();
    }

    @Override
    public void doPreferences() {
    }

    public boolean isApplet() {
        return false;
    }

    private void initialize(GraphicsConfiguration gc) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1024, 768));
        this.topFrame = new JFrame(gc);
        this.topFrame.setIconImage(IconManager.getImage("Backup", IconManager.IconSize.Std32).getImage());
        this.glassPane = GhostGlassPane.getInstance();
        this.topFrame.setGlassPane(this.glassPane);
        this.topFrame.setLocationRelativeTo(null);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        UIRegistry.register("glasspane", this.glassPane);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.add((Component)top, "North");
        UIRegistry.setTopWindow(this.topFrame);
        this.menuBar = this.createMenus();
        if (this.menuBar != null) {
            this.topFrame.setJMenuBar(this.menuBar);
        }
        UIRegistry.register("menubar", this.menuBar);
        JToolBar toolBar = this.createToolBar();
        if (toolBar != null) {
            top.add((Component)toolBar, "Center");
        }
        UIRegistry.register("toolbar", toolBar);
        AppPrefsCache.setUseLocalOnly(true);
        SpecifyAppPrefs.setSkipRemotePrefs(true);
        AppContextMgr.getInstance().setHasContext(true);
        SpecifyAppPrefs.initialPrefs();
        this.mainPanel = new MySQLPrefs(true);
        this.add((Component)this.mainPanel, "Center");
        int[] sections = new int[]{5};
        this.statusField = new JStatusBar(sections);
        this.statusField.setErrorIcon(IconManager.getIcon("Error", IconManager.IconSize.Std16));
        this.statusField.setWarningIcon(IconManager.getIcon("Warning", IconManager.IconSize.Std16));
        UIRegistry.setStatusBar(this.statusField);
        this.add((Component)this.statusField, "South");
        this.topFrame.setContentPane(this);
    }

    public static String getIconName() {
        String postFix = "";
        if (UIRegistry.isEmbedded().booleanValue()) {
            postFix = "E";
        } else if (UIRegistry.isMobile()) {
            postFix = "M";
        }
        return "DatabaseIcon" + postFix;
    }

    protected void setAppIcon(String imgEncoded) {
        ImageIcon appImgIcon = null;
        if (StringUtils.isNotEmpty((String)imgEncoded) && (appImgIcon = GraphicsUtils.uudecodeImage("", imgEncoded)) != null && appImgIcon.getIconWidth() == 32 && appImgIcon.getIconHeight() == 32) {
            this.appIcon.setIcon(appImgIcon);
            return;
        }
        appImgIcon = IconManager.getImage(BackupAndRestoreApp.getIconName(), IconManager.IconSize.Std32);
        this.appIcon.setIcon(appImgIcon);
    }

    public JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setLayout(new ToolbarLayoutManager(2, 2));
        this.appIcon = new JLabel("  ");
        return toolBar;
    }

    public JMenuBar createMenus() {
        JMenuItem mi;
        JMenuBar mb = new JMenuBar();
        JMenu menu = UIHelper.createLocalizedMenu(mb, "Specify.FILE_MENU", "Specify.FILE_MNEU");
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            String title = "Specify.EXIT";
            String mnu = "Specify.Exit_MNEU";
            mi = UIHelper.createLocalizedMenuItem(menu, title, mnu, title, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BackupAndRestoreApp.this.doExit(true);
                }
            });
        }
        HelpMgr.setAppDefHelpId("Backup_Restore");
        JMenu helpMenu = UIHelper.createLocalizedMenu(mb, "Specify.HELP_MENU", "Specify.HELP_MNEU");
        HelpMgr.createHelpMenuItem(helpMenu, "Backup and Restore");
        helpMenu.addSeparator();
        if (UIHelper.getOSType() != UIHelper.OSTYPE.MacOSX) {
            String ttle = "Specify.ABOUT";
            String mneu = "Specify.ABOUTMNEU";
            String desc = "Specify.ABOUT";
            mi = UIHelper.createLocalizedMenuItem(helpMenu, ttle, mneu, desc, true, null);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BackupAndRestoreApp.this.doAbout();
                }
            });
        }
        return mb;
    }

    @Override
    public void doAbout() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder infoPB = new PanelBuilder(new FormLayout("p,6px,f:min(400;p):g", "p:g"));
        JLabel iconLabel = new JLabel(IconManager.getIcon("SpecifyLargeIcon"), 0);
        PanelBuilder iconPB = new PanelBuilder(new FormLayout("p", "20px,t:p,f:p:g"));
        iconPB.add((Component)iconLabel, cc.xy(1, 2));
        infoPB.setDefaultDialogBorder();
        infoPB.add((Component)iconPB.getPanel(), cc.xy(1, 1));
        infoPB.add((Component)UIHelper.createLabel(Specify.getAboutText(this.appName, this.appVersion)), cc.xy(3, 1));
        String title = UIRegistry.getResourceString("Specify.ABOUT");
        CustomDialog aboutDlg = new CustomDialog(this.topFrame, String.valueOf(title) + " " + this.appName, true, 1, (Component)infoPB.getPanel());
        String okLabel = UIRegistry.getResourceString("Specify.CLOSE");
        aboutDlg.setOkLabel(okLabel);
        aboutDlg.createUI();
        aboutDlg.pack();
        Dimension size = aboutDlg.getSize();
        size.height += 80;
        aboutDlg.setSize(size);
        UIHelper.centerAndShow(aboutDlg);
    }

    @Override
    public boolean doExit(boolean doAppExit) {
        boolean okToShutdown = true;
        try {
            try {
                if (AttachmentUtils.getAttachmentManager() != null) {
                    AttachmentUtils.getAttachmentManager().cleanup();
                }
                if ((okToShutdown = SubPaneMgr.getInstance().aboutToShutdown()) && this.mainPanel != null && this.mainPanel.isOKToSave()) {
                    this.mainPanel.savePrefs();
                    AppPreferences.getLocalPrefs().flush();
                    AppPreferences.shutdownLocalPrefs();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BackupAndRestoreApp.class, ex);
                if (okToShutdown && doAppExit) {
                    System.exit(0);
                }
            }
        }
        finally {
            if (okToShutdown && doAppExit) {
                System.exit(0);
            }
        }
        return okToShutdown;
    }

    protected String getTitle() {
        String title = "";
        String resAppVersion = UIRegistry.getAppVersion();
        String postFix = "";
        if (UIRegistry.isEmbedded().booleanValue()) {
            postFix = " (EZDB)";
        } else if (UIRegistry.isMobile()) {
            postFix = " (Mobile)";
        }
        if (StringUtils.isNotEmpty((String)resAppVersion)) {
            this.appVersion = resAppVersion;
            title = String.valueOf(this.appName) + postFix + " " + this.appVersion;
        } else {
            title = String.valueOf(this.appName) + postFix + " " + this.appVersion + "  - " + this.appBuildVersion;
        }
        return title;
    }

    public void showApp() {
        this.topFrame.pack();
        this.topFrame.setTitle(this.getTitle());
        this.topFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BackupAndRestoreApp.this.doExit(true);
            }
        });
        UIHelper.centerWindow(this.topFrame);
        Rectangle r = this.topFrame.getBounds();
        r.setBounds(1, 1, 600, 275);
        this.topFrame.setBounds(r);
        UIHelper.centerWindow(this.topFrame);
        this.topFrame.setVisible(true);
    }

    public JFrame getFrame() {
        return this.topFrame;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setStatus(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackupAndRestoreApp.this.statusField.setText(s);
            }
        });
    }

    protected void setupDefaultFonts() {
        Font labelFont = UIHelper.createLabel("").getFont();
        log.debug((Object)("****** " + labelFont));
        Font defaultFont = !UIHelper.isMacOS() ? labelFont : (labelFont.getSize() == 13 ? labelFont.deriveFont((float)labelFont.getSize() - 2.0f) : labelFont);
        BaseTask.setToolbarBtnFont(defaultFont);
        RolloverCommand.setDefaultFont(defaultFont);
    }

    public void startUp() {
        log.debug((Object)"StartUp...");
        if (UIHelper.isLinux()) {
            Specify.checkForSpecifyAppsRunning();
        }
        if (UIRegistry.isEmbedded().booleanValue()) {
            SpecifyDBSetupWizardFrame.checkForMySQLProcesses();
        }
        UIHelper.adjustUIDefaults();
        this.setupDefaultFonts();
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        UsageTracker.incrUsageCount("RunCount");
        FileCache.setDefaultPath(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "cache");
        UIRegistry.register("mainpane", this);
        UIRegistry.setBaseFont(UIHelper.createLabel("").getFont());
        log.info((Object)"Creating Database configuration ");
        if (!this.isWorkbenchOnly) {
            HibernateUtil.setListener("post-commit-update", new PostUpdateEventListener());
            HibernateUtil.setListener("post-commit-insert", new PostInsertEventListener());
            HibernateUtil.setListener("post-commit-delete", new PostDeleteEventListener());
        }
        Specify.adjustLocaleFromPrefs();
        CommandDispatcher.register("App", this);
        UIRegistry.loadAndPushResourceBundle("backuprestore");
        this.dbLoginPanel = UIHelper.doLogin(null, false, false, false, this, BackupAndRestoreApp.getIconName(), this.getTitle(), null, Specify.getOpaqueIconName(), "Backup_Restore");
        UIRegistry.popResourceBundle();
        localPrefs.load();
    }

    public void restartApp(Window window, String databaseNameArg, String userNameArg, boolean startOver, boolean firstTime) {
        log.debug((Object)"restartApp");
        if (this.dbLoginPanel != null) {
            this.dbLoginPanel.getStatusBar().setText(UIRegistry.getResourceString("Specify.INITIALIZING_APP"));
        }
        if (firstTime) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initialize(gc);
            this.topFrame.setDefaultCloseOperation(0);
            UIRegistry.register("frame", this.topFrame);
        }
        if (window != null) {
            window.setVisible(false);
        }
        this.showApp();
        this.statusField.setText(DBConnection.getInstance().getDatabaseName());
        if (this.dbLoginPanel != null) {
            this.dbLoginPanel.getWindow().setVisible(false);
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType("App") && cmdAction.isAction("AppReqExit")) {
            this.doExit(true);
        }
    }

    @Override
    public void loggedIn(Window window, String databaseNameArg, String userNameArg) {
        log.debug((Object)("loggedIn - database[" + databaseNameArg + "] username[" + userNameArg + "]"));
        boolean firstTime = this.databaseName == null;
        this.databaseName = databaseNameArg;
        this.userName = userNameArg;
        FormHelper.setCurrentUserEditStr(userNameArg);
        AppPreferences.setConnectedToDB(true);
        this.restartApp(window, this.databaseName, this.userName, false, firstTime);
        this.doLayout();
        JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
        if (toolBar != null && toolBar.getComponentCount() < 2) {
            toolBar.setVisible(false);
        }
        this.statusField.setSectionText(0, this.userName);
    }

    @Override
    public void cancelled() {
        this.doExit(true);
    }

    public static DatabaseLoginPanel doLogin(boolean engageUPPrefs, DatabaseLoginPanel.MasterPasswordProviderIFace usrPwdProvider, boolean doAutoClose, DatabaseLoginListener listener, String iconName, String title, String appName, String appIconName, String helpContext) {
        ImageIcon imgIcon;
        ImageIcon icon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std32);
        if (StringUtils.isNotEmpty((String)appIconName) && (imgIcon = IconManager.getIcon(appIconName)) != null) {
            icon = imgIcon;
        }
        JFrame.setDefaultLookAndFeelDecorated(false);
        JFrame frame = new JFrame(title);
        class DBListener
        implements DatabaseLoginListener {
            protected JFrame frame;
            protected DatabaseLoginListener frameDBListener;
            protected boolean doAutoCloseOfListener;

            public DBListener(JFrame frame, DatabaseLoginListener frameDBListener, boolean doAutoCloseOfListener) {
                this.frame = frame;
                this.frameDBListener = frameDBListener;
                this.doAutoCloseOfListener = doAutoCloseOfListener;
            }

            @Override
            public void loggedIn(Window window, String databaseName, String userNameArg) {
                log.debug((Object)"UIHelper.doLogin[DBListener]");
                if (this.doAutoCloseOfListener) {
                    this.frame.setVisible(false);
                }
                this.frameDBListener.loggedIn(window, databaseName, userNameArg);
            }

            @Override
            public void cancelled() {
                this.frame.setVisible(false);
                this.frameDBListener.cancelled();
            }
        }
        DatabaseLoginPanel panel = new DatabaseLoginPanel(null, null, false, usrPwdProvider, new DBListener(frame, listener, doAutoClose), false, false, title, appName, iconName, helpContext);
        panel.setAutoClose(doAutoClose);
        panel.setWindow(frame);
        frame.setContentPane(panel);
        frame.setIconImage(icon.getImage());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        UIHelper.centerAndShow(frame);
        return panel;
    }

    public static void startApp() {
        IconManager.setApplicationClass(BackupAndRestoreApp.class);
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_datamodel.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_plugins.xml"));
        IconManager.loadIcons(XMLHelper.getConfigDir("icons_disciplines.xml"));
        try {
            UIHelper.OSTYPE osType = UIHelper.getOSType();
            if (osType == UIHelper.OSTYPE.Windows) {
                UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
                PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            } else if (osType == UIHelper.OSTYPE.Linux) {
                UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BackupAndRestoreApp.class, e);
            log.error((Object)"Can't change L&F: ", (Throwable)e);
        }
        ImageIcon helpIcon = IconManager.getIcon("AppIcon", IconManager.IconSize.Std16);
        HelpMgr.initializeHelp("SpecifyHelp", helpIcon.getImage());
        BackupAndRestoreApp backupAndRestoreApp = new BackupAndRestoreApp();
        RolloverCommand.setHoverImg(IconManager.getIcon("DropIndicator"));
        backupAndRestoreApp.preStartUp();
        backupAndRestoreApp.startUp();
    }

    public static void main(String[] args) {
        AppBase.processArgs(args);
        AppBase.setupTeeForStdErrStdOut(true, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIRegistry.setAppName("Specify");
                AppPreferences.getLocalPrefs().setDirPath(UIRegistry.getAppDataDir());
                BackupAndRestoreApp.startApp();
            }
        });
    }

    class BRSecurityMgr
    extends SecurityMgr {
        BRSecurityMgr() {
        }

        @Override
        public PermissionSettings getPermission(String nameStr) {
            return new PermissionSettings(15);
        }
    }
}

