/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.mapping;

import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.SimpleCircleIcon;
import edu.ku.brc.util.Pair;
import edu.ku.brc.util.services.MapGrabber;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class LocalityMapper
implements TimingTarget {
    protected static final Logger log = Logger.getLogger(LocalityMapper.class);
    protected List<MapLocationIFace> mapLocations = new Vector<MapLocationIFace>();
    protected MapLocationIFace currentLoc;
    protected List<String> labels = new Vector<String>();
    protected List<Point> markerLocations = new Vector<Point>();
    protected double minLat = -90.0;
    protected double maxLat = 90.0;
    protected double minLong = -180.0;
    protected double maxLong = 180.0;
    protected double mapMinLat;
    protected double mapMaxLat;
    protected double mapMinLong;
    protected double mapMaxLong;
    protected double mapLatRange;
    protected double mapLongRange;
    protected double pixelPerLatRatio;
    protected double pixelPerLongRatio;
    protected Integer maxMapWidth;
    protected Integer maxMapHeight;
    protected int mapWidth;
    protected int mapHeight;
    protected double minAspectRatio = 1.0;
    protected double maxAspectRatio = 1.0;
    protected boolean enforceAspectRatios = false;
    protected int mostRecentPaintedX;
    protected int mostRecentPaintedY;
    protected SimpleCircleIcon marker;
    protected SimpleCircleIcon currentLocMarker;
    protected boolean showArrows = true;
    protected boolean showArrowAnimations = true;
    protected boolean showLabels = true;
    protected Color arrowColor;
    protected Color labelColor = Color.BLACK;
    protected boolean animationInProgress = false;
    protected float percent;
    protected Animator animator;
    protected MapLocationIFace animStartLoc;
    protected MapLocationIFace animEndLoc;
    protected Icon mapIcon;
    protected Icon overlayIcon = null;
    protected boolean cacheValid = false;

    public LocalityMapper() {
        this.arrowColor = Color.BLACK;
        this.marker = new SimpleCircleIcon(8, Color.BLACK);
        this.currentLocMarker = new SimpleCircleIcon(8, Color.BLACK);
        int duration = 750;
        boolean repeatCount = true;
        this.animator = new Animator(duration, (double)repeatCount, Animator.RepeatBehavior.REVERSE, (TimingTarget)this);
        this.animator.setAcceleration(0.45f);
        this.animator.setDeceleration(0.45f);
    }

    public LocalityMapper(List<MapLocationIFace> locations) {
        this();
        this.mapLocations.addAll(locations);
        int i = 0;
        while (i < locations.size()) {
            this.labels.add(null);
            ++i;
        }
        i = 0;
        while (i < locations.size()) {
            this.markerLocations.add(null);
            ++i;
        }
        this.cacheValid = false;
    }

    public LocalityMapper(List<MapLocationIFace> locations, List<String> labels) {
        this();
        if (locations.size() != labels.size()) {
            throw new IllegalArgumentException("Locations and labels list must be the same size");
        }
        this.mapLocations.addAll(this.mapLocations);
        this.labels.addAll(labels);
        int i = 0;
        while (i < this.mapLocations.size()) {
            this.markerLocations.add(null);
            ++i;
        }
        this.cacheValid = false;
    }

    public void addTimingTarget(TimingTarget target) {
        this.animator.addTarget(target);
    }

    public MapLocationIFace getCurrentLoc() {
        return this.currentLoc;
    }

    public void setCurrentLoc(MapLocationIFace currentLoc) {
        if (this.showArrowAnimations) {
            this.animStartLoc = this.currentLoc;
            this.animEndLoc = currentLoc;
            double mapDiagDist = Math.sqrt(Math.pow(this.mapWidth, 2.0) + Math.pow(this.mapHeight, 2.0));
            double arrowSpeed = mapDiagDist / 2000.0;
            int startIndex = this.mapLocations.indexOf(this.animStartLoc);
            int endIndex = this.mapLocations.indexOf(this.animEndLoc);
            if (startIndex != -1 && endIndex != -1) {
                Point startPoint = this.markerLocations.get(startIndex);
                Point endPoint = this.markerLocations.get(endIndex);
                double arrowLength = GraphicsUtils.distance(startPoint, endPoint);
                int duration = (int)(arrowLength / arrowSpeed);
                this.animator.setDuration(duration);
                if (duration <= 1000) {
                    this.animator.setAcceleration(0.5f);
                    this.animator.setDeceleration(0.5f);
                } else {
                    float acc = 500 / duration;
                    this.animator.setAcceleration(acc);
                    this.animator.setDeceleration(acc);
                }
            }
            this.animator.start();
        }
        this.currentLoc = currentLoc;
    }

    public void addLocationAndLabel(MapLocationIFace loc, String label) {
        this.mapLocations.add(loc);
        this.labels.add(label);
        this.markerLocations.add(null);
        this.cacheValid = false;
    }

    public void removeLocationAndLabel(MapLocationIFace loc) {
        int index = this.mapLocations.indexOf(loc);
        this.mapLocations.remove(index);
        this.labels.remove(index);
        this.markerLocations.remove(index);
        this.cacheValid = false;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Color arrowColor) {
        this.arrowColor = arrowColor;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Integer getMaxMapHeight() {
        return this.maxMapHeight;
    }

    public void setMaxMapHeight(Integer maxMapHeight) {
        this.maxMapHeight = maxMapHeight;
        this.cacheValid = false;
    }

    public Integer getMaxMapWidth() {
        return this.maxMapWidth;
    }

    public void setMaxMapWidth(Integer maxMapWidth) {
        this.maxMapWidth = maxMapWidth;
        this.cacheValid = false;
    }

    public double getMaxAspectRatio() {
        return this.maxAspectRatio;
    }

    public void setMaxAspectRatio(double maxAspectRatio) {
        this.maxAspectRatio = maxAspectRatio;
        if (this.enforceAspectRatios) {
            this.cacheValid = false;
        }
    }

    public double getMinAspectRatio() {
        return this.minAspectRatio;
    }

    public void setMinAspectRatio(double minAspectRatio) {
        this.minAspectRatio = minAspectRatio;
        if (this.enforceAspectRatios) {
            this.cacheValid = false;
        }
    }

    public boolean isEnforceAspectRatios() {
        return this.enforceAspectRatios;
    }

    public void setEnforceAspectRatios(boolean enforceAspectRatios) {
        this.enforceAspectRatios = enforceAspectRatios;
        if (this.enforceAspectRatios) {
            this.cacheValid = false;
        }
    }

    public boolean isShowArrowAnimations() {
        return this.showArrowAnimations;
    }

    public void setShowArrowAnimations(boolean showArrowAnimations) {
        this.showArrowAnimations = showArrowAnimations;
    }

    public boolean isShowArrows() {
        return this.showArrows;
    }

    public void setShowArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public Color getCurrentLocColor() {
        return this.currentLocMarker.getColor();
    }

    public void setCurrentLocColor(Color currentLocColor) {
        this.currentLocMarker.setColor(currentLocColor);
    }

    public int getDotSize() {
        return this.marker.getSize();
    }

    public void setDotSize(int dotSize) {
        this.marker.setSize(dotSize);
        this.currentLocMarker.setSize(dotSize);
    }

    public Color getDotColor() {
        return this.marker.getColor();
    }

    public void setDotColor(Color color) {
        this.marker.setColor(color);
    }

    public List<Point> getMarkerLocations() {
        return this.markerLocations;
    }

    public void zoom(float percentZoom) {
        if (percentZoom == 1.0f || percentZoom <= 0.0f) {
            return;
        }
        double longRangeChange = this.mapLongRange * 1.0 / (double)percentZoom;
        double longChange = 0.5 * (this.mapLongRange - longRangeChange);
        this.mapMinLong += longChange;
        this.mapMaxLong -= longChange;
        double latRangeChange = this.mapLatRange * 1.0 / (double)percentZoom;
        double latChange = 0.5 * (this.mapLatRange - latRangeChange);
        this.mapMinLat += latChange;
        this.mapMaxLat -= latChange;
        this.cacheValid = false;
    }

    public void pan(double latChange, double longChange) {
        double latChg = latChange;
        double longChg = longChange;
        if (this.mapMinLat + latChange < -90.0) {
            latChg = -90.0 - this.mapMinLat;
        }
        if (this.mapMaxLat + latChange > 90.0) {
            latChg = 90.0 - this.mapMaxLat;
        }
        if (this.mapMinLong + longChange < -180.0) {
            longChg = -180.0 - this.mapMinLong;
        }
        if (this.mapMaxLong + longChange > 180.0) {
            longChg = 180.0 - this.mapMaxLong;
        }
        this.mapMinLat += latChg;
        this.mapMaxLat += latChg;
        this.mapMinLong += longChg;
        this.mapMaxLong += longChg;
        this.cacheValid = false;
    }

    protected boolean boxIsValid(double minimumLat, double minimumLong, double maximumLat, double maximumLong) {
        return -90.0 <= minimumLat && minimumLat < maximumLat && maximumLat <= 90.0 && -180.0 <= minimumLong && minimumLong < maximumLong && maximumLong <= 180.0;
    }

    private Pair<Double, Double> getLatLong(MapLocationIFace loc) {
        Double lat1 = loc.getLat1();
        Double long1 = loc.getLong1();
        Double lat2 = loc.getLat2();
        Double long2 = loc.getLong2();
        if (lat2 != null && long2 != null) {
            return this.centerOfBBox(lat1, lat2, long1, long2);
        }
        return new Pair<Double, Double>(lat1, long1);
    }

    private Pair<Double, Double> centerOfBBox(Double lat1, Double lat2, Double long1, Double long2) {
        Pair<Double, Double> center = new Pair<Double, Double>();
        center.first = (lat1 + lat2) / 2.0;
        center.second = (long1 + long2) / 2.0;
        return center;
    }

    protected double getLatLongRatio() {
        double longRange = this.maxLong - this.minLong;
        double latRange = this.maxLat - this.minLat;
        return latRange / longRange;
    }

    protected void recalculateBoundingBox() {
        if (this.mapLocations.isEmpty()) {
            this.minLat = -90.0;
            this.minLong = -180.0;
            this.maxLat = 90.0;
            this.maxLong = 180.0;
            this.mapMinLat = -90.0;
            this.mapMinLong = -180.0;
            this.mapMaxLat = 90.0;
            this.mapMaxLong = 180.0;
            return;
        }
        this.minLong = 180.0;
        this.maxLong = -180.0;
        this.minLat = 90.0;
        this.maxLat = -90.0;
        for (MapLocationIFace loc : this.mapLocations) {
            Pair<Double, Double> latLong = this.getLatLong(loc);
            if ((Double)latLong.first < this.minLat) {
                this.minLat = (Double)latLong.first;
            }
            if ((Double)latLong.second < this.minLong) {
                this.minLong = (Double)latLong.second;
            }
            if ((Double)latLong.first > this.maxLat) {
                this.maxLat = (Double)latLong.first;
            }
            if (!((Double)latLong.second > this.maxLong)) continue;
            this.maxLong = (Double)latLong.second;
        }
        this.createBoundingBoxBufferRegion();
        this.expandMapRegionToFillUsableSpace();
        if (this.enforceAspectRatios) {
            this.ensureMinMaxAspectRatio();
        }
    }

    protected void createBoundingBoxBufferRegion() {
        double latSpread = this.maxLat - this.minLat;
        double minSpread = 0.032;
        if (latSpread < minSpread) {
            double diff = minSpread - latSpread;
            latSpread = minSpread;
            this.mapMinLat = this.minLat - diff / 2.0;
            this.mapMaxLat = this.maxLat + diff / 2.0;
        } else {
            this.mapMinLat = this.minLat - 0.05 * latSpread;
            this.mapMaxLat = this.maxLat + 0.05 * latSpread;
        }
        double longSpread = this.maxLong - this.minLong;
        if (longSpread < minSpread) {
            double diff = minSpread - longSpread;
            longSpread = minSpread;
            this.mapMinLong = this.minLong - diff / 2.0;
            this.mapMaxLong = this.maxLong + diff / 2.0;
        } else {
            this.mapMinLong = this.minLong - 0.05 * longSpread;
            this.mapMaxLong = this.maxLong + 0.05 * longSpread;
        }
    }

    protected void ensureMinMaxAspectRatio() {
        double currentWidth = this.mapMaxLong - this.mapMinLong;
        double currentHeight = this.mapMaxLat - this.mapMinLat;
        double currentAspectRatio = currentWidth / currentHeight;
        if (currentAspectRatio < this.minAspectRatio) {
            double newWidth = this.minAspectRatio * currentHeight;
            double amtOfIncr = newWidth - currentWidth;
            this.mapMinLong -= 0.5 * amtOfIncr;
            this.mapMaxLong += 0.5 * amtOfIncr;
        } else if (currentAspectRatio > this.maxAspectRatio) {
            double newHeight = currentWidth / this.maxAspectRatio;
            double amtOfIncr = newHeight - currentHeight;
            this.mapMinLat -= 0.5 * amtOfIncr;
            this.mapMaxLat += 0.5 * amtOfIncr;
        }
        if (this.mapMinLong < -180.0) {
            double panRightAmt = -180.0 - this.mapMinLong;
            this.mapMinLong += panRightAmt;
            this.mapMaxLong += panRightAmt;
        }
        if (this.mapMaxLong > 180.0) {
            double panLeftAmt = this.mapMaxLong - 180.0;
            this.mapMinLong -= panLeftAmt;
            this.mapMaxLong -= panLeftAmt;
        }
        this.mapMinLong = Math.max(this.mapMinLong, -180.0);
        this.mapMaxLong = Math.min(this.mapMaxLong, 180.0);
        if (this.mapMinLat < -90.0) {
            double panUpAmt = -90.0 - this.mapMinLat;
            this.mapMinLat += panUpAmt;
            this.mapMaxLat += panUpAmt;
        }
        if (this.mapMaxLat > 90.0) {
            double panDownAmt = this.mapMaxLat - 90.0;
            this.mapMinLat -= panDownAmt;
            this.mapMaxLat -= panDownAmt;
        }
        this.mapMinLat = Math.max(this.mapMinLat, -90.0);
        this.mapMaxLat = Math.min(this.mapMaxLat, 90.0);
    }

    protected void expandMapRegionToFillUsableSpace() {
        double degToPixelLat = (this.mapMaxLat - this.mapMinLat) / (double)this.maxMapHeight.intValue();
        double degToPixelLon = (this.mapMaxLong - this.mapMinLong) / (double)this.maxMapWidth.intValue();
        double uniformDegToPixel = Math.max(degToPixelLat, degToPixelLon);
        double correctedLatRange = uniformDegToPixel * (double)this.maxMapHeight.intValue();
        double correctedLonRange = uniformDegToPixel * (double)this.maxMapWidth.intValue();
        double latRangeDiff = correctedLatRange - (this.mapMaxLat - this.mapMinLat);
        double lonRangeDiff = correctedLonRange - (this.mapMaxLong - this.mapMinLong);
        this.mapMaxLat += latRangeDiff / 2.0;
        this.mapMinLat -= latRangeDiff / 2.0;
        this.mapMaxLong += lonRangeDiff / 2.0;
        this.mapMinLong -= lonRangeDiff / 2.0;
    }

    protected Image getMapFromService(String host, String defaultPathAndParams, String layers, double miniLat, double miniLong, double maxiLat, double maxiLong, int height, int width) throws HttpException, IOException {
        MapGrabber mapGrabber = new MapGrabber();
        mapGrabber.setHost(host);
        mapGrabber.setDefaultPathAndParams(defaultPathAndParams);
        mapGrabber.setLayers(layers);
        mapGrabber.setMinLat(miniLat);
        mapGrabber.setMaxLat(maxiLat);
        mapGrabber.setMinLong(miniLong);
        mapGrabber.setMaxLong(maxiLong);
        mapGrabber.setHeight(height);
        mapGrabber.setWidth(width);
        return mapGrabber.getMap();
    }

    protected Point determinePixelCoordsOfMapLocationIFace(MapLocationIFace loc) {
        Pair<Double, Double> latLong = this.getLatLong(loc);
        double y = (Double)latLong.first - this.mapMinLat;
        double x = (Double)latLong.second - this.mapMinLong;
        y = (double)this.mapHeight - y * this.pixelPerLatRatio;
        return new Point((int)(x *= this.pixelPerLongRatio), (int)y);
    }

    protected boolean pointIsOnMapIcon(int x, int y) {
        if (this.mostRecentPaintedX > x || this.mostRecentPaintedX + this.mapWidth < x) {
            return false;
        }
        return this.mostRecentPaintedY <= y && this.mostRecentPaintedY + this.mapHeight >= y;
    }

    public Pair<Double, Double> getLatLongForPointOnMapIcon(int x, int y) {
        if (!this.pointIsOnMapIcon(x, y)) {
            return null;
        }
        double lat = -1.0;
        int relativeY = y - this.mostRecentPaintedY;
        lat = this.mapMaxLat - (double)relativeY / this.pixelPerLatRatio;
        double lon = -1.0;
        int relativeX = x - this.mostRecentPaintedX;
        lon = (double)relativeX / this.pixelPerLongRatio + this.mapMinLong;
        return new Pair<Double, Double>(lat, lon);
    }

    public void getMap(final MapperListener callback) {
        Thread mapGrabberThread = new Thread("Map Grabber"){

            @Override
            public void run() {
                block3: {
                    try {
                        Icon map = LocalityMapper.this.grabNewMap();
                        if (callback != null) {
                            callback.mapReceived(map);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block3;
                        callback.exceptionOccurred(e);
                    }
                }
            }
        };
        mapGrabberThread.setDaemon(true);
        mapGrabberThread.start();
    }

    protected Icon grabNewMap() throws HttpException, IOException {
        this.recalculateBoundingBox();
        if (!this.cacheValid) {
            Image mapImage = this.getMapFromService("lifemapper.org", "/ogc?map=specify.map&service=WMS&request=GetMap&srs=EPSG:4326&version=1.3.1&STYLES=&format=image/png&transparent=TRUE", "global_mosaic,states,rivers", this.mapMinLat, this.mapMinLong, this.mapMaxLat, this.mapMaxLong, this.maxMapHeight, this.maxMapWidth);
            this.mapIcon = new ImageIcon(mapImage);
            this.cacheValid = true;
            this.mapWidth = this.mapIcon.getIconWidth();
            this.mapHeight = this.mapIcon.getIconHeight();
            if (this.mapWidth < 0 || this.mapHeight < 0) {
                throw new IOException("Request for map failed.  Received map has negative width or height.");
            }
            this.mapLatRange = this.mapMaxLat - this.mapMinLat;
            this.mapLongRange = this.mapMaxLong - this.mapMinLong;
            this.pixelPerLatRatio = (double)this.mapHeight / this.mapLatRange;
            this.pixelPerLongRatio = (double)this.mapWidth / this.mapLongRange;
            int i = 0;
            while (i < this.mapLocations.size()) {
                MapLocationIFace loc = this.mapLocations.get(i);
                Point iconLoc = this.determinePixelCoordsOfMapLocationIFace(loc);
                this.markerLocations.set(i, iconLoc);
                ++i;
            }
            this.cacheValid = true;
        }
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setClip(x, y, LocalityMapper.this.mapWidth, LocalityMapper.this.mapHeight);
                LocalityMapper.this.mostRecentPaintedX = x;
                LocalityMapper.this.mostRecentPaintedY = y;
                Point currentLocPoint = null;
                if (LocalityMapper.this.currentLoc != null) {
                    currentLocPoint = LocalityMapper.this.determinePixelCoordsOfMapLocationIFace(LocalityMapper.this.currentLoc);
                }
                LocalityMapper.this.mapIcon.paintIcon(c, g, x, y);
                Point lastLoc = null;
                int i = 0;
                while (i < LocalityMapper.this.mapLocations.size()) {
                    boolean current;
                    Point markerLoc = LocalityMapper.this.markerLocations.get(i);
                    String label = LocalityMapper.this.labels.get(i);
                    boolean bl = current = LocalityMapper.this.currentLoc != null && markerLoc.equals(currentLocPoint);
                    if (markerLoc == null) {
                        log.error((Object)"A marker location is null");
                    } else if (!LocalityMapper.this.pointIsOnMapIcon(x + markerLoc.x, y + markerLoc.y)) {
                        log.error((Object)"A marker location is off the map");
                    } else {
                        if (LocalityMapper.this.showArrows && lastLoc != null) {
                            int x1 = x + lastLoc.x;
                            int y1 = y + lastLoc.y;
                            int x2 = x + markerLoc.x;
                            int y2 = y + markerLoc.y;
                            Color origColor = g.getColor();
                            if (current && !LocalityMapper.this.animationInProgress) {
                                g.setColor(LocalityMapper.this.getCurrentLocColor());
                            } else {
                                g.setColor(LocalityMapper.this.arrowColor);
                            }
                            GraphicsUtils.drawArrow(g, x1, y1, x2, y2, 2, 2.0f);
                            g.setColor(origColor);
                        }
                        if (current) {
                            LocalityMapper.this.currentLocMarker.paintIcon(c, g, markerLoc.x + x, markerLoc.y + y);
                        } else {
                            LocalityMapper.this.marker.paintIcon(c, g, markerLoc.x + x, markerLoc.y + y);
                        }
                        if (label != null) {
                            Color origColor = g.getColor();
                            FontMetrics fm = g.getFontMetrics();
                            int length = fm.stringWidth(label);
                            g.setColor(Color.WHITE);
                            g.fillRect(markerLoc.x + x - length / 2, markerLoc.y + y - fm.getHeight() / 2, length, fm.getHeight());
                            g.setColor(LocalityMapper.this.labelColor);
                            GraphicsUtils.drawCenteredString(label, g, markerLoc.x + x, markerLoc.y + y);
                            g.setColor(origColor);
                        }
                        lastLoc = markerLoc;
                    }
                    ++i;
                }
                if (LocalityMapper.this.showArrowAnimations && LocalityMapper.this.animationInProgress) {
                    int startIndex = LocalityMapper.this.mapLocations.indexOf(LocalityMapper.this.animStartLoc);
                    int endIndex = LocalityMapper.this.mapLocations.indexOf(LocalityMapper.this.animEndLoc);
                    if (startIndex != -1 && endIndex != -1) {
                        Point startPoint = LocalityMapper.this.markerLocations.get(startIndex);
                        Point endPoint = LocalityMapper.this.markerLocations.get(endIndex);
                        Point arrowEnd = GraphicsUtils.getPointAlongLine(startPoint, endPoint, LocalityMapper.this.percent);
                        Color orig = g.getColor();
                        g.setColor(LocalityMapper.this.getCurrentLocColor());
                        GraphicsUtils.drawArrow(g, startPoint.x + x, startPoint.y + y, arrowEnd.x + x, arrowEnd.y + y, 5, 3.0f);
                        g.setColor(orig);
                    }
                }
            }

            @Override
            public int getIconWidth() {
                return LocalityMapper.this.mapWidth;
            }

            @Override
            public int getIconHeight() {
                return LocalityMapper.this.mapHeight;
            }
        };
        return icon;
    }

    public void begin() {
        this.percent = 0.0f;
        this.animationInProgress = true;
    }

    public void end() {
        this.animationInProgress = false;
    }

    public void repeat() {
    }

    public void timingEvent(float fraction) {
        this.percent = fraction;
    }

    public static interface MapLocationIFace {
        public Double getLat1();

        public Double getLong1();

        public Double getLat2();

        public Double getLong2();
    }

    public static interface MapperListener {
        public void mapReceived(Icon var1);

        public void exceptionOccurred(Exception var1);
    }
}

