/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.gpx;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.services.gpx.GPXDataSet;
import edu.ku.brc.services.gpx.io.GpxType;
import edu.ku.brc.services.gpx.io.RteType;
import edu.ku.brc.services.gpx.io.TrkType;
import edu.ku.brc.services.gpx.io.TrksegType;
import edu.ku.brc.services.gpx.io.WptType;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.Polyline;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GPXPanel
extends JPanel {
    protected JList wpList;
    protected JList trkList;
    protected JList rteList;
    protected WorldWindPanel wwPanel;
    protected GPXDataSet gpxDS = new GPXDataSet();
    protected GpxType gpxType;

    public GPXPanel() {
        this.gpxType = this.gpxDS.load("/Users/rods/workspace/GPX/blue_hills.gpx");
        this.createUI();
    }

    public GPXPanel(File file) {
        this.gpxType = this.gpxDS.load(file);
        this.createUI();
    }

    protected void createUI() {
        this.wpList = new JList<WptType>(new Vector<WptType>(this.gpxType.getWpt()));
        this.wpList.setCellRenderer(new WPListCellRenderer());
        this.trkList = new JList<TrkType>(new Vector<TrkType>(this.gpxType.getTrk()));
        this.trkList.setCellRenderer(new TrkListCellRenderer());
        this.rteList = new JList<RteType>(new Vector<RteType>(this.gpxType.getRte()));
        this.rteList.setCellRenderer(new RteListCellRenderer());
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,10px,f:p:g", "p,2px,f:p:g,10px,p,2px,f:p:g,10px,p,2px,f:p:g"), (JPanel)this);
        int y = 1;
        pb.add((Component)UIHelper.createLabel("Way Points"), cc.xy(1, y));
        pb.add((Component)UIHelper.createScrollPane(this.wpList), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createLabel("Tracks"), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(this.trkList), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createLabel("Routes"), cc.xy(1, y += 2));
        pb.add((Component)UIHelper.createScrollPane(this.rteList), cc.xy(1, y += 2));
        y += 2;
        this.wwPanel = new WorldWindPanel();
        pb.add((Component)this.wwPanel, cc.xywh(3, 1, 1, 11));
        y += 2;
        pb.setDefaultDialogBorder();
        this.wpList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GPXPanel.this.selectedWayPoint();
                }
            }
        });
        this.trkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GPXPanel.this.selectedTrack();
                }
            }
        });
        this.rteList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    GPXPanel.this.selectedRoute();
                }
            }
        });
    }

    protected void selectedWayPoint() {
        WptType wpt = (WptType)this.wpList.getSelectedValue();
        if (wpt != null) {
            ArrayList<LatLonPlacemarkIFace> pnts = new ArrayList<LatLonPlacemarkIFace>(this.gpxType.getWpt().size());
            pnts.add(new LatLonPoint(wpt.getLat().doubleValue(), (Double)wpt.getLon().doubleValue(), wpt.getName()));
            this.wwPanel.placeMarkers(pnts, true, false, 0);
        }
    }

    protected void selectedTrack() {
        TrkType trkType = (TrkType)this.trkList.getSelectedValue();
        if (trkType != null) {
            ArrayList<LatLonPoint> pnts = new ArrayList<LatLonPoint>(this.gpxType.getWpt().size());
            ArrayList<Position> positions = new ArrayList<Position>(this.gpxType.getWpt().size());
            for (TrksegType trkSeg : trkType.getTrkseg()) {
                for (WptType wp : trkSeg.getTrkpt()) {
                    Position pos = Position.fromDegrees((double)wp.getLat().doubleValue(), (double)wp.getLon().doubleValue(), (double)0.0);
                    positions.add(pos);
                    pnts.add(new LatLonPoint(wp.getLat().doubleValue(), (Double)wp.getLon().doubleValue(), wp.getName()));
                }
            }
            this.wwPanel.reset();
            Polyline polyLine = new Polyline(positions);
            polyLine.setFollowTerrain(true);
            polyLine.setNumSubsegments(20);
            polyLine.setLineWidth(1.25);
            polyLine.setAntiAliasHint(4354);
            this.wwPanel.addPolyline(polyLine);
            LatLonPlacemarkIFace p = (LatLonPlacemarkIFace)pnts.get(0);
            Pair<Double, Double> latLon = p.getLatLon();
            this.wwPanel.flyTo(LatLon.fromDegrees((double)((Double)latLon.first), (double)((Double)latLon.second)));
        }
    }

    protected void selectedRoute() {
    }

    public static CustomDialog getDlgInstance() {
        FileDialog fileDlg = new FileDialog((Frame)UIRegistry.getTopWindow(), "", 0);
        fileDlg.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".gpx");
            }
        });
        fileDlg.setVisible(true);
        String fileName = fileDlg.getFile();
        if (fileName != null) {
            GPXPanel panel = new GPXPanel(new File(String.valueOf(fileDlg.getDirectory()) + File.separator + fileName));
            CustomDialog dlg = new CustomDialog((Frame)UIRegistry.getTopWindow(), "GPX Points", true, panel);
            dlg.createUI();
            dlg.pack();
            dlg.setSize(950, 700);
            return dlg;
        }
        return null;
    }

    class RteListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            lbl.setText(((RteType)value).getName());
            return lbl;
        }
    }

    class TrkListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            lbl.setText(((TrkType)value).getName());
            return lbl;
        }
    }

    class WPListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            lbl.setText(((WptType)value).getName());
            return lbl;
        }
    }
}

