/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.gpx;

import edu.ku.brc.services.gpx.io.GpxType;
import edu.ku.brc.services.gpx.io.RteType;
import edu.ku.brc.services.gpx.io.TrkType;
import edu.ku.brc.services.gpx.io.TrksegType;
import edu.ku.brc.services.gpx.io.WptType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;

public class GPXDataSet {
    protected Exception exception = null;

    public GpxType load(String gpxFileName) {
        return this.load(new File(gpxFileName));
    }

    public GpxType load(File gpxFile) {
        try {
            JAXBContext jaxContext = JAXBContext.newInstance((String)"edu.ku.brc.services.gpx.io");
            Unmarshaller unmarshaller = jaxContext.createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)new FileInputStream(gpxFile));
            GpxType gpx = (GpxType)element.getValue();
            return gpx;
        }
        catch (UnmarshalException ue) {
            ue.printStackTrace();
            this.exception = ue;
        }
        catch (JAXBException je) {
            je.printStackTrace();
            this.exception = je;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.exception = ioe;
        }
        return null;
    }

    public static void main(String[] args) {
        GPXDataSet gpx = new GPXDataSet();
        GpxType gpxType = gpx.load("/Users/rods/workspace/GPX/blue_hills.gpx");
        if (gpxType != null) {
            System.out.println(gpxType.getVersion());
            System.out.println("-------------- Way Points ---------------------------");
            for (WptType wt : gpxType.getWpt()) {
                System.out.println(String.valueOf(wt.getName()) + " -> " + wt.getLat().doubleValue() + ", " + wt.getLon());
            }
            System.out.println("---------------- Routes -------------------------");
            for (RteType rt : gpxType.getRte()) {
                System.out.println(String.valueOf(rt.getName()) + "  " + rt.getDesc());
                for (WptType wt : rt.getRtept()) {
                    System.out.println("    " + wt.getName() + " -> " + wt.getLat().doubleValue() + ", " + wt.getLon());
                }
            }
            System.out.println("---------------- Tracks -------------------------");
            for (TrkType tt : gpxType.getTrk()) {
                System.out.println(String.valueOf(tt.getName()) + "  " + tt.getDesc());
                for (TrksegType tst : tt.getTrkseg()) {
                    for (WptType wt : tst.getTrkpt()) {
                        System.out.println("    " + wt.getName() + " -> " + wt.getLat().doubleValue() + ", " + wt.getLon());
                    }
                }
            }
        }
    }
}

