/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.services.geolocate.client.GeographicPoint;
import edu.ku.brc.services.geolocate.client.GeorefResult;
import edu.ku.brc.services.geolocate.client.GeorefResultSet;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.specify.ui.ClickAndGoSelectListener;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class GeoLocateResultsDisplay
extends JPanel
implements LocalityMapper.MapperListener,
SelectListener {
    protected static final int MAP_WIDTH = 500;
    protected static final int MAP_HEIGHT = 500;
    protected ResultsTableModel tableModel;
    protected JTable resultsTable;
    protected JLabel mapLabel;
    protected JTextField localityStringField;
    protected JTextField countyField;
    protected JTextField stateField;
    protected JTextField countryField;
    protected JButton acceptBtn = null;
    protected WorldWindPanel wwPanel = null;
    protected GeorefResult userDefGeoRef = null;
    protected Position lastClickPos = null;

    public GeoLocateResultsDisplay() {
        this.setLayout((LayoutManager)new FormLayout("p,10px,400px,10px,f:p:g", "p,2px,p,2px,p,2px,p,10px,f:p:g"));
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        this.localityStringField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.LOCALITY_DESC"), 1, rowIndex);
        this.countyField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.COUNTY"), 1, rowIndex += 2);
        this.stateField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.STATE"), 1, rowIndex += 2);
        this.countryField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.COUNTRY"), 1, rowIndex += 2);
        rowIndex += 2;
        this.mapLabel = UIHelper.createLabel(UIRegistry.getResourceString("GeoLocateResultsDisplay.LOADING_MAP"));
        this.mapLabel.setPreferredSize(new Dimension(500, 500));
        boolean useWorldWind = AppPreferences.getLocalPrefs().getBoolean("USE.WORLDWIND", false);
        if (!useWorldWind) {
            this.add((Component)this.mapLabel, cc.xywh(5, 1, 1, 9));
        } else {
            this.wwPanel = new WorldWindPanel();
            this.wwPanel.setPreferredSize(new Dimension(500, 500));
            this.wwPanel.getWorld().addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwPanel.getWorld(), MarkerLayer.class));
            this.wwPanel.getWorld().addSelectListener((SelectListener)this);
            this.wwPanel.getWorld().getInputHandler().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Position pos = (this).GeoLocateResultsDisplay.this.wwPanel.getWorld().getCurrentPosition();
                            if (!pos.equals((Object)(this).GeoLocateResultsDisplay.this.lastClickPos)) {
                                if ((this).GeoLocateResultsDisplay.this.userDefGeoRef == null) {
                                    GeoLocateResultsDisplay.this.addUserDefinedMarker();
                                } else {
                                    GeoLocateResultsDisplay.this.repositionUserDefMarker();
                                }
                            }
                        }
                    });
                }
            });
            this.add((Component)this.wwPanel, cc.xywh(5, 1, 1, 9));
        }
        this.tableModel = new ResultsTableModel();
        this.resultsTable = new JTable(this.tableModel);
        this.resultsTable.setShowVerticalLines(false);
        this.resultsTable.setShowHorizontalLines(false);
        this.resultsTable.setRowSelectionAllowed(true);
        this.resultsTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && GeoLocateResultsDisplay.this.acceptBtn != null) {
                    GeoLocateResultsDisplay.this.acceptBtn.setEnabled(GeoLocateResultsDisplay.this.resultsTable.getSelectedRowCount() > 0);
                }
            }
        });
        if (this.wwPanel != null) {
            this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GeoLocateResultsDisplay.this.wwPanel.flyToMarker(GeoLocateResultsDisplay.this.resultsTable.getSelectedRow());
                }
            });
        }
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof String) {
                    ((JLabel)c).setToolTipText((String)value);
                }
                return c;
            }
        };
        this.resultsTable.getColumnModel().getColumn(3).setCellRenderer(cellRenderer);
        JScrollPane scrollPane = new JScrollPane(this.resultsTable, 20, 30);
        this.add((Component)scrollPane, cc.xywh(1, rowIndex, 3, 1));
        rowIndex += 2;
    }

    public void setAcceptBtn(JButton acceptBtn) {
        this.acceptBtn = acceptBtn;
    }

    private void addUserDefinedMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        GeographicPoint pnt = new GeographicPoint();
        pnt.setLatitude(pos.getLatitude().getDegrees());
        pnt.setLongitude(pos.getLongitude().getDegrees());
        this.userDefGeoRef = new GeorefResult();
        this.userDefGeoRef.setWGS84Coordinate(pnt);
        this.userDefGeoRef.setParsePattern(UIRegistry.getResourceString("GeoLocateResultsDisplay.USRDEF"));
        this.tableModel.add(this.userDefGeoRef);
        int lastRow = this.tableModel.getRowCount() - 1;
        this.resultsTable.getSelectionModel().setSelectionInterval(lastRow, lastRow);
        this.resultsTable.repaint();
        this.wwPanel.placeMarkers(this.tableModel.getPoints(), null);
    }

    private void repositionUserDefMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        GeographicPoint pnt = this.userDefGeoRef.getWGS84Coordinate();
        pnt.setLatitude(pos.getLatitude().getDegrees());
        pnt.setLongitude(pos.getLongitude().getDegrees());
        this.tableModel.fireTableCellUpdated(this.tableModel.getRowCount() - 1, 1);
        this.tableModel.fireTableCellUpdated(this.tableModel.getRowCount() - 1, 2);
        this.wwPanel.placeMarkers(this.tableModel.getPoints(), null);
        this.wwPanel.getWorld().repaint();
        int lastRow = this.tableModel.getRowCount() - 1;
        this.resultsTable.getSelectionModel().setSelectionInterval(lastRow, lastRow);
        this.resultsTable.repaint();
    }

    public void setGeoLocateQueryAndResults(String localityString, String county, String state, String country, GeorefResultSet georefResults) {
        this.userDefGeoRef = null;
        this.lastClickPos = null;
        this.localityStringField.setText(localityString);
        this.localityStringField.setCaretPosition(0);
        this.countyField.setText(county);
        this.countyField.setCaretPosition(0);
        this.stateField.setText(state);
        this.stateField.setCaretPosition(0);
        this.countryField.setText(country);
        this.countryField.setCaretPosition(0);
        this.tableModel.setResultSet(georefResults.getResultSet());
        if (this.wwPanel != null) {
            ArrayList<LatLonPlacemarkIFace> pnts = new ArrayList<LatLonPlacemarkIFace>(georefResults.getResultSet().size());
            for (GeorefResult grr : georefResults.getResultSet()) {
                pnts.add(new LatLonPoint(grr.getWGS84Coordinate().getLatitude(), grr.getWGS84Coordinate().getLongitude()));
            }
            this.wwPanel.placeMarkers(pnts, 0);
        } else {
            this.mapLabel.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.LOADING_MAP"));
        }
        Dimension size = this.resultsTable.getPreferredScrollableViewportSize();
        size.height = Math.min(size.height, this.resultsTable.getRowHeight() * 10);
        this.resultsTable.setPreferredScrollableViewportSize(size);
        UIHelper.calcColumnWidths(this.resultsTable);
    }

    public GeorefResult getSelectedResult() {
        int rowIndex = this.resultsTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex > this.tableModel.getRowCount()) {
            return null;
        }
        return this.tableModel.getResult(rowIndex);
    }

    public void setSelectedResult(int index) {
        if (index < 0 || index > this.resultsTable.getRowCount() - 1) {
            this.resultsTable.clearSelection();
        } else {
            this.resultsTable.setRowSelectionInterval(index, index);
            int colCount = this.resultsTable.getColumnCount();
            this.resultsTable.setColumnSelectionInterval(0, colCount - 1);
        }
    }

    @Override
    public void exceptionOccurred(Exception e) {
        if (this.mapLabel != null) {
            this.mapLabel.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_GETTING_MAP"));
        }
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setErrorMessage(UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_GETTING_MAP"), e);
    }

    @Override
    public void mapReceived(Icon map) {
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setText("");
        this.mapLabel.setText(null);
        this.mapLabel.setIcon(map);
        this.repaint();
    }

    public void selected(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && event.hasObjects() && event.getTopPickedObject().hasPosition()) {
            this.lastClickPos = this.wwPanel.getWorld().getCurrentPosition();
            if (this.wwPanel.getWorld().getView() instanceof OrbitView) {
                int inx;
                if (event.getTopObject().getClass().equals(BasicMarker.class)) {
                    int inx2 = this.wwPanel.getMarkers().indexOf(event.getTopObject());
                    if (inx2 > -1) {
                        this.resultsTable.setRowSelectionInterval(inx2, inx2);
                    }
                } else if (event.getTopObject().getClass().equals(GlobeAnnotation.class) && (inx = this.wwPanel.getAnnotations().indexOf(event.getTopObject())) > -1) {
                    this.resultsTable.setRowSelectionInterval(inx, inx);
                }
            }
        }
    }

    protected JTextField addRow(CellConstraints cc, String labelStr, int column, int row) {
        this.add((Component)UIHelper.createI18NFormLabel(labelStr), cc.xy(column, row));
        JTextField tf = this.createTextField();
        tf.setEditable(false);
        this.add((Component)tf, cc.xy(column + 2, row));
        return tf;
    }

    public void shutdown() {
        if (this.wwPanel != null) {
            this.wwPanel.shutdown();
        }
    }

    protected JTextField createTextField() {
        JTextField tf = UIHelper.createTextField();
        Insets insets = tf.getBorder().getBorderInsets(tf);
        tf.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        tf.setForeground(Color.BLACK);
        tf.setBackground(Color.WHITE);
        tf.setEditable(false);
        return tf;
    }

    protected class ResultsTableModel
    extends AbstractTableModel {
        protected List<GeorefResult> results;

        protected ResultsTableModel() {
        }

        public void setResultSet(List<GeorefResult> results) {
            this.results = results;
            this.fireTableDataChanged();
        }

        public void add(GeorefResult grr) {
            this.results.add(grr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ResultsTableModel.this.fireTableDataChanged();
                }
            });
        }

        public GeorefResult getResult(int index) {
            return this.results.get(index);
        }

        public List<GeorefResult> getResults() {
            return this.results;
        }

        public List<LatLonPlacemarkIFace> getPoints() {
            ArrayList<LatLonPlacemarkIFace> pnts = new ArrayList<LatLonPlacemarkIFace>(this.results.size());
            for (GeorefResult grr : this.results) {
                pnts.add(new LatLonPoint(grr.getWGS84Coordinate().getLatitude(), grr.getWGS84Coordinate().getLongitude()));
            }
            return pnts;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: 
                case 2: {
                    return Double.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.NUMBER");
                }
                case 1: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.LATITUDE");
                }
                case 2: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.LONGITUDE");
                }
                case 3: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.PARSE_PATTERN");
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.results == null ? 0 : this.results.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GeorefResult res = this.results.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return res.getWGS84Coordinate().getLatitude();
                }
                case 2: {
                    return res.getWGS84Coordinate().getLongitude();
                }
                case 3: {
                    return res.getParsePattern();
                }
            }
            return null;
        }
    }
}

