/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawCancelListener;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawEvent;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawListener;
import edu.ku.brc.services.geolocate.prototype.Locality;
import edu.ku.brc.services.geolocate.prototype.LocalityWaypoint;
import edu.ku.brc.services.geolocate.prototype.MapPointerMoveEvent;
import edu.ku.brc.services.geolocate.prototype.MapPointerMoveListener;
import edu.ku.brc.services.geolocate.prototype.Mapper;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceCancelListener;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceEvent;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceListener;
import edu.ku.brc.services.geolocate.prototype.MostAccuratePointReleaseListener;
import edu.ku.brc.services.geolocate.prototype.MostAccuratePointSnapListener;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleChangeEvent;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleChangeListener;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeCancelListener;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeEvent;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeListener;
import edu.ku.brc.services.geolocate.prototype.client.GeographicPoint;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result_Set;
import edu.ku.brc.services.mapping.LatLonPlacemarkIFace;
import edu.ku.brc.services.mapping.LatLonPoint;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.services.usgs.elevation.Elevation_ServiceLocator;
import edu.ku.brc.services.usgs.elevation.Elevation_ServiceSoap;
import edu.ku.brc.services.usgs.elevation.GetElevationResponseGetElevationResult;
import edu.ku.brc.specify.ui.ClickAndGoSelectListener;
import edu.ku.brc.specify.ui.WorldWindPanel;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.MessageElement;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class GeoLocateResultsDisplay
extends JPanel
implements LocalityMapper.MapperListener,
SelectListener {
    private static final String L10N = "GeoLocateResultsDisplay.";
    protected static final int MAP_WIDTH = 500;
    protected static final int MAP_HEIGHT = 500;
    protected static final int MAP_WIDTH2 = 600;
    protected static final int MAP_HEIGHT2 = 450;
    protected ResultsTableModel tableModel;
    protected JTable resultsTable;
    protected JLabel mapLabel;
    protected JTextField localityStringField;
    protected JTextField countyField;
    protected JTextField stateField;
    protected JTextField countryField;
    protected JTextField polyField;
    protected ErrBtnStateType errBtnState = ErrBtnStateType.eApply;
    protected UnCertBtnStateType ucBtnState = UnCertBtnStateType.eApply;
    protected JButton acceptBtn = null;
    protected WorldWindPanel wwPanel = null;
    protected Mapper geoMapper = null;
    protected Georef_Result userDefGeoRef = null;
    protected Position lastClickPos = null;
    protected boolean useWorldWind = AppPreferences.getLocalPrefs().getBoolean("GEOLocate.USEGL_MAPS", true) == false;
    protected JTextField latText;
    protected JTextField lonText;
    protected JButton coordBtn;
    protected JTextField uncertTxt;
    protected JButton uncertBtn;
    protected JTextArea errorPTxt;
    protected JButton errorPBtn;
    protected JLabel statusLatLbl;
    protected JLabel statusLonLbl;
    protected JLabel statusURLbl;
    protected JLabel statusErrorLbl;
    protected JButton getElevBtn;
    protected JCheckBox statusMeasureTool;
    protected JButton statusClearRulerBtn;
    protected JPanel statusElevPanel;
    protected JPanel statusClearRulerPanel;
    protected JPanel statusPanel;
    protected JLabel statusElevLbl;
    protected JLabel statusElevInfoLbl;
    protected boolean isElevBtnDown = false;

    public GeoLocateResultsDisplay() {
        PanelBuilder mainPB = this.useWorldWind ? new PanelBuilder(new FormLayout("p,10px,500px,10px,f:p:g", "p,2px,p,2px,p,2px,p,2px,p,10px,p,2px,f:p:g"), (JPanel)this) : new PanelBuilder(new FormLayout("p,10px,500px,10px,f:p:g", "p,2px,p,2px,p,2px,p,2px,p,5px,p,10px,p,2px,f:p:g,10px,f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        mainPB.addSeparator(UIRegistry.getResourceString("GeoLocateResultsDisplay.LOC_INFO"));
        this.localityStringField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.LOCALITY_DESC"), 1, rowIndex += 2);
        this.countyField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.COUNTY"), 1, rowIndex += 2);
        this.stateField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.STATE"), 1, rowIndex += 2);
        this.countryField = this.addRow(cc, UIRegistry.getResourceString("GeoLocateResultsDisplay.COUNTRY"), 1, rowIndex += 2);
        rowIndex += 2;
        this.mapLabel = UIHelper.createLabel(UIRegistry.getResourceString("GeoLocateResultsDisplay.LOADING_MAP"));
        this.mapLabel.setPreferredSize(new Dimension(500, 500));
        if (!this.useWorldWind) {
            FocusListener focLis = new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    GeoLocateResultsDisplay.this.statusErrorLbl.setText("");
                }
            };
            PanelBuilder corMarkerPB = new PanelBuilder(new FormLayout("f:p:g,10px,f:p:g,10px,f:p:g", "f:p:g"));
            JLabel lbl = UIHelper.createLabel("");
            corMarkerPB.getPanel().setBorder(new TitledBorder(new EtchedBorder(1), UIRegistry.getResourceString("GeoLocateResultsDisplay.GREEN_PROPS"), 1, 2, lbl.getFont(), lbl.getForeground()));
            mainPB.add((Component)corMarkerPB.getPanel(), cc.xyw(1, rowIndex, 3));
            rowIndex += 2;
            this.latText = UIHelper.createTextField();
            this.latText.addFocusListener(focLis);
            this.lonText = UIHelper.createTextField();
            this.lonText.addFocusListener(focLis);
            this.coordBtn = UIHelper.createI18NButton("Apply");
            this.coordBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeoLocateResultsDisplay.this.applyManualCoordinates();
                }
            });
            PanelBuilder coordsPB = new PanelBuilder(new FormLayout("p,2px,f:p:g,p", "p,2px,p,2px,p,f:p:g,p"));
            coordsPB.addSeparator(UIRegistry.getResourceString("GeoLocateResultsDisplay.POS"), cc.xyw(1, 1, 4));
            coordsPB.add((Component)UIHelper.createI18NFormLabel("Latitude", 4), cc.xy(1, 3));
            coordsPB.add((Component)this.latText, cc.xyw(3, 3, 2));
            coordsPB.add((Component)UIHelper.createI18NFormLabel("Longitude", 4), cc.xy(1, 5));
            coordsPB.add((Component)this.lonText, cc.xyw(3, 5, 2));
            coordsPB.add((Component)this.coordBtn, cc.xy(4, 7));
            corMarkerPB.add((Component)coordsPB.getPanel(), cc.xy(1, 1));
            this.uncertTxt = UIHelper.createTextField();
            this.uncertTxt.addFocusListener(focLis);
            this.uncertBtn = UIHelper.createI18NButton("Apply");
            PanelBuilder uncertaintyPB = new PanelBuilder(new FormLayout("p,2px,p:g,p", "p,2px,p,4px,f:p:g,p"));
            uncertaintyPB.addSeparator(UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCRT_RADIUS"), cc.xyw(1, 1, 4));
            uncertaintyPB.add((Component)UIHelper.createI18NFormLabel("In meters"), cc.xy(1, 3));
            uncertaintyPB.add((Component)this.uncertTxt, cc.xyw(3, 3, 2));
            uncertaintyPB.add((Component)this.uncertBtn, cc.xy(4, 6));
            corMarkerPB.add((Component)uncertaintyPB.getPanel(), cc.xy(3, 1));
            this.errorPTxt = UIHelper.createTextArea();
            this.errorPTxt.setLineWrap(true);
            this.errorPTxt.setWrapStyleWord(true);
            this.errorPTxt.addFocusListener(focLis);
            JScrollPane errorPScrollPane = new JScrollPane(this.errorPTxt, 20, 30);
            errorPScrollPane.setPreferredSize(new Dimension(70, 50));
            this.errorPBtn = UIHelper.createI18NButton("Apply");
            PanelBuilder errorPolygonPB = new PanelBuilder(new FormLayout("f:p:g,2px,r:p", "p,2px,p,4px,f:p:g,p"));
            errorPolygonPB.addSeparator(UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_POLY"), cc.xyw(1, 1, 3));
            errorPolygonPB.add((Component)errorPScrollPane, cc.xyw(1, 3, 3));
            errorPolygonPB.add((Component)this.errorPBtn, cc.xy(3, 6));
            corMarkerPB.add((Component)errorPolygonPB.getPanel(), cc.xy(5, 1));
            this.uncertBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoLocateResultsDisplay.this.ucBtnState == UnCertBtnStateType.eApply) {
                        long uRad = 0L;
                        try {
                            uRad = Long.parseLong(GeoLocateResultsDisplay.this.uncertTxt.getText());
                        }
                        catch (Exception ex) {
                            GeoLocateResultsDisplay.this.statusErrorLbl.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.INV_ERR_RADIUS"));
                            return;
                        }
                        GeoLocateResultsDisplay.this.geoMapper.editUncertaintyCircle(uRad);
                        GeoLocateResultsDisplay.this.geoMapper.hideEditUncertaintyHandle();
                        GeoLocateResultsDisplay.this.uncertTxt.setEditable(false);
                        GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCRT_RADIUS"));
                        GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eEdit;
                        GeoLocateResultsDisplay.this.statusURLbl.setText("");
                    } else {
                        GeoLocateResultsDisplay.this.uncertTxt.setEditable(true);
                        GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("Apply"));
                        GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eApply;
                        GeoLocateResultsDisplay.this.geoMapper.showEditUncertaintyHandle();
                    }
                }
            });
            this.errorPBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoLocateResultsDisplay.this.errBtnState == ErrBtnStateType.eApply) {
                        ArrayList<GeoPosition> errorRegion = new ArrayList<GeoPosition>();
                        try {
                            if (GeoLocateResultsDisplay.this.errorPTxt.getText().length() > 0) {
                                double lat = Double.NaN;
                                double lon = Double.NaN;
                                String[] latLons = GeoLocateResultsDisplay.this.errorPTxt.getText().split(",");
                                int i = 0;
                                while (i < latLons.length) {
                                    if (i % 2 == 0) {
                                        lat = Double.parseDouble(latLons[i]);
                                    } else {
                                        lon = Double.parseDouble(latLons[i]);
                                        GeoPosition pos = new GeoPosition(lat, lon);
                                        errorRegion.add(pos);
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (Exception ex) {
                            GeoLocateResultsDisplay.this.statusErrorLbl.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.INV_POLY"));
                            return;
                        }
                        GeoLocateResultsDisplay.this.geoMapper.drawPolygon(errorRegion);
                        GeoLocateResultsDisplay.this.geoMapper.hideEditPolygonHandle();
                        GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.CLR_POLYGON"));
                        GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eClear;
                        GeoLocateResultsDisplay.this.errorPTxt.setEditable(false);
                        GeoLocateResultsDisplay.this.statusMeasureTool.setEnabled(true);
                        GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                    } else if (GeoLocateResultsDisplay.this.errBtnState == ErrBtnStateType.eDraw) {
                        GeoLocateResultsDisplay.this.errorPTxt.setEditable(true);
                        GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("Apply"));
                        GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eApply;
                        GeoLocateResultsDisplay.this.geoMapper.showEditPolygonHandle();
                        GeoLocateResultsDisplay.this.statusMeasureTool.setSelected(false);
                        GeoLocateResultsDisplay.this.statusMeasureTool.setEnabled(false);
                    } else if (GeoLocateResultsDisplay.this.errBtnState == ErrBtnStateType.eClear) {
                        GeoLocateResultsDisplay.this.errorPTxt.setText("");
                        GeoLocateResultsDisplay.this.geoMapper.removePolygon();
                        GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.DRW_POLYGON"));
                        GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eDraw;
                        GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt().getLocality().setErrorPolygon(null);
                    }
                }
            });
            this.geoMapper = new Mapper();
            this.geoMapper.setMapSize(new Dimension(600, 450));
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new FlowLayout(2, 0, 0));
            this.statusPanel.setPreferredSize(new Dimension(600, 46));
            this.statusPanel.setBorder(new BevelBorder(1));
            Font font = new Font("Arial", 0, 10);
            this.statusLatLbl = new JLabel("Lat: ,", 2);
            this.statusLatLbl.setPreferredSize(new Dimension(80, 12));
            this.statusLatLbl.setFont(font);
            this.statusLonLbl = new JLabel("Lon: ", 2);
            this.statusLonLbl.setPreferredSize(new Dimension(85, 12));
            this.statusLonLbl.setFont(font);
            this.statusMeasureTool = new JCheckBox("Measure");
            this.statusMeasureTool.setPreferredSize(new Dimension(60, 12));
            this.statusMeasureTool.setFocusable(false);
            this.statusMeasureTool.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GeoLocateResultsDisplay.this.statusMeasureTool.isSelected()) {
                        GeoLocateResultsDisplay.this.geoMapper.showMeasureDistanceHandle();
                        GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(false);
                    } else {
                        GeoLocateResultsDisplay.this.geoMapper.hideMeasureDistanceHandle();
                        GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                    }
                }
            });
            this.statusMeasureTool.setFont(font);
            this.statusURLbl = new JLabel("U. Radius: ", 2);
            this.statusURLbl.setPreferredSize(new Dimension(115, 12));
            this.statusURLbl.setFont(font);
            this.statusElevPanel = new JPanel();
            this.statusElevPanel.setLayout(new FlowLayout(0, 2, 2));
            this.statusElevPanel.setPreferredSize(new Dimension(176, 16));
            this.statusElevPanel.setBorder(BorderFactory.createEmptyBorder());
            this.getElevBtn = new JButton("Get Elevation");
            this.getElevBtn.setPreferredSize(new Dimension(80, 15));
            this.getElevBtn.setFont(font);
            this.getElevBtn.setFocusable(false);
            this.statusElevPanel.add(this.getElevBtn);
            this.getElevBtn.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    GeoLocateResultsDisplay.this.isElevBtnDown = false;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    GeoLocateResultsDisplay.this.isElevBtnDown = true;
                    LocalityWaypoint mostAccurate = GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt();
                    Double lat = mostAccurate.getPosition().getLatitude();
                    Double lon = mostAccurate.getPosition().getLongitude();
                    Double rLat = GeoLocateResultsDisplay.this.geoMapper.decimalRound(lat, 6);
                    Double rLon = GeoLocateResultsDisplay.this.geoMapper.decimalRound(lon, 6);
                    GeoLocateResultsDisplay.this.statusElevInfoLbl.setForeground(Color.BLACK);
                    GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("Getting Elevation @(" + rLat + ", " + rLon + ")...");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (GeoLocateResultsDisplay.this.isElevBtnDown) {
                        GeoLocateResultsDisplay.this.isElevBtnDown = false;
                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("");
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.getElevBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block10: {
                        Elevation_ServiceLocator service = null;
                        Elevation_ServiceSoap port = null;
                        String elevInfo = "";
                        Double elev = 0.0;
                        LocalityWaypoint mostAccurate = GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt();
                        Double lat = mostAccurate.getPosition().getLatitude();
                        Double lon = mostAccurate.getPosition().getLongitude();
                        try {
                            service = new Elevation_ServiceLocator();
                            if (service == null || (port = service.getElevation_ServiceSoap()) == null) break block10;
                            try {
                                GetElevationResponseGetElevationResult result = port.getElevation(lon.toString(), lat.toString(), "meters", "", "");
                                Iterator it = result.get_any()[0].getChildElements();
                                while (it.hasNext()) {
                                    MessageElement msgEle = (MessageElement)it.next();
                                    if (!msgEle.getName().toLowerCase().equals("Elevation_Query".toLowerCase())) continue;
                                    Iterator it2 = msgEle.getChildElements();
                                    while (it2.hasNext()) {
                                        Object it2Obj = it2.next();
                                        if (it2Obj.getClass() == MessageElement.class) {
                                            MessageElement msgEle2 = (MessageElement)it2Obj;
                                            if (msgEle2.getName().toLowerCase().equals("Data_Source".toLowerCase())) {
                                                elevInfo = msgEle2.getValue();
                                            }
                                            if (!msgEle2.getName().toLowerCase().equals("Elevation".toLowerCase())) continue;
                                            String elevStr = msgEle2.getValue();
                                            elev = GeoLocateResultsDisplay.this.geoMapper.decimalRound(Double.parseDouble(elevStr), 2);
                                            continue;
                                        }
                                        elevInfo = "";
                                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setForeground(Color.BLACK);
                                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("");
                                        GeoLocateResultsDisplay.this.statusElevLbl.setText("N/A");
                                        break;
                                    }
                                    if (elevInfo.length() > 0) {
                                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setForeground(Color.BLACK);
                                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setText(elevInfo);
                                        GeoLocateResultsDisplay.this.statusElevLbl.setText(String.valueOf(elev.toString()) + "m");
                                    }
                                    break;
                                }
                            }
                            catch (RemoteException remEx) {
                                GeoLocateResultsDisplay.this.statusElevInfoLbl.setForeground(Color.RED);
                                GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("Error: unable to parse elevation data.");
                            }
                        }
                        catch (ServiceException servEx) {
                            GeoLocateResultsDisplay.this.statusElevInfoLbl.setForeground(Color.RED);
                            GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("Error: elevation service unavailable.");
                            servEx.printStackTrace();
                        }
                        catch (OutOfMemoryError em1) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    UIRegistry.showError("Out of Memory! Please restart Specify.");
                                }
                            });
                            return;
                        }
                    }
                }
            });
            this.statusElevLbl = new JLabel("", 2);
            this.statusElevLbl.setPreferredSize(new Dimension(90, 12));
            this.statusElevLbl.setFont(font);
            this.statusElevPanel.add(this.statusElevLbl);
            this.statusElevInfoLbl = new JLabel("", 2);
            this.statusElevInfoLbl.setPreferredSize(new Dimension(596, 12));
            this.statusElevInfoLbl.setFont(font);
            this.statusClearRulerPanel = new JPanel();
            this.statusClearRulerPanel.setLayout(new FlowLayout(0, 2, 2));
            this.statusClearRulerPanel.setPreferredSize(new Dimension(80, 16));
            this.statusClearRulerPanel.setBorder(BorderFactory.createEmptyBorder());
            this.statusClearRulerBtn = new JButton("Clear Ruler");
            this.statusClearRulerBtn.setPreferredSize(new Dimension(70, 15));
            this.statusClearRulerBtn.setFont(font);
            this.statusClearRulerBtn.setFocusable(false);
            this.statusClearRulerBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GeoLocateResultsDisplay.this.geoMapper.removeRuler();
                    if (GeoLocateResultsDisplay.this.statusMeasureTool.isSelected()) {
                        GeoLocateResultsDisplay.this.geoMapper.showMeasureDistanceHandle();
                    }
                }
            });
            this.statusClearRulerPanel.add(this.statusClearRulerBtn);
            this.statusErrorLbl = new JLabel("", 2);
            this.statusErrorLbl.setPreferredSize(new Dimension(596, 12));
            this.statusErrorLbl.setForeground(Color.RED);
            this.statusErrorLbl.setFont(font);
            this.statusPanel.add(this.statusElevPanel);
            this.statusPanel.add(this.statusURLbl);
            this.statusPanel.add(this.statusMeasureTool);
            this.statusPanel.add(this.statusClearRulerPanel);
            this.statusPanel.add(this.statusLatLbl);
            this.statusPanel.add(this.statusLonLbl);
            this.statusPanel.add(this.statusElevInfoLbl);
            this.statusPanel.add(this.statusErrorLbl);
            JPanel mPanel = new JPanel(new BorderLayout(0, 2));
            mPanel.setPreferredSize(new Dimension(600, 450 + this.statusPanel.getHeight()));
            mPanel.setMinimumSize(new Dimension(600, 450 + this.statusPanel.getHeight()));
            this.geoMapper.addMeasureDistanceListener(new MeasureDistanceListener(){

                @Override
                public void distanceMeasured(MeasureDistanceEvent evt) {
                    GeoLocateResultsDisplay.this.statusMeasureTool.setSelected(false);
                    GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                }
            });
            this.geoMapper.addMeasureDistanceCancelListener(new MeasureDistanceCancelListener(){

                @Override
                public void measureDistanceCancelled() {
                    GeoLocateResultsDisplay.this.statusMeasureTool.setSelected(false);
                    GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                }
            });
            this.geoMapper.addUncertaintyCircleResizeCancelListener(new UncertaintyCircleResizeCancelListener(){

                @Override
                public void uncertaintyCircleResizeCancelled() {
                    GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCRT_RADIUS"));
                    GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eEdit;
                    GeoLocateResultsDisplay.this.uncertTxt.setEditable(false);
                    GeoLocateResultsDisplay.this.statusURLbl.setText("");
                }
            });
            this.geoMapper.addErrorPolygonDrawCancelListener(new ErrorPolygonDrawCancelListener(){

                @Override
                public void errorPolygonDrawCancelled() {
                    GeoLocateResultsDisplay.this.errorPTxt.setText("");
                    GeoLocateResultsDisplay.this.errorPTxt.setEditable(false);
                    GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.DRW_POLYGON"));
                    GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eDraw;
                    GeoLocateResultsDisplay.this.statusMeasureTool.setEnabled(true);
                    GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                }
            });
            this.geoMapper.addErrorPolygonDrawListener(new ErrorPolygonDrawListener(){

                @Override
                public void errorPolygonDrawn(ErrorPolygonDrawEvent evt) {
                    GeoLocateResultsDisplay.this.setTextIntoErrorPolygonTA(GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt().getLocality().getErrorPolygon());
                    GeoLocateResultsDisplay.this.geoMapper.hideEditPolygonHandle();
                    GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.CLR_POLYGON"));
                    GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eClear;
                    GeoLocateResultsDisplay.this.errorPTxt.setEditable(false);
                    GeoLocateResultsDisplay.this.statusMeasureTool.setEnabled(true);
                    GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                }
            });
            this.geoMapper.addUncertaintyCircleResizeListener(new UncertaintyCircleResizeListener(){

                @Override
                public void uncertaintyCircleResized(UncertaintyCircleResizeEvent evt) {
                    GeoLocateResultsDisplay.this.uncertTxt.setText(GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt().getLocality().getUncertaintyMeters());
                }
            });
            this.geoMapper.addUncertaintyCircleChangeListener(new UncertaintyCircleChangeListener(){

                @Override
                public void uncertaintyCircleChanged(UncertaintyCircleChangeEvent evt) {
                    GeoLocateResultsDisplay.this.statusURLbl.setText("U. Radius: " + Long.toString(evt.getUncertaintyRadiusInMeters()) + "m");
                }
            });
            this.geoMapper.addMapPointerMoveListener(new MapPointerMoveListener(){

                @Override
                public void mapPointerMoved(MapPointerMoveEvent evt) {
                    GeoPosition pointerPos = evt.getLocation();
                    GeoLocateResultsDisplay.this.setStatusBarCoordinates(pointerPos.getLatitude(), pointerPos.getLongitude());
                }
            });
            this.geoMapper.addMostAccuratePointReleaseListener(new MostAccuratePointReleaseListener(){

                @Override
                public void mostAccuratePointReleased(MapPointerMoveEvent evt) {
                    LocalityWaypoint mostAccurate = GeoLocateResultsDisplay.this.geoMapper.getMostAccurateResultPt();
                    double lat = mostAccurate.getPosition().getLatitude();
                    double lon = mostAccurate.getPosition().getLongitude();
                    GeoLocateResultsDisplay.this.latText.setText(Double.toString(GeoLocateResultsDisplay.this.geoMapper.decimalRound(lat, 6)));
                    GeoLocateResultsDisplay.this.lonText.setText(Double.toString(GeoLocateResultsDisplay.this.geoMapper.decimalRound(lon, 6)));
                    GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("");
                    GeoLocateResultsDisplay.this.statusElevLbl.setText("");
                    String resUncert = mostAccurate.getLocality().getUncertaintyMeters();
                    if (resUncert != null && !resUncert.equalsIgnoreCase("unavailable")) {
                        GeoLocateResultsDisplay.this.uncertTxt.setText(resUncert);
                    } else {
                        GeoLocateResultsDisplay.this.uncertTxt.setText("");
                    }
                    String resErrorP = mostAccurate.getLocality().getErrorPolygon();
                    if (resErrorP != null && !resErrorP.equalsIgnoreCase("unavailable")) {
                        GeoLocateResultsDisplay.this.setTextIntoErrorPolygonTA(resErrorP);
                    } else {
                        GeoLocateResultsDisplay.this.errorPTxt.setText("");
                    }
                    if (GeoLocateResultsDisplay.this.ucBtnState == UnCertBtnStateType.eApply) {
                        GeoLocateResultsDisplay.this.geoMapper.persistEditUncertaintyHandle();
                    }
                }
            });
            this.geoMapper.addMostAccuratePointSnapListener(new MostAccuratePointSnapListener(){

                @Override
                public void mostAccuratePointSnapped(MapPointerMoveEvent evt) {
                    int index = 0;
                    double snapLat = evt.getLocation().getLatitude();
                    double snapLon = evt.getLocation().getLongitude();
                    int i = 0;
                    while (i < GeoLocateResultsDisplay.this.tableModel.getResults().size()) {
                        index = i;
                        Georef_Result res = GeoLocateResultsDisplay.this.tableModel.getResult(index);
                        double resLat = GeoLocateResultsDisplay.this.geoMapper.decimalRound(res.getWGS84Coordinate().getLatitude(), 6);
                        double resLon = GeoLocateResultsDisplay.this.geoMapper.decimalRound(res.getWGS84Coordinate().getLongitude(), 6);
                        if (snapLat == resLat && snapLon == resLon) {
                            GeoLocateResultsDisplay.this.latText.setText(Double.toString(resLat));
                            GeoLocateResultsDisplay.this.lonText.setText(Double.toString(resLon));
                            String resUncert = res.getUncertaintyRadiusMeters();
                            if (resUncert != null && !resUncert.equalsIgnoreCase("unavailable")) {
                                GeoLocateResultsDisplay.this.uncertTxt.setText(resUncert);
                            } else {
                                GeoLocateResultsDisplay.this.uncertTxt.setText("");
                            }
                            String resErrorP = res.getUncertaintyPolygon();
                            if (resErrorP != null && !resErrorP.equalsIgnoreCase("unavailable")) {
                                GeoLocateResultsDisplay.this.setTextIntoErrorPolygonTA(resErrorP);
                                GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.CLR_POLYGON"));
                                GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eClear;
                                break;
                            }
                            GeoLocateResultsDisplay.this.errorPTxt.setText("");
                            break;
                        }
                        ++i;
                    }
                    GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCRT_RADIUS"));
                    GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eEdit;
                    GeoLocateResultsDisplay.this.uncertTxt.setEditable(false);
                    GeoLocateResultsDisplay.this.statusURLbl.setText("");
                    GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("");
                    GeoLocateResultsDisplay.this.statusElevLbl.setText("");
                    GeoLocateResultsDisplay.this.resultsTable.getSelectionModel().setSelectionInterval(index, index);
                    GeoLocateResultsDisplay.this.resultsTable.repaint();
                }
            });
            mPanel.add((Component)((Object)this.geoMapper), "Center");
            mPanel.add((Component)this.statusPanel, "South");
            mainPB.add((Component)mPanel, cc.xywh(5, 1, 1, 15));
        } else {
            this.wwPanel = new WorldWindPanel();
            this.wwPanel.setPreferredSize(new Dimension(500, 500));
            this.wwPanel.getWorld().addSelectListener((SelectListener)new ClickAndGoSelectListener((WorldWindow)this.wwPanel.getWorld(), MarkerLayer.class));
            this.wwPanel.getWorld().addSelectListener((SelectListener)this);
            this.wwPanel.getWorld().getInputHandler().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Position pos = (this).GeoLocateResultsDisplay.this.wwPanel.getWorld().getCurrentPosition();
                            if (!pos.equals((Object)(this).GeoLocateResultsDisplay.this.lastClickPos)) {
                                if ((this).GeoLocateResultsDisplay.this.userDefGeoRef == null) {
                                    GeoLocateResultsDisplay.this.addUserDefinedMarker();
                                } else {
                                    GeoLocateResultsDisplay.this.repositionUserDefMarker();
                                }
                            }
                        }
                    });
                }
            });
            mainPB.add((Component)this.wwPanel, cc.xywh(5, 1, 1, 13));
        }
        this.tableModel = new ResultsTableModel();
        this.resultsTable = new JTable(this.tableModel);
        this.resultsTable.setShowVerticalLines(false);
        this.resultsTable.setShowHorizontalLines(false);
        this.resultsTable.setRowSelectionAllowed(true);
        this.resultsTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && GeoLocateResultsDisplay.this.acceptBtn != null) {
                    GeoLocateResultsDisplay.this.acceptBtn.setEnabled(GeoLocateResultsDisplay.this.resultsTable.getSelectedRowCount() > 0);
                }
            }
        });
        if (this.wwPanel != null) {
            this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    GeoLocateResultsDisplay.this.wwPanel.flyToMarker(GeoLocateResultsDisplay.this.resultsTable.getSelectedRow());
                }
            });
        } else {
            this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (GeoLocateResultsDisplay.this.resultsTable.getSelectedRow() > -1) {
                        Georef_Result res = GeoLocateResultsDisplay.this.tableModel.getResult(GeoLocateResultsDisplay.this.resultsTable.getSelectedRow());
                        double lat = res.getWGS84Coordinate().getLatitude();
                        double lon = res.getWGS84Coordinate().getLongitude();
                        GeoLocateResultsDisplay.this.geoMapper.snapMostAccuratePointTo(new GeoPosition(lat, lon));
                        GeoLocateResultsDisplay.this.latText.setText(Double.toString(GeoLocateResultsDisplay.this.geoMapper.decimalRound(lat, 6)));
                        GeoLocateResultsDisplay.this.lonText.setText(Double.toString(GeoLocateResultsDisplay.this.geoMapper.decimalRound(lon, 6)));
                        GeoLocateResultsDisplay.this.geoMapper.hideEditUncertaintyHandle();
                        GeoLocateResultsDisplay.this.geoMapper.hideEditPolygonHandle();
                        GeoLocateResultsDisplay.this.geoMapper.hideMeasureDistanceHandle();
                        GeoLocateResultsDisplay.this.geoMapper.removeRuler();
                        GeoLocateResultsDisplay.this.statusMeasureTool.setSelected(false);
                        GeoLocateResultsDisplay.this.statusMeasureTool.setEnabled(true);
                        GeoLocateResultsDisplay.this.statusClearRulerBtn.setEnabled(true);
                        GeoLocateResultsDisplay.this.statusURLbl.setText("");
                        GeoLocateResultsDisplay.this.statusElevInfoLbl.setText("");
                        GeoLocateResultsDisplay.this.statusElevLbl.setText("");
                        GeoLocateResultsDisplay.this.statusErrorLbl.setText("");
                        String resUncert = res.getUncertaintyRadiusMeters();
                        if (resUncert != null && !resUncert.equalsIgnoreCase("unavailable")) {
                            GeoLocateResultsDisplay.this.uncertTxt.setText(resUncert);
                            GeoLocateResultsDisplay.this.uncertTxt.setEditable(false);
                            GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCRT_RADIUS"));
                            GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eEdit;
                        } else {
                            GeoLocateResultsDisplay.this.uncertTxt.setText("");
                            GeoLocateResultsDisplay.this.uncertTxt.setEditable(true);
                            GeoLocateResultsDisplay.this.uncertBtn.setText(UIRegistry.getResourceString("Apply"));
                            GeoLocateResultsDisplay.this.ucBtnState = UnCertBtnStateType.eApply;
                        }
                        String resErrorP = res.getUncertaintyPolygon();
                        if (resErrorP != null && !resErrorP.equalsIgnoreCase("unavailable")) {
                            GeoLocateResultsDisplay.this.setTextIntoErrorPolygonTA(resErrorP);
                            GeoLocateResultsDisplay.this.errorPTxt.setEditable(false);
                            GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.CLR_POLYGON"));
                            GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eClear;
                        } else {
                            GeoLocateResultsDisplay.this.errorPTxt.setText("");
                            GeoLocateResultsDisplay.this.errorPTxt.setEditable(false);
                            GeoLocateResultsDisplay.this.errorPBtn.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.DRW_POLYGON"));
                            GeoLocateResultsDisplay.this.errBtnState = ErrBtnStateType.eDraw;
                        }
                    }
                }
            });
        }
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof String) {
                    ((JLabel)c).setToolTipText((String)value);
                }
                return c;
            }
        };
        this.resultsTable.getColumnModel().getColumn(3).setCellRenderer(cellRenderer);
        mainPB.addSeparator(UIRegistry.getResourceString("GeoLocateResultsDisplay.GEO_LOC_RESULTS"), cc.xywh(1, rowIndex, 3, 1));
        JScrollPane scrollPane = new JScrollPane(this.resultsTable, 20, 30);
        mainPB.add((Component)scrollPane, cc.xywh(1, rowIndex += 2, 3, 1));
        rowIndex += 2;
    }

    private void setTextIntoErrorPolygonTA(String errStr) {
        if (StringUtils.isNotEmpty((String)errStr)) {
            this.errorPTxt.setText(StringUtils.replace((String)errStr, (String)",", (String)", "));
        }
    }

    protected void setStatusBarCoordinates(double latitude, double longitude) {
        this.statusLatLbl.setText(String.format("Lat: %10.6f,", latitude));
        this.statusLonLbl.setText(String.format("Lon: %11.6f", longitude));
    }

    protected void applyManualCoordinates() {
        double lat = Double.NaN;
        double lon = Double.NaN;
        try {
            lat = Double.parseDouble(this.latText.getText());
            lon = Double.parseDouble(this.lonText.getText());
        }
        catch (Exception ex) {
            this.statusErrorLbl.setText("Error: Invalid coordinate(s) data type.");
            return;
        }
        this.statusElevInfoLbl.setText("");
        this.statusElevLbl.setText("");
        this.geoMapper.snapMostAccuratePointTo(new GeoPosition(lat, lon));
    }

    public void setAcceptBtn(JButton acceptBtn) {
        this.acceptBtn = acceptBtn;
    }

    private void addUserDefinedMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        GeographicPoint pnt = new GeographicPoint();
        pnt.setLatitude(pos.getLatitude().getDegrees());
        pnt.setLongitude(pos.getLongitude().getDegrees());
        this.userDefGeoRef = new Georef_Result();
        this.userDefGeoRef.setWGS84Coordinate(pnt);
        this.userDefGeoRef.setParsePattern(UIRegistry.getResourceString("GeoLocateResultsDisplay.USRDEF"));
        this.tableModel.add(this.userDefGeoRef);
        int lastRow = this.tableModel.getRowCount() - 1;
        this.resultsTable.getSelectionModel().setSelectionInterval(lastRow, lastRow);
        this.resultsTable.repaint();
        this.wwPanel.placeMarkers(this.tableModel.getPoints(), null);
    }

    private void repositionUserDefMarker() {
        Position pos = this.wwPanel.getWorld().getCurrentPosition();
        GeographicPoint pnt = this.userDefGeoRef.getWGS84Coordinate();
        pnt.setLatitude(pos.getLatitude().getDegrees());
        pnt.setLongitude(pos.getLongitude().getDegrees());
        this.tableModel.fireTableCellUpdated(this.tableModel.getRowCount() - 1, 1);
        this.tableModel.fireTableCellUpdated(this.tableModel.getRowCount() - 1, 2);
        this.wwPanel.placeMarkers(this.tableModel.getPoints(), null);
        this.wwPanel.getWorld().repaint();
        int lastRow = this.tableModel.getRowCount() - 1;
        this.resultsTable.getSelectionModel().setSelectionInterval(lastRow, lastRow);
        this.resultsTable.repaint();
    }

    public void setGeoLocateQueryAndResults(String localityString, String county, String state, String country, Georef_Result_Set georefResults) {
        this.localityStringField.setText(localityString);
        this.localityStringField.setCaretPosition(0);
        this.countyField.setText(county);
        this.countyField.setCaretPosition(0);
        this.stateField.setText(state);
        this.stateField.setCaretPosition(0);
        this.countryField.setText(country);
        this.countryField.setCaretPosition(0);
        this.tableModel.setResultSet(georefResults.getResultSet());
        if (this.wwPanel != null) {
            ArrayList<LatLonPlacemarkIFace> pnts = new ArrayList<LatLonPlacemarkIFace>(georefResults.getResultSet().length);
            Georef_Result[] georef_ResultArray = georefResults.getResultSet();
            int n = georef_ResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                Georef_Result grr = georef_ResultArray[n2];
                pnts.add(new LatLonPoint(grr.getWGS84Coordinate().getLatitude(), grr.getWGS84Coordinate().getLongitude()));
                ++n2;
            }
            this.wwPanel.placeMarkers(pnts, 0);
        } else {
            LocalityWaypoint[] lWps = new LocalityWaypoint[georefResults.getNumResults()];
            int index = 0;
            Georef_Result[] georef_ResultArray = georefResults.getResultSet();
            int n = georef_ResultArray.length;
            int n3 = 0;
            while (n3 < n) {
                Georef_Result grr = georef_ResultArray[n3];
                Locality loc = new Locality();
                loc.setLocality(localityString);
                loc.setCountry(country);
                loc.setState(state);
                loc.setCounty(county);
                loc.setPrecision(grr.getPrecision());
                loc.setScore(grr.getScore());
                loc.setLatitude(grr.getWGS84Coordinate().getLatitude());
                loc.setLongitude(grr.getWGS84Coordinate().getLongitude());
                loc.setErrorPolygon(grr.getUncertaintyPolygon());
                loc.setUncertaintyMeters(grr.getUncertaintyRadiusMeters());
                lWps[index] = new LocalityWaypoint(loc);
                ++index;
                ++n3;
            }
            this.geoMapper.plotResultSet(lWps, 0);
        }
        Dimension size = this.resultsTable.getPreferredScrollableViewportSize();
        size.height = Math.min(size.height, this.resultsTable.getRowHeight() * 10);
        this.resultsTable.setPreferredScrollableViewportSize(size);
        UIHelper.calcColumnWidths(this.resultsTable);
    }

    public Georef_Result getSelectedResult() {
        int rowIndex = this.resultsTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex > this.tableModel.getRowCount()) {
            return null;
        }
        return this.tableModel.getResult(rowIndex);
    }

    public void setSelectedResult(int index) {
        if (index < 0 || index > this.resultsTable.getRowCount() - 1) {
            this.resultsTable.clearSelection();
        } else {
            this.resultsTable.setRowSelectionInterval(index, index);
            int colCount = this.resultsTable.getColumnCount();
            this.resultsTable.setColumnSelectionInterval(0, colCount - 1);
        }
    }

    @Override
    public void exceptionOccurred(Exception e) {
        if (this.mapLabel != null) {
            this.mapLabel.setText(UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_GETTING_MAP"));
        }
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setErrorMessage(UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_GETTING_MAP"), e);
    }

    @Override
    public void mapReceived(Icon map) {
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setText("");
        this.mapLabel.setText(null);
        this.mapLabel.setIcon(map);
        this.repaint();
    }

    public void selected(SelectEvent event) {
        if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && event.hasObjects() && event.getTopPickedObject().hasPosition()) {
            this.lastClickPos = this.wwPanel.getWorld().getCurrentPosition();
            if (this.wwPanel.getWorld().getView() instanceof OrbitView) {
                int inx;
                if (event.getTopObject().getClass().equals(BasicMarker.class)) {
                    int inx2 = this.wwPanel.getMarkers().indexOf(event.getTopObject());
                    if (inx2 > -1) {
                        this.resultsTable.setRowSelectionInterval(inx2, inx2);
                    }
                } else if (event.getTopObject().getClass().equals(GlobeAnnotation.class) && (inx = this.wwPanel.getAnnotations().indexOf(event.getTopObject())) > -1) {
                    this.resultsTable.setRowSelectionInterval(inx, inx);
                }
            }
        }
    }

    protected JTextField addRow(CellConstraints cc, String labelStr, int column, int row) {
        this.add((Component)UIHelper.createI18NFormLabel(labelStr), cc.xy(column, row));
        JTextField tf = this.createTextField();
        tf.setEditable(false);
        this.add((Component)tf, cc.xy(column + 2, row));
        return tf;
    }

    public void shutdown() {
        if (this.wwPanel != null) {
            this.wwPanel.shutdown();
        }
    }

    protected JTextField createTextField() {
        JTextField tf = UIHelper.createTextField();
        Insets insets = tf.getBorder().getBorderInsets(tf);
        tf.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        tf.setForeground(Color.BLACK);
        tf.setBackground(Color.WHITE);
        tf.setEditable(false);
        return tf;
    }

    private static enum ErrBtnStateType {
        eDraw,
        eApply,
        eClear;

    }

    protected class ResultsTableModel
    extends AbstractTableModel {
        protected List<Georef_Result> results;

        protected ResultsTableModel() {
        }

        public void setResultSet(Georef_Result[] results) {
            this.results = new ArrayList<Georef_Result>();
            Georef_Result[] georef_ResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Georef_Result grr = georef_ResultArray[n2];
                this.results.add(grr);
                ++n2;
            }
            this.fireTableDataChanged();
        }

        public void add(Georef_Result grr) {
            this.results.add(grr);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ResultsTableModel.this.fireTableDataChanged();
                }
            });
        }

        public Georef_Result getResult(int index) {
            return this.results.get(index);
        }

        public List<Georef_Result> getResults() {
            return this.results;
        }

        public List<LatLonPlacemarkIFace> getPoints() {
            ArrayList<LatLonPlacemarkIFace> pnts = new ArrayList<LatLonPlacemarkIFace>(this.results.size());
            for (Georef_Result grr : this.results) {
                pnts.add(new LatLonPoint(grr.getWGS84Coordinate().getLatitude(), grr.getWGS84Coordinate().getLongitude()));
            }
            return pnts;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: 
                case 2: {
                    return Double.class;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.NUMBER");
                }
                case 1: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.LATITUDE");
                }
                case 2: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.LONGITUDE");
                }
                case 3: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.PARSE_PATTERN");
                }
                case 4: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.PRECISION");
                }
                case 5: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.ERROR_POLY");
                }
                case 6: {
                    return UIRegistry.getResourceString("GeoLocateResultsDisplay.UNCERTAINTY");
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return this.results == null ? 0 : this.results.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Georef_Result res = this.results.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return res.getWGS84Coordinate().getLatitude();
                }
                case 2: {
                    return res.getWGS84Coordinate().getLongitude();
                }
                case 3: {
                    String pattern = res.getParsePattern();
                    String debugStr = res.getDebug();
                    if (debugStr != null && debugStr.length() > 0) {
                        String[] debugPairs = debugStr.split("\\|");
                        int i = 0;
                        while (i < debugPairs.length) {
                            String key = "";
                            String value = "";
                            if (debugPairs[i].split("=").length > 1) {
                                key = debugPairs[i].split("=")[0];
                                value = debugPairs[i].split("=")[1];
                            }
                            if (key.toLowerCase().indexOf(":adm") == 0) {
                                pattern = String.valueOf(pattern) + " (Adm: " + value + ")";
                                break;
                            }
                            ++i;
                        }
                    }
                    return pattern;
                }
                case 4: {
                    if (res.getPrecision() != null) {
                        return String.valueOf(res.getPrecision()) + " (" + res.getScore() + ")";
                    }
                    return "N\\A";
                }
                case 5: {
                    String cellText = "unavailable";
                    if (res.getUncertaintyPolygon() != null) {
                        String polyString = res.getUncertaintyPolygon();
                        if (!cellText.equalsIgnoreCase(polyString.toLowerCase())) {
                            cellText = "present";
                        }
                    } else {
                        cellText = "N\\A";
                    }
                    return cellText;
                }
                case 6: {
                    if (res.getUncertaintyRadiusMeters() != null) {
                        return res.getUncertaintyRadiusMeters();
                    }
                    return "N\\A";
                }
            }
            return null;
        }
    }

    private static enum UnCertBtnStateType {
        eEdit,
        eApply;

    }
}

