/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype.ui;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.services.geolocate.prototype.LocalityWaypoint;
import edu.ku.brc.services.geolocate.prototype.client.GeographicPoint;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result_Set;
import edu.ku.brc.services.geolocate.prototype.ui.GeoLocateResultsDisplay;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import edu.ku.brc.util.Pair;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.apache.commons.lang.StringUtils;

public class GeoLocateResultsChooser
extends CustomDialog {
    protected GeoLocateResultsDisplay resultsDisplayPanel = new GeoLocateResultsDisplay();
    protected List<Pair<GeoCoordDataIFace, Georef_Result_Set>> rowsAndResults;
    protected List<Georef_Result> chosenResults;
    protected boolean hasBeenShown;
    protected int rowIndex;

    public GeoLocateResultsChooser(Frame parent, List<Pair<GeoCoordDataIFace, Georef_Result_Set>> rowsAndResults) {
        super(parent, "", true, 15, null);
        this.rowsAndResults = rowsAndResults;
        this.hasBeenShown = false;
        if (rowsAndResults.size() == 0) {
            throw new IllegalArgumentException("WorkbenchRow set must be non-empty");
        }
        this.chosenResults = new Vector<Georef_Result>(rowsAndResults.size());
        int i = 0;
        while (i < rowsAndResults.size()) {
            this.chosenResults.add(null);
            ++i;
        }
        this.setContentPanel(this.resultsDisplayPanel);
        this.cancelLabel = UIRegistry.getResourceString("GeoLocateResultsChooser.SKIP");
        this.applyLabel = UIRegistry.getResourceString("GeoLocateResultsChooser.ACCEPT");
        this.okLabel = UIRegistry.getResourceString("GeoLocateResultsChooser.QUIT");
        this.rowIndex = -1;
    }

    @Override
    public void createUI() {
        JButton webGeorefBtn = new JButton("GEOLocate Web", IconManager.getIcon("GEOLocate16"));
        webGeorefBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String url = "http://www.museum.tulane.edu/geolocate/web/WebGeoref.aspx?v=1";
                    Georef_Result_Set res = (Georef_Result_Set)GeoLocateResultsChooser.this.rowsAndResults.get((int)GeoLocateResultsChooser.this.rowIndex).second;
                    GeoCoordDataIFace loc = (GeoCoordDataIFace)GeoLocateResultsChooser.this.rowsAndResults.get((int)GeoLocateResultsChooser.this.rowIndex).first;
                    url = String.valueOf(url) + String.format("&country=%1$s&state=%2$s&county=%3$s&locality=%4$s", URLEncoder.encode(loc.getCountry(), "UTF-8"), URLEncoder.encode(loc.getState(), "UTF-8"), URLEncoder.encode(loc.getCounty(), "UTF-8"), URLEncoder.encode(loc.getLocalityString(), "UTF-8"));
                    String points = "&points=";
                    int j = 0;
                    while (j < res.getNumResults()) {
                        String latStr = Double.toString(res.getResultSet()[j].getWGS84Coordinate().getLatitude());
                        String lonStr = Double.toString(res.getResultSet()[j].getWGS84Coordinate().getLongitude());
                        String patStr = res.getResultSet()[j].getParsePattern();
                        patStr = patStr == null ? "" : patStr;
                        String precStr = res.getResultSet()[j].getPrecision();
                        precStr = precStr == null ? "" : String.valueOf(precStr) + " (" + res.getResultSet()[j].getScore() + ")";
                        String uncertStr = res.getResultSet()[j].getUncertaintyRadiusMeters();
                        uncertStr = uncertStr == null || uncertStr.equalsIgnoreCase("unavailable") ? "unavailable" : uncertStr;
                        points = String.valueOf(points) + URLEncoder.encode(String.format("%1$s|%2$s|%3$s|%4$s|%5$s", GeoLocateResultsChooser.this.cleanString(latStr), GeoLocateResultsChooser.this.cleanString(lonStr), GeoLocateResultsChooser.this.cleanString(patStr), GeoLocateResultsChooser.this.cleanString(precStr), GeoLocateResultsChooser.this.cleanString(uncertStr)), "UTF-8");
                        if (j < res.getNumResults() - 1) {
                            points = String.valueOf(points) + ":";
                        }
                        ++j;
                    }
                    url = String.valueOf(url) + points;
                    AttachmentUtils.openURI(new URL(url).toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setExtraBtn(webGeorefBtn);
        super.createUI();
        this.applyBtn.setEnabled(false);
        this.resultsDisplayPanel.setAcceptBtn(this.applyBtn);
    }

    private String cleanString(String str) {
        String newStr = str;
        String[] offenders = new String[]{"\u0000", "\b", "\f", "\n", "\r", "\t"};
        int i = 0;
        while (i < offenders.length) {
            newStr = newStr.replace(offenders[i], " ");
            ++i;
        }
        return newStr.trim();
    }

    public List<Georef_Result> getResultsChosen() {
        if (!this.hasBeenShown) {
            this.pack();
            this.setVisible(true);
        }
        return this.chosenResults;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.hasBeenShown && visible) {
            this.hasBeenShown = true;
            this.createUI();
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, "WorkbenchSpecialTools");
            this.showNextRecord();
            UIHelper.centerWindow(this);
            this.pack();
        }
        super.setVisible(visible);
    }

    @Override
    protected void applyButtonPressed() {
        super.applyButtonPressed();
        Georef_Result result = null;
        if (this.resultsDisplayPanel.useWorldWind) {
            result = this.resultsDisplayPanel.getSelectedResult();
        } else {
            LocalityWaypoint accResult = this.resultsDisplayPanel.geoMapper.getMostAccurateResultPt();
            result = new Georef_Result();
            result.setParsePattern(UIRegistry.getResourceString("GeoLocateResultsDisplay.USRDEF"));
            result.setPrecision(accResult.getLocality().getPrecision());
            result.setScore(accResult.getLocality().getScore());
            result.setUncertaintyPolygon(accResult.getLocality().getErrorPolygon());
            result.setUncertaintyRadiusMeters(accResult.getLocality().getUncertaintyMeters());
            result.setWGS84Coordinate(new GeographicPoint(accResult.getLocality().getLatitude(), accResult.getLocality().getLongitude()));
            result.setErrorPolygon(accResult.getLocality().getErrorPolygon());
            BigDecimal errEst = null;
            String uncertMeters = accResult.getLocality().getUncertaintyMeters();
            if (StringUtils.isNotEmpty((String)uncertMeters)) {
                try {
                    double value = Double.parseDouble(uncertMeters);
                    errEst = new BigDecimal(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            result.setErrorEstimate(errEst);
        }
        this.chosenResults.set(this.rowIndex, result);
        if (this.onLastRecord()) {
            this.resultsDisplayPanel.shutdown();
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    @Override
    protected void okButtonPressed() {
        this.resultsDisplayPanel.shutdown();
        super.okButtonPressed();
    }

    @Override
    protected void cancelButtonPressed() {
        if (this.onLastRecord()) {
            this.resultsDisplayPanel.shutdown();
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    protected void showNextRecord() {
        ++this.rowIndex;
        Georef_Result_Set resSet = (Georef_Result_Set)this.rowsAndResults.get((int)this.rowIndex).second;
        if (resSet.getNumResults() == 0) {
            this.showNextRecord();
        }
        this.setTitle(UIRegistry.getLocalizedMessage("GeoLocateResultsChooser.TITLE", this.rowIndex + 1, this.rowsAndResults.size()));
        try {
            GeoCoordDataIFace item = (GeoCoordDataIFace)this.rowsAndResults.get((int)this.rowIndex).first;
            this.resultsDisplayPanel.setGeoLocateQueryAndResults(item.getLocalityString(), item.getCounty(), item.getState(), item.getCountry(), resSet);
            this.resultsDisplayPanel.setSelectedResult(0);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(GeoLocateResultsChooser.class, e);
            UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("GeoLocateResultsChooser.ERROR_DISPLAY_GL_RESULTS"), e);
            super.setVisible(false);
        }
    }

    protected boolean onLastRecord() {
        return this.rowIndex == this.rowsAndResults.size() - 1;
    }
}

