/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.jdesktop.swingx.JXPanel;

public class ScaleLine
extends JXPanel {
    public final int barPxLength = 100;
    private static final int tickPxRadius = 12;
    private static final int tickPxDiameter = 24;
    private static final int tickFrameOffset = 1;
    private String metricCaption = "";
    private Point metricTickLocation = new Point(100, 12);
    private String imperialCaption = "";
    private Point imperialTickLocation = new Point(100, 12);

    public ScaleLine() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setPreferredSize(new Dimension(100, 24));
        this.setOpaque(false);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(new Color(74, 75, 77));
        g2.drawLine(1, 0, 1, 24);
        g2.drawLine(0, 12, Math.max(this.metricTickLocation.x, this.imperialTickLocation.x), 12);
        Font font = new Font("Arial", 1, 12);
        g2.setFont(font);
        Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(this.metricCaption, g);
        int strOffsetX = (this.metricTickLocation.x - (int)labelBounds.getWidth()) / 2;
        g2.drawString(this.metricCaption, strOffsetX, 9);
        g2.drawLine(this.metricTickLocation.x + 1, 0, this.metricTickLocation.x + 1, this.metricTickLocation.y);
        labelBounds = g.getFontMetrics().getStringBounds(this.imperialCaption, g);
        strOffsetX = (this.imperialTickLocation.x - (int)labelBounds.getWidth()) / 2;
        g2.drawString(this.imperialCaption, strOffsetX, 24);
        g2.drawLine(this.imperialTickLocation.x + 1, 12, this.imperialTickLocation.x + 1, this.imperialTickLocation.y + 12);
    }

    public void adjust(String metricCaption, Point metricTickLocation, String imperialCaption, Point imperialTickLocation, int scaleLineXOffset) {
        this.metricCaption = metricCaption;
        this.imperialCaption = imperialCaption;
        this.imperialTickLocation = new Point(imperialTickLocation.x - scaleLineXOffset, 12);
        this.metricTickLocation = new Point(metricTickLocation.x - scaleLineXOffset, 12);
        this.repaint();
    }

    public Point getLocation() {
        Point location = super.getLocation();
        location.setLocation(location.x, location.y + 12);
        return location;
    }
}

