/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype;

import edu.ku.brc.services.geolocate.prototype.Ellipsoid;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawCancelListener;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawEvent;
import edu.ku.brc.services.geolocate.prototype.ErrorPolygonDrawListener;
import edu.ku.brc.services.geolocate.prototype.GeodeticDistOutput;
import edu.ku.brc.services.geolocate.prototype.GeodeticPosition;
import edu.ku.brc.services.geolocate.prototype.GeographicPosOutput;
import edu.ku.brc.services.geolocate.prototype.LocalityWaypoint;
import edu.ku.brc.services.geolocate.prototype.MapPointerMoveEvent;
import edu.ku.brc.services.geolocate.prototype.MapPointerMoveListener;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceCancelListener;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceEvent;
import edu.ku.brc.services.geolocate.prototype.MeasureDistanceListener;
import edu.ku.brc.services.geolocate.prototype.MostAccuratePointReleaseListener;
import edu.ku.brc.services.geolocate.prototype.MostAccuratePointSnapListener;
import edu.ku.brc.services.geolocate.prototype.ScaleLine;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleChangeEvent;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleChangeListener;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeCancelListener;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeEvent;
import edu.ku.brc.services.geolocate.prototype.UncertaintyCircleResizeListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXMapKit;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointPainter;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.Painter;

public class Mapper
extends JXMapKit {
    private static final int ptStrokeOffsetX = -6;
    private static final int ptStrokeOffsetY = -6;
    private static final int ptStrokeWidth = 12;
    private static final int ptStrokeHeight = 12;
    private static final int ptFillOffsetX = -5;
    private static final int ptFillOffsetY = -5;
    private static final int ptFillWidth = 10;
    private static final int ptFillHeight = 10;
    private static final int defaultZoom = 13;
    private final int uHandleX = 10;
    private final int uHandleY = 0;
    private final int uHandleStrokeWidth = 3;
    private final int uHandleNPoints = 4;
    private final double uRotationAngleDeg = -45.0;
    private final double uRotationAngleRad = -0.7853981633974483;
    private final int[] xArray = new int[]{10, 50, 40, 50};
    private final int[] yArray;
    private int previousFrameCount;
    private boolean shiftRegion;
    private WaypointPainter<JXMapViewer> greenPainter;
    private WaypointPainter<JXMapViewer> redPainter;
    private WaypointPainter<JXMapViewer> polyCursorPainter;
    private WaypointPainter<JXMapViewer> uncertaintyHandlePainter;
    private Painter<JXMapViewer> polygonOverlayPainter;
    private Painter<JXMapViewer> uPolygonOverlayPainter;
    private WaypointPainter<JXMapViewer> rulerCursorPainter;
    private Painter<JXMapViewer> rulerOverlayPainter;
    private boolean isGreenPtSelected;
    private boolean isUHandleSelected;
    private boolean mouseDragged;
    private boolean drawErrorPolygon;
    private boolean measureDistance;
    private boolean isEditUncertaintyHandlePersisted;
    private long uncertaintyRadius;
    private List<GeoPosition> errorRegion;
    private List<GeoPosition> uncertaintyRegion;
    private List<GeoPosition> rulerSegments;
    private LocalityWaypoint mostAccurateResultPt;
    private Set<LocalityWaypoint> resultPoints;
    private GeoPosition handlePos;
    private double handleAz;
    private double handleOffsetX;
    private double handleOffsetY;
    private ScaleLine scaleLine;
    private boolean scaleLineVisible;
    private Point scaleLineLocation;
    protected EventListenerList mapPointerMoveListeners;
    protected EventListenerList mostAccuratePointReleaseListeners;
    protected EventListenerList mostAccuratePointSnapListeners;
    protected EventListenerList errorPolygonDrawListeners;
    protected EventListenerList errorPolygonDrawCancelListeners;
    protected EventListenerList uncertaintyCircleResizeListeners;
    protected EventListenerList uncertaintyCircleResizeCancelListeners;
    protected EventListenerList uncertaintyCircleChangeListeners;
    protected EventListenerList measureDistanceListeners;
    protected EventListenerList measureDistanceCancelListeners;

    public ScaleLine getScaleLine() {
        return this.scaleLine;
    }

    public boolean isScaleLineVisible() {
        return this.scaleLineVisible;
    }

    public void setScaleLineVisible(boolean scaleLineVisible) {
        this.scaleLineVisible = scaleLineVisible;
        this.scaleLine.setVisible(scaleLineVisible);
    }

    private double metricToMiles(double metricDist, boolean isMeters) {
        double cFactor = 0.621371192;
        if (isMeters) {
            metricDist /= 1000.0;
        }
        double distInMiles = metricDist * cFactor;
        return distInMiles;
    }

    private double imperialToMeters(double imperialDist, boolean isFeet) {
        int miToFtFactor = 5280;
        double cFactor = 0.621371192;
        if (isFeet) {
            imperialDist /= (double)miToFtFactor;
        }
        double distInMeters = 1000.0 * (imperialDist / cFactor);
        return distInMeters;
    }

    private double milesToFeet(double distInMiles) {
        int miToFtFactor = 5280;
        double distInFeet = (double)miToFtFactor * distInMiles;
        return distInFeet;
    }

    private int[] normalizeImperial(double distInMiles) {
        double mod;
        int isMi = 1;
        if (distInMiles < 1.0) {
            distInMiles = this.milesToFeet(distInMiles);
            isMi = 0;
        }
        if ((mod = distInMiles % 1000.0) > 0.0 && mod - distInMiles != 0.0) {
            distInMiles -= mod;
        }
        if ((mod = distInMiles % 100.0) > 0.0 && mod - distInMiles != 0.0) {
            distInMiles -= mod;
        }
        if ((mod = distInMiles % 10.0) > 0.0 && mod - distInMiles != 0.0) {
            distInMiles -= mod;
        }
        return new int[]{(int)Math.round(distInMiles), isMi};
    }

    private int[] normalizeMetric(double distInMeters) {
        int isKm = 0;
        double mod = distInMeters % 1000.0;
        if (mod > 0.0 && mod - distInMeters != 0.0) {
            isKm = 1;
            distInMeters = (distInMeters - mod) / 1000.0;
        }
        if ((mod = distInMeters % 100.0) > 0.0 && mod - distInMeters != 0.0) {
            distInMeters -= mod;
        }
        if ((mod = distInMeters % 10.0) > 0.0 && mod - distInMeters != 0.0) {
            distInMeters -= mod;
        }
        return new int[]{(int)Math.round(distInMeters), isKm};
    }

    private void adjustScaleLine() {
        int newX;
        int fullMapWidth;
        Point2D rightMostPt;
        int maxPxLength = 90;
        int startPxX = this.scaleLineLocation.x;
        int endPxX = startPxX + maxPxLength;
        Point endScaleLineLocation = new Point(endPxX, this.scaleLineLocation.y);
        GeoPosition startGP = this.getMainMap().convertPointToGeoPosition((Point2D)this.scaleLineLocation);
        startGP = new GeoPosition(startGP.getLatitude(), this.getSphericalLon(startGP.getLongitude()));
        GeoPosition endGP = this.getMainMap().convertPointToGeoPosition((Point2D)endScaleLineLocation);
        endGP = new GeoPosition(endGP.getLatitude(), this.getSphericalLon(endGP.getLongitude()));
        GeodeticPosition geodaticP = this.computeGeod(startGP, endGP);
        double distInMiles = this.metricToMiles(geodaticP.getDist(), true);
        int[] normalizedMetric = this.normalizeMetric(geodaticP.getDist());
        boolean isKm = normalizedMetric[1] == 1;
        int dist = normalizedMetric[0];
        int[] normalizedImperial = this.normalizeImperial(distInMiles);
        boolean isMi = normalizedImperial[1] == 1;
        int impDist = normalizedImperial[0];
        String metricCaption = String.valueOf(dist) + " " + (isKm ? "km" : "m");
        String imperialCaption = String.valueOf(impDist) + " " + (isMi ? "mi" : "ft");
        endGP = this.computeGeog(startGP, isKm ? dist * 1000 : dist, -90.0);
        GeoPosition endGPImp = this.computeGeog(startGP, this.imperialToMeters(impDist, !isMi), -90.0);
        Point2D metricTickLocation2D = this.getMainMap().convertGeoPositionToPoint(endGP);
        Point2D imperialTickLocation2D = this.getMainMap().convertGeoPositionToPoint(endGPImp);
        int mapWidth = this.getMainMap().getBounds().width;
        Point metricTickLocation = new Point((int)metricTickLocation2D.getX(), (int)metricTickLocation2D.getY());
        Point imperialTickLocation = new Point((int)imperialTickLocation2D.getX(), (int)imperialTickLocation2D.getY());
        if (metricTickLocation.getX() > (double)mapWidth) {
            rightMostPt = this.getMainMap().getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), this.getMainMap().getZoom());
            fullMapWidth = (int)rightMostPt.getX();
            newX = metricTickLocation.x % fullMapWidth;
            metricTickLocation.setLocation(newX, metricTickLocation.y);
        } else if (metricTickLocation.getX() < 0.0) {
            rightMostPt = this.getMainMap().getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), this.getMainMap().getZoom());
            fullMapWidth = (int)rightMostPt.getX();
            fullMapWidth = newX = fullMapWidth - Math.abs(metricTickLocation.x) % fullMapWidth;
            metricTickLocation.setLocation(newX, metricTickLocation.y);
        }
        if (imperialTickLocation.getX() > (double)mapWidth) {
            rightMostPt = this.getMainMap().getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), this.getMainMap().getZoom());
            fullMapWidth = (int)rightMostPt.getX();
            newX = imperialTickLocation.x % fullMapWidth;
            imperialTickLocation.setLocation(newX, imperialTickLocation.y);
        } else if (imperialTickLocation.getX() < 0.0) {
            rightMostPt = this.getMainMap().getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), this.getMainMap().getZoom());
            fullMapWidth = (int)rightMostPt.getX();
            fullMapWidth = newX = fullMapWidth - Math.abs(imperialTickLocation.x) % fullMapWidth;
            imperialTickLocation.setLocation(newX, imperialTickLocation.y);
        }
        this.scaleLine.adjust(metricCaption, metricTickLocation, imperialCaption, imperialTickLocation, this.scaleLineLocation.x);
    }

    public Mapper() {
        int[] nArray = new int[4];
        nArray[1] = -6;
        nArray[3] = 6;
        this.yArray = nArray;
        this.previousFrameCount = 0;
        this.shiftRegion = false;
        this.scaleLineVisible = true;
        this.mapPointerMoveListeners = new EventListenerList();
        this.mostAccuratePointReleaseListeners = new EventListenerList();
        this.mostAccuratePointSnapListeners = new EventListenerList();
        this.errorPolygonDrawListeners = new EventListenerList();
        this.errorPolygonDrawCancelListeners = new EventListenerList();
        this.uncertaintyCircleResizeListeners = new EventListenerList();
        this.uncertaintyCircleResizeCancelListeners = new EventListenerList();
        this.uncertaintyCircleChangeListeners = new EventListenerList();
        this.measureDistanceListeners = new EventListenerList();
        this.measureDistanceCancelListeners = new EventListenerList();
        this.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        this.setAddressLocationShown(false);
        this.setCenterPosition(new GeoPosition(39.64, -97.56));
        this.setZoom(13);
        Dimension mapDim = new Dimension(800, 600);
        this.setPreferredSize(mapDim);
        this.setMinimumSize(mapDim);
        this.setMaximumSize(mapDim);
        this.scaleLine = new ScaleLine();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 50, 4, 4);
        this.getMainMap().add((Component)((Object)this.scaleLine), (Object)gridBagConstraints);
        this.scaleLine.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                Mapper.this.scaleLineLocation = Mapper.this.scaleLine.getLocation();
                Mapper.this.adjustScaleLine();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.greenPainter = null;
        this.redPainter = null;
        this.polyCursorPainter = null;
        this.uncertaintyHandlePainter = null;
        this.polygonOverlayPainter = null;
        this.uPolygonOverlayPainter = null;
        this.isGreenPtSelected = false;
        this.isUHandleSelected = false;
        this.mouseDragged = false;
        this.drawErrorPolygon = false;
        this.measureDistance = false;
        this.isEditUncertaintyHandlePersisted = false;
        this.errorRegion = null;
        this.uncertaintyRegion = null;
        this.rulerSegments = null;
        this.uncertaintyRadius = 0L;
        this.mostAccurateResultPt = null;
        this.resultPoints = new HashSet<LocalityWaypoint>();
        this.getMainMap().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName().toLowerCase();
                if (!propName.equals("mapoverlay") && !propName.equals("panenabled")) {
                    boolean frameChanged;
                    if (propName.equals("centerposition") && Mapper.this.scaleLineLocation != null) {
                        Mapper.this.adjustScaleLine();
                    }
                    if (!Mapper.this.drawErrorPolygon && propName.equals("centerposition") && (frameChanged = Mapper.this.frameChanged())) {
                        if (Mapper.this.errorRegion != null) {
                            List tempERegion = Mapper.this.errorRegion;
                            Mapper.this.errorRegion = null;
                            Mapper.this.clearPolygonOverlay();
                            Mapper.this.errorRegion = tempERegion;
                            Mapper.this.drawPolygonOverlay(Mapper.this.errorRegion);
                        }
                        if (Mapper.this.uncertaintyRegion != null) {
                            List tempURegion = Mapper.this.uncertaintyRegion;
                            Mapper.this.uncertaintyRegion = null;
                            Mapper.this.clearUncertaintyOverlay();
                            Mapper.this.uncertaintyRegion = tempURegion;
                            Mapper.this.drawUncertaintyOverlay(Mapper.this.uncertaintyRegion);
                        }
                        if (Mapper.this.rulerSegments != null) {
                            List tempRSegments = Mapper.this.rulerSegments;
                            Mapper.this.rulerSegments = null;
                            Mapper.this.clearRulerOverlay();
                            Mapper.this.rulerSegments = tempRSegments;
                            Mapper.this.drawRulerOverlay(Mapper.this.rulerSegments);
                        }
                    }
                }
            }
        });
        this.getMainMap().addMouseMotionListener((MouseMotionListener)new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Waypoint newWPt;
                JXMapViewer map = Mapper.this.getMainMap();
                Point pt = me.getPoint();
                GeoPosition gp = map.convertPointToGeoPosition((Point2D)pt);
                boolean isMouseOverGreen = Mapper.this.isEventOnGreenPt(pt);
                Cursor cCursor = new Cursor(0);
                if (isMouseOverGreen || Mapper.this.isEventOnUHandle(pt)) {
                    cCursor = new Cursor(13);
                } else if (Mapper.this.isEventOnRedPt(pt)) {
                    cCursor = new Cursor(1);
                }
                if (Mapper.this.drawErrorPolygon) {
                    newWPt = new Waypoint(gp.getLatitude(), Mapper.this.getSphericalLon(gp.getLongitude()));
                    Mapper.this.drawPolyCursor(newWPt);
                    if (Mapper.this.errorRegion != null && Mapper.this.errorRegion.size() > 0) {
                        ArrayList<GeoPosition> dynamicRegion = new ArrayList<GeoPosition>();
                        dynamicRegion.addAll(Mapper.this.errorRegion);
                        dynamicRegion.add(gp);
                        Mapper.this.drawPolygonOverlay(dynamicRegion);
                    }
                }
                if (Mapper.this.measureDistance) {
                    newWPt = new Waypoint(gp.getLatitude(), Mapper.this.getSphericalLon(gp.getLongitude()));
                    Mapper.this.drawRulerCursor(newWPt);
                    if (Mapper.this.rulerSegments != null && Mapper.this.rulerSegments.size() > 0) {
                        ArrayList<GeoPosition> dynamicSegments = new ArrayList<GeoPosition>();
                        dynamicSegments.addAll(Mapper.this.rulerSegments);
                        dynamicSegments.add(gp);
                        Mapper.this.drawRulerOverlay(dynamicSegments);
                    }
                }
                map.setCursor(cCursor);
                double lat = Mapper.this.decimalRound(gp.getLatitude(), 6);
                double lon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp.getLongitude()), 6);
                GeoPosition MapPMELocation = new GeoPosition(lat, lon);
                MapPointerMoveEvent MapPME = new MapPointerMoveEvent(map, MapPMELocation);
                Mapper.this.fireMapPointerMoveEvent(MapPME);
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                if (Mapper.this.isGreenPtSelected || Mapper.this.isUHandleSelected) {
                    JXMapViewer map = Mapper.this.getMainMap();
                    Point pt = me.getPoint();
                    GeoPosition gp = map.convertPointToGeoPosition((Point2D)pt);
                    Waypoint newWPt = new Waypoint(gp.getLatitude(), Mapper.this.getSphericalLon(gp.getLongitude()));
                    if (Mapper.this.isGreenPtSelected) {
                        Mapper.this.drawMostAccuratePt(newWPt);
                        Mapper.this.mostAccurateResultPt.setPosition(newWPt.getPosition());
                    } else {
                        Mapper.this.moveEditUncertaintyHandleTo(newWPt);
                        GeoPosition centerPos = Mapper.this.mostAccurateResultPt.getPosition();
                        GeodeticPosition geodetics = Mapper.this.computeGeod(centerPos, newWPt.getPosition());
                        long tmpUncertaintyRadius = Math.round(geodetics.getDist());
                        UncertaintyCircleChangeEvent uncertaintyCREvt = new UncertaintyCircleChangeEvent(Mapper.this.getMainMap(), tmpUncertaintyRadius);
                        Mapper.this.fireUncertaintyCircleChangeEvent(uncertaintyCREvt);
                    }
                    Mapper.this.mouseDragged = true;
                    double lat = Mapper.this.decimalRound(gp.getLatitude(), 6);
                    double lon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp.getLongitude()), 6);
                    GeoPosition MapPMELocation = new GeoPosition(lat, lon);
                    MapPointerMoveEvent MapPME = new MapPointerMoveEvent(map, MapPMELocation);
                    Mapper.this.fireMapPointerMoveEvent(MapPME);
                }
            }
        });
        this.getMainMap().addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Point pt = me.getPoint();
                JXMapViewer map = Mapper.this.getMainMap();
                Mapper.this.isGreenPtSelected = Mapper.this.isEventOnGreenPt(pt);
                Mapper.this.isUHandleSelected = Mapper.this.isEventOnUHandle(pt);
                map.setPanEnabled(!Mapper.this.isGreenPtSelected && !Mapper.this.isUHandleSelected);
                if (Mapper.this.isUHandleSelected) {
                    GeoPosition mousePos = map.convertPointToGeoPosition((Point2D)pt);
                    Mapper.this.handleOffsetX = Mapper.this.getSphericalLon(Mapper.this.handlePos.getLongitude()) - Mapper.this.getSphericalLon(mousePos.getLongitude());
                    Mapper.this.handleOffsetY = Mapper.this.handlePos.getLatitude() - mousePos.getLatitude();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                Mapper.this.getMainMap().setPanEnabled(true);
                if (Mapper.this.isGreenPtSelected || Mapper.this.isUHandleSelected) {
                    Mapper.this.getMainMap().setCursor(Cursor.getPredefinedCursor(13));
                    if (Mapper.this.mouseDragged && Mapper.this.isGreenPtSelected) {
                        Point pt = me.getPoint();
                        JXMapViewer map = Mapper.this.getMainMap();
                        GeoPosition gp = map.convertPointToGeoPosition((Point2D)pt);
                        double lat = Mapper.this.decimalRound(gp.getLatitude(), 6);
                        double lon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp.getLongitude()), 6);
                        Mapper.this.clearEditUncertaintyHandle();
                        Mapper.this.uncertaintyRegion = Mapper.this.getUncertaintyRegion(Mapper.this.mostAccurateResultPt.getPosition(), Mapper.this.uncertaintyRadius);
                        Mapper.this.drawUncertaintyOverlay(Mapper.this.uncertaintyRegion);
                        GeoPosition MapPMELocation = new GeoPosition(lat, lon);
                        MapPointerMoveEvent MapPME = new MapPointerMoveEvent(map, MapPMELocation);
                        Mapper.this.fireMostAccuratePointReleaseEvent(MapPME);
                    } else if (Mapper.this.isUHandleSelected) {
                        Mapper.this.handlePos = Mapper.this.getMainMap().convertPointToGeoPosition((Point2D)me.getPoint());
                        Mapper.this.handlePos = new GeoPosition(Mapper.this.handlePos.getLatitude() + Mapper.this.handleOffsetY, Mapper.this.getSphericalLon(Mapper.this.handlePos.getLongitude() + Mapper.this.handleOffsetX));
                        Mapper.this.resizeUncertainty((LocalityWaypoint)((Object)Mapper.this.mostAccurateResultPt.clone()), Mapper.this.handlePos);
                    }
                    if (Mapper.this.isEditUncertaintyHandlePersisted) {
                        Mapper.this.drawEditUncertaintyHandle(Mapper.this.mostAccurateResultPt.getPosition(), Mapper.this.uncertaintyRadius, Mapper.this.handleAz);
                    }
                    Mapper.this.mouseDragged = false;
                    Mapper.this.isEditUncertaintyHandlePersisted = false;
                } else {
                    Mapper.this.adjustScaleLine();
                    if (Mapper.this.isEventOnRedPt(me.getPoint())) {
                        Mapper.this.getMainMap().setCursor(Cursor.getPredefinedCursor(1));
                    }
                }
                Mapper.this.isGreenPtSelected = false;
                Mapper.this.isUHandleSelected = false;
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                GeoPosition gp;
                Point pt = me.getPoint();
                JXMapViewer map = Mapper.this.getMainMap();
                boolean greenClicked = Mapper.this.isEventOnGreenPt(pt);
                boolean redClicked = false;
                if (greenClicked && !Mapper.this.drawErrorPolygon && !Mapper.this.measureDistance) {
                    Mapper.this.clearEditUncertaintyHandle();
                    Mapper.this.fireUncertaintyCircleResizeCancelEvent();
                } else {
                    redClicked = Mapper.this.isEventOnRedPt(pt);
                    if (redClicked && !Mapper.this.drawErrorPolygon && !Mapper.this.measureDistance) {
                        Mapper.this.mostAccurateResultPt = Mapper.this.getClickedWpt(pt);
                        Mapper.this.drawMostAccuratePt(Mapper.this.mostAccurateResultPt);
                        Mapper.this.getMainMap().setCursor(Cursor.getPredefinedCursor(13));
                        gp = Mapper.this.mostAccurateResultPt.getPosition();
                        double snapLat = Mapper.this.decimalRound(gp.getLatitude(), 6);
                        double snapLon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp.getLongitude()), 6);
                        GeoPosition MapPMELocation = new GeoPosition(snapLat, snapLon);
                        MapPointerMoveEvent MapPME = new MapPointerMoveEvent(map, MapPMELocation);
                        Mapper.this.fireMostAccuratePointSnapEvent(MapPME);
                        Mapper.this.clearEditUncertaintyHandle();
                        Mapper.this.clearUncertaintyOverlay();
                        String uncertaintyStr = Mapper.this.mostAccurateResultPt.getLocality().getUncertaintyMeters();
                        Mapper.this.uncertaintyRadius = uncertaintyStr.toLowerCase().equals("unavailable") ? 0L : Long.parseLong(uncertaintyStr);
                        Mapper.this.uncertaintyRegion = Mapper.this.getUncertaintyRegion(Mapper.this.mostAccurateResultPt.getPosition(), Mapper.this.uncertaintyRadius);
                        Mapper.this.drawUncertaintyOverlay(Mapper.this.uncertaintyRegion);
                        Mapper.this.clearPolygonOverlay();
                        if (!Mapper.this.mostAccurateResultPt.getLocality().getErrorPolygon().toLowerCase().equals("unavailable")) {
                            double lat = Double.NaN;
                            double lon = Double.NaN;
                            String[] latLons = Mapper.this.mostAccurateResultPt.getLocality().getErrorPolygon().split(",");
                            int i = 0;
                            while (i < latLons.length) {
                                if (i % 2 == 0) {
                                    lat = Double.parseDouble(latLons[i]);
                                } else {
                                    lon = Double.parseDouble(latLons[i]);
                                    GeoPosition pos = new GeoPosition(lat, lon);
                                    if (Mapper.this.errorRegion == null) {
                                        Mapper.this.errorRegion = new ArrayList();
                                    }
                                    Mapper.this.errorRegion.add(pos);
                                }
                                ++i;
                            }
                            Mapper.this.drawPolygonOverlay(Mapper.this.errorRegion);
                        }
                    } else if (Mapper.this.isEventOnUHandle(pt) && !Mapper.this.drawErrorPolygon && !Mapper.this.measureDistance) {
                        Mapper.this.clearEditUncertaintyHandle();
                        Mapper.this.fireUncertaintyCircleResizeCancelEvent();
                    }
                }
                if (Mapper.this.drawErrorPolygon) {
                    gp = map.convertPointToGeoPosition((Point2D)pt);
                    if (Mapper.this.errorRegion == null) {
                        Mapper.this.errorRegion = new ArrayList();
                    }
                    GeoPosition vertex = new GeoPosition(Mapper.this.decimalRound(gp.getLatitude(), 6), Mapper.this.decimalRound(gp.getLongitude(), 6));
                    if (!Mapper.this.errorRegion.contains(vertex)) {
                        Mapper.this.errorRegion.add(vertex);
                    }
                }
                if (Mapper.this.measureDistance) {
                    gp = map.convertPointToGeoPosition((Point2D)pt);
                    if (Mapper.this.rulerSegments == null) {
                        Mapper.this.rulerSegments = new ArrayList();
                    }
                    GeoPosition vertex = new GeoPosition(Mapper.this.decimalRound(gp.getLatitude(), 6), Mapper.this.decimalRound(gp.getLongitude(), 6));
                    if (!Mapper.this.rulerSegments.contains(vertex)) {
                        Mapper.this.rulerSegments.add(vertex);
                    }
                }
                if (me.getClickCount() == 2) {
                    if (Mapper.this.drawErrorPolygon || Mapper.this.measureDistance) {
                        if (Mapper.this.drawErrorPolygon) {
                            ArrayList<GeoPosition> tempERegion = new ArrayList<GeoPosition>();
                            String polyStr = "";
                            for (GeoPosition gp2 : Mapper.this.errorRegion) {
                                double lat = gp2.getLatitude();
                                double lon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp2.getLongitude()), 6);
                                polyStr = String.valueOf(polyStr) + lat + "," + lon + ",";
                                tempERegion.add(new GeoPosition(lat, lon));
                            }
                            polyStr = polyStr.substring(0, polyStr.length() - 1);
                            Mapper.this.errorRegion = null;
                            Mapper.this.clearPolygonOverlay();
                            Mapper.this.clearPolyCursor();
                            Mapper.this.drawErrorPolygon = false;
                            Mapper.this.errorRegion = tempERegion;
                            Mapper.this.mostAccurateResultPt.getLocality().setErrorPolygon(polyStr);
                            Mapper.this.drawPolygonOverlay(Mapper.this.errorRegion);
                            ErrorPolygonDrawEvent errorPolyDrawEvt = new ErrorPolygonDrawEvent(map, tempERegion);
                            Mapper.this.fireErrorPolygonDrawEvent(errorPolyDrawEvt);
                        }
                        if (Mapper.this.measureDistance) {
                            ArrayList<GeoPosition> tempRSegments = new ArrayList<GeoPosition>();
                            for (GeoPosition gp3 : Mapper.this.rulerSegments) {
                                double lat = gp3.getLatitude();
                                double lon = Mapper.this.decimalRound(Mapper.this.getSphericalLon(gp3.getLongitude()), 6);
                                tempRSegments.add(new GeoPosition(lat, lon));
                            }
                            Mapper.this.rulerSegments = null;
                            Mapper.this.clearRulerOverlay();
                            Mapper.this.clearRulerCursor();
                            Mapper.this.measureDistance = false;
                            Mapper.this.rulerSegments = tempRSegments;
                            Mapper.this.drawRulerOverlay(Mapper.this.rulerSegments);
                            Mapper.this.rulerSegments = null;
                            MeasureDistanceEvent MeasureDistEvt = new MeasureDistanceEvent(map, tempRSegments);
                            Mapper.this.fireMeasureDistanceEvent(MeasureDistEvt);
                        }
                    } else {
                        gp = map.convertPointToGeoPosition((Point2D)pt);
                        map.setCenterPosition(gp);
                        map.setZoom(map.getZoom() - 1);
                    }
                    return;
                }
                if (me.getButton() == 3) {
                    if (Mapper.this.drawErrorPolygon || Mapper.this.measureDistance) {
                        if (Mapper.this.drawErrorPolygon) {
                            Mapper.this.drawErrorPolygon = false;
                            Mapper.this.errorRegion = null;
                            Mapper.this.clearPolygonOverlay();
                            Mapper.this.clearPolyCursor();
                            Mapper.this.fireErrorPolygonDrawCancelEvent();
                        }
                        if (Mapper.this.measureDistance) {
                            Mapper.this.measureDistance = false;
                            Mapper.this.rulerSegments = null;
                            Mapper.this.clearRulerOverlay();
                            Mapper.this.clearRulerCursor();
                            Mapper.this.fireMeasureDistanceCancelEvent();
                        }
                    } else {
                        gp = map.convertPointToGeoPosition((Point2D)pt);
                        map.setCenterPosition(gp);
                        map.setZoom(map.getZoom() + 1);
                    }
                }
            }
        });
    }

    public void snapMostAccuratePointTo(GeoPosition newPos) {
        double lat;
        this.clearUncertaintyOverlay();
        this.clearPolygonOverlay();
        this.setCenterPosition(newPos);
        Iterator<LocalityWaypoint> it = this.resultPoints.iterator();
        LocalityWaypoint lWp = null;
        while (it.hasNext()) {
            lWp = it.next();
            if (lWp.getPosition().equals((Object)newPos)) break;
            lWp = null;
        }
        if (lWp != null) {
            this.mostAccurateResultPt = (LocalityWaypoint)((Object)lWp.clone());
            this.clearPolygonOverlay();
            if (!this.mostAccurateResultPt.getLocality().getErrorPolygon().toLowerCase().equals("unavailable")) {
                lat = Double.NaN;
                double lon = Double.NaN;
                String[] latLons = this.mostAccurateResultPt.getLocality().getErrorPolygon().split(",");
                int i = 0;
                while (i < latLons.length) {
                    if (i % 2 == 0) {
                        lat = Double.parseDouble(latLons[i]);
                    } else {
                        lon = Double.parseDouble(latLons[i]);
                        GeoPosition pos = new GeoPosition(lat, lon);
                        if (this.errorRegion == null) {
                            this.errorRegion = new ArrayList<GeoPosition>();
                        }
                        this.errorRegion.add(pos);
                    }
                    ++i;
                }
                this.drawPolygonOverlay(this.errorRegion);
            }
        } else {
            this.mostAccurateResultPt.setPosition(newPos);
            this.mostAccurateResultPt.getLocality().setPrecision("");
            this.mostAccurateResultPt.getLocality().setScore(-1);
            this.mostAccurateResultPt.getLocality().setMultipleResults("");
            if (!this.mostAccurateResultPt.getLocality().getErrorPolygon().toLowerCase().equals("unavailable")) {
                lat = Double.NaN;
                double lon = Double.NaN;
                String[] latLons = this.mostAccurateResultPt.getLocality().getErrorPolygon().split(",");
                int i = 0;
                while (i < latLons.length) {
                    if (i % 2 == 0) {
                        lat = Double.parseDouble(latLons[i]);
                    } else {
                        lon = Double.parseDouble(latLons[i]);
                        GeoPosition pos = new GeoPosition(lat, lon);
                        if (this.errorRegion == null) {
                            this.errorRegion = new ArrayList<GeoPosition>();
                        }
                        this.errorRegion.add(pos);
                    }
                    ++i;
                }
                this.drawPolygonOverlay(this.errorRegion);
            }
        }
        this.drawMostAccuratePt(new Waypoint(this.mostAccurateResultPt.getPosition()));
        String uncertaintyStr = this.mostAccurateResultPt.getLocality().getUncertaintyMeters();
        this.uncertaintyRadius = uncertaintyStr.toLowerCase().equals("unavailable") ? 0L : Long.parseLong(uncertaintyStr);
        this.uncertaintyRegion = this.getUncertaintyRegion(this.mostAccurateResultPt.getPosition(), this.uncertaintyRadius);
        this.drawUncertaintyOverlay(this.uncertaintyRegion);
    }

    public void plotResultSet(LocalityWaypoint[] resultPoints, int mostAccurateIndex) {
        this.clearMostAccuratePt();
        this.clearPoints();
        ArrayList<Waypoint> resultWps = new ArrayList<Waypoint>();
        int index = mostAccurateIndex < resultPoints.length ? mostAccurateIndex : 0;
        this.mostAccurateResultPt = resultPoints[index];
        int i = 0;
        while (i < resultPoints.length) {
            LocalityWaypoint point = resultPoints[i];
            this.resultPoints.add(point);
            GeoPosition gp = point.getPosition();
            resultWps.add(new Waypoint(gp));
            ++i;
        }
        Waypoint mAWp = new Waypoint(this.mostAccurateResultPt.getPosition());
        this.setCenterPosition(mAWp.getPosition());
        this.setZoom(9);
        this.drawPoints(resultWps);
        this.drawMostAccuratePt(mAWp);
        this.clearUncertaintyOverlay();
        String uncertaintyStr = this.mostAccurateResultPt.getLocality().getUncertaintyMeters();
        this.uncertaintyRadius = uncertaintyStr.toLowerCase().equals("unavailable") ? 0L : Long.parseLong(uncertaintyStr);
        this.uncertaintyRegion = this.getUncertaintyRegion(this.mostAccurateResultPt.getPosition(), this.uncertaintyRadius);
        this.drawUncertaintyOverlay(this.uncertaintyRegion);
        this.clearPolygonOverlay();
        if (!this.mostAccurateResultPt.getLocality().getErrorPolygon().toLowerCase().equals("unavailable")) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            String[] latLons = this.mostAccurateResultPt.getLocality().getErrorPolygon().split(",");
            int i2 = 0;
            while (i2 < latLons.length) {
                if (i2 % 2 == 0) {
                    lat = Double.parseDouble(latLons[i2]);
                } else {
                    lon = Double.parseDouble(latLons[i2]);
                    GeoPosition pos = new GeoPosition(lat, lon);
                    if (this.errorRegion == null) {
                        this.errorRegion = new ArrayList<GeoPosition>();
                    }
                    this.errorRegion.add(pos);
                }
                ++i2;
            }
            this.drawPolygonOverlay(this.errorRegion);
        }
    }

    public void removePolygon() {
        this.clearPolyCursor();
        this.clearPolygonOverlay();
    }

    public void removeRuler() {
        this.clearRulerCursor();
        this.clearRulerOverlay();
    }

    public void drawPolygon(List<GeoPosition> vertices) {
        this.clearPolygonOverlay();
        this.errorRegion = new ArrayList<GeoPosition>();
        this.errorRegion.addAll(vertices);
        String polyStr = "";
        for (GeoPosition vertex : vertices) {
            polyStr = String.valueOf(polyStr) + vertex.getLatitude() + "," + vertex.getLongitude() + ",";
        }
        if (polyStr.length() > 0) {
            polyStr = polyStr.substring(0, polyStr.length() - 1);
            this.mostAccurateResultPt.getLocality().setErrorPolygon(polyStr);
            this.drawPolygonOverlay(this.errorRegion);
        } else {
            this.mostAccurateResultPt.getLocality().setErrorPolygon("Unavailable");
        }
    }

    public void setMapSize(Dimension mapDimensions) {
        this.setPreferredSize(mapDimensions);
        this.setMinimumSize(mapDimensions);
        this.setMaximumSize(mapDimensions);
    }

    public void addMapPointerMoveListener(MapPointerMoveListener listener) {
        this.mapPointerMoveListeners.add(MapPointerMoveListener.class, listener);
    }

    public void removeMapPointerMoveListener(MapPointerMoveListener listener) {
        this.mapPointerMoveListeners.remove(MapPointerMoveListener.class, listener);
    }

    public void addMostAccuratePointReleaseListener(MostAccuratePointReleaseListener listener) {
        this.mostAccuratePointReleaseListeners.add(MostAccuratePointReleaseListener.class, listener);
    }

    public void removeMostAccuratePointReleaseListener(MostAccuratePointReleaseListener listener) {
        this.mostAccuratePointReleaseListeners.remove(MostAccuratePointReleaseListener.class, listener);
    }

    public void addMostAccuratePointSnapListener(MostAccuratePointSnapListener listener) {
        this.mostAccuratePointSnapListeners.add(MostAccuratePointSnapListener.class, listener);
    }

    public void removeMostAccuratePointSnapListener(MostAccuratePointSnapListener listener) {
        this.mostAccuratePointSnapListeners.remove(MostAccuratePointSnapListener.class, listener);
    }

    public void addErrorPolygonDrawListener(ErrorPolygonDrawListener listener) {
        this.errorPolygonDrawListeners.add(ErrorPolygonDrawListener.class, listener);
    }

    public void removeErrorPolygonDrawListener(ErrorPolygonDrawListener listener) {
        this.errorPolygonDrawListeners.remove(ErrorPolygonDrawListener.class, listener);
    }

    public void addErrorPolygonDrawCancelListener(ErrorPolygonDrawCancelListener listener) {
        this.errorPolygonDrawCancelListeners.add(ErrorPolygonDrawCancelListener.class, listener);
    }

    public void removeErrorPolygonDrawCancelListener(ErrorPolygonDrawCancelListener listener) {
        this.errorPolygonDrawCancelListeners.remove(ErrorPolygonDrawCancelListener.class, listener);
    }

    public void addMeasureDistanceListener(MeasureDistanceListener listener) {
        this.measureDistanceListeners.add(MeasureDistanceListener.class, listener);
    }

    public void removeMeasureDistanceListener(MeasureDistanceListener listener) {
        this.measureDistanceListeners.remove(MeasureDistanceListener.class, listener);
    }

    public void addMeasureDistanceCancelListener(MeasureDistanceCancelListener listener) {
        this.measureDistanceCancelListeners.add(MeasureDistanceCancelListener.class, listener);
    }

    public void removeMeasureDistanceCancelListener(MeasureDistanceCancelListener listener) {
        this.measureDistanceCancelListeners.remove(MeasureDistanceCancelListener.class, listener);
    }

    public void addUncertaintyCircleResizeListener(UncertaintyCircleResizeListener listener) {
        this.uncertaintyCircleResizeListeners.add(UncertaintyCircleResizeListener.class, listener);
    }

    public void removeUncertaintyCircleResizeListener(UncertaintyCircleResizeListener listener) {
        this.uncertaintyCircleResizeListeners.remove(UncertaintyCircleResizeListener.class, listener);
    }

    public void addUncertaintyCircleResizeCancelListener(UncertaintyCircleResizeCancelListener listener) {
        this.uncertaintyCircleResizeCancelListeners.add(UncertaintyCircleResizeCancelListener.class, listener);
    }

    public void removeUncertaintyCircleResizeCancelListener(UncertaintyCircleResizeCancelListener listener) {
        this.uncertaintyCircleResizeCancelListeners.remove(UncertaintyCircleResizeCancelListener.class, listener);
    }

    public void addUncertaintyCircleChangeListener(UncertaintyCircleChangeListener listener) {
        this.uncertaintyCircleChangeListeners.add(UncertaintyCircleChangeListener.class, listener);
    }

    public void removeUncertaintyCircleChangeListener(UncertaintyCircleChangeListener listener) {
        this.uncertaintyCircleChangeListeners.remove(UncertaintyCircleChangeListener.class, listener);
    }

    private void fireMapPointerMoveEvent(MapPointerMoveEvent evt) {
        Object[] listeners = this.mapPointerMoveListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == MapPointerMoveListener.class) {
                ((MapPointerMoveListener)listeners[i + 1]).mapPointerMoved(evt);
            }
            ++i;
        }
    }

    private void fireMostAccuratePointReleaseEvent(MapPointerMoveEvent evt) {
        Object[] listeners = this.mostAccuratePointReleaseListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == MostAccuratePointReleaseListener.class) {
                ((MostAccuratePointReleaseListener)listeners[i + 1]).mostAccuratePointReleased(evt);
            }
            ++i;
        }
    }

    private void fireMostAccuratePointSnapEvent(MapPointerMoveEvent evt) {
        Object[] listeners = this.mostAccuratePointSnapListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == MostAccuratePointSnapListener.class) {
                ((MostAccuratePointSnapListener)listeners[i + 1]).mostAccuratePointSnapped(evt);
            }
            ++i;
        }
    }

    private void fireErrorPolygonDrawEvent(ErrorPolygonDrawEvent evt) {
        Object[] listeners = this.errorPolygonDrawListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == ErrorPolygonDrawListener.class) {
                ((ErrorPolygonDrawListener)listeners[i + 1]).errorPolygonDrawn(evt);
            }
            ++i;
        }
    }

    private void fireErrorPolygonDrawCancelEvent() {
        Object[] listeners = this.errorPolygonDrawCancelListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == ErrorPolygonDrawCancelListener.class) {
                ((ErrorPolygonDrawCancelListener)listeners[i + 1]).errorPolygonDrawCancelled();
            }
            ++i;
        }
    }

    private void fireMeasureDistanceEvent(MeasureDistanceEvent evt) {
        Object[] listeners = this.measureDistanceListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == MeasureDistanceListener.class) {
                ((MeasureDistanceListener)listeners[i + 1]).distanceMeasured(evt);
            }
            ++i;
        }
    }

    private void fireMeasureDistanceCancelEvent() {
        Object[] listeners = this.measureDistanceCancelListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == MeasureDistanceCancelListener.class) {
                ((MeasureDistanceCancelListener)listeners[i + 1]).measureDistanceCancelled();
            }
            ++i;
        }
    }

    private void fireUncertaintyCircleResizeEvent(UncertaintyCircleResizeEvent evt) {
        Object[] listeners = this.uncertaintyCircleResizeListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == UncertaintyCircleResizeListener.class) {
                ((UncertaintyCircleResizeListener)listeners[i + 1]).uncertaintyCircleResized(evt);
            }
            ++i;
        }
    }

    private void fireUncertaintyCircleResizeCancelEvent() {
        Object[] listeners = this.uncertaintyCircleResizeCancelListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == UncertaintyCircleResizeCancelListener.class) {
                ((UncertaintyCircleResizeCancelListener)listeners[i + 1]).uncertaintyCircleResizeCancelled();
            }
            ++i;
        }
    }

    private void fireUncertaintyCircleChangeEvent(UncertaintyCircleChangeEvent evt) {
        Object[] listeners = this.uncertaintyCircleChangeListeners.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == UncertaintyCircleChangeListener.class) {
                ((UncertaintyCircleChangeListener)listeners[i + 1]).uncertaintyCircleChanged(evt);
            }
            ++i;
        }
    }

    public Set<LocalityWaypoint> getResultPoints() {
        return this.resultPoints;
    }

    public LocalityWaypoint getMostAccurateResultPt() {
        return this.mostAccurateResultPt;
    }

    private boolean frameChanged() {
        boolean frameChanged = false;
        JXMapViewer map = this.getMainMap();
        Rectangle bounds = map.getViewportBounds();
        Point topLeft = bounds.getLocation();
        Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
        int fullMapWidth = (int)rightMostPt.getX();
        double x = ((Point2D)topLeft).getX();
        int frameCount = (int)Math.floor(x / (double)fullMapWidth);
        if (frameCount != this.previousFrameCount) {
            frameChanged = true;
            this.shiftRegion = frameCount < this.previousFrameCount;
            this.previousFrameCount = frameCount;
        } else {
            frameChanged = false;
        }
        return frameChanged;
    }

    private Painter<JXMapViewer> getRulerPainter(final List<GeoPosition> segments) {
        Painter<JXMapViewer> segmentOverlay = new Painter<JXMapViewer>(){

            public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
                double maxLon = Double.NaN;
                double minLon = Double.NaN;
                double maxLat = Double.NaN;
                double minLat = Double.NaN;
                for (GeoPosition gp : segments) {
                    if (Double.isNaN(minLat)) {
                        minLat = gp.getLatitude();
                        maxLat = gp.getLatitude();
                        minLon = gp.getLongitude();
                        maxLon = gp.getLongitude();
                        continue;
                    }
                    if (gp.getLatitude() < minLat) {
                        minLat = gp.getLatitude();
                    }
                    if (gp.getLatitude() > maxLat) {
                        maxLat = gp.getLatitude();
                    }
                    if (gp.getLongitude() < minLon) {
                        minLon = gp.getLongitude();
                    }
                    if (!(gp.getLongitude() > maxLon)) continue;
                    maxLon = gp.getLongitude();
                }
                Rectangle bounds = map.getViewportBounds();
                int xOffset = 0;
                Point2D topleft = map.getTileFactory().geoToPixel(new GeoPosition(minLat, minLon), map.getZoom());
                Point2D botright = map.getTileFactory().geoToPixel(new GeoPosition(maxLat, maxLon), map.getZoom());
                if (!bounds.contains(topleft) && !bounds.contains(botright) || Mapper.this.shiftRegion) {
                    Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                    double fullMapWidth = rightMostPt.getX();
                    Iterator it = segments.iterator();
                    if (it.hasNext()) {
                        xOffset = (int)(fullMapWidth * (double)Mapper.this.previousFrameCount);
                        double minBoundX = bounds.getX() - Math.floor(bounds.getX() / fullMapWidth) * fullMapWidth;
                        double maxBoundX = minBoundX + bounds.getWidth();
                        if (minBoundX < botright.getX() && botright.getX() < maxBoundX) {
                            xOffset = (int)(Math.floor(bounds.getX() / fullMapWidth) * fullMapWidth);
                        }
                        if (Mapper.this.shiftRegion) {
                            Mapper.this.shiftRegion = false;
                        }
                    }
                }
                g = (Graphics2D)g.create();
                Rectangle rect = map.getViewportBounds();
                g.translate(-rect.x + xOffset, -rect.y);
                int[] xPoints = new int[segments.size()];
                int[] yPoints = new int[segments.size()];
                double dist = 0.0;
                GeoPosition prevVertex = null;
                GeoPosition currentVertex = null;
                int count = 0;
                for (GeoPosition gp : segments) {
                    Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
                    xPoints[count] = (int)pt.getX();
                    yPoints[count] = (int)pt.getY();
                    ++count;
                    if (prevVertex == null) {
                        prevVertex = gp;
                        currentVertex = gp;
                        continue;
                    }
                    currentVertex = gp;
                    GeodeticPosition geodP = Mapper.this.computeGeod(prevVertex, currentVertex);
                    dist += geodP.getDist();
                    prevVertex = currentVertex;
                }
                double impDist = Mapper.this.metricToMiles(dist, true);
                boolean isKm = false;
                boolean isMi = true;
                if (dist > 1000.0) {
                    dist /= 1000.0;
                    isKm = true;
                }
                if (impDist < 1.0) {
                    impDist = Mapper.this.milesToFeet(impDist);
                    isMi = false;
                }
                dist = Mapper.this.decimalRound(dist, 2);
                impDist = Mapper.this.decimalRound(impDist, 2);
                String distanceCaption = String.valueOf(dist) + " " + (isKm ? "km" : "m") + " (" + impDist + " " + (isMi ? "mi" : "ft") + ")";
                g.setColor(Color.RED);
                float[] dash = new float[]{8.0f, 3.0f};
                g.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f));
                g.drawPolyline(xPoints, yPoints, segments.size());
                g.setColor(Color.BLUE);
                g.setFont(new Font("Arial", 1, 11));
                Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(distanceCaption, g);
                int strOffsetX = (int)labelBounds.getWidth() / 2;
                g.drawString(distanceCaption, xPoints[segments.size() - 1] - -3 - strOffsetX, yPoints[segments.size() - 1] + -3 - 1);
            }
        };
        return segmentOverlay;
    }

    private Painter<JXMapViewer> getPolygonPainter(final List<GeoPosition> region, final boolean isUncertaintyCircle) {
        Painter<JXMapViewer> polygonOverlay = new Painter<JXMapViewer>(){

            public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
                double maxLon = Double.NaN;
                double minLon = Double.NaN;
                double maxLat = Double.NaN;
                double minLat = Double.NaN;
                for (GeoPosition gp : region) {
                    if (Double.isNaN(minLat)) {
                        minLat = gp.getLatitude();
                        maxLat = gp.getLatitude();
                        minLon = gp.getLongitude();
                        maxLon = gp.getLongitude();
                        continue;
                    }
                    if (gp.getLatitude() < minLat) {
                        minLat = gp.getLatitude();
                    }
                    if (gp.getLatitude() > maxLat) {
                        maxLat = gp.getLatitude();
                    }
                    if (gp.getLongitude() < minLon) {
                        minLon = gp.getLongitude();
                    }
                    if (!(gp.getLongitude() > maxLon)) continue;
                    maxLon = gp.getLongitude();
                }
                Rectangle bounds = map.getViewportBounds();
                int xOffset = 0;
                Point2D topleft = map.getTileFactory().geoToPixel(new GeoPosition(minLat, minLon), map.getZoom());
                Point2D botright = map.getTileFactory().geoToPixel(new GeoPosition(maxLat, maxLon), map.getZoom());
                if (!bounds.contains(topleft) && !bounds.contains(botright) || Mapper.this.shiftRegion) {
                    Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                    double fullMapWidth = rightMostPt.getX();
                    Iterator it = region.iterator();
                    if (it.hasNext()) {
                        xOffset = (int)(fullMapWidth * (double)Mapper.this.previousFrameCount);
                        double minBoundX = bounds.getX() - Math.floor(bounds.getX() / fullMapWidth) * fullMapWidth;
                        double maxBoundX = minBoundX + bounds.getWidth();
                        if (minBoundX < botright.getX() && botright.getX() < maxBoundX) {
                            xOffset = (int)(Math.floor(bounds.getX() / fullMapWidth) * fullMapWidth);
                        }
                        if (Mapper.this.shiftRegion) {
                            Mapper.this.shiftRegion = false;
                        }
                    }
                }
                g = (Graphics2D)g.create();
                Rectangle rect = map.getViewportBounds();
                g.translate(-rect.x + xOffset, -rect.y);
                Polygon poly = new Polygon();
                for (GeoPosition gp : region) {
                    Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
                    poly.addPoint((int)pt.getX(), (int)pt.getY());
                }
                if (isUncertaintyCircle) {
                    g.setColor(new Color(119, 119, 119, 100));
                    g.fill(poly);
                    g.setColor(Color.BLACK);
                    g.draw(poly);
                } else {
                    g.setColor(new Color(255, 0, 0, 100));
                    g.fill(poly);
                    g.setColor(Color.RED);
                    g.draw(poly);
                }
                g.dispose();
            }
        };
        return polygonOverlay;
    }

    public void editUncertaintyCircle(long uncertaintyRadiusInMeters) {
        this.uncertaintyRadius = uncertaintyRadiusInMeters;
        this.clearUncertaintyOverlay();
        this.mostAccurateResultPt.getLocality().setUncertaintyMeters(Long.toString(this.uncertaintyRadius));
        this.uncertaintyRegion = this.getUncertaintyRegion(this.mostAccurateResultPt.getPosition(), this.uncertaintyRadius);
        this.drawUncertaintyOverlay(this.uncertaintyRegion);
    }

    public void showEditPolygonHandle() {
        this.drawErrorPolygon = true;
        if (this.measureDistance) {
            this.clearRulerCursor();
            this.clearRulerOverlay();
            this.measureDistance = false;
        }
    }

    public void hideEditPolygonHandle() {
        this.clearPolyCursor();
        this.drawErrorPolygon = false;
    }

    public void showMeasureDistanceHandle() {
        this.measureDistance = true;
    }

    public void hideMeasureDistanceHandle() {
        this.clearRulerCursor();
        this.measureDistance = false;
    }

    public void hideEditUncertaintyHandle() {
        this.clearEditUncertaintyHandle();
        this.getMainMap().setCursor(new Cursor(0));
    }

    public void showEditUncertaintyHandle() {
        this.clearEditUncertaintyHandle();
        this.uncertaintyRadius = Long.parseLong(this.mostAccurateResultPt.getLocality().getUncertaintyMeters());
        this.drawEditUncertaintyHandle(this.mostAccurateResultPt.getPosition(), this.uncertaintyRadius, -45.0);
    }

    public void persistEditUncertaintyHandle() {
        this.clearEditUncertaintyHandle();
        this.uncertaintyRadius = Long.parseLong(this.mostAccurateResultPt.getLocality().getUncertaintyMeters());
        if (this.handlePos != null) {
            this.isEditUncertaintyHandlePersisted = true;
        }
    }

    private void resizeUncertainty(LocalityWaypoint centerWaypt, GeoPosition radialPos) {
        GeoPosition centerPos = centerWaypt.getPosition();
        GeodeticPosition geodetics = this.computeGeod(centerPos, radialPos);
        this.uncertaintyRadius = Math.round(geodetics.getDist());
        this.handleAz = -1.0 * geodetics.getFBearing();
        this.mostAccurateResultPt.getLocality().setUncertaintyMeters(Long.toString(this.uncertaintyRadius));
        this.uncertaintyRegion = this.getUncertaintyRegion(centerPos, this.uncertaintyRadius);
        this.drawUncertaintyOverlay(this.uncertaintyRegion);
        UncertaintyCircleResizeEvent uncertaintyCREvt = new UncertaintyCircleResizeEvent(this.getMainMap(), centerWaypt);
        this.fireUncertaintyCircleResizeEvent(uncertaintyCREvt);
    }

    private List<GeoPosition> getUncertaintyRegion(GeoPosition centerPos, long radiusInMeters) {
        ArrayList<GeoPosition> region = new ArrayList<GeoPosition>();
        int numVertices = 360;
        int bearingIncrement = 1;
        int i = 1;
        while (i <= numVertices) {
            GeoPosition gp = this.computeGeog(centerPos, radiusInMeters, i * bearingIncrement);
            region.add(gp);
            ++i;
        }
        return region;
    }

    private void setOverlayPainters() {
        CompoundPainter cpaint;
        JXMapViewer map = this.getMainMap();
        if (this.greenPainter != null) {
            map.setOverlayPainter(this.greenPainter);
        }
        if (this.redPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.redPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.redPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.uncertaintyHandlePainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.uncertaintyHandlePainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.uncertaintyHandlePainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.uPolygonOverlayPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.uPolygonOverlayPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.uPolygonOverlayPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.polyCursorPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.polyCursorPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.polyCursorPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.polygonOverlayPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.polygonOverlayPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.polygonOverlayPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.rulerCursorPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.rulerCursorPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.rulerCursorPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
        if (this.rulerOverlayPainter != null) {
            if (map.getOverlayPainter() == null) {
                map.setOverlayPainter(this.rulerOverlayPainter);
            } else {
                cpaint = new CompoundPainter();
                cpaint.setPainters(new Painter[]{this.rulerOverlayPainter, map.getOverlayPainter()});
                cpaint.setCacheable(false);
                map.setOverlayPainter((Painter)cpaint);
            }
        }
    }

    private void clearUncertaintyOverlay() {
        this.uncertaintyRegion = null;
        this.uPolygonOverlayPainter = null;
        this.setOverlayPainters();
    }

    private void drawUncertaintyOverlay(List<GeoPosition> region) {
        this.uPolygonOverlayPainter = this.getPolygonPainter(region, true);
        this.setOverlayPainters();
    }

    private void clearPolygonOverlay() {
        this.errorRegion = null;
        this.polygonOverlayPainter = null;
        this.setOverlayPainters();
    }

    private void drawPolygonOverlay(List<GeoPosition> region) {
        this.polygonOverlayPainter = this.getPolygonPainter(region, false);
        this.setOverlayPainters();
    }

    private void clearRulerOverlay() {
        this.rulerSegments = null;
        this.rulerOverlayPainter = null;
        this.setOverlayPainters();
    }

    private void drawRulerOverlay(List<GeoPosition> segments) {
        this.rulerOverlayPainter = this.getRulerPainter(segments);
        this.setOverlayPainters();
    }

    private void clearPolyCursor() {
        this.polyCursorPainter = null;
        this.setOverlayPainters();
    }

    private void drawPolyCursor(Waypoint polyWPt) {
        this.polyCursorPainter = new WaypointPainter();
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        waypoints.add(polyWPt);
        this.polyCursorPainter.setWaypoints(waypoints);
        this.polyCursorPainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(Color.BLUE);
                g.drawOval(-6, -6, 12, 12);
                g.drawOval(-5, -5, 10, 10);
                g.fillOval(-1, -1, 3, 3);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    private void clearRulerCursor() {
        this.rulerCursorPainter = null;
        this.setOverlayPainters();
    }

    private void drawRulerCursor(Waypoint rulerWPt) {
        this.rulerCursorPainter = new WaypointPainter();
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        waypoints.add(rulerWPt);
        this.rulerCursorPainter.setWaypoints(waypoints);
        this.rulerCursorPainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(Color.BLUE);
                g.fillRect(-3, -3, 6, 6);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    private void clearEditUncertaintyHandle() {
        this.uncertaintyHandlePainter = null;
        this.setOverlayPainters();
    }

    private void drawEditUncertaintyHandle(GeoPosition centerPos, long radiusInMeters, double markerBearing) {
        this.handlePos = this.computeGeog(centerPos, radiusInMeters, markerBearing);
        this.uncertaintyHandlePainter = new WaypointPainter();
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        waypoints.add(new Waypoint(this.handlePos));
        this.uncertaintyHandlePainter.setWaypoints(waypoints);
        this.uncertaintyHandlePainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(Color.BLUE);
                g.rotate(-0.7853981633974483);
                g.setStroke(new BasicStroke(3.0f));
                g.drawPolygon(Mapper.this.xArray, Mapper.this.yArray, 4);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    private void moveEditUncertaintyHandleTo(Waypoint wPt) {
        this.uncertaintyHandlePainter = new WaypointPainter();
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        wPt.setPosition(new GeoPosition(wPt.getPosition().getLatitude() + this.handleOffsetY, wPt.getPosition().getLongitude() + this.handleOffsetX));
        waypoints.add(wPt);
        this.uncertaintyHandlePainter.setWaypoints(waypoints);
        this.uncertaintyHandlePainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(Color.BLUE);
                g.rotate(-0.7853981633974483);
                g.setStroke(new BasicStroke(3.0f));
                g.drawPolygon(Mapper.this.xArray, Mapper.this.yArray, 4);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    public void clearMostAccuratePt() {
        this.mostAccurateResultPt = null;
        this.greenPainter = null;
        this.setOverlayPainters();
    }

    public void drawMostAccuratePt(Waypoint wayPt) {
        this.greenPainter = new WaypointPainter();
        HashSet<Waypoint> waypoints = new HashSet<Waypoint>();
        waypoints.add(wayPt);
        this.greenPainter.setWaypoints(waypoints);
        this.greenPainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(new Color(50, 50, 50));
                g.fillOval(-6, -6, 12, 12);
                g.setColor(new Color(10, 200, 20));
                g.fillOval(-5, -5, 10, 10);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    public void clearPoints() {
        this.resultPoints = new HashSet<LocalityWaypoint>();
        this.redPainter = null;
        this.setOverlayPainters();
    }

    public void drawPoints(final List<Waypoint> waypoints) {
        this.redPainter = new WaypointPainter();
        HashSet<Waypoint> waypointSet = new HashSet<Waypoint>(waypoints);
        this.redPainter.setWaypoints(waypointSet);
        this.redPainter.setRenderer(new WaypointRenderer(){

            public boolean paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
                g.setColor(new Color(50, 50, 50));
                g.fillOval(-6, -6, 12, 12);
                g.setColor(new Color(200, 10, 20));
                g.fillOval(-5, -5, 10, 10);
                int index = waypoints.indexOf(wp) + 1;
                g.setPaint(new Color(0, 0, 255, 180));
                Polygon pin = new Polygon();
                pin.addPoint(-18, -15);
                pin.addPoint(-4, -4);
                pin.addPoint(-15, -18);
                g.fill(pin);
                Rectangle2D labelBounds = g.getFontMetrics().getStringBounds(String.valueOf(index), g);
                int lenOffset = String.valueOf(index).length();
                lenOffset = lenOffset - 1 < 2 ? 1 : lenOffset;
                int strOffsetX = (int)labelBounds.getWidth() / 2 - lenOffset;
                int strOffsetY = (int)labelBounds.getHeight() / 2 - lenOffset;
                int diam = (int)Math.max(labelBounds.getHeight(), labelBounds.getWidth());
                g.fillOval(-6 - diam - 7, -6 - diam - 7, diam + 2, diam + 2);
                g.setPaint(Color.BLACK);
                g.drawString(String.valueOf(index), -6 - strOffsetX - diam, -6 - strOffsetY - diam + 11);
                g.drawString(String.valueOf(index), -6 - strOffsetX - diam, -6 - strOffsetY - diam + 11);
                g.setPaint(Color.WHITE);
                g.drawString(String.valueOf(index), -6 - strOffsetX - diam, -6 - strOffsetY - diam + 12);
                return true;
            }
        });
        this.setOverlayPainters();
    }

    public double getSphericalLon(double linearLon) {
        double t = Double.NaN;
        double radLon = Double.NaN;
        double cosT = Double.NaN;
        double normLon = Double.NaN;
        double cosSign = Double.NaN;
        double sinSign = Double.NaN;
        double sphericalLon = linearLon;
        if (linearLon < -180.0 || linearLon > 180.0) {
            if (linearLon < -180.0) {
                normLon = linearLon + (double)((int)(Math.ceil(Math.abs(linearLon) / 360.0) * 360.0));
            } else if (linearLon > 180.0) {
                normLon = linearLon - (double)((int)(Math.ceil(linearLon / 360.0) * 360.0));
            }
            if (normLon < 0.0) {
                normLon += 360.0;
            }
            radLon = linearLon * Math.PI / 180.0;
            cosSign = -1.0 * Math.signum(Math.cos(radLon));
            sinSign = Math.signum(Math.sin(radLon));
            cosT = cosSign * Math.sqrt(1.0 - Math.pow(Math.sin(radLon), 2.0));
            t = Math.acos(cosT);
            sphericalLon = sinSign * (180.0 - t * 180.0 / Math.PI);
        }
        return sphericalLon;
    }

    public double decimalRound(double input, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Double.toString(input));
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }

    private boolean isEventOnGreenPt(Point pt) {
        boolean isOnPt = false;
        if (this.greenPainter != null) {
            JXMapViewer map = this.getMainMap();
            for (Waypoint wp : this.greenPainter.getWaypoints()) {
                Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
                Rectangle bounds = map.getViewportBounds();
                Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                double fullMapWidth = rightMostPt.getX();
                int x = (int)(point.getX() - bounds.getX());
                int y = (int)(point.getY() - bounds.getY());
                Rectangle rect = new Rectangle((x = (int)((double)x - Math.floor((double)x / fullMapWidth) * fullMapWidth)) + -6, y + -6, 12, 12);
                if (!rect.contains(pt)) continue;
                isOnPt = true;
                break;
            }
        }
        return isOnPt;
    }

    private boolean isEventOnRedPt(Point pt) {
        boolean isOnPt = false;
        if (this.redPainter != null) {
            JXMapViewer map = this.getMainMap();
            for (Waypoint wp : this.redPainter.getWaypoints()) {
                Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
                Rectangle bounds = map.getViewportBounds();
                Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                double fullMapWidth = rightMostPt.getX();
                int x = (int)(point.getX() - bounds.getX());
                int y = (int)(point.getY() - bounds.getY());
                Rectangle rect = new Rectangle((x = (int)((double)x - Math.floor((double)x / fullMapWidth) * fullMapWidth)) + -6, y + -6, 12, 12);
                if (!rect.contains(pt)) continue;
                isOnPt = true;
                break;
            }
        }
        return isOnPt;
    }

    private boolean isEventOnUHandle(Point pt) {
        boolean isOnPt = false;
        if (this.uncertaintyHandlePainter != null) {
            JXMapViewer map = this.getMainMap();
            for (Waypoint wp : this.uncertaintyHandlePainter.getWaypoints()) {
                Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
                Rectangle bounds = map.getViewportBounds();
                Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                double fullMapWidth = rightMostPt.getX();
                int x = (int)(point.getX() - bounds.getX());
                int y = (int)(point.getY() - bounds.getY());
                x = (int)((double)x - Math.floor((double)x / fullMapWidth) * fullMapWidth);
                int[] xComps = new int[4];
                int[] yComps = new int[4];
                int i = 0;
                while (i < 4) {
                    int xComp = this.xArray[i];
                    int yComp = this.yArray[i];
                    xComps[i] = (int)((double)xComp * Math.cos(0.7853981633974483) + (double)yComp * Math.sin(0.7853981633974483));
                    yComps[i] = (int)((double)(-xComp) * Math.sin(0.7853981633974483) + (double)yComp * Math.cos(0.7853981633974483));
                    ++i;
                }
                Polygon poly = new Polygon(xComps, yComps, 4);
                poly.translate(x, y);
                if (!poly.contains(pt)) continue;
                isOnPt = true;
                break;
            }
        }
        return isOnPt;
    }

    private LocalityWaypoint getClickedWpt(Point pt) {
        LocalityWaypoint clickedWpt = null;
        if (this.redPainter != null) {
            JXMapViewer map = this.getMainMap();
            block0: for (Waypoint wp : this.redPainter.getWaypoints()) {
                Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
                Rectangle bounds = map.getViewportBounds();
                Point2D rightMostPt = map.getTileFactory().geoToPixel(new GeoPosition(0.0, 180.0), map.getZoom());
                double fullMapWidth = rightMostPt.getX();
                int x = (int)(point.getX() - bounds.getX());
                int y = (int)(point.getY() - bounds.getY());
                Rectangle rect = new Rectangle((x = (int)((double)x - Math.floor((double)x / fullMapWidth) * fullMapWidth)) + -6, y + -6, 12, 12);
                if (!rect.contains(pt)) continue;
                Iterator<LocalityWaypoint> it = this.resultPoints.iterator();
                LocalityWaypoint lWp = null;
                while (it.hasNext()) {
                    lWp = it.next();
                    if (!lWp.getPosition().equals((Object)wp.getPosition())) continue;
                    clickedWpt = (LocalityWaypoint)((Object)lWp.clone());
                    break block0;
                }
                break block0;
            }
        }
        return clickedWpt;
    }

    private GeoPosition computeGeog(GeoPosition startingPos, double distInMeters, double fAz) {
        double geoFact = Math.PI / 180;
        double iGeoFact = 57.29577951308232;
        int nmCvFact = 1852;
        Ellipsoid ellipse = new Ellipsoid("WGS84", 6378137 / nmCvFact, 298.257223563);
        double gLat = geoFact * startingPos.getLatitude();
        double gLon = geoFact * startingPos.getLongitude();
        double nmDist = distInMeters / (double)nmCvFact;
        double gFAz = geoFact * fAz;
        GeographicPosOutput out = this.getGPos(gLat, -gLon, gFAz, nmDist, ellipse);
        double newLat = out.getGLat() * iGeoFact;
        double newLon = -out.getGLon() * iGeoFact;
        GeoPosition gp = new GeoPosition(newLat, newLon);
        return gp;
    }

    private GeodeticPosition computeGeod(GeoPosition centerPos, GeoPosition radialPos) {
        double geoFact = Math.PI / 180;
        double iGeoFact = 57.29577951308232;
        double nmCvFact = 1852.0;
        Ellipsoid ellipse = new Ellipsoid("WGS84", 6378137.0 / nmCvFact, 298.257223563);
        double gCLat = geoFact * centerPos.getLatitude();
        double gRLat = geoFact * radialPos.getLatitude();
        double gCLon = geoFact * centerPos.getLongitude();
        double gRLon = geoFact * radialPos.getLongitude();
        GeodeticDistOutput out = this.getGDist(gCLat, gCLon, gRLat, gRLon, ellipse);
        double faz = out.getFaz() * iGeoFact;
        double baz = out.getBaz() * iGeoFact;
        double dist = out.getNmDist() * nmCvFact;
        GeodeticPosition geodetics = new GeodeticPosition(dist, faz, baz);
        return geodetics;
    }

    private GeographicPosOutput getGPosHav(double glat1, double glon1, double faz, double s) {
        int R = 6371000;
        double lat = Math.asin(Math.sin(glat1) * Math.cos(s / 6371000.0) + Math.cos(glat1) * Math.sin(s / 6371000.0) * Math.cos(faz));
        double lon = glon1 + Math.atan2(Math.sin(faz) * Math.sin(s / 6371000.0) * Math.cos(glat1), Math.cos(s / 6371000.0) - Math.sin(glat1) * Math.sin(lat));
        GeographicPosOutput out = new GeographicPosOutput(lat, lon, faz);
        return out;
    }

    private GeodeticDistOutput getGDist(double glat1, double glon1, double glat2, double glon2, Ellipsoid ellipse) {
        double c;
        double a = ellipse.getRadius();
        double f = 1.0 / ellipse.getFlattening();
        GeodeticDistOutput out = new GeodeticDistOutput(0.0, 0.0, Math.PI);
        double EPS = 5.0E-11;
        int iter = 1;
        int MAXITER = 100;
        if (glat1 + glat2 == 0.0 && Math.abs(glon1 - glon2) == Math.PI) {
            System.out.println("Course and distance between antipodal points is undefined");
            glat1 += 1.0E-5;
        }
        if (glat1 == glat2 && (glon1 == glon2 || Math.abs(Math.abs(glon1 - glon2) - Math.PI * 2) < EPS)) {
            System.out.println("Points 1 and 2 are identical - course undefined");
            return out;
        }
        double r = 1.0 - f;
        double tu1 = r * Math.tan(glat1);
        double tu2 = r * Math.tan(glat2);
        double cu1 = 1.0 / Math.sqrt(1.0 + tu1 * tu1);
        double su1 = cu1 * tu1;
        double cu2 = 1.0 / Math.sqrt(1.0 + tu2 * tu2);
        double s1 = cu1 * cu2;
        double b1 = s1 * tu2;
        double f1 = b1 * tu1;
        double x = glon2 - glon1;
        double d = x + 1.0;
        double y = Double.NaN;
        double cz = Double.NaN;
        double sy = Double.NaN;
        double cy = Double.NaN;
        double e = Double.NaN;
        double c2a = Double.NaN;
        double cx = Double.NaN;
        double sx = Double.NaN;
        while (Math.abs(d - x) > EPS && iter < MAXITER) {
            ++iter;
            sx = Math.sin(x);
            cx = Math.cos(x);
            tu1 = cu2 * sx;
            tu2 = b1 - su1 * cu2 * cx;
            sy = Math.sqrt(tu1 * tu1 + tu2 * tu2);
            cy = s1 * cx + f1;
            y = this.atan2(sy, cy);
            double sa = s1 * sx / sy;
            c2a = 1.0 - sa * sa;
            cz = f1 + f1;
            if (c2a > 0.0) {
                cz = cy - cz / c2a;
            }
            e = cz * cz * 2.0 - 1.0;
            c = ((-3.0 * c2a + 4.0) * f + 4.0) * c2a * f / 16.0;
            d = x;
            x = ((e * cy * c + cz) * sy * c + y) * sa;
            x = (1.0 - c) * x * f + glon2 - glon1;
        }
        double faz = this.modcrs(this.atan2(tu1, tu2));
        double baz = this.modcrs(this.atan2(cu1 * sx, b1 * cx - su1 * cu2) + Math.PI);
        x = Math.sqrt((1.0 / (r * r) - 1.0) * c2a + 1.0);
        x += 1.0;
        x = (x - 2.0) / x;
        c = 1.0 - x;
        c = (x * x / 4.0 + 1.0) / c;
        d = (0.375 * x * x - 1.0) * x;
        x = e * cy;
        double s = ((((sy * sy * 4.0 - 3.0) * (1.0 - e - e) * cz * d / 6.0 - x) * d / 4.0 + cz) * sy * d + y) * c * a * r;
        out = new GeodeticDistOutput(s, faz, baz);
        if ((double)Math.abs(iter - MAXITER) < EPS) {
            System.out.println("Algorithm did not converge");
        }
        return out;
    }

    private GeographicPosOutput getGPos(double glat1, double glon1, double faz, double s, Ellipsoid ellipse) {
        double EPS = 5.0E-11;
        if (Math.abs(Math.cos(glat1)) < EPS && !(Math.abs(Math.sin(faz)) < EPS)) {
            System.out.println("Only N-S courses are meaningful, starting at a pole!");
        }
        double a = ellipse.getRadius();
        double f = 1.0 / ellipse.getFlattening();
        double r = 1.0 - f;
        double tu = r * Math.tan(glat1);
        double sf = Math.sin(faz);
        double cf = Math.cos(faz);
        double b = cf == 0.0 ? 0.0 : 2.0 * this.atan2(tu, cf);
        double cu = 1.0 / Math.sqrt(1.0 + tu * tu);
        double su = tu * cu;
        double sa = cu * sf;
        double c2a = 1.0 - sa * sa;
        double x = 1.0 + Math.sqrt(1.0 + c2a * (1.0 / (r * r) - 1.0));
        x = (x - 2.0) / x;
        double c = 1.0 - x;
        c = (x * x / 4.0 + 1.0) / c;
        double d = (0.375 * x * x - 1.0) * x;
        double y = tu = s / (r * a * c);
        c = y + 1.0;
        double cz = Double.NaN;
        double e = Double.NaN;
        double sy = Double.NaN;
        double cy = Double.NaN;
        while (Math.abs(y - c) > EPS) {
            sy = Math.sin(y);
            cy = Math.cos(y);
            cz = Math.cos(b + y);
            e = 2.0 * cz * cz - 1.0;
            c = y;
            x = e * cy;
            y = e + e - 1.0;
            y = (((sy * sy * 4.0 - 3.0) * y * cz * d / 6.0 + x) * d / 4.0 - cz) * sy * d + tu;
        }
        b = cu * cy * cf - su * sy;
        c = r * Math.sqrt(sa * sa + b * b);
        d = su * cy + cu * sy * cf;
        double glat2 = this.modlat(this.atan2(d, c));
        c = cu * cy - su * sy * cf;
        x = this.atan2(sy * sf, c);
        c = ((-3.0 * c2a + 4.0) * f + 4.0) * c2a * f / 16.0;
        d = ((e * cy * c + cz) * sy * c + y) * sa;
        double glon2 = this.modlon(glon1 + x - (1.0 - c) * d * f);
        double baz = this.modcrs(this.atan2(sa, b) + Math.PI);
        GeographicPosOutput out = new GeographicPosOutput(glat2, glon2, baz);
        return out;
    }

    private double modcrs(double x) {
        return this.mod(x, Math.PI * 2);
    }

    private double mod(double x, double y) {
        return x - y * Math.floor(x / y);
    }

    private double modlat(double x) {
        return this.mod(x + 1.5707963267948966, Math.PI * 2) - 1.5707963267948966;
    }

    private double modlon(double x) {
        return this.mod(x + Math.PI, Math.PI * 2) - Math.PI;
    }

    private double atan2(double y, double x) {
        double out = Double.NaN;
        if (x < 0.0) {
            out = Math.atan(y / x) + Math.PI;
        }
        if (x > 0.0 && y >= 0.0) {
            out = Math.atan(y / x);
        }
        if (x > 0.0 && y < 0.0) {
            out = Math.atan(y / x) + Math.PI * 2;
        }
        if (x == 0.0 && y > 0.0) {
            out = 1.5707963267948966;
        }
        if (x == 0.0 && y < 0.0) {
            out = 4.71238898038469;
        }
        if (x == 0.0 && y == 0.0) {
            out = 0.0;
        }
        return out;
    }
}

