/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype;

import edu.ku.brc.services.geolocate.prototype.Locality;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Waypoint;

public class LocalityWaypoint
extends Waypoint {
    private Locality locality;
    private LocalityWaypoint correctedWaypoint;
    private boolean corrected;

    public LocalityWaypoint(Locality locality) {
        this.locality = locality;
        this.correctedWaypoint = null;
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public boolean isCorrected() {
        return this.corrected;
    }

    public void setCorrected(boolean corrected) {
        this.corrected = corrected;
    }

    public LocalityWaypoint getCorrectedWaypoint() {
        return this.correctedWaypoint;
    }

    public void setCorrectedWaypoint(LocalityWaypoint correctedWaypoint) {
        this.correctedWaypoint = correctedWaypoint;
    }

    public GeoPosition getPosition() {
        return new GeoPosition(this.locality.getLatitude(), this.locality.getLongitude());
    }

    public void setPosition(GeoPosition coordinate) {
        super.setPosition(coordinate);
        this.locality.setLatitude(coordinate.getLatitude());
        this.locality.setLongitude(coordinate.getLongitude());
    }

    public Object clone() {
        Locality clonedLocality = new Locality();
        clonedLocality.setCorrectionStatus(this.locality.getCorrectionStatus());
        clonedLocality.setCountry(this.locality.getCountry());
        clonedLocality.setState(this.locality.getState());
        clonedLocality.setCounty(this.locality.getCounty());
        clonedLocality.setLocality(this.locality.getLocality());
        clonedLocality.setErrorPolygon(this.locality.getErrorPolygon());
        clonedLocality.setLocalityId(this.locality.getLocalityId());
        clonedLocality.setLatitude(this.locality.getLatitude());
        clonedLocality.setLongitude(this.locality.getLongitude());
        clonedLocality.setMultipleResults(this.locality.getMultipleResults());
        clonedLocality.setPrecision(this.locality.getPrecision());
        clonedLocality.setUncertaintyMeters(this.locality.getUncertaintyMeters());
        boolean clonedCorrected = this.corrected;
        LocalityWaypoint clonedCorrectedWayPoint = null;
        if (this.correctedWaypoint != null) {
            clonedCorrectedWayPoint = (LocalityWaypoint)((Object)this.correctedWaypoint.clone());
        }
        LocalityWaypoint clone = new LocalityWaypoint(clonedLocality);
        clone.setCorrected(clonedCorrected);
        clone.setCorrectedWaypoint(clonedCorrectedWayPoint);
        return clone;
    }
}

