/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.prototype;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.validation.ValComboBox;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordProviderListenerIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordServiceProviderIFace;
import edu.ku.brc.services.geolocate.prototype.client.GeolocatesvcLocator;
import edu.ku.brc.services.geolocate.prototype.client.GeolocatesvcSoap;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result;
import edu.ku.brc.services.geolocate.prototype.client.Georef_Result_Set;
import edu.ku.brc.services.geolocate.prototype.ui.GeoLocateResultsChooser;
import edu.ku.brc.specify.config.DisciplineType;
import edu.ku.brc.specify.datamodel.Discipline;
import edu.ku.brc.specify.prefs.GEOLocatePrefsPanel;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ProgressDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.rpc.ServiceException;

public class GeoCoordGeoLocateProvider
implements GeoCoordServiceProviderIFace,
Runnable {
    protected GeoCoordProviderListenerIFace listener = null;
    protected String helpContext = null;
    private boolean stopWork = false;
    private List<GeoCoordDataIFace> items;
    private List<Pair<GeoCoordDataIFace, Georef_Result_Set>> glResults = new Vector<Pair<GeoCoordDataIFace, Georef_Result_Set>>();
    private ProgressDialog progressDialog;
    private static final String GL_HYWX = "GEOLocate.HYWX";
    private static final String GL_WTRBODY = "GEOLocate.WATERBODY";
    private static final String GL_RESTRICT = "GEOLocate.RESTRICTTOLOWESTADM";
    private static final String GL_DOUNCERT = "GEOLocate.DOUNCERT";
    private static final String GL_DOPOLY = "GEOLocate.DOPOLY";
    private static final String GL_DISPLACEPOLY = "GEOLocate.DISPLACEPOLY";
    private static final String GL_LANGKEY = "GEOLocate.LANGUAGEKEY";

    @Override
    public void processGeoRefData(List<GeoCoordDataIFace> items, GeoCoordProviderListenerIFace listener, String helpContext) {
        this.listener = listener;
        this.helpContext = helpContext;
        this.progressDialog = new ProgressDialog(UIRegistry.getResourceString("GeoCoordGeoLocateProvider.GEOLOC_PROGRESS"), false, true);
        this.progressDialog.getCloseBtn().setText(UIRegistry.getResourceString("GeoCoordGeoLocateProvider.CANCEL"));
        this.progressDialog.setModal(true);
        this.progressDialog.setProcess(0, items.size());
        this.progressDialog.setIconImage(IconManager.getImage("AppIcon").getImage());
        this.items = items;
        final Thread georeference = new Thread(this);
        georeference.start();
        this.progressDialog.getCloseBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                georeference.interrupt();
                GeoCoordGeoLocateProvider.this.stopWork = true;
            }
        });
        UIHelper.centerAndShow(this.progressDialog);
    }

    @Override
    public void run() {
        for (GeoCoordDataIFace grItem : this.items) {
            if (this.stopWork) break;
            String localityNameStr = grItem.getLocalityString();
            String country = grItem.getCountry();
            String state = grItem.getState();
            String county = grItem.getCounty();
            country = country == null ? "" : country;
            state = state == null ? "" : state;
            county = county == null ? "" : county;
            boolean isFish = Discipline.isCurrentDiscipline(DisciplineType.STD_DISCIPLINES.fish);
            boolean hwyX = AppPreferences.getLocalPrefs().getBoolean(GL_HYWX, isFish);
            boolean findWaterbody = AppPreferences.getLocalPrefs().getBoolean(GL_WTRBODY, isFish);
            boolean restrictToLowestAdm = AppPreferences.getLocalPrefs().getBoolean(GL_RESTRICT, false);
            boolean doUncert = AppPreferences.getLocalPrefs().getBoolean(GL_DOUNCERT, isFish);
            boolean doPoly = AppPreferences.getLocalPrefs().getBoolean(GL_DOPOLY, isFish);
            boolean displacePoly = AppPreferences.getLocalPrefs().getBoolean(GL_DISPLACEPOLY, isFish);
            boolean polyAsLinkID = false;
            GEOLocatePrefsPanel GLP = new GEOLocatePrefsPanel();
            FormViewObj fvo = (FormViewObj)GLP.getForm();
            ValComboBox languageKeyCoBX = (ValComboBox)fvo.getCompById(GL_LANGKEY);
            int languageKey = languageKeyCoBX.getComboBox().getSelectedIndex();
            GeolocatesvcLocator service = null;
            GeolocatesvcSoap port = null;
            try {
                service = new GeolocatesvcLocator();
                if (service != null && (port = service.getgeolocatesvcSoap()) != null) {
                    try {
                        Georef_Result_Set glResultSet = port.georef2(country, state, county, localityNameStr, hwyX, findWaterbody, restrictToLowestAdm, doUncert, doPoly, displacePoly, polyAsLinkID, languageKey);
                        this.glResults.add(new Pair<GeoCoordDataIFace, Georef_Result_Set>(grItem, glResultSet));
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        this.glResults.add(new Pair<GeoCoordDataIFace, Georef_Result_Set>(grItem, new Georef_Result_Set()));
                    }
                }
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
                this.glResults.add(new Pair<GeoCoordDataIFace, Georef_Result_Set>(grItem, new Georef_Result_Set()));
            }
            catch (OutOfMemoryError em1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UIRegistry.showError("Out of Memory! Please restart Specify.");
                    }
                });
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int progress = GeoCoordGeoLocateProvider.this.progressDialog.getProcess();
                    GeoCoordGeoLocateProvider.this.progressDialog.setProcess(++progress);
                }
            });
        }
        if (!this.stopWork) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GeoCoordGeoLocateProvider.this.progressDialog.setVisible(false);
                    JStatusBar statusBar = UIRegistry.getStatusBar();
                    if (statusBar != null) {
                        statusBar.setText(UIRegistry.getResourceString("GeoCoordGeoLocateProvider.GEOLOC_COMPLETED"));
                        Vector<Pair<GeoCoordDataIFace, Georef_Result_Set>> withResults = new Vector<Pair<GeoCoordDataIFace, Georef_Result_Set>>();
                        for (Pair result : GeoCoordGeoLocateProvider.this.glResults) {
                            if (((Georef_Result_Set)result.second).getNumResults() <= 0) continue;
                            withResults.add(result);
                        }
                        if (withResults.size() == 0) {
                            statusBar.setText(UIRegistry.getResourceString("GeoCoordGeoLocateProvider.NO_GL_RESULTS"));
                            JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("GeoCoordGeoLocateProvider.NO_GL_RESULTS"), UIRegistry.getResourceString("NO_RESULTS"), 1);
                            return;
                        }
                        if (GeoCoordGeoLocateProvider.this.listener != null) {
                            GeoCoordGeoLocateProvider.this.listener.aboutToDisplayResults();
                        }
                        String message = withResults.size() == 1 ? UIRegistry.getResourceString("GEOLOC_RES_VIEW_CONFIRM_ONE") : String.format(UIRegistry.getResourceString("GEOLOC_RES_VIEW_CONFIRM"), String.valueOf(withResults.size()));
                        int userChoice = JOptionPane.showConfirmDialog(UIRegistry.getTopWindow(), message, UIRegistry.getResourceString("GeoCoordGeoLocateProvider.GEO_CONTINUE"), 0);
                        if (userChoice != 0) {
                            statusBar.setText(UIRegistry.getResourceString("GeoCoordGeoLocateProvider.USER_TERMINATED"));
                            return;
                        }
                        JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
                        GeoLocateResultsChooser bgResChooser = new GeoLocateResultsChooser((Frame)topFrame, withResults);
                        List<Georef_Result> results = bgResChooser.getResultsChosen();
                        int itemsUpdated = 0;
                        int i = 0;
                        while (i < results.size()) {
                            GeoCoordDataIFace item = (GeoCoordDataIFace)((Pair)withResults.get((int)i)).first;
                            Georef_Result chosenResult = results.get(i);
                            if (chosenResult != null) {
                                Double latitude = chosenResult.getWGS84Coordinate().getLatitude();
                                Double longitude = chosenResult.getWGS84Coordinate().getLongitude();
                                item.set(String.format("%7.5f", latitude), String.format("%7.5f", longitude));
                                item.setErrorPolygon(chosenResult.getErrorPolygon());
                                item.setErrorEstimate(chosenResult.getErrorEstimate());
                                ++itemsUpdated;
                            }
                            ++i;
                        }
                        if (GeoCoordGeoLocateProvider.this.listener != null) {
                            GeoCoordGeoLocateProvider.this.listener.complete(GeoCoordGeoLocateProvider.this.items, itemsUpdated);
                        }
                    }
                }
            });
        }
    }
}

