/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.geolocate.client;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.services.geolocate.client.GeographicPoint;
import edu.ku.brc.services.geolocate.client.Geolocatesvc;
import edu.ku.brc.services.geolocate.client.GeolocatesvcSoap;
import edu.ku.brc.services.geolocate.client.GeorefResult;
import edu.ku.brc.services.geolocate.client.GeorefResultSet;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.services.mapping.SimpleMapLocation;
import java.util.List;

public class GeoLocate {
    private static final String GL_HYWX = "GEOLocate.HYWX";
    private static final String GL_WTRBODY = "GEOLocate.WATERBODY";
    protected static final int MAP_MAX_WIDTH = 400;
    protected static final int MAP_MAX_HEIGHT = 250;

    public static GeorefResultSet getGeoLocateResults(String country, String state, String county, String localityString) {
        Geolocatesvc service = new Geolocatesvc();
        GeolocatesvcSoap port = service.getGeolocatesvcSoap();
        boolean hwyX = AppPreferences.getRemote().getBoolean(GL_HYWX, false);
        boolean findWaterbody = AppPreferences.getRemote().getBoolean(GL_WTRBODY, false);
        GeorefResultSet resultSet = port.georef2(country == null ? "" : country, state == null ? "" : state, county == null ? "" : county, localityString, hwyX, findWaterbody);
        return resultSet;
    }

    public static void getMapOfGeographicPoints(List<GeorefResult> points, LocalityMapper.MapperListener callback) {
        LocalityMapper mapper = new LocalityMapper();
        mapper.setShowArrows(false);
        mapper.setMaxMapWidth(400);
        mapper.setMaxMapHeight(250);
        int index = 0;
        while (index < points.size()) {
            GeographicPoint point = points.get(index).getWGS84Coordinate();
            double lon = point.getLongitude();
            double lat = point.getLatitude();
            SimpleMapLocation tmpLoc = new SimpleMapLocation(lat, lon, null, null);
            mapper.addLocationAndLabel(tmpLoc, Integer.toString(index + 1));
            ++index;
        }
        mapper.getMap(callback);
    }
}

