/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.biogeomancer;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.services.biogeomancer.BioGeomancer;
import edu.ku.brc.services.biogeomancer.BioGeomancerQuerySummaryStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultsChooser;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordProviderListenerIFace;
import edu.ku.brc.services.biogeomancer.GeoCoordServiceProviderIFace;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.ProgressDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GeoCoordBGMProvider
implements GeoCoordServiceProviderIFace {
    private static final Logger log = Logger.getLogger(GeoCoordBGMProvider.class);
    protected GeoCoordProviderListenerIFace listener = null;
    protected String helpContext = null;

    @Override
    public void processGeoRefData(final List<GeoCoordDataIFace> items, GeoCoordProviderListenerIFace listenerArg, String helpContextArg) {
        this.listener = listenerArg;
        this.helpContext = helpContextArg;
        UsageTracker.incrUsageCount("Tools.BioGeomancerData");
        log.info((Object)"Performing BioGeomancer lookup of selected records");
        final ProgressDialog progressDialog = new ProgressDialog(UIRegistry.getResourceString("GeoCoordBGMProvider.BIOGEOMANCER_PROGRESS"), false, true);
        progressDialog.getCloseBtn().setText(UIRegistry.getResourceString("CANCEL"));
        progressDialog.setModal(true);
        progressDialog.setProcess(0, items.size());
        final SwingWorker bgTask = new SwingWorker(){
            final JStatusBar statusBar = UIRegistry.getStatusBar();
            protected boolean cancelled = false;

            @Override
            public void interrupt() {
                super.interrupt();
                this.cancelled = true;
            }

            @Override
            public Object construct() {
                int progress = 0;
                for (GeoCoordDataIFace item : items) {
                    BioGeomancerQuerySummaryStruct bgQuerySummary;
                    String bgResults;
                    if (this.cancelled) break;
                    String localityNameStr = item.getLocalityString();
                    String country = item.getCountry();
                    String state = item.getState();
                    String county = item.getCounty();
                    log.info((Object)("Making call to BioGeomancer service: " + localityNameStr));
                    try {
                        bgResults = BioGeomancer.getBioGeomancerResponse(item.getGeoCoordId().toString(), country, state, county, localityNameStr);
                        bgQuerySummary = BioGeomancer.parseBioGeomancerResponse(bgResults);
                    }
                    catch (IOException ex1) {
                        String warning = UIRegistry.getResourceString("GeoCoordBGMProvider.WB_BIOGEOMANCER_UNAVAILABLE");
                        this.statusBar.setWarningMessage(warning, ex1);
                        log.error((Object)"A network error occurred while contacting the BioGeomancer service", (Throwable)ex1);
                        progressDialog.setProcess(++progress);
                        continue;
                    }
                    catch (Exception ex2) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(GeoCoordBGMProvider.class, ex2);
                        String warning = UIRegistry.getResourceString("GeoCoordBGMProvider.WB_BIOGEOMANCER_UNAVAILABLE");
                        this.statusBar.setWarningMessage(warning, ex2);
                        log.warn((Object)"Failed to get result count from BioGeomancer respsonse", (Throwable)ex2);
                        progressDialog.setProcess(++progress);
                        continue;
                    }
                    int resCount = bgQuerySummary.results.length;
                    if (resCount > 0) {
                        final int rowNumber = item.getGeoCoordId();
                        final BioGeomancerQuerySummaryStruct summaryStruct = bgQuerySummary;
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    log.info((Object)("Requesting map of BioGeomancer results for workbench row " + rowNumber));
                                    BioGeomancer.getMapOfQuerySummary(summaryStruct, null);
                                }
                                catch (Exception e) {
                                    UsageTracker.incrHandledUsageCount();
                                    ExceptionTracker.getInstance().capture(GeoCoordBGMProvider.class, e);
                                    log.warn((Object)"Failed to pre-cache BioGeomancer results map", (Throwable)e);
                                }
                            }
                        });
                        t.setName("Map Pre-Caching Thread: row " + item.getGeoCoordId());
                        log.debug((Object)"Starting map pre-caching thread");
                        t.start();
                    }
                    if (resCount > 0) {
                        item.setXML(bgResults);
                    }
                    progressDialog.setProcess(++progress);
                }
                return null;
            }

            @Override
            public void finished() {
                this.statusBar.setText(UIRegistry.getResourceString("GeoCoordBGMProvider.BIOGEOMANCER_COMPLETED"));
                if (!this.cancelled) {
                    progressDialog.setVisible(false);
                    Vector<GeoCoordDataIFace> rowsWithResults = new Vector<GeoCoordDataIFace>();
                    for (GeoCoordDataIFace row : items) {
                        if (row.getXML() == null) continue;
                        rowsWithResults.add(row);
                    }
                    int numRecordsWithResults = rowsWithResults.size();
                    if (numRecordsWithResults == 0) {
                        this.statusBar.setText(UIRegistry.getResourceString("GeoCoordBGMProvider.NO_BG_RESULTS"));
                        JOptionPane.showMessageDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("GeoCoordBGMProvider.NO_BG_RESULTS"), UIRegistry.getResourceString("NO_RESULTS"), 1);
                        return;
                    }
                    if (GeoCoordBGMProvider.this.listener != null) {
                        GeoCoordBGMProvider.this.listener.aboutToDisplayResults();
                    }
                    String message = String.format(UIRegistry.getResourceString("GeoCoordBGMProvider.BGM_VIEW_RESULTS_CONFIRM"), String.valueOf(numRecordsWithResults));
                    int userChoice = JOptionPane.showConfirmDialog(UIRegistry.getTopWindow(), message, UIRegistry.getResourceString("GeoCoordBGMProvider.CONTINUE"), 0);
                    if (userChoice != 0) {
                        this.statusBar.setText(UIRegistry.getResourceString("GeoCoordBGMProvider.BIOGEOMANCER_TERMINATED"));
                        return;
                    }
                    GeoCoordBGMProvider.this.displayBioGeomancerResults(rowsWithResults);
                }
            }
        };
        progressDialog.getCloseBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                log.debug((Object)"Stopping the BioGeomancer service worker thread");
                bgTask.interrupt();
            }
        });
        log.debug((Object)"Starting the BioGeomancer service worker thread");
        bgTask.start();
        UIHelper.centerAndShow(progressDialog);
    }

    protected void displayBioGeomancerResults(List<GeoCoordDataIFace> items) {
        JFrame topFrame = (JFrame)UIRegistry.getTopWindow();
        BioGeomancerResultsChooser bgResChooser = new BioGeomancerResultsChooser((Frame)topFrame, UIRegistry.getResourceString("GeoCoordBGMProvider.BIOGEOMANCER_CHOOSER"), items, this.helpContext);
        int itemsUpdated = 0;
        List<BioGeomancerResultStruct> results = bgResChooser.getResultsChosen();
        int i = 0;
        while (i < items.size()) {
            GeoCoordDataIFace item = items.get(i);
            BioGeomancerResultStruct userChoice = results.get(i);
            if (userChoice != null) {
                String[] coords = StringUtils.split((String)userChoice.coordinates);
                item.set(coords[1], coords[0]);
                ++itemsUpdated;
            }
            ++i;
        }
        if (this.listener != null) {
            this.listener.complete(items, itemsUpdated);
            this.listener = null;
        }
    }
}

