/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.biogeomancer;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.services.biogeomancer.BioGeomancer;
import edu.ku.brc.services.biogeomancer.BioGeomancerQuerySummaryStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultsTableModel;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionListener;

public class BioGeomancerResultsDisplay
extends JPanel
implements LocalityMapper.MapperListener {
    protected static final int MAP_WIDTH = 400;
    protected static final int MAP_HEIGHT = 250;
    protected JPanel topPanel;
    protected JLabel mapLabel;
    protected JPanel resultsDetailsForm;
    protected JTable bgResultsTable;
    protected JTextField idField;
    protected JTextField countryField;
    protected JTextField adm1Field;
    protected JTextField adm2Field;
    protected JTextField localityField;
    protected JTextField countryBoundingBoxField;
    protected JTextField matchedCountField;
    protected JTextField boundingBoxField;
    protected JTextField boundingBoxCentroidField;
    protected JTextField centroidErrorRadiusField;
    protected JTextField centroidErrorRadiusUnitsField;
    protected JTextField multiPointMatchField;
    protected JTextField weightedCentroidField;
    protected BioGeomancerQuerySummaryStruct summary;

    public BioGeomancerResultsDisplay() {
        String rowDef = String.valueOf(UIHelper.createDuplicateJGoodiesDef("p", "2px", 13)) + ",20px,p:g";
        this.setLayout((LayoutManager)new FormLayout("p,10px,400px,10px,C:p:g", rowDef));
        CellConstraints cc = new CellConstraints();
        int rowIndex = 1;
        this.idField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.ID"), 1, rowIndex);
        this.countryField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.COUNTRY"), 1, rowIndex += 2);
        this.adm1Field = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.ADM1"), 1, rowIndex += 2);
        this.adm2Field = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.ADM2"), 1, rowIndex += 2);
        this.localityField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.LOCALITY"), 1, rowIndex += 2);
        this.countryBoundingBoxField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.COUNTRY_BOUNDING_BOX"), 1, rowIndex += 2);
        this.matchedCountField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.MATCHED_CNT"), 1, rowIndex += 2);
        this.boundingBoxField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.BOUNDING_BOX"), 1, rowIndex += 2);
        this.boundingBoxCentroidField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.BOUNDING_BOX_CENTROID"), 1, rowIndex += 2);
        this.centroidErrorRadiusField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.CENTROID_ERROR_RADIUS"), 1, rowIndex += 2);
        this.centroidErrorRadiusUnitsField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.CENTROID_ERROR_RADIUS_UNITS"), 1, rowIndex += 2);
        this.multiPointMatchField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.MULTI_POINT_MATCH"), 1, rowIndex += 2);
        this.weightedCentroidField = this.addRow(cc, UIRegistry.getResourceString("BioGeomancerResultsDisplay.WEIGHTED_CENTROID"), 1, rowIndex += 2);
        rowIndex += 2;
        this.mapLabel = UIHelper.createLabel(UIRegistry.getResourceString("BioGeomancerResultsDisplay.LOADING_MAP"));
        this.add((Component)this.mapLabel, cc.xywh(5, 1, 1, 25));
        this.mapLabel.setPreferredSize(new Dimension(400, 250));
        this.bgResultsTable = new JTable();
        this.bgResultsTable.setShowVerticalLines(false);
        this.bgResultsTable.setShowHorizontalLines(false);
        this.bgResultsTable.setRowSelectionAllowed(true);
        this.bgResultsTable.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        this.mapLabel.setText("");
        this.add((Component)UIHelper.createScrollPane(this.bgResultsTable), cc.xywh(1, rowIndex, 5, 1));
        rowIndex += 2;
    }

    protected JTextField addRow(CellConstraints cc, String labelStr, int column, int row) {
        this.add((Component)UIHelper.createI18NFormLabel(labelStr), cc.xy(column, row));
        JTextField tf = this.createTextField();
        tf.setEditable(false);
        this.add((Component)tf, cc.xy(column + 2, row));
        return tf;
    }

    protected JTextField createTextField() {
        JTextField tf = UIHelper.createTextField();
        Insets insets = tf.getBorder().getBorderInsets(tf);
        tf.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.bottom));
        tf.setForeground(Color.BLACK);
        tf.setBackground(Color.WHITE);
        tf.setEditable(false);
        return tf;
    }

    public void setBioGeomancerResultsData(String bgXmlResponse) throws Exception {
        this.mapLabel.setIcon(null);
        this.mapLabel.setText(UIRegistry.getResourceString("BioGeomancerResultsDisplay.LOADING_MAP"));
        this.summary = BioGeomancer.parseBioGeomancerResponse(bgXmlResponse);
        this.idField.setText(this.summary.id);
        this.idField.setCaretPosition(0);
        this.countryField.setText(this.summary.country);
        this.countryField.setCaretPosition(0);
        this.adm1Field.setText(this.summary.adm1);
        this.adm1Field.setCaretPosition(0);
        this.adm2Field.setText(this.summary.adm2);
        this.adm2Field.setCaretPosition(0);
        this.localityField.setText(this.summary.localityStr);
        this.localityField.setCaretPosition(0);
        this.countryBoundingBoxField.setText(this.summary.countryBoundingBox);
        this.countryBoundingBoxField.setCaretPosition(0);
        this.matchedCountField.setText(this.summary.matchedRecordCount);
        this.matchedCountField.setCaretPosition(0);
        this.boundingBoxField.setText(this.summary.boundingBox);
        this.boundingBoxField.setCaretPosition(0);
        this.boundingBoxCentroidField.setText(this.summary.boundingBoxCentroid);
        this.boundingBoxCentroidField.setCaretPosition(0);
        this.centroidErrorRadiusField.setText(this.summary.boundingBoxCentroidErrorRadius);
        this.centroidErrorRadiusField.setCaretPosition(0);
        this.centroidErrorRadiusUnitsField.setText(this.summary.boundingBoxCentroidErrorRadiusUnits);
        this.centroidErrorRadiusUnitsField.setCaretPosition(0);
        this.multiPointMatchField.setText(this.summary.multiPointMatch);
        this.multiPointMatchField.setCaretPosition(0);
        this.weightedCentroidField.setText(this.summary.weightedCentroid);
        this.weightedCentroidField.setCaretPosition(0);
        this.bgResultsTable.setModel(new BioGeomancerResultsTableModel(this.summary.results));
        UIHelper.calcColumnWidths(this.bgResultsTable);
        BioGeomancer.getMapOfQuerySummary(this.summary, this);
        this.repaint();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.bgResultsTable.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.bgResultsTable.getSelectionModel().removeListSelectionListener(listener);
    }

    public BioGeomancerResultStruct getSelectedResult() {
        int rowIndex = this.bgResultsTable.getSelectedRow();
        if (rowIndex < 0 || rowIndex > this.summary.results.length - 1) {
            return null;
        }
        return this.summary.results[rowIndex];
    }

    public void setSelectedResult(int index) {
        if (index < 0 || index > this.bgResultsTable.getRowCount() - 1) {
            this.bgResultsTable.clearSelection();
        } else {
            this.bgResultsTable.setRowSelectionInterval(index, index);
            int colCount = this.bgResultsTable.getColumnCount();
            this.bgResultsTable.setColumnSelectionInterval(0, colCount - 1);
        }
    }

    @Override
    public void exceptionOccurred(Exception e) {
        String errorMsg = UIRegistry.getResourceString("BioGeomancerResultsDisplay.WB_MAP_SERVICE_CONNECTION_FAILURE");
        this.mapLabel.setText(errorMsg);
    }

    @Override
    public void mapReceived(Icon map) {
        this.mapLabel.setIcon(map);
    }
}

