/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.biogeomancer;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultsDisplay;
import edu.ku.brc.services.biogeomancer.GeoCoordDataIFace;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Frame;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;

public class BioGeomancerResultsChooser
extends CustomDialog {
    protected BioGeomancerResultsDisplay resultsDisplayPanel = new BioGeomancerResultsDisplay();
    protected List<GeoCoordDataIFace> items;
    protected List<BioGeomancerResultStruct> chosenResults;
    protected boolean hasBeenShown;
    protected int rowIndex;
    protected String baseTitle;
    protected String helpContext;

    public BioGeomancerResultsChooser(Frame parent, String title, List<GeoCoordDataIFace> items, String helpContext) {
        super(parent, title, true, 15, null);
        this.items = items;
        this.hasBeenShown = false;
        this.baseTitle = title;
        this.helpContext = helpContext;
        this.chosenResults = new Vector<BioGeomancerResultStruct>(items.size());
        int i = 0;
        while (i < items.size()) {
            this.chosenResults.add(null);
            ++i;
        }
        this.setContentPanel(this.resultsDisplayPanel);
        this.cancelLabel = UIRegistry.getResourceString("SKIP");
        this.applyLabel = UIRegistry.getResourceString("ACCEPT");
        this.okLabel = UIRegistry.getResourceString("QUIT");
        this.rowIndex = -1;
    }

    public List<BioGeomancerResultStruct> getResultsChosen() {
        if (!this.hasBeenShown) {
            this.setVisible(true);
        }
        return this.chosenResults;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.hasBeenShown && visible) {
            this.hasBeenShown = true;
            this.createUI();
            HelpMgr.registerComponent((AbstractButton)this.helpBtn, this.helpContext);
            this.showNextRecord();
            UIHelper.centerWindow(this);
            this.pack();
        }
        super.setVisible(visible);
    }

    @Override
    protected void applyButtonPressed() {
        super.applyButtonPressed();
        BioGeomancerResultStruct result = this.resultsDisplayPanel.getSelectedResult();
        this.chosenResults.set(this.rowIndex, result);
        if (this.onLastRecord()) {
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    @Override
    protected void okButtonPressed() {
        super.okButtonPressed();
    }

    @Override
    protected void cancelButtonPressed() {
        if (this.onLastRecord()) {
            super.okButtonPressed();
        } else {
            this.showNextRecord();
        }
    }

    protected void showNextRecord() {
        ++this.rowIndex;
        this.setTitle(String.valueOf(this.baseTitle) + ": " + (this.rowIndex + 1) + " " + UIRegistry.getResourceString("BioGeomancerResultsChooser.OF") + " " + this.items.size());
        try {
            this.resultsDisplayPanel.setBioGeomancerResultsData(this.items.get(this.rowIndex).getXML());
            this.resultsDisplayPanel.setSelectedResult(0);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BioGeomancerResultsChooser.class, e);
            UIRegistry.getStatusBar().setErrorMessage(UIRegistry.getResourceString("BioGeomancerResultsChooser.RESULTS_ERROR"), e);
            super.setVisible(false);
        }
    }

    protected boolean onLastRecord() {
        return this.rowIndex == this.items.size() - 1;
    }
}

