/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.services.biogeomancer;

import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.services.biogeomancer.BioGeomancerQuerySummaryStruct;
import edu.ku.brc.services.biogeomancer.BioGeomancerResultStruct;
import edu.ku.brc.services.mapping.LocalityMapper;
import edu.ku.brc.services.mapping.SimpleMapLocation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class BioGeomancer {
    protected static final int MAP_MAX_WIDTH = 400;
    protected static final int MAP_MAX_HEIGHT = 250;

    public static int getResultsCount(String bioGeomancerResponseString) throws Exception {
        Element responseAsXml = XMLHelper.readStrToDOM4J(bioGeomancerResponseString);
        List records = responseAsXml.selectNodes("//record");
        return records != null ? records.size() : 0;
    }

    public static String getBioGeomancerResponse(String id, String country, String adm1, String adm2, String localityArg) throws IOException {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod("http://130.132.27.130/cgi-bin/bgm-0.2/batch_test.pl");
        StringBuilder strBuf = new StringBuilder(128);
        strBuf.append("\"" + id + "\",");
        strBuf.append("\"" + country + "\",");
        strBuf.append("\"" + adm1 + "\",");
        strBuf.append("\"" + (adm2 != null ? adm2 : "") + "\",");
        strBuf.append("\"" + localityArg + "\"\r\n");
        NameValuePair[] postData = new NameValuePair[]{new NameValuePair("batchtext", strBuf.toString()), new NameValuePair("format", "xml")};
        postMethod.addParameters(postData);
        httpClient.executeMethod((HttpMethod)postMethod);
        InputStream iStream = postMethod.getResponseBodyAsStream();
        StringBuilder sb = new StringBuilder();
        byte[] bytes = new byte[8196];
        int numBytes = 0;
        do {
            if ((numBytes = iStream.read(bytes)) <= 0) continue;
            sb.append(new String(bytes, 0, numBytes));
        } while (numBytes > 0);
        postMethod.releaseConnection();
        return sb.toString();
    }

    public static BioGeomancerQuerySummaryStruct getBioGeomancerResponses(String id, String country, String adm1, String adm2, String localityString) throws Exception {
        String responseStr = BioGeomancer.getBioGeomancerResponse(id, country, adm1, adm2, localityString);
        return BioGeomancer.parseBioGeomancerResponse(responseStr);
    }

    public static BioGeomancerQuerySummaryStruct parseBioGeomancerResponse(String bgResponse) throws Exception {
        Element root = XMLHelper.readStrToDOM4J(bgResponse);
        Element summary = (Element)root.selectSingleNode("//summary");
        if (summary == null) {
            throw new Exception("BioGeomancer response is missing required data");
        }
        BioGeomancerQuerySummaryStruct querySummary = new BioGeomancerQuerySummaryStruct();
        querySummary.id = XMLHelper.getValue(summary, "queryId");
        querySummary.country = XMLHelper.getValue(summary, "queryCountry");
        querySummary.adm1 = XMLHelper.getValue(summary, "queryAdm1");
        querySummary.adm2 = XMLHelper.getValue(summary, "queryAdm2");
        querySummary.localityStr = XMLHelper.getValue(summary, "queryString");
        querySummary.countryBoundingBox = XMLHelper.getValue(summary, "countryBoundingBox");
        querySummary.matchedRecordCount = XMLHelper.getValue(summary, "matchedRecordCount");
        querySummary.boundingBox = XMLHelper.getValue(summary, "boundingBox");
        querySummary.boundingBoxCentroid = XMLHelper.getValue(summary, "boundingBoxCentroid");
        querySummary.boundingBoxCentroidErrorRadius = XMLHelper.getValue(summary, "boundingBoxCentroidErrorRadius");
        querySummary.boundingBoxCentroidErrorRadiusUnits = XMLHelper.getValue(summary, "boundingBoxCentroidErrorRadiusUnits");
        querySummary.multiPointMatch = XMLHelper.getValue(summary, "multiPointMatch");
        querySummary.weightedCentroid = XMLHelper.getValue(summary, "weightedCentroid");
        List records = root.selectNodes("//record");
        BioGeomancerResultStruct[] results = new BioGeomancerResultStruct[records.size()];
        int index = 0;
        for (Object o : records) {
            Element record = (Element)o;
            BioGeomancerResultStruct result = new BioGeomancerResultStruct();
            result.country = XMLHelper.getValue(record, "country");
            result.adm1 = XMLHelper.getValue(record, "adm1");
            result.adm2 = XMLHelper.getValue(record, "adm2");
            result.featureName = XMLHelper.getValue(record, "featureName");
            result.featureType = XMLHelper.getValue(record, "featureType");
            result.gazetteer = XMLHelper.getValue(record, "gazetteerSource");
            result.coordinates = XMLHelper.getValue(record, "InterpretedCoordinates");
            result.offset = XMLHelper.getValue(record, "offsetVector");
            result.boundingBox = XMLHelper.getValue(record, "boundingBox");
            result.locality = XMLHelper.getValue(record, "InterpretedString");
            results[index++] = result;
        }
        querySummary.results = results;
        return querySummary;
    }

    public static void getMapOfBioGeomancerResults(String bgResponse, LocalityMapper.MapperListener callback) throws Exception {
        BioGeomancerQuerySummaryStruct summary = BioGeomancer.parseBioGeomancerResponse(bgResponse);
        BioGeomancer.getMapOfQuerySummary(summary, callback);
    }

    public static void getMapOfQuerySummary(BioGeomancerQuerySummaryStruct querySummary, LocalityMapper.MapperListener callback) {
        LocalityMapper mapper = new LocalityMapper();
        mapper.setShowArrows(false);
        mapper.setMaxMapWidth(400);
        mapper.setMaxMapHeight(250);
        int i = 0;
        while (i < querySummary.results.length) {
            BioGeomancerResultStruct result = querySummary.results[i];
            String[] coords = StringUtils.split((String)result.coordinates);
            double lon = Double.parseDouble(coords[0]);
            double lat = Double.parseDouble(coords[1]);
            String bbox = result.boundingBox;
            if (StringUtils.isNotEmpty((String)bbox)) {
                String[] boxList = StringUtils.split((String)bbox.replace(',', ' '));
                double[] box = new double[4];
                int j = 0;
                while (j < boxList.length) {
                    box[j] = Double.parseDouble(boxList[j]);
                    ++j;
                }
                SimpleMapLocation loc = new SimpleMapLocation(box[1], box[0], box[3], box[2]);
                mapper.addLocationAndLabel(loc, Integer.toString(i + 1));
            } else {
                SimpleMapLocation loc = new SimpleMapLocation(lat, lon, null, null);
                mapper.addLocationAndLabel(loc, Integer.toString(i + 1));
            }
            ++i;
        }
        mapper.getMap(callback);
    }
}

