/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class ZipFileHelper {
    private static ZipFileHelper instance = null;
    protected Vector<File> dirsToRemoveList = new Vector();

    public ZipFileHelper() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ZipFileHelper.this.cleanUp();
                    }
                });
                return null;
            }
        });
    }

    public void cleanUp() {
        for (File dir : this.dirsToRemoveList) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    public List<File> unzipToFiles(File zipFile) throws ZipException, IOException {
        Vector<File> files = new Vector<File>();
        int bufSize = 65535;
        File dir = UIRegistry.getAppDataSubDir(String.valueOf(Long.toString(System.currentTimeMillis())) + "_zip", true);
        this.dirsToRemoveList.add(dir);
        File outFile = null;
        FileOutputStream fos = null;
        try {
            ZipInputStream zin = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                if (zin.available() > 0) {
                    outFile = new File(String.valueOf(dir.getCanonicalPath()) + File.separator + entry.getName());
                    fos = new FileOutputStream(outFile);
                    byte[] bytes = new byte[65535];
                    int bytesRead = zin.read(bytes, 0, 65535);
                    while (bytesRead > 0) {
                        fos.write(bytes, 0, bytesRead);
                        bytesRead = zin.read(bytes, 0, 65535);
                    }
                    files.insertElementAt(outFile.getCanonicalFile(), 0);
                }
                entry = zin.getNextEntry();
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return files;
    }

    public File unzipToSingleFile(File zipFile) {
        ZipInputStream zin;
        File outFile;
        block7: {
            block6: {
                int bufSize = 102400;
                outFile = null;
                zin = new ZipInputStream(new FileInputStream(zipFile));
                ZipEntry entry = zin.getNextEntry();
                if (entry != null) break block6;
                return null;
            }
            if (zin.available() != 0) break block7;
            return null;
        }
        try {
            outFile = File.createTempFile("zip_", "sql");
            FileOutputStream fos = new FileOutputStream(outFile);
            byte[] bytes = new byte[102400];
            int bytesRead = zin.read(bytes, 0, 102400);
            while (bytesRead > 0) {
                fos.write(bytes, 0, bytesRead);
                bytesRead = zin.read(bytes, 0, 100);
            }
        }
        catch (ZipException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ZipFileHelper.class, ex);
            return null;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ZipFileHelper.class, ex);
            return null;
        }
        return outFile;
    }

    public static ZipFileHelper getInstance() {
        if (instance == null) {
            instance = new ZipFileHelper();
        }
        return instance;
    }
}

