/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.XMLChecksumUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XMLHelper {
    private static final Logger log = Logger.getLogger(XMLHelper.class);
    private static final String eol = System.getProperty("line.separator");
    private static boolean useChecksum = false;
    private static File configDir = null;
    private static boolean isEmptyAttrOK = false;

    static {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(false);
    }

    public static void setEmptyAttrOK(boolean isEmptyAttrOK) {
        XMLHelper.isEmptyAttrOK = isEmptyAttrOK;
    }

    public static void setUseChecksum(boolean useChecksum) {
        XMLHelper.useChecksum = useChecksum;
    }

    public static Element readFileToDOM4J(File file) throws Exception {
        if (useChecksum && configDir != null && !file.getName().equals("checksum.ini") && !XMLChecksumUtil.checkSignature(file)) {
            JOptionPane.showMessageDialog(null, UIRegistry.getResourceString("XMLHelper.CHECKSUM_MSG"), UIRegistry.getResourceString("XMLHelper.CHECKSUM_TITLE"), 0);
            System.exit(0);
        }
        if (!file.exists()) {
            return null;
        }
        return XMLHelper.readFileToDOM4J(new FileInputStream(file));
    }

    public static Element readFileToDOM4J(FileInputStream fileinputStream) throws Exception {
        SAXReader saxReader = new SAXReader();
        saxReader.setValidation(false);
        saxReader.setStripWhitespaceText(true);
        saxReader.setFeature("http://xml.org/sax/features/namespaces", false);
        saxReader.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
        Document document = saxReader.read((InputStream)fileinputStream);
        return document.getRootElement();
    }

    public static Element readStrToDOM4J(String data) throws Exception {
        SAXReader saxReader = new SAXReader();
        saxReader.setValidation(false);
        saxReader.setStripWhitespaceText(true);
        saxReader.setFeature("http://xml.org/sax/features/namespaces", false);
        saxReader.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", false);
        Document document = saxReader.read((Reader)new StringReader(data));
        return document.getRootElement();
    }

    public static String getConfigDirPath(String fileName) {
        if (configDir == null) {
            File cfgDir = new File(String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + "config");
            if (!cfgDir.exists()) {
                String path = new File(".").getAbsolutePath();
                if (path.endsWith(".")) {
                    path = UIHelper.stripSubDirs(path, 1);
                }
                cfgDir = new File(String.valueOf(path) + File.separator + "config");
                log.debug((Object)("Checking Working Path[" + cfgDir.getAbsolutePath() + "]"));
                if (!cfgDir.exists()) {
                    throw new RuntimeException("Couldn't find config path[" + cfgDir.getAbsolutePath() + "]");
                }
            }
            configDir = cfgDir;
        }
        return String.valueOf(configDir.getAbsolutePath()) + File.separator + (fileName != null ? fileName : "");
    }

    public static File getConfigDir(String fileName) {
        return new File(XMLHelper.getConfigDirPath(fileName));
    }

    public static Element readDOMFromConfigDir(String fileName) {
        try {
            return XMLHelper.readFileToDOM4J(XMLHelper.getConfigDir(fileName));
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public static String getAttr(Element element, String attrName, String defValue) {
        String str = element.attributeValue(attrName);
        return str != null ? str : defValue;
    }

    public static int getAttr(Element element, String attrName, int defValue) {
        String str = element.attributeValue(attrName);
        return StringUtils.isNotEmpty((String)str) ? Integer.parseInt(str) : defValue;
    }

    public static byte getAttr(Element element, String attrName, byte defValue) {
        String str = element.attributeValue(attrName);
        return StringUtils.isNotEmpty((String)str) ? Byte.parseByte(str) : defValue;
    }

    public static short getAttr(Element element, String attrName, short defValue) {
        String str = element.attributeValue(attrName);
        return StringUtils.isNotEmpty((String)str) ? Short.parseShort(str) : defValue;
    }

    public static boolean getAttr(Element element, String attrName, boolean defValue) {
        String str = element.attributeValue(attrName);
        return StringUtils.isNotEmpty((String)str) ? Boolean.parseBoolean(str.toLowerCase()) : defValue;
    }

    public static String getValue(Element element, String name) {
        Element node = (Element)element.selectSingleNode(name);
        if (node != null) {
            String data = node.getTextTrim();
            int inx = data.indexOf("(");
            if (inx != -1) {
                int einx = data.indexOf(")");
                return data.substring(inx + 1, einx);
            }
            return data;
        }
        log.debug((Object)("****** [" + name + "] was not found."));
        return "";
    }

    public static String getContents(File file) {
        StringBuilder contents;
        block19: {
            contents = new StringBuilder();
            BufferedReader input = null;
            try {
                input = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(eol);
                }
            }
            catch (FileNotFoundException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(XMLHelper.class, ex);
                ex.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                    break block19;
                }
                catch (IOException ex2) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(XMLHelper.class, ex2);
                    ex2.printStackTrace();
                }
                break block19;
            }
            catch (IOException ex) {
                try {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(XMLHelper.class, ex);
                    ex.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex3) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(XMLHelper.class, ex3);
                        ex3.printStackTrace();
                    }
                }
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(XMLHelper.class, ex);
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static void setContents(File outFile, String contents) throws FileNotFoundException, IOException {
        if (outFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (outFile.exists()) {
            if (!outFile.isFile()) {
                throw new IllegalArgumentException("Should not be a directory: " + outFile);
            }
            if (!outFile.canWrite()) {
                throw new IllegalArgumentException("File cannot be written: " + outFile);
            }
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(outFile));
            if (contents != null) {
                output.write(contents);
                output.flush();
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static XStream createXStreamWithCData() {
        return new XStream((HierarchicalStreamDriver)new XppDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out){

                    protected void writeText(QuickWriter writer, String text) {
                        writer.write("<![CDATA[");
                        writer.write(text);
                        writer.write("]]>");
                    }
                };
            }
        });
    }

    public static void indent(StringBuilder sb, int width) {
        int i = 0;
        while (i < width) {
            sb.append(' ');
            ++i;
        }
    }

    public static void addAttr(StringBuilder sb, String name, String value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value == null ? "" : value);
        sb.append('\"');
    }

    public static void addAttr(StringBuilder sb, String name, Integer value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value == null ? "" : value);
        sb.append('\"');
    }

    public static void addAttr(StringBuilder sb, String name, Short value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value == null ? "" : value);
        sb.append('\"');
    }

    public static void addAttr(StringBuilder sb, String name, Boolean value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value == null ? "" : value);
        sb.append('\"');
    }

    public static void addAttr(StringBuilder sb, String name, Byte value) {
        sb.append(' ');
        sb.append(name);
        sb.append("=\"");
        sb.append(value == null ? "" : value);
        sb.append('\"');
    }

    public static void addNode(StringBuilder sb, int indent, String name, boolean isEnd) {
        XMLHelper.indent(sb, indent);
        sb.append('<');
        if (isEnd) {
            sb.append('/');
        }
        sb.append(name);
        sb.append('>');
    }

    public static void addNode(StringBuilder sb, int indent, String name, String value) {
        XMLHelper.addNode(sb, indent, name, false);
        sb.append(value);
        XMLHelper.addNode(sb, 0, name, true);
    }

    public static String fixUpHTML(File file) {
        String path = FilenameUtils.getFullPath((String)file.getAbsolutePath());
        StringBuilder sb = new StringBuilder();
        try {
            List lines = FileUtils.readLines((File)file);
            boolean fndBegin = false;
            for (Object lineObj : lines) {
                String line = (String)lineObj;
                if (!fndBegin) {
                    if (line.indexOf("<body") <= -1) continue;
                    fndBegin = true;
                    continue;
                }
                int inx = line.indexOf("<img");
                if (inx > -1) {
                    inx = line.indexOf("src=\"", inx);
                    sb.append(line.substring(0, inx + 5));
                    File f = new File(path);
                    sb.append(f.toURL());
                    sb.append(line.substring(inx + 5, line.length()));
                    continue;
                }
                sb.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(XMLHelper.class, ex);
            log.error((Object)ex);
        }
        return sb.toString();
    }

    public static void xmlAttr(StringBuilder sb, String attr, String val) {
        if (StringUtils.isNotEmpty((String)val) || isEmptyAttrOK) {
            sb.append(' ');
            sb.append(attr);
            sb.append("=\"");
            sb.append(val);
            sb.append('\"');
        }
    }

    public static void xmlAttr(StringBuilder sb, String attr, Integer val) {
        if (val != null || isEmptyAttrOK) {
            XMLHelper.xmlAttr(sb, attr, val.toString());
        }
    }

    public static void xmlAttr(StringBuilder sb, String attr, Short val) {
        if (val != null || isEmptyAttrOK) {
            XMLHelper.xmlAttr(sb, attr, val.toString());
        }
    }

    public static void xmlAttr(StringBuilder sb, String attr, Byte val) {
        if (val != null || isEmptyAttrOK) {
            XMLHelper.xmlAttr(sb, attr, val.toString());
        }
    }

    public static void xmlAttr(StringBuilder sb, String attr, Boolean val) {
        if (val != null || isEmptyAttrOK) {
            XMLHelper.xmlAttr(sb, attr, val.toString());
        }
    }

    public static void xmlNode(StringBuilder sb, String tag, String val, boolean useCData) {
        if (val != null || isEmptyAttrOK) {
            sb.append("<");
            sb.append(tag);
            sb.append(">");
            if (useCData) {
                sb.append("<![CDATA[");
            }
            sb.append(val);
            if (useCData) {
                sb.append("]]>");
            }
            sb.append("</");
            sb.append(tag);
            sb.append(">\n");
        }
    }

    public static void xmlProps(StringBuilder sb, Properties props) {
        if (props != null) {
            int i = 0;
            for (Object key : props.keySet()) {
                if (i > 0) {
                    sb.append(';');
                }
                sb.append(key.toString());
                sb.append("=");
                sb.append(props.getProperty(key.toString()));
                ++i;
            }
        }
    }
}

