/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import edu.ku.brc.af.prefs.AppPreferences;

public class ProxyHelper {
    public static final String PROXY_HOST = "PROXY_HOST";
    public static final String PROXY_PORT = "PROXY_PORT";
    public static final String PROXY_HOST_HTTPS = "PROXY_HOST_HTTPS";
    public static final String PROXY_PORT_HTTPS = "PROXY_PORT_HTTPS";
    public static final String PROXY_TYPE = "PROXY_TYPE";

    public static void registerProxy(String proxyHost, String proxyPort, String proxyHostHttps, String proxyPortHttps, boolean doPrefsAlso) {
        ProxyHelper.setSysProp("http.proxyHost", proxyHost);
        ProxyHelper.setSysProp("http.proxyPort", proxyPort);
        ProxyHelper.setSysProp("https.proxyHost", proxyHostHttps);
        ProxyHelper.setSysProp("https.proxyPort", proxyPortHttps);
        if (doPrefsAlso) {
            ProxyHelper.setProp(PROXY_HOST, proxyHost);
            ProxyHelper.setProp(PROXY_PORT, proxyPort);
            ProxyHelper.setProp(PROXY_HOST_HTTPS, proxyHostHttps);
            ProxyHelper.setProp(PROXY_PORT_HTTPS, proxyPortHttps);
        }
    }

    private static void setSysProp(String name, String value) {
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.clearProperty(name);
        }
    }

    private static void setProp(String name, String value) {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        if (value != null) {
            localPrefs.put(name, value);
        } else {
            localPrefs.remove(name);
        }
    }

    public static void clearProxySettings(boolean doPrefsAlso) {
        ProxyHelper.registerProxy(null, null, null, null, true);
    }

    public static void setProxySettingsFromPrefs() {
        AppPreferences localPrefs = AppPreferences.getLocalPrefs();
        ProxyHelper.registerProxy(localPrefs.get(PROXY_HOST, null), localPrefs.get(PROXY_PORT, null), localPrefs.get(PROXY_HOST_HTTPS, null), localPrefs.get(PROXY_PORT_HTTPS, null), false);
    }
}

