/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Encryption {
    private static final Logger log = Logger.getLogger(Encryption.class);
    private static String encryptDecryptPassword = "KU BRC Specify";
    static final int ITERATION_COUNT = 1000;
    static final int SALT_LENGTH = 8;
    static final String ALGORITHM = "PBEWithMD5AndDES";
    static final String EXTRA_PROVIDER = null;

    public static String getEncryptDecryptPassword() {
        return encryptDecryptPassword;
    }

    public static void setEncryptDecryptPassword(String encryptDecryptPassword) {
        Encryption.encryptDecryptPassword = encryptDecryptPassword;
    }

    public static byte[] encrypt(byte[] input, char[] password) throws Exception {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[8];
        sr.nextBytes(salt);
        PBEKeySpec keyspec = new PBEKeySpec(password, salt, 1000);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey key = skf.generateSecret(keyspec);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PBEParameterSpec paramspec = new PBEParameterSpec(salt, 1000);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)key, paramspec, sr);
        baos.write(salt);
        baos.write(cipher.doFinal(input));
        keyspec.clearPassword();
        return baos.toByteArray();
    }

    public static byte[] decrypt(byte[] input, char[] password) throws Exception {
        byte[] salt = new byte[8];
        System.arraycopy(input, 0, salt, 0, 8);
        PBEKeySpec keyspec = new PBEKeySpec(password, salt, 1000);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
        SecretKey key = skf.generateSecret(keyspec);
        PBEParameterSpec paramspec = new PBEParameterSpec(salt, 1000);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)key, paramspec);
        byte[] output = cipher.doFinal(input, 8, input.length - 8);
        keyspec.clearPassword();
        return output;
    }

    public static String makeHEXStr(byte[] bytes) {
        StringBuffer strBuf = new StringBuffer(bytes.length + 50);
        int i = 0;
        while (i < bytes.length) {
            String s = Integer.toHexString(bytes[i] & 0xFF);
            if (s.length() == 1) {
                s = "0" + s;
            }
            strBuf.append(s.toUpperCase());
            ++i;
        }
        return strBuf.toString();
    }

    public static byte[] reverseHEXStr(String str) {
        int len = str.length() / 2;
        byte[] bytes = new byte[len];
        int inx = 0;
        int i = 0;
        while (i < len) {
            int iVal = Integer.parseInt(str.substring(inx, inx + 2), 16);
            bytes[i] = (byte)(iVal > 127 ? iVal - 256 : iVal);
            inx += 2;
            ++i;
        }
        return bytes;
    }

    public static String decrypt(String str) {
        return Encryption.decrypt(str, encryptDecryptPassword);
    }

    public static String decrypt(String str, String key) {
        if (StringUtils.isEmpty((String)str) || StringUtils.isEmpty((String)key)) {
            return "";
        }
        try {
            return new String(Encryption.decrypt(Encryption.reverseHEXStr(str), key.toCharArray()));
        }
        catch (BadPaddingException bpex) {
            log.debug((Object)"Error decrypting password.");
            return null;
        }
        catch (Exception ex) {
            log.error((Object)"Error decrypting password.");
            return str;
        }
    }

    public static String encrypt(String str) {
        return Encryption.encrypt(str, encryptDecryptPassword);
    }

    public static String encrypt(String str, String key) {
        if (StringUtils.isEmpty((String)str) || StringUtils.isEmpty((String)key)) {
            return "";
        }
        try {
            return Encryption.makeHEXStr(Encryption.encrypt(str.getBytes(), key.toCharArray()));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(Encryption.class, ex);
            log.error((Object)"Error endcrypting password.");
            return str;
        }
    }

    public static void main(String[] args) throws Exception {
        if (EXTRA_PROVIDER != null) {
            Provider prov = (Provider)Class.forName(EXTRA_PROVIDER).newInstance();
            Security.addProvider(prov);
        }
        String input = "Hello World!";
        String password = "abcd";
        byte[] inputBytes = input.getBytes();
        char[] passwordChars = password.toCharArray();
        byte[] ciphertext = Encryption.encrypt(inputBytes, passwordChars);
        System.out.println("Ciphertext:");
        int i = 0;
        while (i < ciphertext.length) {
            String s = Integer.toHexString(ciphertext[i] & 0xFF);
            if (s.length() == 1) {
                s = "0" + s;
            }
            System.out.print(s);
            if (i % 30 == 29) {
                System.out.println();
            }
            ++i;
        }
        if ((ciphertext.length - 1) % 30 != 29) {
            System.out.println();
        }
        String hexText = Encryption.makeHEXStr(ciphertext);
        System.out.println("To:   [" + hexText + "]");
        System.out.println("From: [" + Encryption.reverseHEXStr(hexText) + "]****");
        byte[] output = Encryption.decrypt(ciphertext, passwordChars);
        String sOutput = new String(output);
        System.out.println("Plaintext:\n" + sOutput);
    }
}

