/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.mail.smtp.SMTPTransport;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EMailHelper {
    private static final Logger log = Logger.getLogger(EMailHelper.class);
    public static final String POP3_STR = "POP3";
    public static final String IMAP_STR = "IMAP";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String HTML_TEXT = "text/html";
    protected static final EMailHelper instance = new EMailHelper();
    protected String lastErrorMsg = "";
    protected boolean isDebugging = false;
    protected List<MailBoxInfo> mailBoxCache = new ArrayList<MailBoxInfo>();

    protected EMailHelper() {
    }

    public static EMailHelper getInstance() {
        return instance;
    }

    /*
     * Exception decompiling
     */
    public static ErrorType sendMsg(String host, String uName, String pWord, String fromEMailAddr, String toEMailAddr, String subject, String bodyText, String mimeType, String port, String security, File fileAttachment) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 8[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String askForPassword(Frame topframe) {
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p", "p,2px,p"));
        CellConstraints cc = new CellConstraints();
        JLabel label = UIHelper.createI18NFormLabel("EMailHelper.PASSWORD");
        JPasswordField passField = UIHelper.createPasswordField(25);
        JCheckBox savePassword = UIHelper.createCheckBox(UIRegistry.getResourceString("EMailHelper.SAVE_PASSWORD"));
        builder.add((Component)label, cc.xy(1, 1));
        builder.add((Component)passField, cc.xy(3, 1));
        builder.add((Component)savePassword, cc.xy(3, 3));
        JOptionPane.showConfirmDialog(topframe, builder.getPanel(), UIRegistry.getResourceString("EMailHelper.PASSWORD_TITLE"), 2, 3);
        String passwordText = new String(passField.getPassword());
        if (savePassword.isSelected()) {
            AppPreferences appPrefs = AppPreferences.getRemote();
            if (StringUtils.isNotEmpty((String)passwordText)) {
                appPrefs.put("settings.email.password", Encryption.encrypt(passwordText));
            }
        }
        return passwordText;
    }

    public static ArrayList<String> askForUserAndPassword(Frame topframe) {
        ArrayList<String> userAndPass = new ArrayList<String>();
        AppPreferences remotePrefs = AppPreferences.getRemote();
        String remoteUsername = remotePrefs.get("settings.email.username", null);
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p", "p,2px,p,2px,p"));
        CellConstraints cc = new CellConstraints();
        JLabel plabel = UIHelper.createI18NFormLabel("EMailHelper.PASSWORD");
        JLabel ulabel = UIHelper.createI18NFormLabel("EMailHelper.USERNAME");
        JPasswordField passField = UIHelper.createPasswordField(25);
        JTextField userField = UIHelper.createTextField(remoteUsername, 25);
        JCheckBox savePassword = UIHelper.createCheckBox(UIRegistry.getResourceString("EMailHelper.SAVE_PASSWORD"));
        builder.add((Component)ulabel, cc.xy(1, 1));
        builder.add((Component)userField, cc.xy(3, 1));
        builder.add((Component)plabel, cc.xy(1, 3));
        builder.add((Component)passField, cc.xy(3, 3));
        builder.add((Component)savePassword, cc.xy(3, 5));
        Integer option = JOptionPane.showConfirmDialog(topframe, builder.getPanel(), UIRegistry.getResourceString("EMailHelper.PASSWORD_TITLE"), 2, 3);
        String passwordText = new String(passField.getPassword());
        String userText = new String(userField.getText());
        if (savePassword.isSelected() && StringUtils.isNotEmpty((String)passwordText)) {
            remotePrefs.put("settings.email.password", Encryption.encrypt(passwordText));
        }
        if (option == 2) {
            return null;
        }
        userAndPass.add(0, userText);
        userAndPass.add(1, passwordText);
        return userAndPass;
    }

    public static boolean isEMailPrefsOK(Hashtable<String, String> emailPrefs) {
        String[] emailPrefNames;
        AppPreferences remotePrefs = AppPreferences.getRemote();
        boolean allOK = true;
        String[] stringArray = emailPrefNames = new String[]{"smtp", "username", "password", "email", "port", "security"};
        int n = emailPrefNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pName = stringArray[n2];
            String key = "settings.email." + pName;
            String value = remotePrefs.get(key, "");
            if (StringUtils.isNotEmpty((String)value) || pName.equals("password") || pName.equals("port")) {
                emailPrefs.put(pName, value);
            } else if (!key.equals("security")) {
                log.info((Object)("Key[" + key + "] is empty"));
                allOK = false;
                break;
            }
            ++n2;
        }
        return allOK;
    }

    public static AccountType getAccountType(String acctType) {
        if (acctType != null) {
            try {
                return AccountType.valueOf(acctType);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(EMailHelper.class, ex);
                return AccountType.Unknown;
            }
        }
        return AccountType.Unknown;
    }

    public static boolean isIMAP(String acctType) {
        return acctType != null && acctType.equals(IMAP_STR);
    }

    public static boolean hasEMailSettings(String usernameStr, String passwordStr, String emailStr, String smtpStr, String serverNameStr, String acctTypeStr, String localMailBoxStr) {
        AccountType acctType = EMailHelper.getAccountType(acctTypeStr);
        return acctType != AccountType.Unknown && StringUtils.isNotEmpty((String)usernameStr) && StringUtils.isNotEmpty((String)passwordStr) && StringUtils.isNotEmpty((String)emailStr) && StringUtils.isNotEmpty((String)smtpStr) && StringUtils.isNotEmpty((String)serverNameStr) && (acctType == AccountType.IMAP || acctType == AccountType.POP3 || StringUtils.isNotEmpty((String)localMailBoxStr));
    }

    public static boolean hasEMailSettings() {
        String usernameStr = AppPreferences.getRemote().get("settings.email.username", null);
        String passwordStr = Encryption.decrypt(AppPreferences.getRemote().get("settings.email.password", null));
        String emailStr = AppPreferences.getRemote().get("settings.email.email", null);
        String smtpStr = AppPreferences.getRemote().get("settings.email.smtp", null);
        String serverNameStr = AppPreferences.getRemote().get("settings.email.servername", null);
        String acctTypeStr = AppPreferences.getRemote().get("settings.email.accounttype", null);
        String localMailBoxStr = AppPreferences.getRemote().get("settings.email.localmailbox", null);
        return EMailHelper.hasEMailSettings(usernameStr, passwordStr, emailStr, smtpStr, serverNameStr, acctTypeStr, localMailBoxStr);
    }

    public static boolean getMessagesFromInbox(Store store, List<Message> msgList) {
        try {
            Folder inbox = store.getDefaultFolder().getFolder("Inbox");
            inbox.open(1);
            Message[] messages = inbox.getMessages();
            Collections.addAll(msgList, messages);
            EMailHelper eMailHelper = instance;
            eMailHelper.getClass();
            MailBoxInfo mbx = eMailHelper.new MailBoxInfo(store, inbox);
            EMailHelper.instance.mailBoxCache.add(mbx);
            return true;
        }
        catch (MessagingException mex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(EMailHelper.class, (Exception)((Object)mex));
            EMailHelper.instance.lastErrorMsg = mex.toString();
            return false;
        }
    }

    public static boolean getAvailableMsgs(List<Message> msgList) {
        boolean status;
        block11: {
            status = false;
            msgList.clear();
            try {
                Store store;
                Session session;
                Properties props;
                String usernameStr = AppPreferences.getRemote().get("settings.email.username", null);
                String passwordStr = Encryption.decrypt(AppPreferences.getRemote().get("settings.email.password", null));
                String emailStr = AppPreferences.getRemote().get("settings.email.email", null);
                String smtpStr = AppPreferences.getRemote().get("settings.email.smtp", null);
                String serverNameStr = AppPreferences.getRemote().get("settings.email.servername", null);
                String acctTypeStr = AppPreferences.getRemote().get("settings.email.accounttype", null);
                String localMailBoxStr = AppPreferences.getRemote().get("settings.email.localmailbox", null);
                AccountType acctType = EMailHelper.getAccountType(acctTypeStr);
                if (!EMailHelper.hasEMailSettings(usernameStr, passwordStr, emailStr, smtpStr, serverNameStr, acctTypeStr, localMailBoxStr)) {
                    JOptionPane.showMessageDialog(UIRegistry.getMostRecentWindow(), UIRegistry.getResourceString("EMailHelper.EMAIL_SET_NOT_VALID"));
                }
                if (acctTypeStr.equals(UIRegistry.getResourceString("EMailHelper.POP3"))) {
                    try {
                        props = new Properties();
                        session = Session.getDefaultInstance((Properties)props);
                        store = session.getStore(new URLName("mstor:" + localMailBoxStr));
                        store.connect();
                        status = EMailHelper.getMessagesFromInbox(store, msgList);
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(EMailHelper.class, ex);
                        EMailHelper.instance.lastErrorMsg = ex.toString();
                        ex.printStackTrace();
                        status = false;
                    }
                } else {
                    throw new RuntimeException("Unknown Account Type [" + acctTypeStr + "] must be POP3 or IMAP");
                }
                try {
                    String msgStr;
                    props = System.getProperties();
                    session = Session.getInstance((Properties)props, null);
                    if (acctType == AccountType.POP3) {
                        store = session.getStore("pop3");
                        store.connect(serverNameStr, usernameStr, passwordStr);
                        status = EMailHelper.getMessagesFromInbox(store, msgList);
                        break block11;
                    }
                    if (acctType == AccountType.IMAP) {
                        store = session.getStore("imap");
                        store.connect(serverNameStr, usernameStr, passwordStr);
                        status = EMailHelper.getMessagesFromInbox(store, msgList);
                        break block11;
                    }
                    EMailHelper.instance.lastErrorMsg = msgStr = String.valueOf(UIRegistry.getResourceString("EMailHelper.UNKNOWN_ACCT_TYPE")) + acctTypeStr + UIRegistry.getResourceString("EMailHelper.ACCT_TYPE_MUST_BE");
                    throw new RuntimeException(msgStr);
                }
                catch (Exception ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(EMailHelper.class, ex);
                    EMailHelper.instance.lastErrorMsg = ex.toString();
                    status = false;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(EMailHelper.class, ex);
                EMailHelper.instance.lastErrorMsg = ex.toString();
                status = false;
            }
        }
        return status;
    }

    public static String getLastErrorMsg() {
        return EMailHelper.instance.lastErrorMsg;
    }

    public static boolean isDebugging() {
        return EMailHelper.instance.isDebugging;
    }

    public static void setDebugging(boolean isDebugging) {
        EMailHelper.instance.isDebugging = isDebugging;
    }

    public static void closeAllMailBoxes() {
        for (MailBoxInfo mbx : EMailHelper.instance.mailBoxCache) {
            mbx.close();
        }
        EMailHelper.instance.mailBoxCache.clear();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean sendMsgAsGMail(String host, String uName, String pWord, String fromEMailAddr, String toEMailAddr, String subject, String bodyText, String mimeType, String port, String security, File fileAttachment) {
        String userName = uName;
        String password = pWord;
        Boolean fail = false;
        ArrayList<Object> userAndPass = new ArrayList();
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", "587");
        props.put("mail.smtp.starttls.enable", "true");
        boolean usingSSL = false;
        if (usingSSL) {
            props.put("mail.smtps.port", "587");
            props.put("mail.smtp.starttls.enable", "true");
        }
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(EMailHelper.instance.isDebugging);
        if (EMailHelper.instance.isDebugging) {
            log.debug((Object)("Host:     " + host));
            log.debug((Object)("UserName: " + userName));
            log.debug((Object)("Password: " + password));
            log.debug((Object)("From:     " + fromEMailAddr));
            log.debug((Object)("To:       " + toEMailAddr));
            log.debug((Object)("Subject:  " + subject));
        }
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(fromEMailAddr));
            if (toEMailAddr.indexOf(",") > -1) {
                StringTokenizer st = new StringTokenizer(toEMailAddr, ",");
                InternetAddress[] address = new InternetAddress[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String toStr = st.nextToken().trim();
                    address[i++] = new InternetAddress(toStr);
                }
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            } else {
                InternetAddress[] address = new InternetAddress[]{new InternetAddress(toEMailAddr)};
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            }
            msg.setSubject(subject);
            if (fileAttachment != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setContent((Object)bodyText, mimeType);
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(fileAttachment);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(fds.getName());
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                msg.setContent((Multipart)mp);
            } else {
                msg.setContent((Object)bodyText, mimeType);
            }
            msg.setSentDate(new Date());
            int cnt = 0;
            do {
                ++cnt;
                SMTPTransport t = (SMTPTransport)session.getTransport("smtp");
                try {
                    t.connect(host, userName, password);
                    t.sendMessage((Message)msg, msg.getAllRecipients());
                    fail = false;
                }
                catch (MessagingException mex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(EMailHelper.class, (Exception)((Object)mex));
                    EMailHelper.instance.lastErrorMsg = mex.toString();
                    Exception ex = null;
                    ex = mex.getNextException();
                    if (ex != null) {
                        ex.printStackTrace();
                        EMailHelper.instance.lastErrorMsg = String.valueOf(EMailHelper.instance.lastErrorMsg) + ", " + ex.toString();
                    }
                    if (!mex.toString().equals("javax.mail.AuthenticationFailedException")) continue;
                    fail = true;
                    userAndPass = EMailHelper.askForUserAndPassword((Frame)UIRegistry.getTopWindow());
                    if (userAndPass == null) {
                        log.debug((Object)("Response: " + t.getLastServerResponse()));
                        t.close();
                        return false;
                    }
                    try {
                        userName = (String)userAndPass.get(0);
                        password = (String)userAndPass.get(1);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        log.debug((Object)("Response: " + t.getLastServerResponse()));
                        t.close();
                    }
                }
                log.debug((Object)("Response: " + t.getLastServerResponse()));
                t.close();
            } while (fail.booleanValue() && cnt < 6);
        }
        catch (MessagingException mex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(EMailHelper.class, (Exception)((Object)mex));
            EMailHelper.instance.lastErrorMsg = mex.toString();
            Exception ex = null;
            ex = mex.getNextException();
            if (ex != null) {
                ex.printStackTrace();
                EMailHelper.instance.lastErrorMsg = String.valueOf(EMailHelper.instance.lastErrorMsg) + ", " + ex.toString();
            }
            return false;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(EMailHelper.class, ex);
            ex.printStackTrace();
        }
        return fail == false;
    }

    public static boolean isGmailEmail() {
        String smtpStr = AppPreferences.getRemote().get("settings.email.smtp", null);
        return StringUtils.isNotEmpty((String)smtpStr) && smtpStr.equals("smtp.gmail.com");
    }

    public static enum AccountType {
        Unknown,
        POP3,
        IMAP;

    }

    public static enum ErrorType {
        OK,
        Cancel,
        Error;

    }

    class MailBoxInfo {
        protected Store store;
        protected Folder folder;

        public MailBoxInfo(Store store, Folder folder) {
            this.store = store;
            this.folder = folder;
        }

        public Folder getFolder() {
            return this.folder;
        }

        public Store getStore() {
            return this.store;
        }

        public void close() {
            try {
                this.folder.close(false);
                this.store.close();
            }
            catch (MessagingException mex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(EMailHelper.class, (Exception)((Object)mex));
                EMailHelper.instance.lastErrorMsg = mex.toString();
            }
        }
    }
}

