/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.helpers;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;

public class BrowserLauncher {
    private static final String errMsg = UIRegistry.getResourceString("BrowserLauncher.ERROR_LAUNCH_BROWSER");

    public static void openURL(String url) {
        UIHelper.OSTYPE osType = UIHelper.getOSType();
        try {
            if (osType == UIHelper.OSTYPE.MacOSX) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osType == UIHelper.OSTYPE.Windows) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "mozilla", "epiphany", "opera", "konqueror", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(BrowserLauncher.class, e);
            JOptionPane.showMessageDialog(null, String.valueOf(errMsg) + ":\n" + e.getLocalizedMessage());
        }
    }
}

