/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class TableModel2Excel {
    private static final Logger log = Logger.getLogger(TableModel2Excel.class);
    protected static TableModel2Excel instance = new TableModel2Excel();

    public static String getFileNameWithoutExt(String path) {
        int inx = path.indexOf(File.separator);
        return path.substring(inx + 1, path.lastIndexOf(46));
    }

    public static File getTempExcelName() {
        String prefix = "collection_items_";
        String ext = ".xls";
        try {
            String fileName = TableModel2Excel.getFileNameWithoutExt(File.createTempFile(prefix, null).getName());
            return new File(String.valueOf(fileName) + ext);
        }
        catch (IOException ioex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TableModel2Excel.class, ioex);
            return new File(String.valueOf(prefix) + Long.toString(new Date().getTime()) + ext);
        }
    }

    public static File convertToExcel(String title, TableModel tableModel) {
        return TableModel2Excel.convertToExcel(TableModel2Excel.getTempExcelName(), title, tableModel);
    }

    protected static void setBordersOnStyle(HSSFCellStyle style, short colorIndex, short borderStyle) {
        style.setBorderBottom(borderStyle);
        style.setBottomBorderColor(colorIndex);
        style.setBorderLeft(borderStyle);
        style.setLeftBorderColor(colorIndex);
        style.setBorderRight(borderStyle);
        style.setRightBorderColor(colorIndex);
        style.setBorderTop(borderStyle);
        style.setTopBorderColor(colorIndex);
    }

    public static File convertToExcel(File toFile, String title, TableModel tableModel) {
        if (toFile == null) {
            UIRegistry.showLocalizedMsg("WARNING", "FILE_NO_EXISTS", toFile != null ? toFile.getAbsolutePath() : "");
            return null;
        }
        if (tableModel != null && tableModel.getRowCount() > 0) {
            FileOutputStream out;
            try {
                out = new FileOutputStream(toFile);
            }
            catch (FileNotFoundException ex) {
                UIRegistry.showLocalizedMsg("WARNING", "FILE_NO_WRITE", toFile != null ? toFile.getAbsolutePath() : "");
                return null;
            }
            try {
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet();
                HSSFFont headerFont = wb.createFont();
                headerFont.setFontHeightInPoints((short)12);
                headerFont.setBoldweight((short)700);
                HSSFCellStyle headerStyle = wb.createCellStyle();
                headerStyle.setAlignment((short)2);
                headerStyle.setFont(headerFont);
                TableModel2Excel.setBordersOnStyle(headerStyle, (short)22, (short)1);
                short s = tableModel.getColumnCount();
                HSSFRow headerRow = sheet.createRow(0);
                int i = 0;
                while (i < s) {
                    HSSFCell headerCell = headerRow.createCell((short)i);
                    headerCell.setCellStyle(headerStyle);
                    headerCell.setCellValue(tableModel.getColumnName(i));
                    sheet.setColumnWidth((short)i, (short)7680);
                    ++i;
                }
                HSSFCellStyle oddCellStyle = wb.createCellStyle();
                HSSFCellStyle evenCellStyle = wb.createCellStyle();
                TableModel2Excel.setBordersOnStyle(oddCellStyle, (short)22, (short)1);
                TableModel2Excel.setBordersOnStyle(evenCellStyle, (short)22, (short)1);
                HSSFFont cellFont = wb.createFont();
                cellFont.setFontHeightInPoints((short)11);
                oddCellStyle.setFont(cellFont);
                evenCellStyle.setFont(cellFont);
                evenCellStyle.setFillPattern((short)1);
                oddCellStyle.setFillPattern((short)1);
                oddCellStyle.setFillForegroundColor((short)9);
                evenCellStyle.setFillForegroundColor((short)31);
                oddCellStyle.setAlignment((short)2);
                evenCellStyle.setAlignment((short)2);
                wb.setSheetName(0, title);
                short rownum = 0;
                while (rownum < (short)tableModel.getRowCount()) {
                    HSSFRow row = sheet.createRow(rownum + 1);
                    short cellnum = 0;
                    while (cellnum < s) {
                        HSSFCell cell = row.createCell(cellnum);
                        Object dataVal = tableModel.getValueAt(rownum, cellnum);
                        cell.setCellValue(dataVal != null ? dataVal.toString() : "");
                        cell.setCellStyle(rownum % 2 == 0 ? evenCellStyle : oddCellStyle);
                        cellnum = (short)(cellnum + 1);
                    }
                    rownum = (short)(rownum + 1);
                }
                wb.write((OutputStream)out);
                out.close();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(TableModel2Excel.class, ex);
                log.error((Object)"convertToExcel", (Throwable)ex);
            }
        }
        return toFile;
    }

    public static StringBuilder convertToHTML(String title, TableModel tableModel) {
        StringBuilder strBuilder = new StringBuilder(512);
        strBuilder.append("<table border=1>");
        if (tableModel != null && tableModel.getRowCount() > 0) {
            int i = 0;
            while (i < tableModel.getColumnCount()) {
                strBuilder.append("<td align=center>");
                strBuilder.append(tableModel.getColumnName(i));
                strBuilder.append("</td>");
                ++i;
            }
            strBuilder.append("</tr>\n");
            int rownum = 0;
            while (rownum < tableModel.getRowCount()) {
                strBuilder.append("<tr>\n");
                int cellnum = 0;
                while (cellnum < tableModel.getColumnCount()) {
                    strBuilder.append("<td align=center>");
                    Object data = tableModel.getValueAt(rownum, cellnum);
                    strBuilder.append(data != null ? data.toString() : "&nbsp;");
                    strBuilder.append("</td>");
                    cellnum = (short)(cellnum + 1);
                }
                strBuilder.append("</tr>\n");
                ++rownum;
            }
            strBuilder.append("</table>\n");
        }
        return strBuilder;
    }
}

