/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import com.mysql.jdbc.CommunicationsException;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.QueryExecutor;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SQLExecutionProcessor {
    private static final Logger log = Logger.getLogger(SQLExecutionProcessor.class);
    private static long lastErrorTime = 0L;
    protected SQLExecutionListener listener;
    protected String sqlStr;
    protected Connection dbConnection;
    protected Statement dbStatement = null;
    protected boolean isAutoCloseConnection = true;
    protected QueryExecutor queryExecutor;
    protected Object data = null;
    protected boolean inError = false;

    public SQLExecutionProcessor(SQLExecutionListener listener, String sqlStr) {
        this(null, null, listener, sqlStr);
    }

    public SQLExecutionProcessor(QueryExecutor queryExecutor, SQLExecutionListener listener, String sqlStr) {
        this(null, queryExecutor, listener, sqlStr);
    }

    public SQLExecutionProcessor(Connection dbConnection, SQLExecutionListener listener, String sqlStr) {
        this(dbConnection, null, listener, sqlStr);
    }

    public SQLExecutionProcessor(Connection dbConnection, QueryExecutor queryExecutor, SQLExecutionListener listener, String sqlStr) {
        this.dbConnection = dbConnection;
        this.queryExecutor = queryExecutor == null ? QueryExecutor.getInstance() : queryExecutor;
        this.listener = listener;
        this.sqlStr = this.trimStr(sqlStr);
        this.isAutoCloseConnection = dbConnection == null;
    }

    public SQLExecutionListener getListener() {
        return this.listener;
    }

    public boolean isAutoCloseConnection() {
        return this.isAutoCloseConnection;
    }

    public void setAutoCloseConnection(boolean isAutoCloseConnection) {
        this.isAutoCloseConnection = isAutoCloseConnection;
    }

    protected String trimStr(String str) {
        return str.replace("\n", "").replace("\t", "").replace("\r", "").trim();
    }

    public void setSqlStr(String sqlStr) {
        this.sqlStr = this.trimStr(sqlStr);
    }

    public String getSqlStr() {
        return this.sqlStr;
    }

    public void close() {
        try {
            if (this.dbStatement != null) {
                this.dbStatement.close();
                this.dbStatement = null;
            }
            if (this.dbConnection != null && this.isAutoCloseConnection) {
                this.dbConnection.close();
                this.dbConnection = null;
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(SQLExecutionProcessor.class, ex);
            log.error((Object)ex);
        }
    }

    public void closeStatement() {
        try {
            if (this.dbStatement != null) {
                this.dbStatement.close();
                this.dbStatement = null;
            }
        }
        catch (SQLException ex) {
            UsageTracker.incrSQLUsageCount();
            ExceptionTracker.getInstance().capture(SQLExecutionProcessor.class, ex);
            log.error((Object)ex);
        }
    }

    public void start() {
        QueryExecutor.getInstance().executeQuery(this);
    }

    public void execute() {
        block13: {
            try {
                if (this.dbConnection == null) {
                    this.dbConnection = DBConnection.getInstance().createConnection();
                }
                if (this.dbConnection != null) {
                    if (this.dbStatement != null) {
                        this.dbStatement.close();
                    }
                    this.dbStatement = this.dbConnection.createStatement(1005, 1007);
                    if (this.sqlStr.trim().toLowerCase().startsWith("select")) {
                        ResultSet rs = this.dbStatement.executeQuery(this.sqlStr);
                        this.listener.exectionDone(this, rs);
                        this.inError = true;
                    } else {
                        this.dbStatement.executeUpdate(this.sqlStr);
                        this.listener.exectionDone(this, null);
                    }
                    if (this.isAutoCloseConnection) {
                        this.close();
                    }
                }
            }
            catch (SQLException ex) {
                long now = System.currentTimeMillis();
                boolean showError = now - lastErrorTime > 2000L;
                lastErrorTime = now;
                if (showError) {
                    UsageTracker.incrSQLUsageCount();
                    if (ex instanceof CommunicationsException) {
                        CommandDispatcher.dispatch(new CommandAction("ERRMSG", "DISPLAY", this, null, "BAD_CONNECTION"));
                        return;
                    }
                    ExceptionTracker.getInstance().capture(SQLExecutionProcessor.class, ex);
                    log.error((Object)("Error in run[" + this.sqlStr + "]"), (Throwable)ex);
                    return;
                }
                if (this.listener != null) {
                    this.listener.executionError(this, ex);
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                long now = System.currentTimeMillis();
                boolean showError = now - lastErrorTime > 2000L;
                lastErrorTime = now;
                if (showError) {
                    ExceptionTracker.getInstance().capture(SQLExecutionProcessor.class, ex);
                    log.error((Object)("Error in run[" + this.sqlStr + "]"), (Throwable)ex);
                }
                if (this.listener == null) break block13;
                this.listener.executionError(this, ex);
            }
        }
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

