/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.QRCProcessorListener;
import edu.ku.brc.dbsupport.QueryResultsContainer;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsListener;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class QueryResultsSerializedGetter
implements QRCProcessorListener {
    private static final Logger log = Logger.getLogger(QueryResultsSerializedGetter.class);
    protected Vector<QueryResultsContainerIFace> qrcs = new Vector();
    protected boolean hasFailed = false;
    protected QueryResultsListener listener;
    protected boolean hasProcessingStarted = false;
    protected int currentProcessingIndex;
    protected Connection connection = null;

    public QueryResultsSerializedGetter(QueryResultsListener listener) {
        this.listener = listener;
    }

    public QueryResultsSerializedGetter(QueryResultsListener listener, boolean isSerialized) {
        this.listener = listener;
    }

    public void add(QueryResultsContainerIFace qrc) {
        this.qrcs.addElement(qrc);
    }

    public void add(List<QueryResultsContainerIFace> qrcsArg) {
        if (qrcsArg != null) {
            this.qrcs.addAll(qrcsArg);
        }
        this.currentProcessingIndex = 0;
        if (this.qrcs.size() > 0) {
            this.startContainer(this.qrcs.get(this.currentProcessingIndex));
        }
    }

    protected void startContainer(QueryResultsContainerIFace qrc) {
        if (this.hasProcessingStarted) {
            throw new RuntimeException("Processing has already started!.");
        }
        if (this.connection == null) {
            this.connection = DBConnection.getInstance().createConnection();
        }
        qrc.start(this, this.connection);
    }

    public void add(QueryResultsContainer qrc, boolean startProcessing) {
        this.qrcs.addElement(qrc);
        if (startProcessing) {
            if (this.hasProcessingStarted) {
                throw new RuntimeException("Processing has already been started!");
            }
            this.hasProcessingStarted = true;
            this.currentProcessingIndex = 0;
            this.startContainer(this.qrcs.firstElement());
        }
    }

    public List<QueryResultsContainerIFace> getQueryResultsContainers() {
        return this.qrcs;
    }

    public void clear() {
        for (QueryResultsContainerIFace qrc : this.qrcs) {
            qrc.clear();
        }
        this.qrcs.clear();
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException ex) {
                UsageTracker.incrSQLUsageCount();
                ExceptionTracker.getInstance().capture(QueryResultsSerializedGetter.class, ex);
                log.error((Object)ex);
            }
        }
    }

    @Override
    public synchronized void exectionDone(QueryResultsContainerIFace qrc) {
        ++this.currentProcessingIndex;
        if (this.currentProcessingIndex == this.qrcs.size()) {
            this.listener.allResultsBack(qrc);
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (SQLException ex) {
                    UsageTracker.incrSQLUsageCount();
                    ExceptionTracker.getInstance().capture(QueryResultsSerializedGetter.class, ex);
                    log.error((Object)ex);
                }
            }
        } else {
            QueryResultsContainerIFace nxtQRC = this.qrcs.elementAt(this.currentProcessingIndex);
            nxtQRC.start(this, this.connection);
        }
    }

    @Override
    public synchronized void executionError(QueryResultsContainerIFace qrc) {
        this.hasFailed = true;
    }
}

