/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class QueryResultsDataObj {
    protected Object result = null;
    protected int row = 0;
    protected int col = 0;
    protected boolean isProcessable = true;
    protected String formatStr = "";

    public QueryResultsDataObj(int row, int col, String formatStr) {
        this.row = row;
        this.col = col;
        this.formatStr = formatStr;
    }

    public QueryResultsDataObj(int row, int col) {
        this(row, col, null);
    }

    public QueryResultsDataObj(Object result, String formatStr) {
        this.result = result;
        this.isProcessable = false;
        this.formatStr = formatStr;
    }

    public QueryResultsDataObj(Object result) {
        this(result, null);
    }

    public Object getResult() {
        if (StringUtils.isNotEmpty((String)this.formatStr)) {
            if (this.result instanceof BigDecimal && this.formatStr.startsWith("%") && this.formatStr.endsWith("f")) {
                this.result = ((BigDecimal)this.result).doubleValue();
            }
            return String.format(this.formatStr, this.result);
        }
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public boolean isProcessable() {
        return this.isProcessable;
    }

    public void clear() {
        this.result = null;
    }
}

