/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.QRCProcessorListener;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.dbsupport.SQLExecutionListener;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class QueryResultsContainer
implements QueryResultsContainerIFace,
SQLExecutionListener {
    private static final Logger log = Logger.getLogger(QueryResultsContainer.class);
    protected String sql;
    protected Vector<QueryResultsDataObj> qrdos = new Vector();
    protected QRCProcessorListener listener = null;
    protected SQLExecutionProcessor sqlProc;
    protected boolean hasFailed = false;

    public QueryResultsContainer() {
    }

    public QueryResultsContainer(String sql) {
        this.sql = sql;
    }

    @Override
    public List<QueryResultsDataObj> getQueryResultsDataObjs() {
        return this.qrdos;
    }

    @Override
    public void add(QueryResultsDataObj qrdo) {
        this.qrdos.addElement(qrdo);
    }

    protected void processResultSet(ResultSet resultSet) {
        block5: {
            if (resultSet != null) {
                try {
                    if (!resultSet.first()) break block5;
                    int prvRow = 1;
                    for (QueryResultsDataObj qrdo : this.qrdos) {
                        if (!qrdo.isProcessable()) continue;
                        int col = qrdo.getCol();
                        int row = qrdo.getRow();
                        if (!(row - 1 == prvRow ? !resultSet.next() : row != prvRow && !resultSet.absolute(row))) {
                            qrdo.setResult(resultSet.getObject(col));
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(QueryResultsContainer.class, ex);
                    log.error((Object)ex);
                }
            }
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public void clear() {
        for (QueryResultsDataObj qrdo : this.qrdos) {
            qrdo.clear();
        }
        this.qrdos.clear();
    }

    @Override
    public synchronized void start(QRCProcessorListener listenerArg, Connection connection) {
        this.listener = listenerArg;
        this.sqlProc = new SQLExecutionProcessor(connection, (SQLExecutionListener)this, this.sql);
        this.sqlProc.start();
    }

    @Override
    public synchronized boolean hasFailed() {
        return this.hasFailed;
    }

    @Override
    public synchronized void exectionDone(SQLExecutionProcessor process, ResultSet resultSet) {
        this.processResultSet(resultSet);
        this.sqlProc.close();
        this.sqlProc = null;
        final QueryResultsContainer thisItem = this;
        if (this.listener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryResultsContainer.this.listener.exectionDone(thisItem);
                }
            });
        }
    }

    @Override
    public synchronized void executionError(SQLExecutionProcessor process, Exception ex) {
        this.hasFailed = true;
        this.sqlProc.close();
        this.sqlProc = null;
        final QueryResultsContainer thisItem = this;
        if (this.listener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryResultsContainer.this.listener.executionError(thisItem);
                }
            });
        }
    }
}

