/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.SQLExecutionProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class QueryExecutor {
    private static QueryExecutor instance = new QueryExecutor();
    protected ExecutorService jpaQueryExecServ = null;

    public QueryExecutor() {
        this(5);
    }

    public QueryExecutor(int queueSize) {
        this.jpaQueryExecServ = Executors.newFixedThreadPool(queueSize);
    }

    public static QueryExecutor getInstance() {
        return instance;
    }

    public void shutdown() {
        this.jpaQueryExecServ.shutdownNow();
    }

    public Future<CustomQueryIFace> executeQuery(final CustomQueryIFace customQuery) {
        Callable<CustomQueryIFace> customQueryWorker = new Callable<CustomQueryIFace>(){

            @Override
            public CustomQueryIFace call() throws Exception {
                customQuery.execute();
                return customQuery;
            }
        };
        return this.jpaQueryExecServ.submit(customQueryWorker);
    }

    public void executeQuery(final SQLExecutionProcessor sqlExeProc) {
        Callable<SQLExecutionProcessor> sqlExeProcWorker = new Callable<SQLExecutionProcessor>(){

            @Override
            public SQLExecutionProcessor call() throws Exception {
                sqlExeProc.execute();
                return sqlExeProc;
            }
        };
        this.jpaQueryExecServ.submit(sqlExeProcWorker);
    }
}

