/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MySQLDMBSUserMgr
extends DBMSUserMgr {
    private static final int[] PERM_LIST = new int[]{1, 8, 2, 4, 16, 64, 128, 512};
    private static final Logger log = Logger.getLogger(MySQLDMBSUserMgr.class);
    private DBConnection dbConnection = null;
    private Connection connection = null;
    private String itUsername = null;
    private String itPassword = null;
    private DatabaseDriverInfo driverInfo = DatabaseDriverInfo.getDriver("MySQL");

    public MySQLDMBSUserMgr() {
        if (this.driverInfo == null || DBConnection.getInstance().isEmbedded()) {
            this.driverInfo = DatabaseDriverInfo.getDriver("MySQLEmbedded");
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean connectToDBMS(String itUsernameArg, String itPasswordArg, String databaseHost) {
        try {
            this.itUsername = itUsernameArg;
            this.itPassword = itPasswordArg;
            this.hostName = databaseHost;
            String connStr = this.driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Opensys, databaseHost, null);
            this.dbConnection = new DBConnection(itUsernameArg, itPasswordArg, connStr, this.driverInfo.getDriverClassName(), this.driverInfo.getDialectClassName(), null);
            if (this.dbConnection != null) {
                this.connection = this.dbConnection.createConnection();
            }
            return this.connection != null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean connect(String itUsernameArg, String itPasswordArg, String databaseHost, String dbName) {
        this.itUsername = itUsernameArg;
        this.itPassword = itPasswordArg;
        this.hostName = databaseHost;
        String connStr = this.driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Create, databaseHost, dbName);
        if (connStr == null) {
            connStr = this.driverInfo.getConnectionStr(DatabaseDriverInfo.ConnectionType.Open, databaseHost, dbName);
        }
        this.dbConnection = new DBConnection(itUsernameArg, itPasswordArg, connStr, this.driverInfo.getDriverClassName(), this.driverInfo.getDialectClassName(), dbName);
        if (this.connection == null) {
            this.connection = this.dbConnection.createConnection();
        }
        return this.connection != null;
    }

    @Override
    public List<String> getDatabaseList() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.connection != null) {
            Vector<Object> dbNames = BasicSQLUtils.querySingleCol(this.connection, "SELECT SCHEMA_NAME FROM information_schema.SCHEMATA WHERE SCHEMA_NAME <> 'information_schema' AND SCHEMA_NAME <> 'mysql' ORDER BY SCHEMA_NAME");
            for (Object nm : dbNames) {
                names.add(nm.toString());
            }
        }
        return names;
    }

    @Override
    public List<String> getDatabaseListForUser(String username) {
        ArrayList<String> dbNames;
        block11: {
            String[] permsArray = new String[]{"SELECT", "DELETE", "UPDATE", "INSERT", "LOCK TABLES"};
            HashSet permsHash = new HashSet();
            Collections.addAll(permsHash, permsArray);
            dbNames = new ArrayList<String>();
            try {
                if (this.connection == null) break block11;
                String userStr = String.format("'%s'@'%s'", username, this.hostName);
                String sql = "SHOW GRANTS";
                for (Object obj : BasicSQLUtils.querySingleCol(this.connection, sql)) {
                    String permsStr;
                    String[] pToks;
                    boolean isAllDBs = false;
                    String data = (String)obj;
                    String dbName = null;
                    System.out.println("->[" + data + "]");
                    if (StringUtils.contains((String)data, (String)userStr)) {
                        String[] toks = StringUtils.split((String)data, (char)'`');
                        if (toks.length > 2) {
                            dbName = toks[1];
                        }
                    } else if (StringUtils.contains((String)data, (String)"ON *.* TO")) {
                        isAllDBs = true;
                    }
                    if ((pToks = StringUtils.split((String)(permsStr = StringUtils.substringBetween((String)data, (String)"GRANT ", (String)" ON")), (char)',')) == null) continue;
                    if (pToks.length == 1 && pToks[0].equalsIgnoreCase("ALL PRIVILEGES") && isAllDBs) {
                        dbNames.addAll(this.getDatabaseList());
                        continue;
                    }
                    if (pToks.length < permsHash.size()) continue;
                    int cnt = 0;
                    String[] stringArray = pToks;
                    int n = pToks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        if (permsHash.contains(p.trim())) {
                            ++cnt;
                        }
                        ++n2;
                    }
                    if (cnt != permsHash.size()) continue;
                    if (isAllDBs) {
                        dbNames.addAll(this.getDatabaseList());
                        break;
                    }
                    if (dbName == null) continue;
                    dbNames.add(dbName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return dbNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canGrantPemissions(String hostMachineName, String username) {
        PreparedStatement pStmt = null;
        try {
            if (this.connection == null) return false;
            try {
                pStmt = this.connection.prepareStatement("SELECT Grant_priv FROM mysql.user WHERE Host = ? AND User = ?");
                pStmt.setString(1, hostMachineName);
                pStmt.setString(2, username);
                boolean hasPerm = false;
                ResultSet rs = pStmt.executeQuery();
                if (rs.next()) {
                    hasPerm = rs.getString(1).equals("Y");
                }
                rs.close();
                boolean bl = hasPerm;
                return bl;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return false;
            }
            finally {
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doesFieldExistInTable(String tableName, String fieldName) {
        try {
            String dbFieldName;
            DatabaseMetaData mdm = this.connection.getMetaData();
            ResultSet rs = mdm.getColumns(this.connection.getCatalog(), this.connection.getCatalog(), tableName, null);
            do {
                if (rs.next()) continue;
                rs.close();
                return false;
            } while (!(dbFieldName = rs.getString("COLUMN_NAME")).equals(fieldName));
            rs.close();
            return true;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public boolean createDatabase(String dbName) {
        try {
            int rv;
            if (this.connection != null && (rv = BasicSQLUtils.update(this.connection, "CREATE DATABASE " + dbName)) == 1) {
                String sql = String.format("GRANT ALL ON %s.* TO '%s'@'%s' IDENTIFIED BY '%s'", dbName, this.itUsername, this.hostName, this.itPassword);
                rv = BasicSQLUtils.update(this.connection, sql);
                return rv == 0;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean dropDatabase(String dbName) {
        try {
            if (this.connection != null) {
                int rv = BasicSQLUtils.update(this.connection, "DROP DATABASE " + dbName);
                return rv > -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean dropTable(String tableName) {
        try {
            if (this.connection != null) {
                int rv = BasicSQLUtils.update(this.connection, "DROP TABLE " + tableName);
                return rv > -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean dropUser(String username) {
        block21: {
            PreparedStatement pStmt = null;
            Statement delStmtUser = null;
            Statement delStmtDB = null;
            try {
                if (this.connection == null) break block21;
                boolean isOK = true;
                try {
                    try {
                        pStmt = this.connection.prepareStatement("SELECT host FROM mysql.user WHERE user = ?");
                        pStmt.setString(1, username);
                        delStmtUser = this.connection.prepareStatement("DELETE FROM mysql.user WHERE user = ? AND host = ?");
                        delStmtDB = this.connection.prepareStatement("DELETE FROM mysql.db WHERE user = ? AND host = ?");
                        ResultSet rs = pStmt.executeQuery();
                        while (rs.next()) {
                            String hostNm = rs.getString(1);
                            delStmtUser.setString(1, username);
                            delStmtUser.setString(2, hostNm);
                            if (delStmtUser.executeUpdate() == 0) {
                                isOK = false;
                                break;
                            }
                            delStmtDB.setString(1, username);
                            delStmtDB.setString(2, hostNm);
                            if (delStmtDB.executeUpdate() != 0) continue;
                            isOK = false;
                            break;
                        }
                        rs.close();
                        BasicSQLUtils.update(this.connection, "FLUSH PRIVILEGES");
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        isOK = false;
                        try {
                            if (pStmt != null) {
                                pStmt.close();
                            }
                            if (delStmtUser != null) {
                                delStmtUser.close();
                            }
                            if (delStmtDB != null) {
                                delStmtDB.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                finally {
                    try {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        if (delStmtUser != null) {
                            delStmtUser.close();
                        }
                        if (delStmtDB != null) {
                            delStmtDB.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                return isOK;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doesDBExists(String dbName) {
        if (dbName == null) return false;
        try {
            Object[] row;
            Iterator<Object[]> iterator = BasicSQLUtils.query(this.connection, "show databases").iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((row = iterator.next())[0] == null || !dbName.equalsIgnoreCase(row[0].toString()));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean doesUserExists(String userName) {
        Integer count = BasicSQLUtils.getCount(this.connection, String.format("SELECT count(*) FROM mysql.user WHERE User = '%s' AND Host = '%s'", userName, this.hostName));
        return count == null ? false : count == 1;
    }

    @Override
    public boolean changePassword(String username, String oldPwd, String newPwd) {
        block6: {
            Statement stmt = null;
            try {
                if (this.connection != null) {
                    stmt = this.connection.createStatement();
                    String sql = String.format("SELECT host,user,password FROM mysql.user WHERE host = '%s' AND user = '%s' and password = password('%s')", this.hostName, username, oldPwd);
                    Vector<Object[]> list = BasicSQLUtils.query(this.connection, sql);
                    if (list != null && list.size() == 1 && BasicSQLUtils.update(this.connection, sql = String.format("UPDATE mysql.user SET Password=PASSWORD('%s') WHERE User='%s' AND Host='%s'", newPwd, username, this.hostName)) == 1) {
                        this.close(stmt);
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    this.close(stmt);
                    break block6;
                }
                catch (Throwable throwable) {
                    this.close(stmt);
                    throw throwable;
                }
            }
            this.close(stmt);
        }
        return false;
    }

    private int addPerm(String permStr, int permsArg) {
        int perms = permsArg;
        if (permStr.equals("SELECT")) {
            perms |= 1;
        } else if (permStr.equals("UPDATE")) {
            perms |= 2;
        } else if (permStr.equals("DELETE")) {
            perms |= 4;
        } else if (permStr.equals("ALL")) {
            perms |= 0x3FF;
        } else if (permStr.equals("LOCK TABLES")) {
            perms |= 0x10;
        } else if (permStr.equals("INSERT")) {
            perms |= 8;
        } else if (permStr.equals("CREATE")) {
            perms |= 0x80;
        } else if (permStr.equals("DROP")) {
            perms |= 0x200;
        } else if (permStr.equals("ALTER")) {
            perms |= 0x40;
        } else {
            log.error((Object)("Unhandled Permission [" + permStr + "]"));
        }
        return perms;
    }

    private int getPermissionsFromMySQL(String username, String dbName, boolean doAccess) {
        if (this.connection != null) {
            if (username.equalsIgnoreCase("root")) {
                return 1023;
            }
            StringBuilder debugLines = new StringBuilder();
            boolean doDebugPerms = AppPreferences.getLocalPrefs().getBoolean("DEBUG_IT_PERMS", false);
            String[] permNames = new String[]{"Select", "Insert", "Update", "Delete", "Lock_tables", "Alter", "Create", "Drop"};
            int permLen = doAccess ? 5 : permNames.length;
            StringBuilder sb = new StringBuilder("SELECT host `Host`");
            if (doAccess) {
                sb.append(", user `USER`, db `Database`");
            }
            sb.append(", REPLACE(RTRIM(CONCAT(");
            int i = 0;
            while (i < permLen) {
                String perm = permNames[i];
                if (i > 0) {
                    sb.append(',');
                }
                if (doDebugPerms) {
                    sb.append("\n");
                }
                sb.append(String.format("IF(%s_priv = 'Y', '%s ', '') ", perm, perm));
                ++i;
            }
            sb.append(")), ' ', ', ') AS `Privileges` FROM ");
            if (doAccess) {
                sb.append(String.format("mysql.db WHERE User = '%s' ORDER BY Host, User, Db", username));
            } else {
                sb.append(String.format("mysql.user WHERE User = '%s' ORDER BY Host, User", username));
            }
            log.debug((Object)sb.toString());
            if (doDebugPerms) {
                debugLines.append(String.valueOf(sb.toString()) + "\n\n");
            }
            HashMap<String, Integer> nameToPerm = new HashMap<String, Integer>();
            int i2 = 0;
            while (i2 < permLen) {
                nameToPerm.put(permNames[i2], PERM_LIST[i2]);
                ++i2;
            }
            HashMap<Object, Integer> hostHash = new HashMap<Object, Integer>();
            BasicSQLUtils.setSkipTrackExceptions(true);
            Vector<Object[]> rows = BasicSQLUtils.query(this.connection, sb.toString());
            BasicSQLUtils.setSkipTrackExceptions(false);
            for (Object[] row : rows) {
                String permStr;
                String host = (String)row[0];
                if (!StringUtils.isNotEmpty((String)host) || !StringUtils.isNotEmpty((String)(permStr = (String)row[1]))) continue;
                int perms = 0;
                String[] privs = StringUtils.split((String)permStr, (char)',');
                if (privs != null && privs.length > 0) {
                    String[] stringArray = privs;
                    int n = privs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        Integer prm = (Integer)nameToPerm.get(p.trim());
                        if (prm != null) {
                            debugLines.append("Adding Perm: " + p.trim() + "\n");
                            perms |= prm.intValue();
                        }
                        ++n2;
                    }
                }
                if (doDebugPerms) {
                    debugLines.append("Host: [" + (String)host + "]\n\n");
                }
                hostHash.put(host, perms);
            }
            if (doDebugPerms) {
                debugLines.append("hostHash.size(): " + hostHash.size() + "\n");
                int maxPerms = 0;
                for (String key : hostHash.keySet()) {
                    Integer p = (Integer)hostHash.get(key);
                    debugLines.append("Key/Val: [" + key + "][" + p + "]\n");
                    if (p == null || p <= maxPerms) continue;
                    maxPerms = p;
                }
                debugLines.append("maxPerms: " + maxPerms + "\n");
                JTextArea ta = UIHelper.createTextArea();
                ta.setText(debugLines.toString());
                JPanel p = new JPanel(new BorderLayout());
                p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                p.add((Component)UIHelper.createScrollPane(ta, true), "Center");
                CustomDialog dlg = new CustomDialog(null, "Debug", true, 1, (Component)p);
                dlg.setOkLabel("Close");
                UIHelper.centerAndShow(dlg);
            }
            if (hostHash.size() == 1) {
                return (Integer)hostHash.values().iterator().next();
            }
            int maxPerms = 0;
            for (Integer p : hostHash.values()) {
                if (p <= maxPerms) continue;
                maxPerms = p;
            }
            if (maxPerms == 0 && (maxPerms = this.getPermissionsFromUserTable(username, dbName)) != 0) {
                UsageTracker.incrUsageCount("OLD_IT_PERMS_WORKED");
            }
            return maxPerms;
        }
        return 0;
    }

    @Override
    public int getPermissionsForUpdate(String username, String dbName) {
        return this.getPermissionsFromMySQL(username, dbName, false);
    }

    @Override
    public int getPermissionsForAccess(String username, String dbName) {
        return this.getPermissionsFromMySQL(username, dbName, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPermissionsUsingGrants(String username, String serverName, String dbName) {
        try {
            if (this.connection == null) return 0;
            String uNameStr = String.format("'%s'@'", username);
            Vector<Object[]> list = BasicSQLUtils.query(this.connection, "SHOW GRANTS");
            if (list == null) return 0;
            int perms = 0;
            for (Object[] row : list) {
                String[] tokens;
                String line = row[0].toString();
                if (!StringUtils.contains((String)line, (String)uNameStr) || !StringUtils.contains((String)line, (String)dbName)) continue;
                if (StringUtils.containsIgnoreCase((String)line, (String)"GRANT ALL")) {
                    return 1023;
                }
                String pStr = line;
                int eInx = pStr.indexOf(" ON ");
                if (eInx <= -1) continue;
                pStr = pStr.substring(5, eInx).trim();
                String[] stringArray = tokens = StringUtils.split((String)pStr, (String)",");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    perms = this.addPerm(tok.trim(), perms);
                    ++n2;
                }
            }
            if (perms != 0) return perms;
            if (!username.equalsIgnoreCase("root")) return perms;
            return 1023;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    /*
     * Loose catch block
     */
    private int getPermissionsFromInfoSchema(String username, String dbName) {
        block12: {
            Statement stmt;
            block10: {
                int n;
                BasicSQLUtils.setSkipTrackExceptions(true);
                stmt = null;
                try {
                    if (this.connection == null) break block10;
                    stmt = this.connection.createStatement();
                    Vector<Object[]> list = BasicSQLUtils.query(this.connection, "SELECT * FROM INFORMATION_SCHEMA.USER_PRIVILEGES");
                    if (list == null) break block10;
                    int perms = 0;
                    for (Object[] row : list) {
                        String[] toks = StringUtils.split((String)row[0].toString(), (String)"'");
                        if (!toks[0].equals(username)) continue;
                        String yesStr = row[3].toString();
                        if (yesStr.equalsIgnoreCase("YES")) {
                            perms = this.addPerm(row[2].toString(), perms);
                            continue;
                        }
                        if (list.size() != 1) continue;
                        perms = this.getPermissionsUsingGrants(toks[0].toString(), toks[2].toString(), dbName);
                    }
                    if (perms == 0 && username.equalsIgnoreCase("root")) {
                        perms = 1023;
                    }
                    n = perms;
                    this.close(stmt);
                }
                catch (SQLException ex) {
                    block11: {
                        if (ex.getErrorCode() != 1142) break block11;
                        this.close(stmt);
                        BasicSQLUtils.setSkipTrackExceptions(false);
                        return 1024;
                    }
                    ex.printStackTrace();
                    this.close(stmt);
                    BasicSQLUtils.setSkipTrackExceptions(false);
                    break block12;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    this.close(stmt);
                    {
                        catch (Throwable throwable) {
                            this.close(stmt);
                            BasicSQLUtils.setSkipTrackExceptions(false);
                            throw throwable;
                        }
                    }
                    BasicSQLUtils.setSkipTrackExceptions(false);
                    break block12;
                }
                BasicSQLUtils.setSkipTrackExceptions(false);
                return n;
            }
            this.close(stmt);
            BasicSQLUtils.setSkipTrackExceptions(false);
        }
        return 0;
    }

    private int getPermissionsFromUserTable(String username, String dbName) {
        int perms = 0;
        if (this.connection != null) {
            String sql;
            if (username.equalsIgnoreCase("root")) {
                return 1023;
            }
            String columns = "Select_priv, Insert_priv, Update_priv, Delete_priv, Lock_tables_priv, Alter_priv, Create_priv, Drop_priv ";
            String pre = "SELECT " + columns + " ";
            if (StringUtils.isNotEmpty((String)dbName)) {
                sql = String.valueOf(pre) + " FROM mysql.db WHERE User = ? AND Db = ?";
                perms = this.getPerms(PERM_LIST, sql, username, dbName);
                if (perms == 1024) {
                    perms = this.getPermissionsFromInfoSchema(username, dbName);
                }
            }
            if (perms == 0) {
                sql = String.valueOf(pre) + "FROM mysql.user WHERE User = ? AND Host = ?";
                perms = this.getPerms(PERM_LIST, sql, username, this.hostName);
            }
            return perms;
        }
        return 0;
    }

    private int getPerms(int[] permList, String sql, String ... args) {
        String yes = "Y";
        int perms = 0;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            try {
                pStmt = this.connection.prepareStatement(sql);
                int i = 0;
                while (i < args.length) {
                    pStmt.setString(i + 1, args[i]);
                    ++i;
                }
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    i = 0;
                    while (i < permList.length) {
                        if (rs.getString(i + 1).equals(yes)) {
                            perms |= permList[i];
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1142) {
                    try {
                        if (pStmt != null) {
                            pStmt.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return 1024;
                }
                ex.printStackTrace();
                try {
                    if (pStmt != null) {
                        pStmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return perms;
    }

    @Override
    public int getPermissionsForUser(String userName) {
        return this.getPermissionsFromMySQL(userName, null, true);
    }

    @Override
    public boolean doesDBHaveTables() {
        try {
            Iterator<Object[]> iterator = BasicSQLUtils.query(this.connection, "show tables").iterator();
            if (iterator.hasNext()) {
                Object[] row = iterator.next();
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean doesDBHaveTable(String tableName) {
        try {
            return this.doesDBHaveTable(this.connection.getCatalog(), tableName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean doesDBHaveTable(String databaseName, String tableName) {
        if (tableName != null) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                String sql = "SELECT COUNT(*) FROM information_schema.`TABLES` T WHERE T.TABLE_SCHEMA = ? AND T.TABLE_NAME = ?";
                stmt = this.connection.prepareStatement(sql);
                if (stmt != null) {
                    stmt.setString(1, databaseName);
                    stmt.setString(2, tableName);
                    rs = stmt.executeQuery();
                    if (rs != null && rs.next()) {
                        boolean bl = rs.getInt(1) > 0;
                        return bl;
                    }
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public boolean setPermissions(String username, String dbName, int permissions) {
        if (this.connection != null) {
            if (permissions == 0) {
                PreparedStatement pStmt = null;
                try {
                    pStmt = this.connection.prepareStatement("DELETE FROM mysql.db WHERE Host=? AND Db=? AND User=?");
                    pStmt.setString(1, this.hostName);
                    pStmt.setString(2, dbName);
                    pStmt.setString(3, username);
                    int rv = pStmt.executeUpdate();
                    BasicSQLUtils.update(this.connection, "FLUSH PRIVILEGES");
                    boolean bl = rv == 1;
                    return bl;
                }
                catch (SQLException ex) {
                    UIRegistry.showError("Removing permissions failed.");
                    ex.printStackTrace();
                }
                finally {
                    this.close(pStmt);
                }
            }
            StringBuilder sb = new StringBuilder("GRANT ");
            this.appendPerms(sb, permissions);
            sb.append(String.format(" ON %s.* TO '%s'@'%s'", dbName, username, this.hostName));
            Statement stmt = null;
            try {
                stmt = this.connection.createStatement();
                int rv = stmt.executeUpdate(sb.toString());
                BasicSQLUtils.update(this.connection, "FLUSH PRIVILEGES");
                boolean bl = rv == 0;
                return bl;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                UIRegistry.showError("Setting permissions failed.");
            }
            finally {
                this.close(stmt);
            }
        }
        return false;
    }

    @Override
    public boolean close() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.close();
                this.dbConnection = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void appendPerms(StringBuilder sb, int permissions) {
        if ((permissions & 0x3FF) == 1023) {
            sb.append("ALL ");
        } else {
            if ((permissions & 1) == 1) {
                sb.append("SELECT,");
            }
            if ((permissions & 2) == 2) {
                sb.append("UPDATE,");
            }
            if ((permissions & 4) == 4) {
                sb.append("DELETE,");
            }
            if ((permissions & 8) == 8) {
                sb.append("INSERT,");
            }
            if ((permissions & 0x10) == 16) {
                sb.append("LOCK TABLES,");
            }
            if ((permissions & 0x40) == 64) {
                sb.append("ALTER,");
            }
            if ((permissions & 0x80) == 128) {
                sb.append("CREATE,");
            }
            if ((permissions & 0x200) == 512) {
                sb.append("DROP,");
            }
            sb.setLength(sb.length() - 1);
        }
    }

    @Override
    public boolean createUser(String username, String password, String dbName, int permissions) {
        block7: {
            Statement stmt = null;
            try {
                if (this.connection != null) {
                    StringBuilder sb = new StringBuilder("GRANT ");
                    this.appendPerms(sb, permissions);
                    sb.append(String.format(" ON %s.* TO '%s'@'%s' IDENTIFIED BY '%s'", dbName, username, this.hostName, password));
                    stmt = this.connection.createStatement();
                    int rv = stmt.executeUpdate(sb.toString());
                    boolean bl = rv == 0;
                    this.close(stmt);
                    return bl;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block7;
            }
            finally {
                this.close(stmt);
            }
            this.close(stmt);
        }
        return false;
    }

    @Override
    public boolean removeUser(String username, String password) {
        block5: {
            Statement stmt = null;
            try {
                if (this.connection != null) {
                    stmt = this.connection.createStatement();
                    int rv = stmt.executeUpdate(String.format("DROP USER '%s'@'%s'", username, this.hostName));
                    boolean bl = rv == 0;
                    this.close(stmt);
                    return bl;
                }
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    this.close(stmt);
                    break block5;
                }
                catch (Throwable throwable) {
                    this.close(stmt);
                    throw throwable;
                }
            }
            this.close(stmt);
        }
        return false;
    }

    @Override
    public boolean verifyEngineAndCharSet(String dbName) {
        this.errMsg = null;
        Vector<Object[]> rows = BasicSQLUtils.query(this.connection, "select ENGINE,TABLE_COLLATION FROM information_schema.tables WHERE table_schema = '" + dbName + "'");
        if (rows != null && rows.size() > 0) {
            Object[] row = rows.get(0);
            if (row[0] != null && !row[0].toString().equalsIgnoreCase("InnoDB")) {
                this.errMsg = "The engine is not InnoDB.";
            }
            if (row[1] != null && !StringUtils.contains((String)row[1].toString(), (String)"utf8")) {
                this.errMsg = String.valueOf(this.errMsg == null ? "" : String.valueOf(this.errMsg) + "\n") + "The character set is not UTF-8.";
            }
        } else {
            this.errMsg = "Error checking the database engine and character set.";
        }
        return this.errMsg == null;
    }

    @Override
    public Integer getFieldLength(String tableName, String fieldName) {
        Vector<Object> rows;
        block3: {
            try {
                String sql = "SELECT CHARACTER_MAXIMUM_LENGTH FROM `information_schema`.`COLUMNS` where TABLE_SCHEMA = '" + this.connection.getCatalog() + "' and TABLE_NAME = '" + tableName + "' and COLUMN_NAME = '" + fieldName + "'";
                rows = BasicSQLUtils.querySingleCol(this.connection, sql);
                if (rows.size() != 0) break block3;
                return null;
            }
            catch (Exception ex) {
                this.errMsg = "Error getting field length";
                return null;
            }
        }
        return ((Number)rows.get(0)).intValue();
    }
}

