/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.CustomQueryListener;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.dbsupport.QueryExecutor;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.util.Pair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.exception.JDBCConnectionException;

public class JPAQuery
implements CustomQueryIFace {
    private static final Logger log = Logger.getLogger(JPAQuery.class);
    private static long lastErrorTime = 0L;
    protected QueryExecutor queryExecutor;
    protected String sqlStr;
    protected boolean inError = false;
    protected List<?> resultsList = null;
    protected boolean isUnique = false;
    protected int maxResults = 0;
    protected int firstResult = 0;
    protected boolean doDebug = AppPreferences.getLocalPrefs().getBoolean("esdebug", false);
    protected List<Pair<String, Object>> params = null;
    protected CustomQueryListener cql = null;
    protected Object data = null;
    protected Query query = null;
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);

    public JPAQuery(String sqlStr) {
        this(null, sqlStr, null);
    }

    public JPAQuery(String sqlStr, CustomQueryListener cql) {
        this(null, sqlStr, cql);
    }

    public JPAQuery(QueryExecutor queryExecutor, String sqlStr, CustomQueryListener cql) {
        this.queryExecutor = queryExecutor == null ? QueryExecutor.getInstance() : queryExecutor;
        this.sqlStr = sqlStr;
        this.cql = cql;
    }

    public JPAQuery(Query query, CustomQueryListener cql) {
        this.query = query;
        this.cql = cql;
        this.queryExecutor = QueryExecutor.getInstance();
    }

    public void setUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    @Override
    public boolean isInError() {
        return this.inError;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Future<CustomQueryIFace> start() {
        return this.queryExecutor.executeQuery(this);
    }

    public CustomQueryListener getListener() {
        return this.cql;
    }

    @Override
    public boolean execute() {
        this.execute(this.cql);
        return !this.inError;
    }

    public void clearCql() {
        this.cql = null;
    }

    private boolean dispatchError() {
        long now = System.currentTimeMillis();
        boolean showError = now - lastErrorTime > 2000L;
        lastErrorTime = now;
        if (showError) {
            this.inError = true;
            CommandDispatcher.dispatch(new CommandAction("ERRMSG", "DISPLAY", this, null, "BAD_CONNECTION"));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean runQuery() {
        block29: {
            this.inError = false;
            session = HibernateUtil.getNewSession();
            try {
                v0 = qry = this.query != null ? this.query : session.createQuery(this.sqlStr);
                if (this.maxResults > 0) {
                    qry.setMaxResults(this.maxResults);
                }
                if (this.firstResult > 0) {
                    qry.setFirstResult(this.firstResult);
                }
                if (this.params != null) {
                    for (Pair<String, Object> param : this.params) {
                        qry.setParameter(param.getFirst(), param.getSecond());
                    }
                }
                if (this.resultsList != null) {
                    this.resultsList.clear();
                    this.resultsList = null;
                }
                if (this.isUnique) {
                    objArray = new ArrayList<?>(1);
                    objArray.add(qry.uniqueResult());
                    this.resultsList = objArray;
                } else {
                    this.resultsList = qry.list();
                }
                if (this.doDebug) {
                    this.dumpResults();
                }
                ** GOTO lbl52
            }
            catch (JDBCConnectionException ex) {
                if (this.dispatchError()) {
                    this.inError = true;
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (HibernateException var6_9) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                try {
                    try {
                        UsageTracker.incrHandledUsageCount();
                        try {
                            HibernateUtil.rebuildSessionFactory();
                            localQuery = session.createQuery(this.sqlStr);
                            this.resultsList = localQuery.list();
                        }
                        catch (JDBCConnectionException ex2) {
                            this.dispatchError();
                        }
lbl52:
                        // 3 sources

                        this.inError = this.resultsList == null;
                    }
                    catch (Exception ex) {
                        JPAQuery.log.error((Object)ex);
                        this.dispatchError();
                        UsageTracker.incrHandledUsageCount();
                        JPAQuery.log.error((Object)("** In Exception [" + this.sqlStr + "]"));
                        ex.printStackTrace();
                        this.inError = true;
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (HibernateException var6_10) {}
                        }
                        break block29;
                    }
                }
                catch (Throwable var5_13) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (HibernateException var6_11) {
                            // empty catch block
                        }
                    }
                    throw var5_13;
                }
            }
            if (session == null) break block29;
            try {
                session.close();
            }
            catch (HibernateException var6_12) {
                // empty catch block
            }
        }
        return this.inError == false;
    }

    @Override
    public void execute(CustomQueryListener cqlArg) {
        this.runQuery();
        try {
            if (cqlArg != null) {
                if (this.inError) {
                    cqlArg.executionError(this);
                } else {
                    cqlArg.exectionDone(this);
                }
            }
            if (this.cql != null && cqlArg != null && this.cql != cqlArg) {
                if (this.inError) {
                    cqlArg.executionError(this);
                } else {
                    cqlArg.exectionDone(this);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void dumpResults() {
        StringBuilder sb = new StringBuilder();
        int rowNum = 0;
        boolean firstRow = true;
        for (Object row : this.resultsList) {
            if (row instanceof Object[]) {
                Object[] cols;
                int n;
                if (firstRow) {
                    Object[] cols2;
                    firstRow = false;
                    sb.setLength(0);
                    Object[] objectArray = cols2 = (Object[])row;
                    n = cols2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object colData = objectArray[n2];
                        sb.append('|');
                        if (colData != null && colData.getClass() != null) {
                            sb.append(colData.getClass().getSimpleName());
                        }
                        ++n2;
                    }
                    sb.append('|');
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sb.setLength(0);
                Object[] objectArray = cols = (Object[])row;
                int n3 = cols.length;
                n = 0;
                while (n < n3) {
                    Object colData = objectArray[n];
                    sb.append('|');
                    if (colData instanceof Calendar) {
                        sb.append(sdf.format(((Calendar)colData).getTime()));
                    } else {
                        sb.append(colData);
                    }
                    ++n;
                }
                sb.append('|');
            }
            ++rowNum;
        }
    }

    @Override
    public List<?> getDataObjects() {
        return this.resultsList;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<QueryResultsContainerIFace> getQueryDefinition() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public List<QueryResultsDataObj> getResults() {
        throw new RuntimeException("Not Implemented");
    }

    public List<Pair<String, Object>> getParams() {
        return this.params;
    }

    public void setParams(List<Pair<String, Object>> params) {
        this.params = params;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void cancel() {
        this.cancelled.set(true);
    }

    @Override
    public List<Integer> getTableIds() {
        return null;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }
}

