/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.EntityMode;
import org.hibernate.Session;

public class ImportExportDB {
    private static final Logger log = Logger.getLogger(ImportExportDB.class);
    protected Session session;
    protected String importFolderPath;

    public static void main(String[] args) {
        Pair<String, String> usernamePassword = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB();
        UIHelper.tryLogin("com.mysql.jdbc.Driver", "org.hibernate.dialect.MySQLDialect", "testfish", "jdbc:mysql://localhost/testfish", (String)usernamePassword.first, (String)usernamePassword.second);
        Session testSession = HibernateUtil.getCurrentSession();
        String workingFolder = "Specify6ImportExport";
        File wf = new File(workingFolder);
        if (!wf.exists()) {
            wf.mkdirs();
        }
        ImportExportDB impexp = new ImportExportDB(testSession, String.valueOf(workingFolder) + File.separator);
        try {
            try {
                System.out.println("importing...");
                System.out.println("printing...");
                impexp.writeXMLfile("PrepType");
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                ex.printStackTrace();
                impexp.close();
                System.out.println("...done");
            }
        }
        finally {
            impexp.close();
            System.out.println("...done");
        }
    }

    public ImportExportDB(Session session) {
        this.session = session;
    }

    public ImportExportDB(Session session, String importFolderPath) {
        this.session = session;
        this.importFolderPath = importFolderPath;
    }

    public void importTable(String dbTable) {
        try {
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            if (path == null) {
                log.debug((Object)"error opening file");
            } else {
                HibernateUtil.beginTransaction();
                long t = 0L;
                this.sequentialDatabaseImport(dbImport, dbTable, dbTable, t, false);
                HibernateUtil.commitTransaction();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            try {
                ex.printStackTrace();
                HibernateUtil.rollbackTransaction();
            }
            catch (Exception ex1) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex1);
                ex1.printStackTrace();
            }
        }
    }

    public void importSingleDBObject(String dbTable, int id, boolean recursion) {
        try {
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            Element importMe = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]");
            if (path == null) {
                log.debug((Object)"error opening file");
            } else if (importMe == null) {
                log.debug((Object)("record with id:" + id + " does not exsist in " + this.importFolderPath + dbTable + ".xml"));
            } else {
                HibernateUtil.beginTransaction();
                long t = 0L;
                this.singleXMLImport(importMe, dbTable, dbTable, t, id, recursion);
                HibernateUtil.commitTransaction();
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    public Object buildSingleDBObject(String dbTable, int id, boolean recursion) {
        Object dbObject = new Object();
        try {
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            Element importMe = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]");
            if (path == null) {
                log.debug((Object)"error opening file");
            } else {
                long t = 0L;
                dbObject = this.buildSingleDBObjectFromXML(importMe, dbTable, dbTable, t, id, recursion);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    public Object buildSingleDataBaseObject(String dbTable, int id, boolean recursion) {
        Object dbObject = new Object();
        try {
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            Element importMe = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]");
            if (path == null) {
                log.debug((Object)"error opening file");
            } else {
                long t = 0L;
                dbObject = this.buildSingleDataBaseObjectFromXML(importMe, dbTable, dbTable, t, id, recursion);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    public Map buildSingleDataBaseObjectTemp(String dbTable, int id, boolean recursion) {
        Map dbObject = new HashMap();
        try {
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            Element importMe = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]");
            if (path == null) {
                log.debug((Object)"error opening file");
            } else {
                long t = 0L;
                dbObject = this.buildSingleDataBaseObjectFromXMLTemp(importMe, dbTable, dbTable, t, id, recursion);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    protected void dynamicXMLImport(Element dbImport, String dbTable) {
        try {
            String id = new String();
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            String lowerdbTable = this.lowerFirstChar(dbTable);
            List ids = dbImport.selectNodes("//" + lowerdbTable + "Id");
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Element idElement = (Element)ids.get(k);
                    id = idElement.getStringValue();
                    Object agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findType(element = (Element)i.next(), dbTable, agent, " ")) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (value == "OneToMany" || value == "ManyToMany") {
                            List collectingevent_ids = element.selectNodes("//" + dbTable + "[" + id + "]/" + element.getName() + "/*");
                            if (collectingevent_ids.isEmpty()) continue;
                            String childDbName = this.getDbName(collectingevent_ids);
                            BeanUtils.populate(agent, agentMap);
                            Set collection = this.xmlImportRecursion(agentMap, childDbName, collectingevent_ids, agent, lowerdbTable);
                            if (collection != null) {
                                agentMap.put(element.getName(), collection);
                                continue;
                            }
                            log.debug((Object)("error on the collection " + element.getName() + " with parent " + dbTable));
                            continue;
                        }
                        if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                        log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                    } while (i.hasNext());
                    BeanUtils.populate(agent, agentMap);
                    this.session.saveOrUpdate(agent);
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected void sequentialXMLImport(Element dbImport, String dbTable, String parentName, long parentId) {
        try {
            String id = new String();
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            String lowerdbTable = this.lowerFirstChar(dbTable);
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            List ids = dbImport.selectNodes("//" + primaryKey);
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Vector collectionIds = new Vector(20);
                    Vector<String> collectionNames = new Vector<String>(20);
                    Element idElement = (Element)ids.get(k);
                    id = idElement.getStringValue();
                    Object agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findTypeSequential(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (value == "OneToMany" || value == "ManyToMany") {
                            List temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*");
                            if (temp_collection_ids.isEmpty()) continue;
                            String childDbName = this.getDbName(temp_collection_ids);
                            collectionNames.addElement(childDbName);
                            int index = 0;
                            while (index < temp_collection_ids.size()) {
                                collectionIds.addElement(temp_collection_ids.get(index));
                                ++index;
                            }
                        } else {
                            if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                            log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                        }
                    } while (i.hasNext());
                    BeanUtils.populate(agent, agentMap);
                    this.session.save(agent);
                    if (!collectionIds.isEmpty()) {
                        long newParentId = new Long(this.session.getIdentifier(agent).toString());
                        this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
                    }
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected void sequentialXMLImportRecursion(Vector collectionNames, Vector collectionIds, String parentName, long parentId) {
        int idIndex = 0;
        try {
            int z = 0;
            while (z < collectionNames.size()) {
                String dbTable = collectionNames.get(z).toString();
                String lowerdbTable = this.lowerFirstChar(dbTable);
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
                String primaryKey = info.getPrimaryKeyName();
                File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
                Element dbImport = XMLHelper.readFileToDOM4J(path);
                DBTableInfo tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
                int k = 0;
                while (k < collectionIds.size() && idIndex < collectionIds.size()) {
                    Vector newCollectionIds = new Vector(20);
                    Vector<String> newCollectionNames = new Vector<String>(20);
                    Element temp_id = (Element)collectionIds.get(idIndex);
                    if (temp_id.getName().equals(dbTable)) {
                        ++idIndex;
                        String id = temp_id.getText();
                        Element collectingevent = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]");
                        Iterator iter = collectingevent.elementIterator();
                        HashMap<String, Object> agentMap = new HashMap<String, Object>();
                        Object agent = tableInfo.getClassObj().newInstance();
                        do {
                            Element element;
                            Object value2;
                            if ((value2 = this.findTypeSequential(element = (Element)iter.next(), dbTable, parentId, parentName)) != null && value2 != "OneToMany" && value2 != "ManyToMany") {
                                agentMap.put(element.getName(), value2);
                                continue;
                            }
                            if (value2 == "ManyToMany") {
                                HashSet<Object> parentSet = new HashSet<Object>();
                                Object parentObject = this.genericDBObject2(parentName, parentId);
                                parentSet.add(parentObject);
                                agentMap.put(element.getName(), parentSet);
                                continue;
                            }
                            if (value2 == "OneToMany") {
                                List temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*");
                                if (temp_collection_ids.isEmpty()) continue;
                                String childDbName = this.getDbName(temp_collection_ids);
                                newCollectionNames.addElement(childDbName);
                                int index = 0;
                                while (index < temp_collection_ids.size()) {
                                    newCollectionIds.addElement(temp_collection_ids.get(index));
                                    ++index;
                                }
                            } else {
                                if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                                log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                            }
                        } while (iter.hasNext());
                        BeanUtils.populate(agent, agentMap);
                        this.session.saveOrUpdate(agent);
                        if (!newCollectionIds.isEmpty()) {
                            long newParentId = new Long(this.session.getIdentifier(agent).toString());
                            this.sequentialXMLImportRecursion(newCollectionNames, newCollectionIds, dbTable, newParentId);
                        }
                    } else {
                        k = collectionIds.size();
                    }
                    ++k;
                }
                ++z;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected void singleXMLImport(Element dbImport, String dbTable, String parentName, long parentId, int id, boolean recursion) {
        try {
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String lowerdbTable = this.lowerFirstChar(dbTable);
            String primaryKey = parentInfo.getPrimaryKeyName();
            Vector collectionIds = new Vector(20);
            Vector<String> collectionNames = new Vector<String>(20);
            Object agent = parentInfo.getClassObj().newInstance();
            HashMap<String, Object> agentMap = new HashMap<String, Object>();
            Element dbElement = dbImport;
            Iterator i = dbElement.elementIterator();
            do {
                Element element;
                Object value;
                if ((value = this.findTypeSequential(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                    agentMap.put(element.getName(), value);
                    continue;
                }
                if (recursion && (value == "OneToMany" || value == "ManyToMany")) {
                    List temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*");
                    if (temp_collection_ids.isEmpty()) continue;
                    String childDbName = this.getDbName(temp_collection_ids);
                    collectionNames.addElement(childDbName);
                    int index = 0;
                    while (index < temp_collection_ids.size()) {
                        collectionIds.addElement(temp_collection_ids.get(index));
                        ++index;
                    }
                } else {
                    if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                    log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                }
            } while (i.hasNext());
            BeanUtils.populate(agent, agentMap);
            this.session.save(agent);
            if (!collectionIds.isEmpty()) {
                long newParentId = new Long(this.session.getIdentifier(agent).toString());
                this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected Object buildSingleDBObjectFromXML(Element dbImport, String dbTable, String parentName, long parentId, int id, boolean recursion) {
        Object dbObject = new Object();
        try {
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = parentInfo.getPrimaryKeyName();
            Vector collectionIds = new Vector(20);
            Vector<String> collectionNames = new Vector<String>(20);
            Object agent = parentInfo.getClassObj().newInstance();
            HashMap<String, Object> agentMap = new HashMap<String, Object>();
            Element dbElement = dbImport;
            Iterator i = dbElement.elementIterator();
            do {
                Element element;
                Object value;
                if ((value = this.findTypeRecordSet(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                    agentMap.put(element.getName(), value);
                    continue;
                }
                if (value == "OneToMany" || value == "ManyToMany") {
                    List temp_collection_ids;
                    if (!recursion || (temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*")).isEmpty()) continue;
                    String childDbName = this.getDbName(temp_collection_ids);
                    collectionNames.addElement(childDbName);
                    int index = 0;
                    while (index < temp_collection_ids.size()) {
                        collectionIds.addElement(temp_collection_ids.get(index));
                        ++index;
                    }
                } else {
                    if (element.getName().equals(primaryKey)) continue;
                    log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                }
            } while (i.hasNext());
            BeanUtils.populate(agent, agentMap);
            this.session.save(agent);
            if (!collectionIds.isEmpty()) {
                long newParentId = new Long(this.session.getIdentifier(agent).toString());
                this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
            }
            dbObject = agent;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    protected Object buildSingleDataBaseObjectFromXML(Element dbImport, String dbTable, String parentName, long parentId, int id, boolean recursion) {
        Object dbObject = new Object();
        try {
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = parentInfo.getPrimaryKeyName();
            Vector collectionIds = new Vector(20);
            Vector<String> collectionNames = new Vector<String>(20);
            Object agent = parentInfo.getClassObj().newInstance();
            HashMap<String, Object> agentMap = new HashMap<String, Object>();
            Element dbElement = dbImport;
            Iterator i = dbElement.elementIterator();
            do {
                Element element;
                Object value;
                if ((value = this.findTypeDataBaseParent(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                    agentMap.put(element.getName(), value);
                    continue;
                }
                if (value == "OneToMany" || value == "ManyToMany") {
                    List temp_collection_ids;
                    if (!recursion || (temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*")).isEmpty()) continue;
                    String childDbName = this.getDbName(temp_collection_ids);
                    collectionNames.addElement(childDbName);
                    int index = 0;
                    while (index < temp_collection_ids.size()) {
                        collectionIds.addElement(temp_collection_ids.get(index));
                        ++index;
                    }
                } else {
                    if (element.getName().equals(primaryKey)) continue;
                    log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                }
            } while (i.hasNext());
            BeanUtils.populate(agent, agentMap);
            this.session.save(agent);
            if (!collectionIds.isEmpty()) {
                long newParentId = new Long(this.session.getIdentifier(agent).toString());
                this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
            }
            dbObject = agent;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    protected Map buildSingleDataBaseObjectFromXMLTemp(Element dbImport, String dbTable, String parentName, long parentId, int id, boolean recursion) {
        HashMap<String, Object> agentMap = new HashMap<String, Object>();
        try {
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = parentInfo.getPrimaryKeyName();
            Vector collectionIds = new Vector(20);
            Vector<String> collectionNames = new Vector<String>(20);
            Object agent = parentInfo.getClassObj().newInstance();
            Element dbElement = dbImport;
            Iterator i = dbElement.elementIterator();
            do {
                Element element;
                Object value;
                if ((value = this.findTypeDataBaseParent(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                    agentMap.put(element.getName(), value);
                    continue;
                }
                if (value == "OneToMany" || value == "ManyToMany") {
                    List temp_collection_ids;
                    if (!recursion || (temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*")).isEmpty()) continue;
                    String childDbName = this.getDbName(temp_collection_ids);
                    collectionNames.addElement(childDbName);
                    int index = 0;
                    while (index < temp_collection_ids.size()) {
                        collectionIds.addElement(temp_collection_ids.get(index));
                        ++index;
                    }
                } else {
                    if (element.getName().equals(primaryKey)) continue;
                    log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                }
            } while (i.hasNext());
            if (!collectionIds.isEmpty()) {
                long newParentId = new Long(this.session.getIdentifier(agent).toString());
                this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return agentMap;
    }

    protected void sequentialXMLImportRecordSet(Element dbImport, String dbTable, String parentName, long parentId) {
        try {
            String id = new String();
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            List ids = dbImport.selectNodes("//" + primaryKey);
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Vector collectionIds = new Vector(20);
                    Vector<String> collectionNames = new Vector<String>(20);
                    Element idElement = (Element)ids.get(k);
                    id = idElement.getStringValue();
                    Object agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findTypeRecordSet(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (value == "OneToMany" || value == "ManyToMany") {
                            List temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*");
                            if (temp_collection_ids.isEmpty()) continue;
                            String childDbName = this.getDbName(temp_collection_ids);
                            collectionNames.addElement(childDbName);
                            int index = 0;
                            while (index < temp_collection_ids.size()) {
                                collectionIds.addElement(temp_collection_ids.get(index));
                                ++index;
                            }
                        } else {
                            if (element.getName().equals(primaryKey)) continue;
                            log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                        }
                    } while (i.hasNext());
                    BeanUtils.populate(agent, agentMap);
                    this.session.save(agent);
                    if (!collectionIds.isEmpty()) {
                        long newParentId = new Long(this.session.getIdentifier(agent).toString());
                        this.sequentialXMLImportRecursion(collectionNames, collectionIds, dbTable, newParentId);
                    }
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected void parentXMLImport(Element dbImport, String dbTable, String parentName, long parentId) {
        List<String> immediateParents = new ArrayList<String>();
        immediateParents = this.getImmediateParentTables(dbTable, immediateParents, false);
        List<String> parents = new ArrayList<String>();
        parents = this.getParentTables(dbTable, parents, false);
        Element dbElement = (Element)dbImport.selectNodes("//" + dbTable);
        Iterator i = dbElement.elementIterator();
        do {
            Element element;
            String elementName;
            if (!immediateParents.contains(elementName = (element = (Element)i.next()).getName().toString())) continue;
            if (element.getText().equals("") || element.getText().equals(null)) {
                immediateParents.remove(elementName);
                continue;
            }
            String className = immediateParents.get(immediateParents.indexOf(elementName));
            int num = new Integer(className);
            this.importSingleDBObject(className, num, false);
        } while (i.hasNext());
    }

    protected void iterativeXMLImport(Element dbImport, String dbTable, String parentName, long parentId) {
        try {
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            String lowerdbTable = this.lowerFirstChar(dbTable);
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Object agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findTypeSequential(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                        log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                    } while (i.hasNext());
                    BeanUtils.populate(agent, agentMap);
                    this.session.save(agent);
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected Object dynamicXMLImportRecReturn(Element dbImport, String dbTable) {
        Object agent = new Object();
        try {
            String id = new String();
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            String lowerdbTable = this.lowerFirstChar(dbTable);
            List ids = dbImport.selectNodes("//" + lowerdbTable + "Id");
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Element idElement = (Element)ids.get(k);
                    id = idElement.getStringValue();
                    agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findType(element = (Element)i.next(), dbTable, agent, " ")) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (value == "OneToMany" || value == "ManyToMany") {
                            List collectingevent_ids = element.selectNodes("//" + dbTable + "[" + id + "]/" + element.getName() + "/*");
                            if (collectingevent_ids.isEmpty()) continue;
                            String childDbName = this.getDbName(collectingevent_ids);
                            BeanUtils.populate((Object)agent, agentMap);
                            Set collection = this.xmlImportRecursion(agentMap, childDbName, collectingevent_ids, agent, lowerdbTable);
                            if (collection != null) {
                                agentMap.put(element.getName(), collection);
                                continue;
                            }
                            log.debug((Object)("error on the collection " + element.getName() + " with parent " + dbTable));
                            continue;
                        }
                        if (element.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                        log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                    } while (i.hasNext());
                    BeanUtils.populate((Object)agent, agentMap);
                    this.session.saveOrUpdate(agent);
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return agent;
    }

    protected Set xmlImportRecursion(Map parentMap, String dbTable, List ids, Object parentObject, String parentName) {
        try {
            HashSet set = new HashSet();
            String lowerdbTable = this.lowerFirstChar(dbTable);
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            File path = new File(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            Element dbImport = XMLHelper.readFileToDOM4J(path);
            int j = 0;
            while (j < ids.size()) {
                Element temp_id = (Element)ids.get(j);
                String id2 = temp_id.getText();
                Element collectingevent = (Element)dbImport.selectSingleNode("//" + dbTable + "[" + id2 + "]");
                Iterator iter = collectingevent.elementIterator();
                HashMap<String, Object> collectingEventMap = new HashMap<String, Object>();
                Object agent = parentInfo.getClassObj().newInstance();
                do {
                    Element secondelement;
                    Object value2;
                    if ((value2 = this.findType(secondelement = (Element)iter.next(), dbTable, parentObject, parentName)) != null && value2 != "OneToMany" && value2 != "ManyToMany") {
                        collectingEventMap.put(secondelement.getName(), value2);
                        continue;
                    }
                    if (value2 == "ManyToMany") {
                        HashSet<Object> parentSet = new HashSet<Object>();
                        parentSet.add(parentObject);
                        collectingEventMap.put(secondelement.getName(), parentSet);
                        continue;
                    }
                    if (value2 == "OneToMany") {
                        List associated_ids = secondelement.selectNodes("//" + dbTable + "[" + id2 + "]/" + secondelement.getName() + "/*");
                        if (associated_ids.isEmpty()) continue;
                        String childDbName = this.getDbName(associated_ids);
                        BeanUtils.populate(agent, collectingEventMap);
                        Set collection = this.xmlImportRecursion(collectingEventMap, childDbName, associated_ids, agent, lowerdbTable);
                        if (collection != null) {
                            collectingEventMap.put(secondelement.getName(), collection);
                            continue;
                        }
                        log.debug((Object)("error on the collection " + secondelement.getName() + " with parent " + dbTable));
                        continue;
                    }
                    if (secondelement.getName().equals(String.valueOf(lowerdbTable) + "Id")) continue;
                    log.debug((Object)("did not add " + secondelement.getName() + " to the element " + dbTable));
                } while (iter.hasNext());
                BeanUtils.populate(agent, collectingEventMap);
                set.add(agent);
                ++j;
            }
            return set;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
            return null;
        }
    }

    protected void sequentialDatabaseImport(Element dbImport, String dbTable, String parentName, long parentId, boolean recursion) {
        try {
            String id = new String();
            DBTableInfo parentInfo = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            List records = dbImport.selectNodes("//" + dbTable);
            DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
            String primaryKey = info.getPrimaryKeyName();
            List ids = dbImport.selectNodes("//" + primaryKey);
            if (records.size() < 1) {
                log.debug((Object)("Cannot import. Given database type:" + dbTable + " does not exsist in import file"));
            } else {
                int k = 0;
                while (k < records.size()) {
                    Vector collectionIds = new Vector(20);
                    Vector<String> collectionNames = new Vector<String>(20);
                    Element idElement = (Element)ids.get(k);
                    id = idElement.getStringValue();
                    Object agent = parentInfo.getClassObj().newInstance();
                    HashMap<String, Object> agentMap = new HashMap<String, Object>();
                    Element dbElement = (Element)records.get(k);
                    Iterator i = dbElement.elementIterator();
                    do {
                        Element element;
                        Object value;
                        if ((value = this.findTypeDataBase(element = (Element)i.next(), dbTable, parentId, parentName)) != null && value != "OneToMany" && value != "ManyToMany") {
                            agentMap.put(element.getName(), value);
                            continue;
                        }
                        if (value == "OneToMany" || value == "ManyToMany") {
                            List temp_collection_ids;
                            if (!recursion || (temp_collection_ids = element.selectNodes("//" + dbTable + "[" + primaryKey + " = \"" + id + "\"]/" + element.getName() + "/*")).isEmpty()) continue;
                            String childDbName = this.getDbName(temp_collection_ids);
                            collectionNames.addElement(childDbName);
                            int index = 0;
                            while (index < temp_collection_ids.size()) {
                                collectionIds.addElement(temp_collection_ids.get(index));
                                ++index;
                            }
                        } else {
                            if (element.getName().equals(primaryKey)) continue;
                            log.debug((Object)("did not add " + element.getName() + " to the element " + dbTable));
                        }
                    } while (i.hasNext());
                    BeanUtils.populate(agent, agentMap);
                    this.session.save(agent);
                    ++k;
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    protected Object findType(Element compareMe, String dbTable, Object parentObject, String parentName) {
        block21: {
            block22: {
                String lowerdbTable = dbTable.toLowerCase();
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
                DBFieldInfo fieldInfo = info.getFieldByName(compareMe.getName());
                if (compareMe.getName().equals(String.valueOf(this.lowerFirstChar(dbTable)) + "Id")) break block21;
                if (fieldInfo != null) {
                    String type = fieldInfo.getType();
                    if (type.equals("java.lang.String") || type.equals("text")) {
                        return compareMe.getStringValue();
                    }
                    if (type.equals("java.util.Date")) {
                        Date dtTmp = new SimpleDateFormat("yy-MM-dd H:mm:ss").parse(compareMe.getStringValue());
                        return dtTmp;
                    }
                    if (type.equals("java.sql.Timestamp")) {
                        Timestamp tmstmp = Timestamp.valueOf(compareMe.getStringValue());
                        return tmstmp;
                    }
                    if (type.equals("java.lang.Integer")) {
                        int num = new Integer(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Boolean")) {
                        Boolean bool = Boolean.valueOf(compareMe.getStringValue());
                        return bool;
                    }
                    if (type.equals("java.math.BigDecimal")) {
                        BigDecimal num = UIHelper.parseDoubleToBigDecimal(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Double")) {
                        double num = new Double(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Float")) {
                        float num = new Float(compareMe.getStringValue()).floatValue();
                        return Float.valueOf(num);
                    }
                    if (type.equals("java.lang.Long")) {
                        long num = new Long(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Short")) {
                        short num = new Short(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Byte")) {
                        byte num = new Byte(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.util.Calendar")) {
                        Calendar date = this.dateString2Calendar(compareMe.getStringValue());
                        return date;
                    }
                    break block21;
                }
                DBRelationshipInfo tablerel = info.getRelationshipByName(compareMe.getName());
                if (tablerel != null && tablerel.getType().name() == "ManyToOne") {
                    long num = new Long(compareMe.getStringValue());
                    if (compareMe.getName().equals(parentName)) {
                        return parentObject;
                    }
                    try {
                        File path = new File(String.valueOf(this.importFolderPath) + this.capFirstChar(compareMe.getName()) + "Generic.xml");
                        Element dbImport2 = XMLHelper.readFileToDOM4J(path);
                        Object tableObject = this.dynamicXMLImportRecReturn(dbImport2, this.capFirstChar(compareMe.getName()));
                        return tableObject;
                    }
                    catch (FileNotFoundException e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ImportExportDB.class, e);
                        String className = tablerel.getClassName().substring(29).toLowerCase();
                        Object tableObject = this.genericDBObject2(className, num);
                        return tableObject;
                    }
                }
                if ((tablerel == null || tablerel.getType().name() != "OneToMany") && (tablerel == null || tablerel.getType().name() != "ManyToMany")) break block22;
                if (compareMe.getName().equals(String.valueOf(parentName) + "s")) {
                    return "ManyToMany";
                }
                return "OneToMany";
            }
            try {
                log.debug((Object)("could not import element: " + compareMe.getName() + ", with data:" + compareMe.getData()));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected Object findTypeSequential(Element compareMe, String dbTable, long parentId, String parentName) {
        block21: {
            block22: {
                String lowerdbTable = dbTable.toLowerCase();
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
                DBFieldInfo fieldInfo = info.getFieldByName(compareMe.getName());
                if (compareMe.getName().equals(String.valueOf(this.lowerFirstChar(dbTable)) + "Id")) break block21;
                if (fieldInfo != null) {
                    String type = fieldInfo.getType();
                    if (type.equals("java.lang.String") || type.equals("text")) {
                        return compareMe.getStringValue();
                    }
                    if (type.equals("java.util.Date")) {
                        Date dtTmp = new SimpleDateFormat("yy-MM-dd H:mm:ss").parse(compareMe.getStringValue());
                        return dtTmp;
                    }
                    if (type.equals("java.sql.Timestamp")) {
                        Timestamp tmstmp = Timestamp.valueOf(compareMe.getStringValue());
                        return tmstmp;
                    }
                    if (type.equals("java.lang.Integer")) {
                        int num = new Integer(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Boolean")) {
                        Boolean bool = Boolean.valueOf(compareMe.getStringValue());
                        return bool;
                    }
                    if (type.equals("java.math.BigDecimal")) {
                        BigDecimal num = UIHelper.parseDoubleToBigDecimal(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Double")) {
                        double num = new Double(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Float")) {
                        float num = new Float(compareMe.getStringValue()).floatValue();
                        return Float.valueOf(num);
                    }
                    if (type.equals("java.lang.Long")) {
                        long num = new Long(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Short")) {
                        short num = new Short(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Byte")) {
                        byte num = new Byte(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.util.Calendar")) {
                        Calendar date = this.dateString2Calendar(compareMe.getStringValue());
                        return date;
                    }
                    break block21;
                }
                DBRelationshipInfo tablerel = info.getRelationshipByName(compareMe.getName());
                if (tablerel != null && tablerel.getType().name() == "ManyToOne") {
                    long num = new Long(compareMe.getStringValue());
                    if (compareMe.getName().equals(this.lowerFirstChar(parentName))) {
                        String className = tablerel.getClassName().substring(29).toLowerCase();
                        Object tableObject = this.genericDBObject2(className, parentId);
                        return tableObject;
                    }
                    try {
                        File path = new File(String.valueOf(this.importFolderPath) + this.capFirstChar(compareMe.getName()) + "Generic.xml");
                        Element dbImport2 = XMLHelper.readFileToDOM4J(path);
                        Object tableObject = this.dynamicXMLImportRecReturn(dbImport2, this.capFirstChar(compareMe.getName()));
                        return tableObject;
                    }
                    catch (FileNotFoundException e) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ImportExportDB.class, e);
                        String className = tablerel.getClassName().substring(29).toLowerCase();
                        Object tableObject = this.genericDBObject2(className, num);
                        return tableObject;
                    }
                }
                if ((tablerel == null || tablerel.getType().name() != "OneToMany") && (tablerel == null || tablerel.getType().name() != "ManyToMany")) break block22;
                if (compareMe.getName().equals(String.valueOf(parentName) + "s")) {
                    return "ManyToMany";
                }
                return "OneToMany";
            }
            try {
                log.debug((Object)("could not import element: " + compareMe.getName() + ", with data:" + compareMe.getData()));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected Object findTypeRecordSet(Element compareMe, String dbTable, long parentId, String parentName) {
        block20: {
            block21: {
                String lowerdbTable = dbTable.toLowerCase();
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
                DBFieldInfo fieldInfo = info.getFieldByName(compareMe.getName());
                if (compareMe.getName().equals(String.valueOf(this.lowerFirstChar(dbTable)) + "Id")) break block20;
                if (fieldInfo != null) {
                    String type = fieldInfo.getType();
                    if (type.equals("java.lang.String") || type.equals("text")) {
                        return compareMe.getStringValue();
                    }
                    if (type.equals("java.util.Date")) {
                        Date dtTmp = new SimpleDateFormat("yy-MM-dd H:mm:ss").parse(compareMe.getStringValue());
                        return dtTmp;
                    }
                    if (type.equals("java.sql.Timestamp")) {
                        Timestamp tmstmp = Timestamp.valueOf(compareMe.getStringValue());
                        return tmstmp;
                    }
                    if (type.equals("java.lang.Integer")) {
                        int num = new Integer(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Boolean")) {
                        Boolean bool = Boolean.valueOf(compareMe.getStringValue());
                        return bool;
                    }
                    if (type.equals("java.math.BigDecimal")) {
                        BigDecimal num = UIHelper.parseDoubleToBigDecimal(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Double")) {
                        double num = new Double(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Float")) {
                        float num = new Float(compareMe.getStringValue()).floatValue();
                        return Float.valueOf(num);
                    }
                    if (type.equals("java.lang.Long")) {
                        long num = new Long(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Short")) {
                        short num = new Short(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Byte")) {
                        byte num = new Byte(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.util.Calendar")) {
                        Calendar date = this.dateString2Calendar(compareMe.getStringValue());
                        return date;
                    }
                    break block20;
                }
                DBRelationshipInfo tablerel = info.getRelationshipByName(compareMe.getName());
                if (tablerel != null && tablerel.getType().name() == "ManyToOne" && !compareMe.getStringValue().equals("")) {
                    long num = new Long(compareMe.getStringValue());
                    String className = tablerel.getClassName().substring(29);
                    if (className.equals("Agent")) {
                        className = className.toLowerCase();
                        Object tableObject = this.genericDBObject2(className, num);
                        return tableObject;
                    }
                    Object tableObject = this.getParentDBObject(className, num);
                    return tableObject;
                }
                if ((tablerel == null || tablerel.getType().name() != "OneToMany") && (tablerel == null || tablerel.getType().name() != "ManyToMany")) break block21;
                if (compareMe.getName().equals(String.valueOf(parentName) + "s")) {
                    return "ManyToMany";
                }
                return "OneToMany";
            }
            try {
                log.debug((Object)("could not import element: " + compareMe.getName() + ", with data:" + compareMe.getData()));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                if (ex.toString().startsWith("java.lang.NumberFormatException")) {
                    return null;
                }
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected Object findTypeDataBase(Element compareMe, String dbTable, long parentId, String parentName) {
        block20: {
            block21: {
                String lowerdbTable = dbTable.toLowerCase();
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
                DBFieldInfo fieldInfo = info.getFieldByName(compareMe.getName());
                if (compareMe.getName().equals(String.valueOf(this.lowerFirstChar(dbTable)) + "Id")) break block20;
                if (fieldInfo != null) {
                    String type = fieldInfo.getType();
                    if (type.equals("java.lang.String") || type.equals("text")) {
                        return compareMe.getStringValue();
                    }
                    if (type.equals("java.util.Date")) {
                        Date dtTmp = new SimpleDateFormat("yy-MM-dd H:mm:ss").parse(compareMe.getStringValue());
                        return dtTmp;
                    }
                    if (type.equals("java.sql.Timestamp")) {
                        Timestamp tmstmp = Timestamp.valueOf(compareMe.getStringValue());
                        return tmstmp;
                    }
                    if (type.equals("java.lang.Integer")) {
                        int num = new Integer(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Boolean")) {
                        Boolean bool = Boolean.valueOf(compareMe.getStringValue());
                        return bool;
                    }
                    if (type.equals("java.math.BigDecimal")) {
                        BigDecimal num = UIHelper.parseDoubleToBigDecimal(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Double")) {
                        double num = new Double(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Float")) {
                        float num = new Float(compareMe.getStringValue()).floatValue();
                        return Float.valueOf(num);
                    }
                    if (type.equals("java.lang.Long")) {
                        long num = new Long(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Short")) {
                        short num = new Short(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Byte")) {
                        byte num = new Byte(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.util.Calendar")) {
                        Calendar date = this.dateString2Calendar(compareMe.getStringValue());
                        return date;
                    }
                    break block20;
                }
                DBRelationshipInfo tablerel = info.getRelationshipByName(compareMe.getName());
                if (tablerel != null && tablerel.getType().name() == "ManyToOne" && !compareMe.getStringValue().equals("")) {
                    long num = new Long(compareMe.getStringValue());
                    String className = tablerel.getClassName().substring(29);
                    if (className.equals("Agent")) {
                        className = className.toLowerCase();
                        Object tableObject = this.genericDBObject2(className, num);
                        return tableObject;
                    }
                    Object tableObject = this.loadOrCreateParentDataBaseObject(className, num);
                    return tableObject;
                }
                if ((tablerel == null || tablerel.getType().name() != "OneToMany") && (tablerel == null || tablerel.getType().name() != "ManyToMany")) break block21;
                if (compareMe.getName().equals(String.valueOf(parentName) + "s")) {
                    return "ManyToMany";
                }
                return "OneToMany";
            }
            try {
                log.debug((Object)("could not import element: " + compareMe.getName() + ", with data:" + compareMe.getData()));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                if (ex.toString().startsWith("java.lang.NumberFormatException")) {
                    return null;
                }
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected Object findTypeDataBaseParent(Element compareMe, String dbTable, long parentId, String parentName) {
        block22: {
            block23: {
                String lowerdbTable = dbTable.toLowerCase();
                DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
                String primaryKey = info.getPrimaryKeyName();
                DBFieldInfo fieldInfo = info.getFieldByName(compareMe.getName());
                if (fieldInfo != null || primaryKey.equals(compareMe.getName())) {
                    String type = new String();
                    if (fieldInfo == null) {
                        type = "java.lang.Integer";
                        System.out.println(compareMe.getStringValue());
                    } else {
                        type = fieldInfo.getType();
                    }
                    if (type.equals("java.lang.String") || type.equals("text")) {
                        return compareMe.getStringValue();
                    }
                    if (type.equals("java.util.Date")) {
                        Date dtTmp = new SimpleDateFormat("yy-MM-dd H:mm:ss").parse(compareMe.getStringValue());
                        return dtTmp;
                    }
                    if (type.equals("java.sql.Timestamp")) {
                        Timestamp tmstmp = Timestamp.valueOf(compareMe.getStringValue());
                        return tmstmp;
                    }
                    if (type.equals("java.lang.Integer")) {
                        int num = new Integer(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Boolean")) {
                        Boolean bool = Boolean.valueOf(compareMe.getStringValue());
                        return bool;
                    }
                    if (type.equals("java.math.BigDecimal")) {
                        BigDecimal num = UIHelper.parseDoubleToBigDecimal(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Double")) {
                        double num = new Double(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Float")) {
                        float num = new Float(compareMe.getStringValue()).floatValue();
                        return Float.valueOf(num);
                    }
                    if (type.equals("java.lang.Long")) {
                        long num = new Long(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Short")) {
                        short num = new Short(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.lang.Byte")) {
                        byte num = new Byte(compareMe.getStringValue());
                        return num;
                    }
                    if (type.equals("java.util.Calendar")) {
                        Calendar date = this.dateString2Calendar(compareMe.getStringValue());
                        return date;
                    }
                    break block22;
                }
                DBRelationshipInfo tablerel = info.getRelationshipByName(compareMe.getName());
                if (tablerel != null && tablerel.getType().name() == "ManyToOne" && !compareMe.getStringValue().equals("")) {
                    long num = new Long(compareMe.getStringValue());
                    String className = tablerel.getClassName().substring(29);
                    if (className.equals("Agent")) {
                        className = className.toLowerCase();
                        Object tableObject = this.genericDBObject2(className, num);
                        return tableObject;
                    }
                    Object tableObject = this.loadOrCreateParentDataBaseObject(className, num);
                    return tableObject;
                }
                if ((tablerel == null || tablerel.getType().name() != "OneToMany") && (tablerel == null || tablerel.getType().name() != "ManyToMany")) break block23;
                if (compareMe.getName().equals(String.valueOf(parentName) + "s")) {
                    return "ManyToMany";
                }
                return "OneToMany";
            }
            try {
                log.debug((Object)("could not import element: " + compareMe.getName() + ", with data:" + compareMe.getData()));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
                if (ex.toString().startsWith("java.lang.NumberFormatException")) {
                    return null;
                }
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected Object genericDBObject(String className, long id) {
        DBTableInfo manyToOneInfo = DBTableIdMgr.getInstance().getInfoByTableName(className);
        Object tableObject = new Object();
        try {
            tableObject = manyToOneInfo.getClassObj().newInstance();
            HashMap<String, Comparable<Long>> relationMap = new HashMap<String, Comparable<Long>>();
            Timestamp tmstmp = Timestamp.valueOf("9999-08-22 10:09:05");
            relationMap.put(className.concat("Id"), Long.valueOf(id));
            relationMap.put("timestampCreated", tmstmp);
            relationMap.put("timestampModified", tmstmp);
            BeanUtils.populate((Object)tableObject, relationMap);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return tableObject;
    }

    protected Object genericDBObject2(String className, long id) {
        int num = (int)id;
        DBTableInfo manyToOneInfo = DBTableIdMgr.getInstance().getInfoByTableName(className);
        Object tableObject2 = new Object();
        Object temp = new Object();
        try {
            tableObject2 = manyToOneInfo.getClassObj().newInstance();
            temp = this.session.load(tableObject2.getClass(), (Serializable)Integer.valueOf(num));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            if (ex.toString().startsWith("org.hibernate.NonUniqueObjectException")) {
                ex.printStackTrace();
            }
            if (ex.toString().startsWith("org.hibernate.ObjectNotFoundException")) {
                tableObject2 = this.genericDBObject(className, id);
                return tableObject2;
            }
            ex.printStackTrace();
        }
        return temp;
    }

    protected Object getParentDBObject(String className, long id) {
        int num = (int)id;
        Object dbObject = new Object();
        try {
            dbObject = this.buildSingleDBObject(className, num, false);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return dbObject;
    }

    protected Object loadOrCreateParentDataBaseObject(String className, long id) {
        int num = (int)id;
        String name = className.toLowerCase();
        DBTableInfo manyToOneInfo = DBTableIdMgr.getInstance().getInfoByTableName(name);
        String primaryKey = manyToOneInfo.getPrimaryKeyName();
        Object dbObject = new Object();
        Object temp = new Object();
        try {
            temp = manyToOneInfo.getClassObj().newInstance();
            dbObject = this.session.load(temp.getClass(), (Serializable)Integer.valueOf(num));
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            if (ex.toString().startsWith("org.hibernate.ObjectNotFoundException")) {
                dbObject = this.buildSingleDataBaseObject(className, num, false);
                long newParentId = new Long(this.session.getIdentifier(dbObject).toString());
                int newParentIdInt = (int)newParentId;
                this.session.evict(dbObject);
                if ((long)num != newParentId) {
                    try {
                        String requiredFields = this.constructSQLString(this.getRequiredFields(className));
                        String query = "INSERT INTO " + className.toLowerCase() + " (" + primaryKey + ") VALUES (" + newParentIdInt + ") ON DUPLICATE KEY UPDATE " + primaryKey + "=" + num;
                        if (StringUtils.isNotEmpty((String)requiredFields)) {
                            this.session.createSQLQuery(query).executeUpdate();
                        } else {
                            query = query.concat(requiredFields);
                            this.session.createSQLQuery(query).executeUpdate();
                        }
                        Object loaded = this.session.load(temp.getClass(), (Serializable)Integer.valueOf(num));
                        return loaded;
                    }
                    catch (Exception ex2) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(ImportExportDB.class, ex2);
                        ex2.printStackTrace();
                    }
                }
            }
            ex.printStackTrace();
        }
        return dbObject;
    }

    public void writeRecordSet(String dbTable, int id) {
        List<String> children = new ArrayList<String>();
        List<String> parents = new ArrayList<String>();
        List<Object> parentsChildren = new ArrayList();
        children = this.getChildTables(dbTable, children);
        parents = this.getParentTables(dbTable, parents, false);
        int i = 0;
        while (i < parents.size()) {
            String db = parents.get(i).toString();
            if (!db.equals("Agent")) {
                parentsChildren = this.getChildTables(db, parentsChildren);
            }
            ++i;
        }
        parentsChildren = this.removeDuplicates(parentsChildren);
        i = 0;
        while (i < children.size()) {
            this.writeXMLfile(children.get(i));
            ++i;
        }
        i = 0;
        while (i < parents.size()) {
            if (!children.contains(parents.get(i))) {
                this.writeXMLfile(parents.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < parentsChildren.size()) {
            String pChild = (String)parentsChildren.get(i);
            if (!children.contains(pChild) || !parents.contains(pChild)) {
                this.writeXMLfile(pChild);
            }
            ++i;
        }
        this.writeSingleRecordXML(dbTable, id);
    }

    private List<String> getChildTables(String dbTable, List<String> children) {
        String lowerdbTable = dbTable.toLowerCase();
        DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
        try {
            List<DBRelationshipInfo> relatedTables = info.getRelationships();
            Iterator<DBRelationshipInfo> i = relatedTables.iterator();
            do {
                DBRelationshipInfo table = i.next();
                String type = table.getType().name();
                String childName = table.getClassName().substring(29);
                if (childName.equals("Agent") || children.contains(childName) || !type.equals("OneToMany") && !type.equals("OneToOne")) continue;
                children.add(childName);
                children = this.getChildTables(childName, children);
            } while (i.hasNext());
        }
        catch (NullPointerException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            log.debug((Object)("table: " + dbTable + " does not exsist"));
        }
        return children;
    }

    private List<String> getParentTables(String dbTable, List<String> parents, Boolean foundAgent) {
        String lowerdbTable = dbTable.toLowerCase();
        DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
        try {
            List<DBRelationshipInfo> relatedTables = info.getRelationships();
            Iterator<DBRelationshipInfo> i = relatedTables.iterator();
            do {
                DBRelationshipInfo table;
                String type;
                if (!(type = (table = i.next()).getType().name()).equals("ManyToOne") && !type.equals("ManyToMany")) continue;
                String parentName = table.getClassName().substring(29);
                if (parentName.equals("agent") && !foundAgent.booleanValue() && !parents.contains(parentName)) {
                    foundAgent = true;
                    parents.add(parentName);
                    parents = this.getParentTables(parentName, parents, foundAgent);
                    continue;
                }
                if (parentName.equals("agent") || parents.contains(parentName)) continue;
                parents.add(parentName);
                parents = this.getParentTables(parentName, parents, foundAgent);
            } while (i.hasNext());
        }
        catch (NullPointerException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            log.debug((Object)("table:" + dbTable + " does not exsist"));
        }
        return parents;
    }

    private List<String> getImmediateParentTables(String dbTable, List<String> parents, Boolean foundAgent) {
        String lowerdbTable = dbTable.toLowerCase();
        DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(lowerdbTable);
        try {
            List<DBRelationshipInfo> relatedTables = info.getRelationships();
            Iterator<DBRelationshipInfo> i = relatedTables.iterator();
            do {
                DBRelationshipInfo table;
                String type;
                if (!(type = (table = i.next()).getType().name()).equals("ManyToOne") && !type.equals("ManyToMany")) continue;
                String parentName = table.getClassName().substring(29);
                if (parentName.equals("agent") && !foundAgent.booleanValue() && !parents.contains(parentName)) {
                    foundAgent = true;
                    parents.add(parentName);
                    continue;
                }
                if (parentName.equals("agent") || parents.contains(parentName)) continue;
                parents.add(parentName);
            } while (i.hasNext());
        }
        catch (NullPointerException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            log.debug((Object)("table: " + dbTable + " does not exsist"));
        }
        return parents;
    }

    public void printXML(String dbTable) {
        Session dom4jSession = this.session.getSession(EntityMode.DOM4J);
        String query = "from " + dbTable;
        List userXML = dom4jSession.createQuery(query).list();
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)System.out, format);
            int i = 0;
            while (i < userXML.size()) {
                Element writeMe = (Element)userXML.get(i);
                writer.write(writeMe);
                ++i;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        System.out.println();
    }

    public void printRecordSet(String dbTable) {
        List<String> children = new ArrayList<String>();
        List<String> parents = new ArrayList<String>();
        children = this.removeDuplicates(this.getChildTables(dbTable, children));
        parents = this.getParentTables(dbTable, parents, false);
        System.out.println("----Parents------------");
        int i = 0;
        while (i < parents.size()) {
            this.printXML(parents.get(i));
            System.out.println("-------------------\n");
            ++i;
        }
        System.out.println("----Children------------");
        i = 0;
        while (i < children.size()) {
            this.printXML(children.get(i));
            System.out.println("-------------------\n");
            ++i;
        }
    }

    public void exportTables() {
        Vector<DBTableInfo> allTables = DBTableIdMgr.getInstance().getTables();
        int i = 0;
        while (i < allTables.size()) {
            String table = allTables.get(i).getClassName().substring(29);
            if (table.equals("DataType") || table.equals("Discipline") || table.equals("Division") || table.equals("GeographyTreeDef") || table.equals("GeographyTreeDefItem") || table.equals("GeologicTimePeriodTreeDef") || table.equals("GeologicTimePeriodTreeDefItem") || table.equals("Institution") || table.equals("LithoStratTreeDef") || table.equals("LithoStratTreeDefItem") || table.equals("SpecifyUser") || table.equals("SpLocaleBase") || table.equals("SpLocaleContainer") || table.equals("SpLocaleContainerItem") || table.equals("StorageTreeDef") || table.equals("StorageTreeDefItem") || table.equals("Taxon") || table.equals("TaxonTreeDef") || table.equals("TaxonTreeDefItem") || table.equals("TreatmentEvent") || table.equals("UserPermission") || table.equals("Workbench") || table.equals("WorkbenchRow") || table.equals("WorkbenchTemplate") || table.equals("WorkbenchTemplateMappingItem")) {
                System.out.println("skipped: " + table);
            } else {
                this.writeXMLfile(table);
            }
            ++i;
        }
        System.out.println("...done");
    }

    public void printSingleRecordXML(String dbTable, int id) {
        Session dom4jSession = this.session.getSession(EntityMode.DOM4J);
        DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
        String primaryKey = info.getPrimaryKeyName();
        String query = "from " + dbTable + " where " + primaryKey + " = " + id;
        List userXML = dom4jSession.createQuery(query).list();
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)System.out, format);
            int i = 0;
            while (i < userXML.size()) {
                Element writeMe = (Element)userXML.get(i);
                writer.write(writeMe);
                ++i;
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        System.out.println();
    }

    public void writeSingleRecordXML(String dbTable, int id) {
        Session dom4jSession = this.session.getSession(EntityMode.DOM4J);
        DBTableInfo info = DBTableIdMgr.getInstance().getInfoByTableName(dbTable.toLowerCase());
        String primaryKey = info.getPrimaryKeyName();
        String query = "from " + dbTable + " where " + primaryKey + " = " + id;
        List userXML = dom4jSession.createQuery(query).list();
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(this.importFolderPath) + dbTable + ".xml");
            PrintStream p = new PrintStream(fout);
            p.print("<root>");
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fout, format);
            int i = 0;
            while (i < userXML.size()) {
                Element writeMe = (Element)userXML.get(i);
                writer.write(writeMe);
                ++i;
            }
            p.println("\n</root>");
            p.close();
            fout.close();
            writer.close();
            System.out.println("Wrote: " + dbTable + ".xml");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        System.out.println();
    }

    public void writeXMLfile(String dataBase) {
        Session dom4jSession = this.session.getSession(EntityMode.DOM4J);
        String query = "from " + dataBase + " where id = 1";
        System.out.println(query);
        List userXML = dom4jSession.createQuery(query).list();
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(this.importFolderPath) + dataBase + ".xml");
            PrintStream p = new PrintStream(fout);
            p.print("<root>");
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fout, format);
            int i = 0;
            while (i < userXML.size()) {
                Element writeMe = (Element)userXML.get(i);
                writer.write(writeMe);
                ++i;
            }
            p.println("\n</root>");
            p.close();
            fout.close();
            writer.close();
            System.out.println("Wrote: " + dataBase + ".xml");
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
    }

    void close() {
        if (this.session.isOpen()) {
            this.session.close();
        }
    }

    public String capFirstChar(String text) {
        text = String.valueOf(text.substring(0, 1).toUpperCase()) + text.substring(1);
        return text;
    }

    public String lowerFirstChar(String text) {
        text = String.valueOf(text.substring(0, 1).toLowerCase()) + text.substring(1);
        return text;
    }

    public String removeLastChar(String text) {
        text = text.substring(0, text.length() - 1);
        return text;
    }

    public String getDbName(List dbElements) {
        Element temp = (Element)dbElements.get(0);
        String dbName = temp.getName();
        return dbName;
    }

    public String getDbName(Vector dbElements) {
        Element temp = (Element)dbElements.get(0);
        String dbName = temp.getName();
        return dbName;
    }

    protected Calendar dateString2Calendar(String newstring) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMMMMMMM yyyy");
        Calendar cal = Calendar.getInstance();
        try {
            Date date = df.parse(newstring);
            cal.setTime(date);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ImportExportDB.class, ex);
            ex.printStackTrace();
        }
        return cal;
    }

    private List removeDuplicates(List list) {
        HashSet set = new HashSet();
        set.addAll(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public List<String> getRequiredFields(String className) {
        DBTableInfo dbTableInfo = DBTableIdMgr.getInstance().getInfoByTableName(className.toLowerCase());
        List<DBFieldInfo> fields = dbTableInfo.getFields();
        List<DBRelationshipInfo> relFields = dbTableInfo.getRelationships();
        ArrayList<String> requiredFields = new ArrayList<String>();
        int i = 0;
        while (i < fields.size()) {
            if (fields.get(i).isRequired()) {
                requiredFields.add(fields.get(i).getName());
            }
            ++i;
        }
        i = 0;
        while (i < relFields.size()) {
            if (relFields.get(i).isRequired()) {
                String name = String.valueOf(relFields.get(i).getClassName().substring(29)) + "ID";
                requiredFields.add(name);
            }
            ++i;
        }
        return requiredFields;
    }

    private String constructSQLString(List<String> requiredFields) {
        if (requiredFields.isEmpty() || requiredFields == null) {
            return null;
        }
        String query = new String();
        int i = 0;
        while (i < requiredFields.size()) {
            String field = requiredFields.get(i);
            query = query.concat(", " + field + "=" + field);
            ++i;
        }
        return query;
    }
}

