/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.AuditInterceptor;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.function.ClassicAvgFunction;
import org.hibernate.dialect.function.ClassicCountFunction;
import org.hibernate.dialect.function.ClassicSumFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.hql.ast.ASTQueryTranslatorFactory;

public class HibernateUtil {
    protected static final Logger log = Logger.getLogger(HibernateUtil.class);
    private static Configuration configuration = null;
    private static SessionFactory sessionFactory = null;
    private static ThreadLocal<Object> threadSession = new ThreadLocal();
    private static ThreadLocal<Object> threadTransaction = new ThreadLocal();
    private static boolean useThreadLocal = true;
    private static Hashtable<String, Object> eventListeners = new Hashtable();

    public static void setHibernateLogonConfig(Configuration config) {
        DBConnection dbConn = DBConnection.getInstance();
        String userName = dbConn.getUserName();
        String password = dbConn.getPassword();
        String driver = dbConn.getDriver();
        String connection = dbConn.getConnectionStr();
        config.setProperty("hibernate.connection.username", userName);
        config.setProperty("hibernate.connection.password", password);
        config.setProperty("hibernate.connection.autoReconnect", "true");
        config.setProperty("hibernate.connection.autoReconnectForPools", "true");
        config.setProperty("hibernate.connection.is-connection-validation-required", "true");
        config.setProperty("connection.autoReconnect", "true");
        config.setProperty("connection.autoReconnectForPools", "true");
        config.setProperty("connection.is-connection-validation-required", "true");
        log.info((Object)("Using database [" + connection + "]"));
        if (connection.indexOf("inetdae7") != -1) {
            throw new RuntimeException("Connection string does not support SQLServer!");
        }
        config.setProperty("hibernate.connection.url", connection);
        config.setProperty("hibernate.dialect", dbConn.getDialect());
        config.setProperty("hibernate.connection.driver_class", driver);
        config.addSqlFunction("count", (SQLFunction)new ClassicCountFunction());
        config.addSqlFunction("avg", (SQLFunction)new ClassicAvgFunction());
        config.addSqlFunction("sum", (SQLFunction)new ClassicSumFunction());
    }

    public static void setListener(String type, Object listener) {
        eventListeners.put(type, listener);
    }

    public static void initialize() {
        if (configuration != null) {
            HibernateUtil.shutdown();
        }
        try {
            configuration = new AnnotationConfiguration().configure();
            AuditInterceptor auditInter = AuditInterceptor.getInstance();
            Enumeration<String> e = eventListeners.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                configuration.setListener(key, eventListeners.get(key));
            }
            HibernateUtil.setHibernateLogonConfig(configuration);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Throwable ex) {
            log.error((Object)"Building SessionFactory failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static org.hibernate.Session getNewSession() {
        Session session = HibernateUtil.getSessionFactory().openSession();
        return session;
    }

    public static SessionFactory getSessionFactory() {
        if (configuration == null) {
            HibernateUtil.initialize();
        }
        SessionFactory sf = null;
        String sfName = configuration.getProperty("hibernate.session_factory_name");
        if (sfName != null) {
            try {
                sf = (SessionFactory)new InitialContext().lookup(sfName);
            }
            catch (NamingException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateUtil.class, ex);
                throw new RuntimeException(ex);
            }
        } else {
            sf = sessionFactory;
        }
        if (sf == null) {
            throw new IllegalStateException("SessionFactory not available.");
        }
        return sf;
    }

    public static void shutdown() {
        if (configuration != null) {
            HibernateUtil.closeSession();
            HibernateUtil.getSessionFactory().close();
            configuration = null;
            sessionFactory = null;
            threadSession.set(null);
            threadTransaction.set(null);
            configuration = null;
        }
    }

    public static void rebuildSessionFactory() {
        HibernateUtil.rebuildSessionFactory(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSessionFactory(Configuration cfg) {
        SessionFactory sessionFactory = HibernateUtil.sessionFactory;
        synchronized (sessionFactory) {
            if (HibernateUtil.sessionFactory != null && !HibernateUtil.sessionFactory.isClosed()) {
                HibernateUtil.sessionFactory.close();
            }
            if (cfg.getProperty("hibernate.session_factory_name") != null) {
                cfg.buildSessionFactory();
            } else {
                HibernateUtil.sessionFactory = cfg.buildSessionFactory();
            }
            configuration = cfg;
        }
    }

    public static org.hibernate.Session getCurrentSession() {
        if (useThreadLocal) {
            org.hibernate.Session s = (org.hibernate.Session)threadSession.get();
            if (s == null) {
                s = HibernateUtil.getSessionFactory().openSession();
                threadSession.set(s);
            }
            return s;
        }
        Session s = HibernateUtil.getSessionFactory().getCurrentSession();
        return s;
    }

    public static void closeSession() {
        if (useThreadLocal) {
            org.hibernate.Session s = (org.hibernate.Session)threadSession.get();
            threadSession.set(null);
            Transaction tx = (Transaction)threadTransaction.get();
            if (!(tx == null || tx.wasCommitted() && tx.wasRolledBack())) {
                throw new IllegalStateException("Closing Session but Transaction still open!");
            }
            if (s != null && s.isOpen()) {
                s.close();
            }
        } else {
            log.warn((Object)"Using CMT/JTA, intercepted superfluous close call.");
        }
    }

    public static void beginTransaction() {
        if (useThreadLocal) {
            Transaction tx = (Transaction)threadTransaction.get();
            if (tx == null) {
                tx = HibernateUtil.getCurrentSession().beginTransaction();
                threadTransaction.set(tx);
            }
        } else {
            log.warn((Object)"Using CMT/JTA, intercepted superfluous tx begin call.");
        }
    }

    public static void commitTransaction() {
        if (useThreadLocal) {
            Transaction tx = (Transaction)threadTransaction.get();
            try {
                if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                    tx.commit();
                }
                threadTransaction.set(null);
            }
            catch (RuntimeException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(HibernateUtil.class, ex);
                log.error((Object)ex);
                HibernateUtil.rollbackTransaction();
                throw ex;
            }
        } else {
            log.warn((Object)"Using CMT/JTA, intercepted superfluous tx commit call.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rollbackTransaction() {
        if (useThreadLocal) {
            Transaction tx = (Transaction)threadTransaction.get();
            try {
                try {
                    threadTransaction.set(null);
                    if (tx == null || tx.wasCommitted() || tx.wasRolledBack()) return;
                    tx.rollback();
                    return;
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Might swallow original cause, check ERROR log!", ex);
                }
            }
            finally {
                HibernateUtil.closeSession();
            }
        } else {
            log.warn((Object)"Using CMT/JTA, intercepted superfluous tx rollback call.");
        }
    }

    public static void reconnect(org.hibernate.Session session) {
        if (useThreadLocal) {
            session.reconnect(DBConnection.getInstance().getConnection());
            threadSession.set(session);
        } else {
            log.error((Object)"Using CMT/JTA, intercepted not supported reconnect call.");
        }
    }

    public static org.hibernate.Session disconnectSession() {
        if (useThreadLocal) {
            Transaction tx = (Transaction)threadTransaction.get();
            if (!(tx == null || tx.wasCommitted() && tx.wasRolledBack())) {
                throw new IllegalStateException("Disconnecting Session but Transaction still open!");
            }
            org.hibernate.Session session = HibernateUtil.getCurrentSession();
            threadSession.set(null);
            if (session.isConnected() && session.isOpen()) {
                session.disconnect();
            }
            return session;
        }
        log.error((Object)"Using CMT/JTA, intercepted not supported disconnect call.");
        return null;
    }

    public static void registerInterceptorAndRebuild(Interceptor interceptor) {
        configuration.setInterceptor(interceptor);
        HibernateUtil.rebuildSessionFactory();
    }

    public static Interceptor getInterceptor() {
        return configuration.getInterceptor();
    }

    public static void attach(Object obj, org.hibernate.Session session) {
        try {
            session.lock(obj, LockMode.NONE);
        }
        catch (HibernateException he) {
            log.warn((Object)"Exception thrown in attach()", (Throwable)he);
        }
    }

    public static String toSql(String hqlQueryText) {
        if (hqlQueryText != null && hqlQueryText.trim().length() > 0) {
            ASTQueryTranslatorFactory translatorFactory = new ASTQueryTranslatorFactory();
            SessionFactoryImplementor factory = (SessionFactoryImplementor)sessionFactory;
            QueryTranslator translator = translatorFactory.createQueryTranslator(hqlQueryText, hqlQueryText, Collections.EMPTY_MAP, factory);
            translator.compile(Collections.EMPTY_MAP, false);
            return translator.getSQLString();
        }
        return null;
    }
}

