/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class DatabaseDriverInfo
implements Comparable<DatabaseDriverInfo> {
    private static final Logger log = Logger.getLogger(DatabaseDriverInfo.class);
    protected static SoftReference<Vector<DatabaseDriverInfo>> driverList = null;
    protected String name;
    protected String driver;
    protected String dialect;
    protected boolean isEmbedded;
    protected String port;
    protected Hashtable<ConnectionType, String> connectionFormats = new Hashtable();

    public DatabaseDriverInfo(String name, String driver, String dialect, boolean isEmbedded, String port) {
        this.name = name;
        this.driver = driver;
        this.dialect = dialect;
        this.isEmbedded = isEmbedded;
        this.port = port;
    }

    public void addFormat(ConnectionType type, String connFormatStr) {
        if (type != null && StringUtils.isNotEmpty((String)connFormatStr)) {
            this.connectionFormats.put(type, connFormatStr);
        }
    }

    protected String subForDataDir(String connStr) {
        String dataDir = UIRegistry.getEmbeddedDBPath();
        if (StringUtils.isNotEmpty((String)dataDir)) {
            dataDir = new File(dataDir).getAbsolutePath();
            return StringUtils.replace((String)connStr, (String)"DATADIR", (String)dataDir);
        }
        return connStr;
    }

    public String getConnectionStr(ConnectionType type, String server, String database) {
        return this.getConnectionStr(type, server, database, true, true, null, null, this.getName());
    }

    public String getConnectionStr(ConnectionType type, String server, String databaseName, boolean doAddAsDBName, boolean doAddToPath, String username, String password, String serverType) {
        String connStr = this.connectionFormats.get((Object)type);
        if (connStr != null) {
            if (serverType != null && serverType.equals("SQLServer")) {
                connStr = connStr.replaceFirst("DATABASE", StringUtils.isNotEmpty((String)databaseName) && doAddAsDBName ? databaseName : "");
                connStr = connStr.replaceFirst("USERNAME", StringUtils.isNotEmpty((String)username) ? username : "");
                connStr = connStr.replaceFirst("PASSWORD", StringUtils.isNotEmpty((String)password) ? password : "");
                return StringUtils.isNotEmpty((String)server) ? connStr.replaceFirst("SERVER", server) : connStr;
            }
            connStr = this.subForDataDir(connStr);
            connStr = connStr.replaceFirst("DATABASE", StringUtils.isNotEmpty((String)databaseName) && doAddAsDBName ? databaseName : "");
            connStr = connStr.replaceFirst("USERNAME", StringUtils.isNotEmpty((String)username) ? username : "");
            connStr = connStr.replaceFirst("PASSWORD", StringUtils.isNotEmpty((String)password) ? password : "");
            connStr = connStr.replaceFirst("PORT", StringUtils.isNotEmpty((String)this.port) ? this.port : "");
            if (this.isEmbedded && doAddToPath) {
                connStr = connStr.replaceFirst("SPECIFY_DATA", String.valueOf(databaseName) + "_data");
            }
            return StringUtils.isNotEmpty((String)server) ? connStr.replaceFirst("SERVER", server) : connStr;
        }
        return null;
    }

    public String getConnectionStr(ConnectionType type, String server, String database, String username, String password, String serverType) {
        return this.getConnectionStr(type, server, database, true, true, username, password, serverType);
    }

    public String getDialectClassName() {
        return this.dialect;
    }

    public String getDriverClassName() {
        return this.driver;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public String toString() {
        return this.name;
    }

    public String getPort() {
        return this.port;
    }

    public Integer getPortAsInt() {
        return this.port != null && StringUtils.isNumeric((String)this.port) ? Integer.valueOf(Integer.parseInt(this.port)) : null;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setPort(Integer port) {
        this.port = port != null ? port.toString() : null;
    }

    @Override
    public int compareTo(DatabaseDriverInfo obj) {
        return this.name.compareTo(obj.name);
    }

    public static DatabaseDriverInfo getDriver(String drvName) {
        Vector<DatabaseDriverInfo> list = DatabaseDriverInfo.getDriversList();
        int inx = -1;
        for (DatabaseDriverInfo ddi : list) {
            ++inx;
            if ((ddi.getDriverClassName() == null || !ddi.getDriverClassName().equals(drvName)) && !ddi.getName().equals(drvName)) continue;
            return list.get(inx);
        }
        return null;
    }

    public static Vector<DatabaseDriverInfo> getDriversList() {
        Vector<DatabaseDriverInfo> list = null;
        if (driverList != null) {
            list = driverList.get();
        }
        if (list == null) {
            driverList = new SoftReference<Vector<DatabaseDriverInfo>>(DatabaseDriverInfo.loadDatabaseDriverInfo());
        }
        return driverList.get();
    }

    protected static Vector<DatabaseDriverInfo> loadDatabaseDriverInfo() {
        Vector<DatabaseDriverInfo> dbDrivers;
        block8: {
            dbDrivers = new Vector<DatabaseDriverInfo>();
            try {
                Element root = XMLHelper.readFileToDOM4J(new FileInputStream(XMLHelper.getConfigDirPath("dbdrivers.xml")));
                if (root != null) {
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    Iterator i = root.elementIterator("db");
                    while (i.hasNext()) {
                        Element dbElement = (Element)i.next();
                        String name = XMLHelper.getAttr(dbElement, "name", null);
                        if (hash.get(name) == null) {
                            hash.put(name, name);
                            String driver = XMLHelper.getAttr(dbElement, "driver", null);
                            String dialect = XMLHelper.getAttr(dbElement, "dialect", null);
                            String port = XMLHelper.getAttr(dbElement, "port", null);
                            boolean isEmbedded = XMLHelper.getAttr(dbElement, "embedded", false);
                            if (UIRegistry.isEmbedded() == false && !UIRegistry.isMobile() ? isEmbedded : !isEmbedded) continue;
                            if (StringUtils.isEmpty((String)driver)) {
                                throw new RuntimeException("Driver cannot be null!");
                            }
                            if (StringUtils.isEmpty((String)driver)) {
                                throw new RuntimeException("Dialect cannot be null!");
                            }
                            DatabaseDriverInfo drv = new DatabaseDriverInfo(name, driver, dialect, isEmbedded, port);
                            Iterator connIter = dbElement.elementIterator("connection");
                            while (connIter.hasNext()) {
                                Element connElement = (Element)connIter.next();
                                String typeStr = XMLHelper.getAttr(connElement, "type", null);
                                String connFormat = connElement.getTextTrim();
                                ConnectionType type = ConnectionType.valueOf(StringUtils.capitalize((String)typeStr));
                                drv.addFormat(type, connFormat);
                            }
                            dbDrivers.add(drv);
                            continue;
                        }
                        log.error((Object)("Database Driver Name[" + name + "] is in use."));
                    }
                    break block8;
                }
                String msg = "The root element for the document was null!";
                log.error((Object)msg);
                throw new ConfigurationException(msg);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DatabaseDriverInfo.class, ex);
                ex.printStackTrace();
                log.error((Object)ex);
            }
        }
        Collections.sort(dbDrivers);
        return dbDrivers;
    }

    public static DatabaseDriverInfo getInfoByName(Vector<DatabaseDriverInfo> dbDrivers, String name) {
        int inx = Collections.binarySearch(dbDrivers, new DatabaseDriverInfo(name, null, null, false, null));
        return inx > -1 ? dbDrivers.get(inx) : null;
    }

    public static enum ConnectionType {
        Create,
        Open,
        Close,
        Opensys;

    }
}

