/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DataProviderIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DataProviderFactory {
    public static final String factoryName = "edu.ku.brc.dbsupport.DataProvider";
    private static DataProviderIFace instance = null;

    public static DataProviderIFace getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(DataProviderFactory.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = Class.forName(factoryNameStr).asSubclass(DataProviderIFace.class).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DataProviderFactory.class, e);
                InternalError error = new InternalError("Can't instantiate DataProviderFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        throw new InternalError("Can't instantiate DataProviderFactory factory becase edu.ku.brc.dbsupport.DataProvider has not been set.");
    }
}

