/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.List;

public abstract class DBMSUserMgr {
    public static String factoryName = "edu.ku.brc.dbsupport.DBMSUserMgr";
    public static final int PERM_NONE = 0;
    public static final int PERM_SELECT = 1;
    public static final int PERM_UPDATE = 2;
    public static final int PERM_DELETE = 4;
    public static final int PERM_INSERT = 8;
    public static final int PERM_LOCK_TABLES = 16;
    public static final int PERM_ALL_BASIC = 31;
    public static final int PERM_ALTER_TABLE = 64;
    public static final int PERM_CREATE_TABLE = 128;
    public static final int PERM_DROP_TABLE = 512;
    public static final int PERM_ALL = 1023;
    public static final int PERM_NO_ACCESS = 1024;
    private static DBMSUserMgr instance = null;
    protected String hostName = null;
    protected String errMsg = null;

    public abstract boolean createDatabase(String var1);

    public abstract boolean dropDatabase(String var1);

    public abstract boolean dropTable(String var1);

    public abstract boolean dropUser(String var1);

    public abstract boolean doesDBExists(String var1);

    public abstract boolean doesUserExists(String var1);

    public abstract boolean changePassword(String var1, String var2, String var3);

    public abstract boolean close();

    public abstract boolean connectToDBMS(String var1, String var2, String var3);

    public abstract boolean connect(String var1, String var2, String var3, String var4);

    public abstract void setConnection(Connection var1);

    public abstract Connection getConnection();

    public abstract boolean doesFieldExistInTable(String var1, String var2);

    public abstract Integer getFieldLength(String var1, String var2);

    public abstract boolean createUser(String var1, String var2, String var3, int var4);

    public abstract boolean doesDBHaveTables();

    public abstract boolean doesDBHaveTable(String var1);

    public abstract boolean doesDBHaveTable(String var1, String var2);

    public abstract boolean verifyEngineAndCharSet(String var1);

    public String getErrorMsg() {
        return this.errMsg;
    }

    public abstract boolean removeUser(String var1, String var2);

    public abstract int getPermissionsForUpdate(String var1, String var2);

    public abstract int getPermissionsForAccess(String var1, String var2);

    public abstract boolean setPermissions(String var1, String var2, int var3);

    public abstract List<String> getDatabaseList();

    public abstract List<String> getDatabaseListForUser(String var1);

    public abstract boolean canGrantPemissions(String var1, String var2);

    public abstract int getPermissionsForUser(String var1);

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public static DBSTATUS isOkToProceed(String dbName, String hostName, String itUsername, String itPassword) {
        DBSTATUS status = DBMSUserMgr.checkForDB(dbName, hostName, itUsername, itPassword);
        if (status == DBSTATUS.hasTables || status == DBSTATUS.emptyDB) {
            status = UIHelper.promptForAction("PROCEED", "CANCEL", "DEL_CUR_DB_TITLE", UIRegistry.getLocalizedMessage("DEL_CUR_DB", dbName)) ? DBSTATUS.ok : DBSTATUS.cancelled;
        }
        return status;
    }

    public static DBSTATUS checkForDB(String dbName, String hostName, String itUsername, String itPassword) {
        boolean isEmbedded = DBConnection.getInstance().isEmbedded();
        if (isEmbedded) {
            File dbDataDir = DBConnection.getEmbeddedDataDir();
            if (dbDataDir != null) {
                return dbDataDir.exists() ? DBSTATUS.hasTables : DBSTATUS.missingDB;
            }
            return DBSTATUS.error;
        }
        DBMSUserMgr mgr = null;
        try {
            mgr = DBMSUserMgr.getInstance();
            if (mgr.connectToDBMS(itUsername, itPassword, hostName)) {
                if (mgr.doesDBExists(dbName)) {
                    mgr.close();
                    if (mgr.connect(itUsername, itPassword, hostName, dbName)) {
                        DBSTATUS dBSTATUS = mgr.doesDBHaveTables() ? DBSTATUS.hasTables : DBSTATUS.emptyDB;
                        return dBSTATUS;
                    }
                    DBSTATUS dBSTATUS = DBSTATUS.error;
                    return dBSTATUS;
                }
                DBSTATUS dBSTATUS = DBSTATUS.missingDB;
                return dBSTATUS;
            }
            DBSTATUS dBSTATUS = DBSTATUS.error;
            return dBSTATUS;
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, ex);
        }
        finally {
            if (mgr != null) {
                mgr.close();
            }
        }
        return DBSTATUS.error;
    }

    public static DBMSUserMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = Class.forName(factoryNameStr).asSubclass(DBMSUserMgr.class).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBMSUserMgr.class, e);
                InternalError error = new InternalError("Can't instantiate DBMSUserMgr factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        throw new InternalError("Can't instantiate DBMSUserMgr factory becase " + factoryName + " has not been set.");
    }

    public static enum DBSTATUS {
        ok,
        hasTables,
        missingDB,
        emptyDB,
        error,
        cancelled;

    }
}

