/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import com.mysql.management.driverlaunched.ServerLauncherSocketFactory;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.config.init.SpecifyDBSetupWizard;
import edu.ku.brc.specify.dbsupport.TaskSemaphoreMgr;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DBConnection {
    private static final Logger log = Logger.getLogger(DBConnection.class);
    private static int dbCnt = 0;
    private static boolean debugCnt = false;
    private static SQLException loginException = null;
    protected String dbUsername;
    protected String dbPassword;
    protected String dbConnectionStr;
    protected String dbCloseConnectionStr = null;
    protected String dbDriver;
    protected String dbDialect;
    protected String dbName;
    protected String serverName;
    protected String dbDriverName;
    protected boolean argHaveBeenChecked = false;
    protected boolean skipDBNameCheck = false;
    protected Connection connection = null;
    protected String errMsg = "";
    protected static final DBConnection instance;
    protected static Boolean isEmbeddedDB;
    protected static File embeddedDataDir;
    protected static Stack<DBConnection> connections;
    protected static boolean isShuttingDown;
    protected static File mobileMachineDir;
    protected static boolean isCopiedToMachineDisk;
    protected static boolean hasCopiedToMobileDisk;
    protected static AtomicBoolean finalShutdownComplete;
    protected static ShutdownUIIFace shutdownUI;
    protected static boolean firstTime;
    protected static boolean connectionCreated;

    static {
        mobileMachineDir = null;
        isCopiedToMachineDisk = false;
        hasCopiedToMobileDisk = false;
        finalShutdownComplete = new AtomicBoolean(false);
        shutdownUI = null;
        firstTime = true;
        connectionCreated = false;
        isShuttingDown = false;
        isEmbeddedDB = null;
        embeddedDataDir = null;
        connections = new Stack();
        instance = new DBConnection();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (connectionCreated) {
                            DBConnection.shutdownFinalConnection(false, true);
                        }
                    }
                });
                return null;
            }
        });
    }

    protected DBConnection() {
        connections.push(this);
        if (debugCnt) {
            System.err.println("Connection Cnt: " + ++dbCnt);
        }
    }

    public static boolean isEmbedded(String connectionStr) {
        return StringUtils.isNotEmpty((String)connectionStr) && StringUtils.contains((String)connectionStr, (String)"mxj");
    }

    public static void setIsEmbeddedDB(Boolean isEmbeddedDB) {
        DBConnection.isEmbeddedDB = isEmbeddedDB;
    }

    public static void checkForEmbeddedDir(String connectionStr) {
        int eInx;
        String attr;
        int inx;
        isEmbeddedDB = DBConnection.isEmbedded(connectionStr);
        if (isEmbeddedDB.booleanValue() && (inx = connectionStr.indexOf(attr = "server.basedir=")) > -1 && (eInx = connectionStr.indexOf("&", inx += attr.length())) > -1) {
            embeddedDataDir = new File(connectionStr.substring(inx, eInx));
        }
    }

    public static void setShutdownUI(ShutdownUIIFace shutdownUI) {
        DBConnection.shutdownUI = shutdownUI;
    }

    public static void startOver() {
        finalShutdownComplete.set(false);
    }

    public static void shutdownFinalConnection(final boolean doExit, boolean doImmediately) {
        if (!finalShutdownComplete.get()) {
            if (shutdownUI != null) {
                shutdownUI.displayShutdownMsgDlg();
            }
            if (doImmediately) {
                DBConnection.doingShutdownFinalConnection(doExit);
            } else {
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        super.done();
                        DBConnection.doingShutdownFinalConnection(doExit);
                    }
                };
                worker.execute();
            }
        }
    }

    private static void doingShutdownFinalConnection(boolean doExit) {
        if (isEmbeddedDB != null && isEmbeddedDB.booleanValue()) {
            ServerLauncherSocketFactory.shutdown((File)embeddedDataDir, null);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (UIRegistry.isMobile()) {
            DBConnection.copyToMobileDisk();
        }
        finalShutdownComplete.set(true);
        if (shutdownUI != null) {
            shutdownUI.displayFinalShutdownDlg();
        }
        if (doExit) {
            System.exit(0);
        }
    }

    public static void clearEmbeddedBinDir() {
        try {
            File binDir;
            boolean rmDir = true;
            try {
                File osFile;
                File mobileEmbeddedDir = new File(UIRegistry.getMobileEmbeddedDBPath());
                if (mobileEmbeddedDir.exists() && (osFile = new File(String.valueOf(UIRegistry.getMobileEmbeddedDBPath()) + File.separator + "os.txt")).exists()) {
                    String os = FileUtils.readFileToString((File)osFile);
                    if (UIHelper.getOSType().toString().equals(os)) {
                        rmDir = false;
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (rmDir && (binDir = new File(String.valueOf(UIRegistry.getMobileEmbeddedDBPath()) + File.separator + "bin")).exists()) {
                FileUtils.deleteDirectory((File)binDir);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isEmbedded() {
        return isEmbeddedDB == null ? false : isEmbeddedDB;
    }

    public static File getEmbeddedDataDir() {
        return embeddedDataDir;
    }

    public DBConnection(String dbUsername, String dbPassword, String dbConnectionStr, String dbDriver, String dbDialect, String dbName) {
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.dbConnectionStr = dbConnectionStr;
        this.dbDriver = dbDriver;
        this.dbDialect = dbDialect;
        this.dbName = dbName;
        this.skipDBNameCheck = dbName == null;
        connections.push(this);
        DBConnection.checkForEmbeddedDir(dbConnectionStr);
        if (debugCnt) {
            System.err.println("DB Connection Cnt: " + ++dbCnt);
        }
    }

    public String getErrorMsg() {
        return this.errMsg;
    }

    public void setSkipDBNameCheck(boolean skipDBNameCheck) {
        this.skipDBNameCheck = skipDBNameCheck;
    }

    public static SQLException getLoginException() {
        return loginException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection createConnection() {
        connectionCreated = true;
        if (shutdownUI != null && firstTime) {
            shutdownUI.displayInitialDlg();
            firstTime = false;
        }
        if (UIRegistry.isMobile() && this == DBConnection.getInstance()) {
            if (!isCopiedToMachineDisk) {
                DBConnection.clearEmbeddedBinDir();
            }
            if (DBConnection.copyToMachineDisk()) {
                try {
                    if (mobileMachineDir.exists()) {
                        File osFile = new File(mobileMachineDir + File.separator + "os.txt");
                        FileUtils.writeStringToFile((File)osFile, (String)UIHelper.getOSType().toString());
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        Connection con = null;
        try {
            if (!this.argHaveBeenChecked) {
                if (!this.skipDBNameCheck && StringUtils.isEmpty((String)this.dbName)) {
                    this.errMsg = UIRegistry.getResourceString("DBConnection.NO_DB_NAME");
                    return null;
                }
                if (StringUtils.isEmpty((String)this.dbConnectionStr)) {
                    this.errMsg = UIRegistry.getResourceString("DBConnection.NO_DB_CONN_STR");
                    return null;
                }
                if (StringUtils.isEmpty((String)this.dbUsername)) {
                    this.errMsg = UIRegistry.getResourceString("DBConnection.NO_DB_USERNAME");
                    return null;
                }
                if (StringUtils.isEmpty((String)this.dbPassword)) {
                    this.errMsg = UIRegistry.getResourceString("DBConnection.NO_DB_PASSWORD");
                    return null;
                }
                if (StringUtils.isEmpty((String)this.dbDriver)) {
                    this.errMsg = UIRegistry.getResourceString("DBConnection.NO_DB_DRIVER");
                    return null;
                }
                this.argHaveBeenChecked = true;
            }
            Class.forName(this.dbDriver);
            return DriverManager.getConnection(this.dbConnectionStr, this.dbUsername, this.dbPassword);
        }
        catch (SQLException sqlEx) {
            loginException = sqlEx;
            sqlEx.printStackTrace();
            log.error((Object)"Error in getConnection", (Throwable)sqlEx);
            this.errMsg = sqlEx.getNextException() != null ? sqlEx.getNextException().getMessage() : sqlEx.getMessage();
            this.errMsg = String.valueOf(this.errMsg) + " For [" + this.dbConnectionStr + "][" + this.dbUsername + "]";
            return con;
        }
        catch (Exception ex) {
            log.error((Object)"Error in getConnection", (Throwable)ex);
            this.errMsg = ex.getMessage();
            this.errMsg = String.valueOf(this.errMsg) + " For [" + this.dbConnectionStr + "][" + this.dbUsername + "]";
        }
        return con;
    }

    public void close() {
        if (debugCnt) {
            System.err.println("DB Connection Cnt: " + --dbCnt + "  is Instance: " + (this == DBConnection.getInstance()));
        }
        try {
            String msg;
            if (connections.size() == 1 && this == instance) {
                connections.remove(this);
            } else if (connections.indexOf(this) > -1) {
                connections.remove(this);
            } else {
                msg = "The DBConnection [" + this + "] has already been removed!";
                log.error((Object)msg);
            }
            if (!isShuttingDown && this == instance) {
                msg = "The DBConnection.getInstance().close() should not be called. (Call DBConnection.shutdown()).";
                log.error((Object)msg);
                UIRegistry.showError(msg);
            }
            if (this.dbCloseConnectionStr != null) {
                Connection con = DriverManager.getConnection(this.dbCloseConnectionStr, this.dbUsername, this.dbPassword);
                if (con != null) {
                    con.close();
                }
            } else if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void setUsernamePassword(String dbUsername, String dbPassword) {
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.argHaveBeenChecked = false;
    }

    public void setDatabaseName(String dbName) {
        this.dbName = dbName;
        this.argHaveBeenChecked = false;
    }

    public void setDriver(String dbDriver) {
        this.dbDriver = dbDriver;
        this.argHaveBeenChecked = false;
    }

    public void setDialect(String dbDialect) {
        this.dbDialect = dbDialect;
        this.argHaveBeenChecked = false;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDriverName() {
        return this.dbDriverName;
    }

    public void setDriverName(String dbDriverName) {
        this.dbDriverName = dbDriverName;
    }

    public void setConnectionStr(String dbConnectionStr) {
        this.dbConnectionStr = dbConnectionStr;
        this.argHaveBeenChecked = false;
        DBConnection.checkForEmbeddedDir(dbConnectionStr);
    }

    public String getDriver() {
        return this.dbDriver;
    }

    public String getConnectionStr() {
        return this.dbConnectionStr;
    }

    public String getDbCloseConnectionStr() {
        return this.dbCloseConnectionStr;
    }

    public void setDbCloseConnectionStr(String dbCloseConnectionStr) {
        this.dbCloseConnectionStr = dbCloseConnectionStr;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String getPassword() {
        return this.dbPassword;
    }

    public String getUserName() {
        return this.dbUsername;
    }

    public String getDialect() {
        return this.dbDialect;
    }

    private void ensureEmbddedDirExists() {
        File embeddedDir;
        if (this.isEmbedded() && !(embeddedDir = DBConnection.getEmbeddedDataDir()).exists()) {
            log.debug((Object)("Created data dir[" + embeddedDir.getAbsolutePath() + "]"));
            if (embeddedDir.mkdirs()) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SpecifyDBSetupWizard.class, new Exception("The Embedded Data Dir could not be created at[" + embeddedDir.getAbsolutePath() + "]"));
            }
        }
    }

    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public static DBConnection createInstance(String dbDriver, String dbDialect, String dbName, String dbConnectionStr, String dbUsername, String dbPassword) {
        DBConnection dbConnection = new DBConnection();
        dbConnection.setDriver(dbDriver);
        dbConnection.setDialect(dbDialect);
        dbConnection.setDatabaseName(dbName);
        dbConnection.setConnectionStr(dbConnectionStr);
        dbConnection.setUsernamePassword(dbUsername, dbPassword);
        DBConnection.checkForEmbeddedDir(dbConnectionStr);
        return dbConnection;
    }

    public static DBConnection getInstance() {
        return instance;
    }

    public static synchronized void shutdown() {
        isShuttingDown = true;
        try {
            while (!connections.isEmpty()) {
                DBConnection dbConn = connections.peek();
                dbConn.close();
            }
            connections.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        isShuttingDown = false;
    }

    public static void clearMobileMachineDir() {
        mobileMachineDir = null;
    }

    public static File getMobileMachineDir(String dbName) {
        if (mobileMachineDir == null && StringUtils.isNotEmpty((String)dbName)) {
            String path = UIRegistry.getDefaultUserHomeDir();
            mobileMachineDir = new File(String.valueOf(path) + File.separator + dbName + "_data_" + Long.toString(System.currentTimeMillis()));
        } else if (StringUtils.isEmpty((String)dbName) && mobileMachineDir == null) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskSemaphoreMgr.class, new RuntimeException("dbName was null"));
        }
        return mobileMachineDir;
    }

    public static File getMobileMachineDir() {
        return DBConnection.getMobileMachineDir(null);
    }

    public static void setCopiedToMachineDisk(boolean isCopiedToMachineDisk) {
        DBConnection.isCopiedToMachineDisk = isCopiedToMachineDisk;
    }

    private static boolean copyToMachineDisk() {
        if (!isCopiedToMachineDisk) {
            File mobileEmbeddedDir;
            block6: {
                mobileMachineDir = DBConnection.getMobileMachineDir();
                if (!mobileMachineDir.exists()) {
                    mobileMachineDir.mkdirs();
                }
                System.out.println("****** copyToMachineDisk - getMobileEmbeddedDBPath[" + new File(UIRegistry.getMobileEmbeddedDBPath()).getCanonicalPath() + "] to mobileTmpDir[" + mobileMachineDir.getCanonicalPath() + "]");
                mobileEmbeddedDir = new File(UIRegistry.getMobileEmbeddedDBPath());
                if (!mobileEmbeddedDir.exists()) break block6;
                FileUtils.copyDirectory((File)mobileEmbeddedDir, (File)mobileMachineDir, (boolean)true);
                UIRegistry.setEmbeddedDBPath(mobileMachineDir.getCanonicalPath());
                isCopiedToMachineDisk = true;
                for (Object fObj : FileUtils.listFiles((File)mobileMachineDir, null, (boolean)true)) {
                    File f = (File)fObj;
                    if (!f.getName().endsWith("DS_Store")) continue;
                    f.delete();
                }
                return true;
            }
            try {
                log.error((Object)("Mobile path doesn't exist at[" + mobileEmbeddedDir.getCanonicalPath() + "]"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static void setCopiedToMobileDisk(boolean isCopiedToMobileDisk) {
        hasCopiedToMobileDisk = isCopiedToMobileDisk;
    }

    private static boolean copyToMobileDisk() {
        if (!hasCopiedToMobileDisk && mobileMachineDir != null && isCopiedToMachineDisk) {
            hasCopiedToMobileDisk = true;
            try {
                File f;
                File mobileDir = new File(UIRegistry.getMobileEmbeddedDBPath());
                FileUtils.deleteDirectory((File)mobileDir);
                FileUtils.copyDirectory((File)mobileMachineDir, (File)mobileDir, (boolean)true);
                for (Object fObj : FileUtils.listFiles((File)mobileDir, null, (boolean)true)) {
                    f = (File)fObj;
                    if (!f.getName().endsWith("DS_Store")) continue;
                    f.delete();
                }
                for (Object fObj : FileUtils.listFiles((File)mobileMachineDir, null, (boolean)true)) {
                    f = (File)fObj;
                    if (!f.exists() || f.getName().equals("mysql.sock")) continue;
                    f.delete();
                }
                log.debug((Object)("Removing on exit[" + mobileMachineDir.getCanonicalPath() + "]"));
                mobileMachineDir.deleteOnExit();
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static interface ShutdownUIIFace {
        public void displayInitialDlg();

        public void displayShutdownMsgDlg();

        public void displayFinalShutdownDlg();
    }
}

