/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.dbsupport.CustomQueryFactory;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.dbsupport.QRCProcessorListener;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsDataObj;
import edu.ku.brc.helpers.SwingWorker;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;

public class CustomQueryResultsContainer
implements QueryResultsContainerIFace {
    protected CustomQueryIFace customQuery;
    protected List<QueryResultsDataObj> qrdos = new Vector<QueryResultsDataObj>();
    protected QRCProcessorListener listener = null;
    protected boolean hasFailed = false;

    public CustomQueryResultsContainer(String customQueryName) {
        this.customQuery = CustomQueryFactory.getInstance().getQuery(customQueryName);
    }

    public CustomQueryResultsContainer(CustomQueryIFace customQuery) {
        this.customQuery = customQuery;
    }

    @Override
    public void add(QueryResultsDataObj qrdo) {
        this.qrdos.add(qrdo);
    }

    @Override
    public List<QueryResultsDataObj> getQueryResultsDataObjs() {
        return this.qrdos;
    }

    @Override
    public void clear() {
        for (QueryResultsDataObj qrdo : this.qrdos) {
            qrdo.clear();
        }
        this.qrdos.clear();
    }

    @Override
    public synchronized void start(final QRCProcessorListener listenerArg, Connection connection) {
        this.listener = listenerArg;
        final CustomQueryResultsContainer thisItem = this;
        SwingWorker worker = new SwingWorker(){
            protected boolean inError = false;

            @Override
            public Object construct() {
                this.inError = !CustomQueryResultsContainer.this.customQuery.execute();
                return null;
            }

            @Override
            public void finished() {
                if (this.inError) {
                    listenerArg.executionError(thisItem);
                    CustomQueryResultsContainer.this.hasFailed = true;
                } else {
                    List<?> list = CustomQueryResultsContainer.this.customQuery.getDataObjects();
                    for (QueryResultsDataObj qrdo : CustomQueryResultsContainer.this.qrdos) {
                        if (!qrdo.isProcessable()) continue;
                        int col = qrdo.getCol();
                        qrdo.setResult(list.get(col - 1));
                    }
                    listenerArg.exectionDone(thisItem);
                    CustomQueryResultsContainer.this.hasFailed = false;
                }
            }
        };
        worker.start();
    }

    @Override
    public synchronized boolean hasFailed() {
        return this.hasFailed;
    }
}

