/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.dbsupport;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.CustomQueryIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class CustomQueryFactory {
    public static final String factoryName = "edu.ku.brc.dbsupport.CustomQueryFactory";
    protected static CustomQueryFactory instance = null;

    public abstract CustomQueryIFace getQuery(String var1);

    public static CustomQueryFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(CustomQueryFactory.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (CustomQueryFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(CustomQueryFactory.class, e);
                InternalError error = new InternalError("Can't instantiate CustomQueryFactory factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }
}

