/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.weblink;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.weblink.WebLinkConfigDlg;
import edu.ku.brc.af.ui.weblink.WebLinkDef;
import edu.ku.brc.af.ui.weblink.WebLinkDefArg;
import edu.ku.brc.af.ui.weblink.WebLinkUsedBy;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebLinkMgr {
    public static final String factoryName = "edu.ku.brc.ui.weblink.WebLinkMgr";
    private static final Logger log = Logger.getLogger(WebLinkMgr.class);
    protected static WebLinkMgr instance = null;
    protected Vector<WebLinkDef> webLinkDefs;
    protected boolean hasChanged = false;

    protected WebLinkMgr() {
        this.webLinkDefs = new Vector();
    }

    public WebLinkMgr(WebLinkMgr webLinkMgr) {
        this.webLinkDefs = (Vector)webLinkMgr.webLinkDefs.clone();
    }

    protected void copyFrom(WebLinkMgr webLinkMgr) {
        this.hasChanged = webLinkMgr.hasChanged;
        this.webLinkDefs = webLinkMgr.webLinkDefs;
    }

    public static WebLinkMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(WebLinkMgr.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (WebLinkMgr)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(WebLinkMgr.class, e);
                InternalError error = new InternalError("Can't instantiate WebLink factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        instance = new WebLinkMgr();
        return instance;
    }

    public void reload() {
        this.reset();
        this.read();
    }

    public void applyChanges(WebLinkMgr source) {
        if (source.hasChanged) {
            this.hasChanged = source.hasChanged;
            this.copyFrom(source);
            this.write();
        } else {
            log.debug((Object)"Not saved = No Changes");
        }
    }

    public boolean isHasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    protected void reset() {
        this.webLinkDefs.clear();
    }

    public WebLinkDef get(String name) {
        for (WebLinkDef wld : this.webLinkDefs) {
            if (!wld.getName().equals(name)) continue;
            return wld;
        }
        return null;
    }

    protected void config(XStream xstream) {
        WebLinkDef.configXStream(xstream);
        WebLinkDefArg.configXStream(xstream);
        WebLinkUsedBy.configXStream(xstream);
    }

    protected void loadFromXML(String xml) {
        if (StringUtils.isNotEmpty((String)xml)) {
            XStream xstream = new XStream();
            this.config(xstream);
            this.webLinkDefs = (Vector)xstream.fromXML(xml);
        }
    }

    protected String convertToXML() {
        XStream xstream = XMLHelper.createXStreamWithCData();
        this.config(xstream);
        return xstream.toXML(this.webLinkDefs);
    }

    public void add(WebLinkDef wld) {
        this.webLinkDefs.add(wld);
        this.hasChanged = true;
    }

    public void remove(WebLinkDef wld) {
        this.webLinkDefs.removeElement(wld);
        this.hasChanged = true;
    }

    public void read() {
        throw new RuntimeException("Read is not implemented");
    }

    public void write() {
        throw new RuntimeException("Write is not implemented");
    }

    public Vector<WebLinkDef> getWebLinkDefs(DBTableInfo tableInfo) {
        Vector<WebLinkDef> list = new Vector<WebLinkDef>();
        for (WebLinkDef wld : this.webLinkDefs) {
            if ((tableInfo == null || wld.getTableName() == null || !wld.getTableName().equals(tableInfo.getName())) && (tableInfo != null || wld.getTableName() != null)) continue;
            list.add(wld);
        }
        return list;
    }

    public WebLinkConfigDlg editWebLinks(DBTableInfo tableInfo, boolean isTableMode) {
        WebLinkConfigDlg dlg = new WebLinkConfigDlg(this, tableInfo, isTableMode);
        dlg.createUI();
        dlg.setSize(400, 400);
        dlg.setVisible(true);
        if (dlg.hasChanged()) {
            this.hasChanged = true;
        }
        return dlg;
    }
}

