/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.weblink;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.weblink.WebLinkDef;
import edu.ku.brc.af.ui.weblink.WebLinkDefArg;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.StringUtils;

public class WebLinkEditorDlg
extends CustomDialog {
    protected DBTableInfo tableInfo;
    protected JTextField nameTF;
    protected JTextField baseUrlTF;
    protected JTextArea descTA;
    protected JTable table;
    protected WebLinkArgsTableModel model;
    protected JTable availableFields;
    protected AvailFieldsTableModel avModel = null;
    protected Vector<String> avFieldList = new Vector();
    protected Vector<String> availFieldNames = null;
    protected boolean isEdit = false;
    protected WebLinkDef webLinkDef = null;
    protected Vector<WebLinkDefArg> args = new Vector();
    protected Hashtable<String, String> fields = new Hashtable();
    protected Hashtable<String, String> verifyHash = new Hashtable();
    protected Hashtable<String, String> titleHash = new Hashtable();
    protected Hashtable<String, DBFieldInfo> fieldInfoHash = new Hashtable();
    protected boolean hasChanged = false;
    protected String format = "";
    protected int curInx = 0;
    protected boolean isParsingError = false;
    protected boolean isParsingIncomplete = false;
    protected Color txtFGColor;
    protected Color txtBGColor;
    protected Color errColor = new Color(255, 220, 220);

    public WebLinkEditorDlg(WebLinkDef webLinkDef, DBTableInfo tableInfo) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WebLinkArgDlg.WEB_LNK_EDTR"), true, 7, null);
        this.webLinkDef = webLinkDef;
        this.tableInfo = tableInfo;
        this.availFieldNames = new Vector();
        if (tableInfo != null) {
            for (DBFieldInfo fi : tableInfo.getFields()) {
                if (!fi.getType().equals("java.lang.String")) continue;
                this.fieldInfoHash.put(fi.getName(), fi);
                this.availFieldNames.add(fi.getName());
            }
            List<String> treeFieldNames = DBTableIdMgr.getInstance().getTreeFieldNames(tableInfo);
            if (treeFieldNames != null) {
                for (String fName : treeFieldNames) {
                    this.availFieldNames.add(fName);
                }
            }
            this.avModel = new AvailFieldsTableModel();
            Collections.sort(this.availFieldNames);
            this.availableFields = new JTable(this.avModel);
        }
        for (WebLinkDefArg arg : webLinkDef.getArgs()) {
            try {
                WebLinkDefArg wlda = (WebLinkDefArg)arg.clone();
                String fName = wlda.getName();
                if (tableInfo != null) {
                    boolean isField = this.fieldInfoHash.get(fName) != null;
                    wlda.setField(isField);
                    wlda.setPrompt(!isField);
                }
                if (wlda.getTitle() != null) {
                    this.titleHash.put(fName, wlda.getTitle());
                }
                this.args.add(wlda);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.helpContext = "WEBLNK_ARGS_EDITOR";
    }

    protected void adjustAvailableJList() {
        if (this.avModel != null) {
            this.avFieldList.clear();
            this.verifyHash.clear();
            int i = 0;
            while (i < this.model.getRowCount()) {
                this.verifyHash.put((String)this.model.getValueAt(i, 0), "X");
                ++i;
            }
            for (String fName : this.availFieldNames) {
                if (this.verifyHash.get(fName) != null) continue;
                this.avFieldList.addElement(fName);
            }
            this.avModel.fire();
        }
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    @Override
    public void createUI() {
        super.createUI();
        this.nameTF = UIHelper.createTextField();
        this.baseUrlTF = UIHelper.createTextField(25);
        this.descTA = UIHelper.createTextArea();
        this.descTA.setLineWrap(true);
        this.descTA.setWrapStyleWord(true);
        this.txtFGColor = this.nameTF.getForeground();
        this.txtBGColor = this.nameTF.getBackground();
        if (this.isEdit) {
            ViewFactory.changeTextFieldUIForDisplay(this.nameTF, true);
        }
        this.descTA.setRows(5);
        this.model = new WebLinkArgsTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(true));
        CellConstraints cc = new CellConstraints();
        PanelBuilder rightPB = new PanelBuilder(new FormLayout("p,2px,f:p:g", "p,2px,p, 4px,p,2px,200px" + (this.tableInfo != null ? ",2px,200px" : "")));
        rightPB.add((Component)UIHelper.createI18NFormLabel("WebLinkArgDlg.NAME"), cc.xy(1, 1));
        rightPB.add((Component)this.nameTF, cc.xy(3, 1));
        rightPB.add((Component)UIHelper.createI18NFormLabel("WebLinkArgDlg.URL"), cc.xy(1, 3));
        rightPB.add((Component)this.baseUrlTF, cc.xy(3, 3));
        rightPB.add((Component)UIHelper.createI18NFormLabel("WebLinkArgDlg.DESC"), cc.xy(1, 5));
        rightPB.add((Component)UIHelper.createScrollPane(this.descTA), cc.xy(3, 5));
        rightPB.add((Component)UIHelper.createI18NFormLabel("WebLinkArgDlg.FIELDS"), cc.xy(1, 7));
        rightPB.add((Component)UIHelper.createScrollPane(this.table), cc.xy(3, 7));
        if (this.tableInfo != null) {
            rightPB.add((Component)UIHelper.createScrollPane(this.availableFields), cc.xy(3, 9));
        }
        rightPB.setDefaultDialogBorder();
        TableColumn promptCol = this.table.getColumnModel().getColumn(2);
        promptCol.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        UIHelper.makeTableHeadersCentered(this.table, false);
        this.contentPanel = rightPB.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.setDataIntoUI();
        DocumentListener docLis = new DocumentListener(){

            protected void changed() {
                WebLinkEditorDlg.this.hasChanged = true;
                WebLinkEditorDlg.this.parseForFields();
                WebLinkEditorDlg.this.enableUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }
        };
        this.nameTF.getDocument().addDocumentListener(docLis);
        this.baseUrlTF.getDocument().addDocumentListener(docLis);
        this.adjustAvailableJList();
        this.enableUI();
        this.pack();
    }

    protected void setURLToError() {
        Toolkit.getDefaultToolkit().beep();
        this.baseUrlTF.setBackground(this.errColor);
        this.isParsingError = true;
        this.baseUrlTF.repaint();
        this.enableUI();
    }

    protected void parseForFields() {
        if (this.isParsingError) {
            this.baseUrlTF.setBackground(this.txtBGColor);
            this.isParsingError = false;
            this.enableUI();
        }
        boolean wasIncomplete = this.isParsingIncomplete;
        this.fields.clear();
        this.args.clear();
        this.model.fire();
        String baseStr = this.baseUrlTF.getText();
        Pattern pattern = Pattern.compile("<.*?>");
        Matcher matcher = pattern.matcher(baseStr);
        while (matcher.find()) {
            String titleStr;
            String token = matcher.group(0);
            if (token.length() <= 2) continue;
            if (StringUtils.contains((String)(token = token.substring(1, token.length() - 1)), (String)">") || StringUtils.contains((String)token, (String)"<")) {
                this.setURLToError();
                return;
            }
            if (this.tableInfo == null || this.fieldInfoHash.get(token) != null) {
                if (this.tableInfo != null && token.equals("this")) {
                    this.setURLToError();
                    return;
                }
                this.fields.put(token, token);
                titleStr = this.titleHash.get(token);
                if (StringUtils.isEmpty((String)titleStr) && this.fieldInfoHash == null) {
                    titleStr = StringUtils.capitalize((String)token);
                }
                this.model.addItem(token, titleStr, !token.equals("this"));
                continue;
            }
            titleStr = StringUtils.capitalize((String)token);
            this.model.addItem(token, titleStr, !token.equals("this"));
        }
        if (wasIncomplete != this.isParsingIncomplete) {
            this.enableUI();
        }
        this.adjustAvailableJList();
        this.format = baseStr;
    }

    @Override
    protected void cancelButtonPressed() {
        this.hasChanged = false;
        super.cancelButtonPressed();
    }

    @Override
    protected void okButtonPressed() {
        this.getDataFromUI();
        this.webLinkDef.getArgs().clear();
        this.webLinkDef.getArgs().addAll(this.args);
        super.okButtonPressed();
    }

    protected void setDataIntoUI() {
        final String buStr = this.webLinkDef.getBaseURLStr();
        this.nameTF.setText(this.webLinkDef.getName());
        this.baseUrlTF.setText(buStr);
        this.descTA.setText(this.webLinkDef.getDesc());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebLinkEditorDlg.this.baseUrlTF.select(0, 0);
                if (StringUtils.isNotEmpty((String)buStr) && buStr.length() > 0) {
                    WebLinkEditorDlg.this.baseUrlTF.setCaretPosition(0);
                }
            }
        });
    }

    protected void getDataFromUI() {
        this.webLinkDef.setName(this.nameTF.getText());
        this.webLinkDef.setBaseURLStr(this.baseUrlTF.getText());
        this.webLinkDef.setDesc(this.descTA.getText());
    }

    protected void enableUI() {
        boolean okEnable = true;
        if (this.nameTF.getText().length() == 0 || this.baseUrlTF.getText().length() == 0) {
            okEnable = false;
        }
        this.okBtn.setEnabled(okEnable && !this.isParsingError && !this.isParsingIncomplete);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    class AvailFieldsTableModel
    extends DefaultTableModel {
        protected String[] colHeaders = new String[]{UIRegistry.getResourceString("WebLinkArgDlg.COLNAME"), UIRegistry.getResourceString("WebLinkArgDlg.COLTITLE")};

        public void fire() {
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colHeaders.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.colHeaders[column];
        }

        @Override
        public int getRowCount() {
            return WebLinkEditorDlg.this.avFieldList == null ? 0 : WebLinkEditorDlg.this.avFieldList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return WebLinkEditorDlg.this.avFieldList.get(row);
                }
                case 1: {
                    return WebLinkEditorDlg.this.tableInfo.getFieldByName(WebLinkEditorDlg.this.avFieldList.get(row)).getTitle();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }
    }

    class WebLinkArgsTableModel
    extends DefaultTableModel {
        protected String[] colHeaders = null;

        public void fire() {
            this.fireTableDataChanged();
        }

        public void addItem(String name, String title, boolean isPrompt) {
            WebLinkDefArg arg = new WebLinkDefArg(name, title, isPrompt);
            if (WebLinkEditorDlg.this.tableInfo != null) {
                DBFieldInfo fi = WebLinkEditorDlg.this.fieldInfoHash.get(arg.getName());
                if (fi != null) {
                    arg.setField(true);
                    arg.setPrompt(false);
                    arg.setTitle(fi.getTitle());
                } else {
                    arg.setPrompt(true);
                }
            }
            WebLinkEditorDlg.this.args.add(arg);
            this.fireTableDataChanged();
            WebLinkEditorDlg.this.hasChanged = true;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex < 2 ? String.class : Boolean.class;
        }

        public void removeItem() {
            int index = WebLinkEditorDlg.this.table.getSelectedRow();
            if (index > -1) {
                WebLinkEditorDlg.this.args.remove(index);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            if (this.colHeaders == null) {
                this.colHeaders = new String[]{UIRegistry.getResourceString("WebLinkArgDlg.COLNAME"), UIRegistry.getResourceString("WebLinkArgDlg.COLTITLE"), UIRegistry.getResourceString("WebLinkArgDlg.COLPROMPT")};
            }
            return this.colHeaders.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.colHeaders[column];
        }

        @Override
        public int getRowCount() {
            return WebLinkEditorDlg.this.args == null ? 0 : WebLinkEditorDlg.this.args.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            WebLinkDefArg arg = WebLinkEditorDlg.this.args.get(row);
            switch (column) {
                case 0: {
                    return arg.getName();
                }
                case 1: {
                    return arg.getTitle();
                }
                case 2: {
                    if (arg.isPrompt() && !arg.isField()) {
                        return true;
                    }
                    return false;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            WebLinkDefArg arg = WebLinkEditorDlg.this.args.get(row);
            boolean canPrompt = arg.isPrompt() && !arg.isField();
            switch (column) {
                case 0: {
                    return false;
                }
                case 1: {
                    return canPrompt;
                }
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Missing case!");
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            WebLinkDefArg arg = WebLinkEditorDlg.this.args.get(row);
            switch (column) {
                case 0: {
                    break;
                }
                case 1: {
                    WebLinkEditorDlg.this.titleHash.put(arg.getName(), (String)value);
                    arg.setTitle((String)value);
                    WebLinkEditorDlg.this.hasChanged = true;
                    break;
                }
                case 2: {
                    arg.setPrompt((Boolean)value);
                    WebLinkEditorDlg.this.hasChanged = true;
                }
            }
        }
    }
}

