/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.weblink;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.ui.weblink.WebLinkDefArg;
import edu.ku.brc.af.ui.weblink.WebLinkUsedBy;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class WebLinkDef {
    protected String name;
    protected String tableName;
    protected String desc;
    protected String baseURLStr;
    protected Vector<WebLinkDefArg> args;
    protected Vector<WebLinkUsedBy> usedByList;

    public WebLinkDef() {
        this(null, null, null, null);
        this.args = new Vector();
        this.usedByList = new Vector();
    }

    public WebLinkDef(String name, String tableName) {
        this(name, tableName, null, null);
        this.args = new Vector();
        this.usedByList = new Vector();
    }

    public WebLinkDef(String name, String tableName, String desc, String baseURLStr) {
        this.name = name;
        this.tableName = tableName;
        this.desc = desc;
        this.baseURLStr = baseURLStr;
        this.args = null;
        this.usedByList = null;
    }

    public boolean isOwnedByTable(String tblName) {
        return StringUtils.isNotEmpty((String)this.tableName) && StringUtils.isNotEmpty((String)tblName) && this.tableName.equals(tblName);
    }

    public boolean isUSedByTable(String tblName) {
        if (this.usedByList == null || this.usedByList.size() == 0) {
            return false;
        }
        for (WebLinkUsedBy ub : this.usedByList) {
            if (!tblName.equals(ub.getTableName())) continue;
            return true;
        }
        return false;
    }

    public int getPromptCount() {
        int cnt = 0;
        for (WebLinkDefArg arg : this.args) {
            if (!arg.isPrompt()) continue;
            ++cnt;
        }
        return cnt;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getBaseURLStr() {
        return this.baseURLStr;
    }

    public void setBaseURLStr(String baseURLStr) {
        this.baseURLStr = baseURLStr;
    }

    public Vector<WebLinkDefArg> getArgs() {
        return this.args;
    }

    public void setArgs(Vector<WebLinkDefArg> args) {
        this.args = args;
    }

    public Vector<WebLinkUsedBy> getUsedByList() {
        return this.usedByList;
    }

    public void setUsedByList(Vector<WebLinkUsedBy> usedByList) {
        this.usedByList = usedByList;
    }

    public String toString() {
        return this.name;
    }

    public static void configXStream(XStream xstream) {
        xstream.alias("weblinkdef", WebLinkDef.class);
    }
}

