/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.weblink;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.weblink.WebLinkDef;
import edu.ku.brc.af.ui.weblink.WebLinkEditorDlg;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.af.ui.weblink.WebLinkUsedBy;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.EditDeleteAddPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WebLinkConfigDlg
extends CustomDialog {
    protected JList list;
    protected EditDeleteAddPanel itemsPanelEDA;
    protected WebLinkMgr wlMgr;
    protected boolean hasChanged = false;
    protected boolean isTableMode;
    protected DBTableInfo tableInfo;

    public WebLinkConfigDlg(WebLinkMgr wlMgr, DBTableInfo tableInfo, boolean isTableMode) throws HeadlessException {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WebLinkConfigDlg.WEB_LNK_EDT"), true, isTableMode ? 5 : 7, null);
        this.wlMgr = wlMgr;
        this.tableInfo = tableInfo;
        this.isTableMode = isTableMode;
        if (isTableMode) {
            this.okLabel = UIRegistry.getResourceString("CLOSE");
        }
        this.helpContext = "WEBLNK_EDITOR";
    }

    @Override
    public void createUI() {
        super.createUI();
        ActionListener addItemAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebLinkConfigDlg.this.addWebLink();
            }
        };
        ActionListener delItemAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebLinkConfigDlg.this.delWebLink();
            }
        };
        ActionListener editItemAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebLinkConfigDlg.this.editWebLink();
            }
        };
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "p,2px,f:p:g,2px,p"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("WebLinkConfigDlg.WEB_LINKS"), 0), cc.xy(1, 1));
        this.list = new JList(new DefaultListModel());
        pb.add((Component)UIHelper.createScrollPane(this.list), cc.xy(1, 3));
        this.itemsPanelEDA = new EditDeleteAddPanel(editItemAL, delItemAL, addItemAL);
        pb.add((Component)this.itemsPanelEDA, cc.xy(1, 5));
        for (WebLinkDef wld : this.wlMgr.getWebLinkDefs(this.isTableMode ? this.tableInfo : null)) {
            ((DefaultListModel)this.list.getModel()).addElement(wld);
        }
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    WebLinkConfigDlg.this.enableUI();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    WebLinkConfigDlg.this.editWebLink();
                }
                super.mouseClicked(e);
            }
        });
        pb.setDefaultDialogBorder();
        this.contentPanel = pb.getPanel();
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
        this.enableUI();
    }

    public void setWebLink(String wbName) {
        if (!this.isTableMode && wbName != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            int i = 0;
            while (i < model.size()) {
                WebLinkDef wld = (WebLinkDef)model.getElementAt(i);
                if (wld.getName().equals(wbName)) {
                    this.list.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected void enableUI() {
        boolean enabled;
        WebLinkDef wld = (WebLinkDef)this.list.getSelectedValue();
        boolean bl = enabled = wld != null;
        if (enabled) {
            this.itemsPanelEDA.getAddBtn().setEnabled(true);
            this.itemsPanelEDA.getDelBtn().setEnabled(true);
            this.itemsPanelEDA.getEditBtn().setEnabled(true);
        } else {
            this.itemsPanelEDA.getAddBtn().setEnabled(true);
            this.itemsPanelEDA.getDelBtn().setEnabled(false);
            this.itemsPanelEDA.getEditBtn().setEnabled(false);
        }
    }

    protected void addWebLink() {
        WebLinkDef wld = new WebLinkDef();
        WebLinkEditorDlg dlg = new WebLinkEditorDlg(wld, this.isTableMode ? this.tableInfo : null);
        dlg.setVisible(true);
        if (!dlg.isCancelled() && dlg.hasChanged()) {
            if (this.isTableMode && this.tableInfo != null) {
                wld.setTableName(this.tableInfo.getName());
                wld.getUsedByList().add(new WebLinkUsedBy(this.tableInfo.getName()));
            }
            ((DefaultListModel)this.list.getModel()).addElement(wld);
            this.list.setSelectedValue(wld, true);
            this.wlMgr.add(wld);
            this.hasChanged = true;
        }
    }

    protected void delWebLink() {
        WebLinkDef wld = (WebLinkDef)this.list.getSelectedValue();
        if (this.tableInfo != null) {
            for (WebLinkUsedBy wlub : wld.getUsedByList()) {
                if (!wlub.getTableName().equals(this.tableInfo.getName())) continue;
                wld.getUsedByList().remove(wlub);
                break;
            }
        }
        ((DefaultListModel)this.list.getModel()).removeElement(wld);
        this.wlMgr.remove(wld);
        this.hasChanged = true;
    }

    protected void editWebLink() {
        WebLinkDef wld = (WebLinkDef)this.list.getSelectedValue();
        WebLinkEditorDlg dlg = new WebLinkEditorDlg(wld, this.isTableMode ? this.tableInfo : null);
        dlg.setEdit(true);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            this.hasChanged = true;
            this.wlMgr.setHasChanged(true);
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public WebLinkDef getSelectedItem() {
        return (WebLinkDef)this.list.getSelectedValue();
    }
}

