/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.weblink;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormHelper;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValTextField;
import edu.ku.brc.af.ui.weblink.WebLinkDataProviderIFace;
import edu.ku.brc.af.ui.weblink.WebLinkDef;
import edu.ku.brc.af.ui.weblink.WebLinkDefArg;
import edu.ku.brc.af.ui.weblink.WebLinkMgr;
import edu.ku.brc.specify.plugins.UIPluginBase;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.AttachmentUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WebLinkButton
extends UIPluginBase
implements ActionListener,
UIValidatable,
DataChangeListener {
    protected Logger log = Logger.getLogger(WebLinkButton.class);
    protected JButton launchBtn;
    protected JButton editBtn = null;
    protected ValTextField textField = null;
    protected WebLinkDef webLinkDef = null;
    protected String urlStr;
    protected boolean usingThisData = true;
    protected boolean isTableSpecific;
    protected WebLinkDataProviderIFace provider = null;
    protected Hashtable<String, JTextField> textFieldHash = new Hashtable();
    protected Hashtable<String, String> valueHash = new Hashtable();
    protected CustomDialog promptDialog = null;
    protected String cellName = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected String watchId = null;
    protected boolean isWatchSetUp = false;

    @Override
    public void initialize(Properties propertiesArg, boolean isViewModeArg) {
        super.initialize(propertiesArg, isViewModeArg);
        this.urlStr = this.properties.getProperty("url");
        String iconName = this.properties.getProperty("icon");
        ImageIcon icon = null;
        if (StringUtils.isNotEmpty((String)iconName)) {
            icon = IconManager.getIcon(iconName, IconManager.STD_ICON_SIZE);
        }
        if (icon == null) {
            icon = IconManager.getIcon("WebLink", IconManager.STD_ICON_SIZE);
        }
        this.launchBtn = UIHelper.createButton(icon);
        this.launchBtn.addActionListener(this);
        String wlName = this.properties.getProperty("weblink");
        if (StringUtils.isNotEmpty((String)wlName)) {
            this.webLinkDef = WebLinkMgr.getInstance().get(wlName);
            if (this.webLinkDef != null) {
                this.setToolTipText(this.webLinkDef.getDesc());
            }
        }
        this.isTableSpecific = this.webLinkDef != null ? StringUtils.isNotEmpty((String)this.webLinkDef.getTableName()) : false;
        PanelBuilder pb = new PanelBuilder(new FormLayout("p," + (this.isTableSpecific ? "" : "2px,p,") + "f:p:g", "p"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.launchBtn, cc.xy(1, 1));
        if (!this.isTableSpecific && !this.usingThisData) {
            this.textField = new ValTextField(10);
            if (!isViewModeArg) {
                pb.add((Component)this.textField, cc.xy(3, 1));
            }
            this.textField.setRequired(this.isRequired);
            if (!this.isViewMode) {
                DataChangeNotifier dcn = new DataChangeNotifier(null, this.textField, null);
                dcn.addDataChangeListener(this);
                this.textField.getDocument().addDocumentListener(dcn);
            } else {
                ViewFactory.changeTextFieldUIForDisplay(this.textField, false);
            }
        } else {
            this.watchId = this.properties.getProperty("watch");
        }
        if (this.textField != null) {
            this.textField.setEnabled(true);
        } else if (StringUtils.isEmpty((String)this.watchId)) {
            this.log.error((Object)"Error");
        }
    }

    @Override
    public boolean isNotEmpty() {
        throw new NotImplementedException("isNotEmpty not implement!");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        URI uri;
        String urlString;
        try {
            urlString = this.buildURL(false);
        }
        catch (Exception e1) {
            UsageTracker.incrHandledUsageCount();
            this.log.error((Object)"Failed to build URL", (Throwable)e1);
            return;
        }
        if (StringUtils.isEmpty((String)urlString)) {
            return;
        }
        try {
            uri = new URL(urlString).toURI();
        }
        catch (MalformedURLException e) {
            this.log.error((Object)("Bad URL syntax: " + urlString), (Throwable)e);
            return;
        }
        catch (URISyntaxException e) {
            this.log.error((Object)("Bad URL syntax: " + urlString), (Throwable)e);
            return;
        }
        try {
            AttachmentUtils.openURI(uri);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            UIRegistry.showLocalizedError("WEBLNK_BAD", "\n" + uri);
            this.log.error((Object)("Failed to open URL: " + uri.toString()), (Throwable)e);
            return;
        }
    }

    private CustomDialog createPromptDlg(Hashtable<String, String> backupHash) {
        int promptCnt;
        if (this.webLinkDef != null && ((promptCnt = this.webLinkDef.getPromptCount()) > 0 || backupHash.size() > 0)) {
            JTextField txtField;
            this.textFieldHash.clear();
            String rowDef = UIHelper.createDuplicateJGoodiesDef("p", "4px", promptCnt += backupHash.size());
            PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", rowDef));
            CellConstraints cc = new CellConstraints();
            DocumentAdaptor dla = new DocumentAdaptor(){

                @Override
                protected void changed(DocumentEvent e) {
                    super.changed(e);
                    boolean enableOK = true;
                    for (JTextField tf : WebLinkButton.this.textFieldHash.values()) {
                        if (tf.getText().length() != 0) continue;
                        enableOK = false;
                        break;
                    }
                    WebLinkButton.this.promptDialog.getOkBtn().setEnabled(enableOK);
                }
            };
            int y = 1;
            for (WebLinkDefArg arg : this.webLinkDef.getArgs()) {
                if (!arg.isPrompt()) continue;
                txtField = UIHelper.createTextField(15);
                txtField.getDocument().addDocumentListener(dla);
                this.textFieldHash.put(arg.getName(), txtField);
                String label = arg.getTitle();
                if (StringUtils.isEmpty((String)label)) {
                    label = arg.getName();
                }
                pb.add((Component)UIHelper.createFormLabel(label), cc.xy(1, y));
                pb.add((Component)txtField, cc.xy(3, y));
                y += 2;
            }
            for (String name : backupHash.keySet()) {
                txtField = UIHelper.createTextField(15);
                txtField.getDocument().addDocumentListener(dla);
                this.textFieldHash.put(name, txtField);
                pb.add((Component)UIHelper.createLabel(backupHash.get(name), 4), cc.xy(1, y));
                pb.add((Component)txtField, cc.xy(3, y));
                y += 2;
            }
            pb.setDefaultDialogBorder();
            return new CustomDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("WBLK_PROMPT_DATA"), true, 7, (Component)pb.getPanel());
        }
        return null;
    }

    protected String buildURL(boolean forToolTip) {
        if (this.webLinkDef != null) {
            int promptCnt;
            this.valueHash.clear();
            int possibleValues = 0;
            int numValues = 0;
            Vector<Object> missingList = null;
            Hashtable<String, String> backupPrompt = new Hashtable<String, String>();
            for (WebLinkDefArg arg : this.webLinkDef.getArgs()) {
                if (!arg.isPrompt()) {
                    ++possibleValues;
                    String name = arg.getName();
                    String value = "";
                    if (this.provider != null) {
                        value = this.provider.getWebLinkData(name);
                    } else if (this.dataObj instanceof FormDataObjIFace) {
                        Object dataVal = FormHelper.getValue((FormDataObjIFace)this.dataObj, name);
                        if (dataVal != null) {
                            value = dataVal.toString();
                        } else {
                            backupPrompt.put(name, arg.getTitle() == null ? arg.getName() : arg.getTitle());
                        }
                    } else if (this.dataObj instanceof String && this.textField != null) {
                        value = (String)this.dataObj;
                    }
                    String textFieldValue = null;
                    if (this.textField != null) {
                        textFieldValue = this.textField.getText();
                    }
                    if (value != null) {
                        if (StringUtils.isNotEmpty((String)textFieldValue) && !textFieldValue.equals(value)) {
                            value = textFieldValue;
                        }
                        this.valueHash.put(name, value);
                        ++numValues;
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)textFieldValue)) {
                        this.valueHash.put(name, textFieldValue);
                        ++numValues;
                        continue;
                    }
                    if (missingList == null) {
                        missingList = new Vector<Object>();
                    }
                    missingList.add(name);
                    continue;
                }
                this.valueHash.put(arg.getName(), "??");
            }
            if (possibleValues != numValues) {
                return null;
            }
            if (!(forToolTip || (promptCnt = this.webLinkDef.getPromptCount()) <= 0 && backupPrompt.size() <= 0)) {
                this.promptDialog = this.createPromptDlg(backupPrompt);
                this.promptDialog.setVisible(true);
                if (!this.promptDialog.isCancelled()) {
                    for (String key : this.textFieldHash.keySet()) {
                        this.valueHash.put(key, this.textFieldHash.get(key).getText());
                    }
                } else {
                    return null;
                }
                this.promptDialog = null;
            }
            byte[] chars = this.webLinkDef.getBaseURLStr().getBytes();
            int i = 0;
            byte[] byArray = this.webLinkDef.getBaseURLStr().getBytes();
            int n = byArray.length;
            int value = 0;
            while (value < n) {
                byte b = byArray[value];
                if (b == 60 || b == 62) {
                    chars[i] = 39;
                }
                ++i;
                ++value;
            }
            String url = new String(chars);
            for (String key : this.valueHash.keySet()) {
                String val = this.valueHash.get(key);
                if (val.equals("this")) {
                    val = this.valueHash.get("this");
                }
                url = StringUtils.replace((String)url, (String)("'" + key + "'"), (String)(val != null ? val : ""));
            }
            url = StringUtils.replace((String)url, (String)"AMP", (String)"&");
            return url;
        }
        if (this.textField != null) {
            return this.textField.getText();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean isTextFieldOK = true;
        if (enabled && StringUtils.isNotEmpty((String)this.watchId) && this.textField != null) {
            isTextFieldOK = StringUtils.isNotEmpty((String)this.textField.getText());
        }
        String urlToLaunch = this.buildURL(false);
        boolean enbl = (this.webLinkDef != null || StringUtils.isNotEmpty((String)urlToLaunch)) && enabled && isTextFieldOK;
        this.launchBtn.setEnabled(enbl);
        if (this.editBtn != null) {
            this.editBtn.setEnabled(enbl);
        }
    }

    @Override
    public void setCellName(String cellName) {
        super.setCellName(cellName);
        this.usingThisData = StringUtils.isNotEmpty((String)cellName) && cellName.equals("this");
    }

    @Override
    public void setParent(FormViewObj parent) {
        Component comp;
        super.setParent(parent);
        if (this.fvo != null && this.isTableSpecific && StringUtils.isNotEmpty((String)this.watchId) && (comp = (Component)this.fvo.getCompById(this.watchId)) instanceof ValTextField) {
            this.textField = (ValTextField)comp;
            DataChangeNotifier dcn = new DataChangeNotifier(null, this.textField, null);
            dcn.addDataChangeListener(this);
            this.textField.getDocument().addDocumentListener(dcn);
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (value == null) {
            this.dataObj = null;
            this.provider = null;
            this.setEnabled(false);
        } else {
            this.dataObj = value;
            if (value instanceof WebLinkDataProviderIFace) {
                this.provider = (WebLinkDataProviderIFace)value;
            } else if (this.dataObj instanceof String && this.textField != null) {
                this.textField.setText((String)this.dataObj);
                this.setEnabled(true);
            }
            String url = this.buildURL(true);
            if (StringUtils.isNotEmpty((String)url)) {
                this.setToolTips();
            }
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void reset() {
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.isChanged = false;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.textField != null ? this.textField.getState() : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public String[] getFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.webLinkDef != null) {
            for (WebLinkDefArg arg : this.webLinkDef.getArgs()) {
                if (arg.isPrompt()) continue;
                names.add(arg.getName());
            }
        }
        String[] nms = new String[names.size()];
        int i = 0;
        while (i < nms.length) {
            nms[i] = (String)names.get(i);
            ++i;
        }
        return nms;
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        this.validateState();
        this.isChanged = true;
        this.notifyChangeListeners(new ChangeEvent(this));
        String text = this.textField.getText();
        if ((this.dataObj instanceof String && StringUtils.isEmpty((String)((String)this.dataObj)) || this.dataObj == null) && text != null) {
            this.launchBtn.setEnabled(true);
            this.dataObj = text;
        } else if (this.dataObj != null && text != null) {
            if (this.launchBtn != null) {
                if (text.length() == 0) {
                    this.launchBtn.setEnabled(false);
                    this.dataObj = null;
                } else if (!this.launchBtn.isEnabled() && text.length() > 0) {
                    this.launchBtn.setEnabled(true);
                }
            }
        } else {
            this.dataObj = text;
        }
        if (this.dataObj != null) {
            this.setToolTips();
        }
    }

    protected void setToolTips() {
        String url = this.buildURL(true);
        this.launchBtn.setToolTipText(url);
        if (this.textField != null) {
            this.textField.setToolTipText(url);
        }
    }
}

