/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.db.PickListDBAdapterIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.apache.commons.lang.StringUtils;

public class ValTextField
extends JAutoCompTextField
implements UIValidatable,
GetSetValueIFace,
AppPrefsChangeListener,
UIRegistry.UndoableTextIFace {
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean viewOnly = false;
    protected Color bgColor;
    protected int limit = Integer.MAX_VALUE;
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected boolean doSetText = false;
    protected ValPlainTextDocument document;
    protected String defaultValue = null;
    protected UndoManager undoManager = null;

    public ValTextField() {
        this.init();
    }

    public ValTextField(String text) {
        super(text);
        this.init();
    }

    public ValTextField(int numCols) {
        super(numCols);
        this.init();
    }

    public ValTextField(int numCols, PickListDBAdapterIFace pickListDBAdapter) {
        super(numCols, pickListDBAdapter);
        this.init();
    }

    public ValTextField(String str, int numCols) {
        super(str, numCols);
        this.init();
    }

    protected void init() {
        UIHelper.setControlSize(this);
        this.setDocument(new ValPlainTextDocument());
        this.bgColor = this.getBackground();
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ValTextField.this.isNew = false;
                ValTextField.this.repaint();
            }
        });
        this.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                ValTextField.this.isChanged = true;
            }
        });
    }

    public void setLimit(int limit) {
        ((ValPlainTextDocument)this.getDocument()).setLimit(limit);
    }

    @Override
    public boolean isNotEmpty() {
        return this.getText().length() > 0;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setBackground(this.isRequired && this.isEnabled() && !this.viewOnly ? requiredFieldColor.getColor() : this.bgColor);
    }

    @Override
    public void setText(String text) {
        if (this.document != null) {
            this.document.setIgnoreNotify(true);
        }
        this.doSetText = true;
        super.setText(text);
        this.doSetText = false;
        if (this.document != null) {
            this.document.setIgnoreNotify(false);
        }
    }

    public void setTextWithNotification(String text) {
        super.setText(text);
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        if (isRequired && this.isEnabled() && !this.viewOnly) {
            this.setBackground(requiredFieldColor.getColor());
        } else if (this.bgColor != null) {
            this.setBackground(this.bgColor);
        }
        this.isRequired = isRequired;
    }

    public void setViewOnly(boolean isViewOnlyArg) {
        this.viewOnly = isViewOnlyArg;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.isRequired && this.getText().length() == 0 ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.setText(StringUtils.isNotEmpty((String)this.defaultValue) ? this.defaultValue : "");
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
        if (this.document != null) {
            DocumentListener[] documentListenerArray = this.document.getDocumentListeners();
            int n = documentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentListener l = documentListenerArray[n2];
                this.document.removeDocumentListener(l);
                ++n2;
            }
        }
        this.document = null;
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public UndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new UndoManager();
            UIRegistry.getInstance().hookUpUndoableEditListener(this);
        }
        return this.undoManager;
    }

    @Override
    public JTextComponent getTextComponent() {
        return this;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.setValueWithNotification(value, defaultValue, false);
    }

    public void setValueWithNotification(Object value, String defaultValue, boolean doNotification) {
        String data;
        this.defaultValue = defaultValue;
        if (value != null) {
            data = value.toString();
            this.isChanged = true;
        } else {
            this.isChanged = StringUtils.isNotEmpty((String)defaultValue);
            String string = data = this.isChanged ? defaultValue : "";
        }
        if (doNotification) {
            this.setTextWithNotification(data);
        } else {
            this.setText(data);
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
        }
        this.validateState();
        this.repaint();
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("requiredfieldcolor")) {
            this.setBackground(this.isRequired && this.isEnabled() && !this.viewOnly ? requiredFieldColor.getColor() : this.bgColor);
        }
    }

    public class JFormattedDoc
    extends ValPlainTextDocument {
        protected JTextField textField;
        protected UIFieldFormatterField.FieldType fieldType;
        protected int docLenLimit;
        protected int minVal;
        protected int maxVal;

        public JFormattedDoc(JTextField textField, int limit, int minVal, int maxVal) {
            this.textField = textField;
            this.fieldType = UIFieldFormatterField.FieldType.numeric;
            this.docLenLimit = limit;
            this.minVal = minVal;
            this.maxVal = maxVal;
        }

        public JFormattedDoc(JTextField textField, UIFieldFormatterField.FieldType fieldType, int limit) {
            this.textField = textField;
            this.fieldType = fieldType;
            this.docLenLimit = limit;
            this.minVal = Integer.MIN_VALUE;
            this.maxVal = Integer.MAX_VALUE;
        }

        protected boolean isCharOK(String text) {
            int len = Math.min(text.length(), this.docLenLimit);
            String str = text.substring(0, len);
            if (this.fieldType == UIFieldFormatterField.FieldType.alpha && !StringUtils.isAlpha((String)str)) {
                return false;
            }
            if (this.fieldType == UIFieldFormatterField.FieldType.alphanumeric && !StringUtils.isAlphanumeric((String)str)) {
                return false;
            }
            if (this.fieldType == UIFieldFormatterField.FieldType.numeric) {
                if (StringUtils.isNumeric((String)str)) {
                    return this.isNumValOK(str);
                }
                return false;
            }
            return true;
        }

        @Override
        public void remove(int offset, int len) throws BadLocationException {
            super.remove(offset, len);
        }

        private boolean isNumValOK(String str) {
            try {
                String valStr = String.valueOf(this.getText(0, this.getLength())) + str;
                if (this.fieldType == UIFieldFormatterField.FieldType.numeric && StringUtils.isNumeric((String)valStr)) {
                    int val = Integer.parseInt(valStr);
                    return val >= this.minVal && val <= this.maxVal;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public void insertString(int offset, String strArg, AttributeSet attr) throws BadLocationException {
            String str = strArg;
            if (str == null) {
                return;
            }
            if (str.length() > 1) {
                if (this.isCharOK(str)) {
                    super.insertString(offset, str, attr);
                }
                ValTextField.this.validateState();
                return;
            }
            int len = this.getLength() + 1;
            if (len <= this.docLenLimit) {
                if (!this.isCharOK(str)) {
                    ValTextField.this.validateState();
                    return;
                }
                super.insertString(offset, str, attr);
            }
            ValTextField.this.validateState();
        }
    }
}

