/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.validation.ValPlainTextDocument;
import edu.ku.brc.af.ui.forms.validation.ValTextArea;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.IconButton;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;

public class ValTextAreaBrief
extends ValTextArea {
    protected JPanel panel;
    protected JScrollPane scrollPane;
    protected IconButton iconButton;
    protected boolean isEditting;
    protected String title;

    public ValTextAreaBrief() {
    }

    public ValTextAreaBrief(Document doc, String text, int rows, int cols) {
        super(doc, text, rows, cols);
    }

    public ValTextAreaBrief(Document doc) {
        super(doc);
    }

    public ValTextAreaBrief(int rows, int cols) {
        super(rows, cols);
    }

    public ValTextAreaBrief(String text, int rows, int cols) {
        super(text, rows, cols);
    }

    public ValTextAreaBrief(String text) {
        super(text);
    }

    public void initialize(boolean isEditMode) {
        this.isEditting = isEditMode;
        this.iconButton = new IconButton(IconManager.getIcon(this.isEditting ? "FormEdit" : "InfoIcon", IconManager.IconSize.Std16), false);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g,2px,p", "t:p:g"));
        pb.add((Component)new JScrollPane(this, 21, 31), cc.xy(1, 1));
        pb.add((Component)this.iconButton, cc.xy(3, 1));
        this.panel = pb.getPanel();
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValTextAreaBrief.this.showPopup();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "none");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    if (event.isShiftDown()) {
                        ValTextAreaBrief.this.transferFocusBackward();
                    } else {
                        ValTextAreaBrief.this.transferFocus();
                    }
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.iconButton != null) {
            this.iconButton.setEnabled(enabled);
        }
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(enabled);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void showPopup() {
        JScrollPane sp;
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g", "f:p:g"));
        JTextArea ta = UIHelper.createTextArea(10, 60);
        if (this.getDocument() instanceof ValPlainTextDocument) {
            ta.setDocument(new ValPlainTextDocument(((ValPlainTextDocument)this.getDocument()).getLimit()));
        }
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(this.isEditting);
        final CustomDialog dlg = new CustomDialog(null, "", true, this.isEditting ? 3 : 1, (Component)pb.getPanel());
        if (this.isEditting) {
            sp = UIHelper.createScrollPane(ta);
        } else {
            dlg.setOkLabel(UIRegistry.getResourceString("CLOSE"));
            sp = ViewFactory.changeTextAreaForDisplay(ta);
        }
        pb.add((Component)sp, cc.xy(1, 1));
        dlg.createUI();
        dlg.setTitle(this.title);
        dlg.getOkBtn().setEnabled(!this.isEditting);
        ta.setText(this.getText());
        ta.setCaretPosition(0);
        ta.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                dlg.getOkBtn().setEnabled(true);
            }
        });
        pb.setDefaultDialogBorder();
        dlg.pack();
        dlg.setVisible(true);
        if (!dlg.isCancelled() && this.isEditting) {
            this.setText(ta.getText());
        }
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        super.setValue(value, defaultValue);
        if (!this.isEditting) {
            this.iconButton.setEnabled(!this.getText().isEmpty());
        }
    }

    public JComponent getUIComponent() {
        return this.panel;
    }
}

