/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.apache.commons.lang.StringUtils;

public class ValTextArea
extends JTextArea
implements UIValidatable,
GetSetValueIFace,
AppPrefsChangeListener {
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected Color bgColor = null;
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected String defaultValue = null;

    public ValTextArea() {
        this.init();
    }

    public ValTextArea(String text) {
        super(text);
        this.init();
    }

    public ValTextArea(int rows, int cols) {
        super(rows, cols);
        this.init();
    }

    public ValTextArea(String text, int rows, int cols) {
        super(text, rows, cols);
        this.init();
    }

    public ValTextArea(Document doc) {
        super(doc);
        this.init();
    }

    public ValTextArea(Document doc, String text, int rows, int cols) {
        super(doc, text, rows, cols);
        this.init();
    }

    public void init() {
        this.bgColor = this.getBackground();
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        this.initDocument();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ValTextArea.this.isNew = false;
                ValTextArea.this.repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "none");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 9) {
                    if (event.isShiftDown()) {
                        ValTextArea.this.transferFocusBackward();
                    } else {
                        ValTextArea.this.transferFocus();
                    }
                }
            }
        });
    }

    public void initDocument() {
        this.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                ValTextArea.this.isChanged = true;
            }
        });
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        this.initDocument();
    }

    @Override
    public boolean isNotEmpty() {
        return this.getText().length() > 0;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.isRequired && this.getText().length() == 0 ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.setText(StringUtils.isNotEmpty((String)this.defaultValue) ? this.defaultValue : "");
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.defaultValue = defaultValue;
        this.setText(value != null ? value.toString() : (StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : ""));
        this.setCaretPosition(0);
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("requiredfieldcolor")) {
            this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        }
    }
}

