/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;

public class ValSpinner
extends JSpinner
implements UIValidatable,
GetSetValueIFace {
    protected static ColorWrapper requiredFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isReadOnly = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected boolean currentValue = false;
    protected Color bgColor = null;
    protected JTextField textField = null;
    protected int minValue = -1;
    protected int maxValue = -1;

    public ValSpinner() {
        this.init();
    }

    public ValSpinner(SpinnerModel arg0) {
        super(arg0);
        this.init();
    }

    public ValSpinner(int minVal, int maxVal, boolean isRequired, boolean isReadOnly) {
        super(new SpinnerNumberModel(minVal, minVal, maxVal, 1));
        this.isRequired = isRequired;
        this.isReadOnly = isReadOnly;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.init();
        this.textField = this.getTextField(this);
        if (this.textField != null) {
            this.bgColor = this.textField.getBackground();
        }
        if (this.isRequired) {
            this.fixBGOfJSpinner();
        }
    }

    public void setRange(int minVal, int maxVal, int val) {
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.setModel(new SpinnerNumberModel(val, minVal, maxVal, 1));
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.textField != null && requiredFieldColor != null) {
            this.textField.setBackground(this.isRequired && enabled ? requiredFieldColor.getColor() : this.bgColor);
        }
        this.textField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean isNotEmpty() {
        return this.getValue() != null;
    }

    protected void init() {
        UIHelper.setControlSize(this);
        if (requiredFieldColor == null) {
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ValSpinner.this.isChanged = true;
            }
        });
    }

    protected void fixBGOfJSpinner() {
        if (this.textField != null && requiredFieldColor != null) {
            this.textField.setBackground(requiredFieldColor.getColor());
        }
    }

    protected JTextField getTextField(Container container) {
        int i = 0;
        while (i < container.getComponentCount()) {
            JTextField tf;
            Component c = container.getComponent(i);
            if (c instanceof JTextField) {
                return (JTextField)c;
            }
            if (c instanceof Container && (tf = this.getTextField((Container)c)) != null) {
                return tf;
            }
            ++i;
        }
        return null;
    }

    public Integer getIntValue() {
        return (Integer)this.getValue();
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isInError() {
        return false;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        return this.valState;
    }

    @Override
    public void reset() {
        this.valState = UIValidatable.ErrorType.Valid;
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        Integer val = null;
        if (value == null && StringUtils.isNotEmpty((String)defaultValue)) {
            val = Integer.parseInt(defaultValue);
        } else if (value instanceof Number) {
            Number num = (Number)value;
            val = num.intValue();
        } else {
            val = value instanceof String ? Integer.valueOf(Integer.parseInt((String)value)) : Integer.valueOf(0);
        }
        if (val < this.minValue) {
            val = this.minValue;
        } else if (val > this.maxValue) {
            val = this.maxValue;
        }
        this.setValue(val);
    }
}

