/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.helpers.Encryption;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.apache.commons.lang.StringUtils;

public class ValPasswordField
extends JPasswordField
implements UIValidatable,
GetSetValueIFace,
AppPrefsChangeListener {
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isEncrypted = false;
    protected boolean isNew = false;
    protected Color bgColor = null;
    protected String defaultValue = null;
    protected int minLen = 0;

    public ValPasswordField() {
        this.init();
    }

    public ValPasswordField(String text) {
        super(text);
        this.init();
    }

    public ValPasswordField(int cols) {
        super(cols);
        this.init();
    }

    public ValPasswordField(String text, int cols) {
        super(text, cols);
    }

    public ValPasswordField(Document doc, String text, int cols) {
        super(doc, text, cols);
        this.init();
    }

    public void init() {
        UIHelper.setControlSize(this);
        this.bgColor = this.getBackground();
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ValPasswordField.this.isNew = false;
                ValPasswordField.this.repaint();
            }
        });
        this.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                ValPasswordField.this.isChanged = true;
            }
        });
    }

    @Override
    public boolean isNotEmpty() {
        return this.getPassword().length > 0;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
    }

    @Override
    public void setText(String text) {
        super.setText(this.isEncrypted ? Encryption.decrypt(text) : text);
    }

    public String getPasswordText() {
        return new String(super.getPassword());
    }

    @Override
    public char[] getPassword() {
        String text = new String(super.getPassword());
        return text.length() == 0 ? "".toCharArray() : (this.isEncrypted ? Encryption.encrypt(text).toCharArray() : text.toCharArray());
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeKeyListeners(this);
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public String getReason() {
        return null;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public void setMinLen(int minLen) {
        this.minLen = minLen;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        this.defaultValue = defaultValue;
        String data = value != null ? (value instanceof String ? (String)value : value.toString()) : (StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : "");
        this.setText(data);
        this.validateState();
        this.repaint();
    }

    @Override
    public Object getValue() {
        return new String(this.getPassword());
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.getPassword().length < this.minLen ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.setText("");
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("requiredfieldcolor")) {
            this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        }
    }
}

