/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.ui.forms.validation;

import edu.ku.brc.af.prefs.AppPrefsCache;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.GetSetValueIFace;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hibernate.collection.PersistentSet;

public class ValListBox
extends JList
implements UIValidatable,
ListSelectionListener,
GetSetValueIFace,
AppPrefsChangeListener {
    protected UIValidatable.ErrorType valState = UIValidatable.ErrorType.Valid;
    protected boolean isRequired = false;
    protected boolean isChanged = false;
    protected boolean isNew = false;
    protected Color bgColor = null;
    protected static ColorWrapper valTextColor = null;
    protected static ColorWrapper requiredFieldColor = null;

    public ValListBox(ListModel arg0) {
        super(arg0);
        this.init();
    }

    public ValListBox(Object[] arg0) {
        super(arg0);
        this.init();
    }

    public ValListBox(Vector<?> arg0) {
        super(arg0);
        this.init();
    }

    public ValListBox() {
        this.init();
    }

    public void init() {
        this.addListSelectionListener(this);
        this.bgColor = this.getBackground();
        if (valTextColor == null || requiredFieldColor == null) {
            valTextColor = AppPrefsCache.getColorWrapper("ui", "formatting", "valtextcolor");
            requiredFieldColor = AppPrefsCache.getColorWrapper("ui", "formatting", "requiredfieldcolor");
        }
        AppPrefsCache.addChangeListener("ui.formatting.requiredfieldcolor", this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ValListBox.this.isNew = false;
                ValListBox.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNew && this.valState == UIValidatable.ErrorType.Error && this.isEnabled()) {
            UIHelper.drawRoundedRect((Graphics2D)g, valTextColor.getColor(), this.getSize(), 1);
        }
    }

    @Override
    public boolean isInError() {
        return this.valState != UIValidatable.ErrorType.Valid;
    }

    @Override
    public UIValidatable.ErrorType getState() {
        return this.valState;
    }

    @Override
    public boolean isNotEmpty() {
        return this.getSelectedIndex() != -1;
    }

    @Override
    public void setState(UIValidatable.ErrorType state) {
        this.valState = state;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.setBackground(isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        this.isRequired = isRequired;
    }

    @Override
    public boolean isChanged() {
        return this.isChanged;
    }

    @Override
    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    @Override
    public void setAsNew(boolean isNew) {
        this.isNew = this.isRequired ? isNew : false;
    }

    @Override
    public UIValidatable.ErrorType validateState() {
        this.valState = this.isRequired && this.getSelectedIndex() == -1 ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        return this.valState;
    }

    @Override
    public void reset() {
        this.setSelectedIndex(-1);
        this.valState = this.isRequired ? UIValidatable.ErrorType.Incomplete : UIValidatable.ErrorType.Valid;
        this.repaint();
    }

    @Override
    public Component getValidatableUIComp() {
        return this;
    }

    @Override
    public void cleanUp() {
        UIHelper.removeFocusListeners(this);
        UIHelper.removeListSelectionListeners(this);
        UIHelper.removeKeyListeners(this);
        AppPrefsCache.removeChangeListener("ui.formatting.requiredfieldcolor", this);
    }

    @Override
    public String getReason() {
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.isChanged = true;
    }

    @Override
    public void setValue(Object value, String defaultValue) {
        if (value == null) {
            this.setSelectedIndex(-1);
            if (this.getModel() instanceof DefaultListModel) {
                DefaultListModel defModel = (DefaultListModel)this.getModel();
                defModel.clear();
            }
            return;
        }
        Iterator iter = null;
        if (value instanceof Set) {
            iter = ((Set)value).iterator();
        } else if (value instanceof PersistentSet) {
            iter = ((PersistentSet)value).iterator();
        }
        if (iter != null) {
            DefaultListModel defModel = new DefaultListModel();
            while (iter.hasNext()) {
                defModel.addElement(iter.next());
            }
            this.setModel(defModel);
            this.setSelectedIndex(-1);
        } else {
            boolean fnd = false;
            ListModel model = this.getModel();
            int i = 0;
            while (i < model.getSize()) {
                Object item = model.getElementAt(i);
                if (item instanceof String) {
                    if (((String)item).equals(value)) {
                        this.setSelectedIndex(i);
                        fnd = true;
                        break;
                    }
                } else if (item.equals(value)) {
                    this.setSelectedIndex(i);
                    fnd = true;
                    break;
                }
                ++i;
            }
            if (!fnd) {
                this.setSelectedIndex(-1);
                this.valState = UIValidatable.ErrorType.Error;
            } else {
                this.valState = UIValidatable.ErrorType.Valid;
            }
        }
        this.repaint();
    }

    @Override
    public Object getValue() {
        return this.getSelectedValue();
    }

    @Override
    public void preferenceChange(AppPrefsChangeEvent evt) {
        if (evt.getKey().equals("requiredfieldcolor")) {
            this.setBackground(this.isRequired && this.isEnabled() ? requiredFieldColor.getColor() : this.bgColor);
        }
    }
}

